!_______________________________________________________________________
!
   subroutine msCumulHist( x, x_min, x_max, n_bin, x_nb )

      type(mfArray), intent(in) :: x
      real(kind=MF_DOUBLE), intent(in) :: x_min, x_max
      integer, intent(in) :: n_bin
      type(mfArray), optional :: x_nb
      !------ API end ------

      ! Cumulative Histogram. Works on columns of matrix X
      !
      ! If X has NCOL columns, draws first an histogram (via 'msHist')
      ! from the data of all columns, then draw a second histogram
      ! from the data of the NCOL-1 first columns, and so on.
      ! Each histogram is drawn in a different color, taken from the
      ! current color scheme; if NCOL is greater than the number of colors
      ! then the following colors are cycled in the same set.
      !
      ! Columns of X may have been initialized from data which contain
      ! different number of element. In such a case, the optional
      ! argument 'x_nb' is a vector which contains the useful number
      ! of elements in each column.

      type(mfArray) :: x_tmp, x_nb_tmp
      integer :: ncol, j, k, jlen, icol, ind_next_color
      integer :: axis_manual_save_x, axis_manual_save_y

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msCumulHist"

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( x )

      ! checking that 'x' is allocated
      if( mfIsEmpty(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not initialized!" )
         go to 99
      end if

      ! 'x' must be real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! checking that 'x' is a 2D array
      if( size(x,1)==1 .or. size(x,2)==1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "your array is a vector.",                  &
                            "You should employ the 'msHist' routine instead." )
         go to 99
      end if

      ncol = size(x,2)

      if( present(x_nb) ) then

         call msInitArgs( x_nb )

         ! checking that 'x_nb' is allocated
         if( mfIsEmpty(x_nb) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_nb' not initialized!" )
            go to 99
         end if

         ! 'x_nb' must be real
         if( .not. mfIsReal(x_nb) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_nb' must be real!" )
            go to 99
         end if

         ! 'x_nb' cannot be sparse
         if( mfIsSparse(x_nb) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_nb' cannot be sparse!" )
            go to 99
         end if

         ! checking that 'x_nb' is a 1-D array
         if( size(x_nb,1)==1 ) then
            x_nb_tmp = x_nb
         else if( size(x_nb,2)==1 ) then
            call msAssign( x_nb_tmp, .t. x_nb )
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'x_nb' must be a vector" )
            go to 99
         end if


      else

         ! row vector
         call msAssign( x_nb_tmp, mfOnes(1,ncol)*(1.0d0*size(x,1)) )

      end if

      call msHold("off")

      win => mf_win_db(CURRENT_WIN_ID)

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      ind_next_color = 1
      do k = ncol, 1, -1

         ! building a long vector from the k-first col of 'x'
         call msAssign( x_tmp, mfZeros(0,1) )
         do j = 1, k
            jlen = nint( mfDble( mfGet(x_nb_tmp,j) ) )
            call msAssign( x_tmp, x_tmp .vc. mfGet( x, 1 .to. jlen, j .to. j ) )
         end do

         ! selecting a color index from the current color scheme
         select case( win%color_scheme )
            case( 1 )
               icol = COL_CYCLE_TAB_1(ind_next_color)
               if( ind_next_color == 6 ) then
                  ind_next_color = 1
               else
                  ind_next_color = ind_next_color + 1
               end if
            case( 2 )
               icol = COL_CYCLE_TAB_2(ind_next_color)
               if( ind_next_color == 7 ) then
                  ind_next_color = 1
               else
                  ind_next_color = ind_next_color + 1
               end if
            case( 3 )
               icol = COL_CYCLE_TAB_3(ind_next_color)
               if( ind_next_color == 7 ) then
                  ind_next_color = 1
               else
                  ind_next_color = ind_next_color + 1
               end if
            case( 4 )
               icol = COL_CYCLE_TAB_4(ind_next_color)
               if( ind_next_color == 12 ) then
                  ind_next_color = 1
               else
                  ind_next_color = ind_next_color + 1
               end if
            case default
               write(STDERR,*) "(FGL CumulHist:) Internal error."
               write(STDERR,*) "     Bad value for color_scheme."
               pause "only for debugging purpose"
               stop
         end select

         ! calling 'msPlotHist' with appropriate args
         ! + a non documented argument (icol_mfplot), for internal use.
         call msPlotHist( mfOut(), x_tmp, x_min, x_max, n_bin,          &
                          filled=.true., icol_mfplot=icol )

         if( k == ncol ) then
            call msHold("on")
         end if

      end do

 99   continue

      call msSilentRelease( x_tmp, x_nb_tmp )

      call msFreeArgs( x )
      call msAutoRelease( x )
      if( present(x_nb) ) then
         call msFreeArgs( x_nb )
         call msAutoRelease( x_nb )
      end if

   end subroutine msCumulHist
