!_______________________________________________________________________
!
   subroutine mf_contour_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "contour"

      integer :: i, k, k_max, n, n_level
      integer :: icolor, icolor_old, order
      real(kind=MF_DOUBLE) :: lev
      logical :: found

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Contour", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Contour", 0 )
         end if
         gr_pdf_color_intent = 1 ! stroke
      end if

      call grslw( grobj%struct%linewidth ) ! set line width

      if( PRINTING_EPS .or. PRINTING_PDF ) then
         ! For EPS or PDF devices, it is sufficient to call GRSLS only one
         ! time (the reset the dash offset to zero between contours is done
         ! by another way...).
         call grsls( grobj%struct%linestyle ) ! set line style
      end if

      ! All contours have been computed in Contour_aux.
      n_level = grobj%struct%npt

      order = grobj%struct%marker

      ! Contour draw
      k = 0 ! current position
      k_max = size( grobj%struct%abs_mat, 2 )
      icolor_old = -1
      do ! Loop over contours

         ! Get infos for this contour
         k = k + 1
         if( k > k_max ) exit
         lev = grobj%struct%abs_mat(1,k) ! level value
         n = grobj%struct%abs_mat(2,k) ! nb of points
         if( n == 0 ) cycle

         ! Find level number from level value
         found = .false.
         do i = 1, n_level
            if( grobj%struct%lev_tab(i) == lev ) then
               found = .true.
               exit
            end if
         end do
         if( .not. found ) then
            print "(/,A)", "(MUESLI:) FGL: mf_contour_draw: internal error."
            print "(A)",   "          -> level not found in stored contours!"
            pause "for debugging purpose only"
            stop
         end if

         if( .not. (PRINTING_EPS .or. PRINTING_PDF) ) then
            ! For X11 device, it is necessary to call GRSLS for each new
            ! contour curve, in order to reset the dash offset to zero.
            call grsls( grobj%struct%linestyle ) ! set line style
         end if

         icolor = grobj%struct%col_tab(i)
         if( icolor /= icolor_old ) then
            call grsci( icolor ) ! set color index
         end if
         icolor_old = icolor

         if( order == 1 ) then

            ! Each segment (two consecutive pts) is a straight line
            call pgline( n, grobj%struct%abs_mat(1,k+1:k+n),            &
                            grobj%struct%abs_mat(2,k+1:k+n) )

         else ! order = 2

            ! Each segment (three consecutive pts) is a quadratic Bézier curve
            call pg_quadr_bezier( n, grobj%struct%abs_mat(1,k+1:k+n),   &
                                     grobj%struct%abs_mat(2,k+1:k+n),   &
                                     grobj%struct%linestyle )

         end if
         k = k + n

      end do

      if( grobj%struct%bool1 ) then
         call mf_contour_labelling( grobj )
      end if

      call grslw( 1.0d0 ) ! default line width
      call grsls( 1 ) ! default line style

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Contour", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Contour", 0 )
         end if
      end if

   end subroutine mf_contour_draw
!_______________________________________________________________________
!
   subroutine mf_contour_labelling( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! New algorithm to choose location of each label; it is not based on
      ! the number of points (as previously) but on the distance between
      ! the points and the total lenth of each contour.

      integer :: j, k, k_save, k_max, n
      integer :: tb, lab_len, nb_writes, estim_nb_writes
      real(kind=MF_DOUBLE) :: x, y, lev, x1, y1
      logical :: draw_here, bool_1, bool_2, closed_contour
      real(kind=MF_DOUBLE) :: xc, yc, xv1, xv2, yv1, yv2, xl, xr, yb, yt
      real(kind=MF_DOUBLE) :: xn, yn, angle, xo, yo, xp, yp, dindx, dindy
      real(kind=MF_DOUBLE) :: xbox(4), ybox(4)
      real(kind=MF_DOUBLE) :: lab_len_wc, total_len, distance,          &
                              len_backward, len_forward
      character(len=15) :: label

   !------ end of declarations -- execution starts hereafter  ------

      ! Draw labels over the contours
      gr_pdf_color_intent = 2 ! Fill
      call grsci( grobj%struct%color )
      call pgsch( grobj%struct%height_text )

      k = 0 ! Current position
      k_max = size( grobj%struct%abs_mat, 2 )
      do ! loop over contours

         ! Get infos for this contour
         k = k + 1
         if( k > k_max ) exit
         lev = grobj%struct%abs_mat(1,k) ! level value
         n = grobj%struct%abs_mat(2,k) ! nb of points
         if( n == 0 ) cycle

         write(label,'(1X,ES9.2)') lev
         lab_len = len_trim(label) + 1
         ! Find label length in world coordinates (dummy position)
         call pgqtxt( 0.0d0, 0.0d0, 0.0d0, 0.5d0, label, xbox, ybox)
         lab_len_wc = abs( xbox(3) - xbox(1) )

         ! 'lab_len_wc' is the reference length on which is based the
         ! algorithm for chosing the location of labels: it is the
         ! length (in World Coordinates) of the label itself.
         ! The first label is put when the cumulative distance from the
         ! beginning of the curve is at least equal to this reference
         ! length, and then each distance equal to five time this length.
         ! Another criterion is the distance to the end of the curve.

         ! Go to the first point of this contour
         k = k + 1
         x1 = grobj%struct%abs_mat(1,k)
         y1 = grobj%struct%abs_mat(2,k)

         ! Check for a closed contour
         x = grobj%struct%abs_mat(1,k+n-1)
         y = grobj%struct%abs_mat(2,k+n-1)
         if( x1 == x .and. y1 == y ) then
            closed_contour = .true.
         else
            closed_contour = .false.
         end if

         ! Compute the total length of the curve
         k_save = k
         xp = x1
         yp = y1
         total_len = 0.0d0
         do j = 2, n ! loop over points
            k = k + 1
            x = grobj%struct%abs_mat(1,k)
            y = grobj%struct%abs_mat(2,k)
            total_len = total_len + sqrt( (x-xp)**2 + (y-yp)**2 )
            xp = x
            yp = y
         end do

         ! Only for opened curves, estimate the number of labels.
         ! (later on, if this number is equal to 1, we will locate it
         !  at the center of the curve)
         if( .not. closed_contour ) then
            if( total_len >= lab_len_wc ) then
               estim_nb_writes = 1 + (total_len-lab_len_wc)/(5*lab_len_wc)
               if( estim_nb_writes >= 2 ) then
                  estim_nb_writes = estim_nb_writes - 1
               end if
            else
               estim_nb_writes = 0
            end if
         else
            estim_nb_writes = -1 ! means not estimated
         end if

         len_backward = 0.0d0
         len_forward  = total_len
         nb_writes = 0
         k = k_save

         ! save first point
         xp = x1
         yp = y1

         do j = 2, n ! Loop over points

            k = k + 1
            x = grobj%struct%abs_mat(1,k)
            y = grobj%struct%abs_mat(2,k)
            distance = sqrt( (x-xp)**2 + (y-yp)**2 )
            len_backward = len_backward + distance
            len_forward  = len_forward - distance
            if( estim_nb_writes == 1 ) then
               if( nb_writes == 0 ) then
                  draw_here = len_backward >= total_len/2.
               else
                  draw_here = .false.
               end if
            else
               bool_1 = len_backward >= lab_len_wc + 5*nb_writes*lab_len_wc
               if( nb_writes == 0 ) then
                  bool_2 = .true.
               else
                  bool_2 = len_forward  >= lab_len_wc + 5*lab_len_wc
               end if
               draw_here = bool_1 .and. bool_2
            end if

            if( draw_here ) then

               nb_writes = nb_writes + 1
               ! Find center of the label
               xc = (x+xp)*0.5d0
               yc = (y+yp)*0.5d0
               ! Find slope of this segment (angle)
               call pgqvp(1, xv1, xv2, yv1, yv2)
               call pgqwin(xl, xr, yb, yt)
               angle = 0.0d0
               if( xr /= xl .and. yt /= yb ) then
                  dindx = (xv2 - xv1) / (xr - xl)
                  dindy = (yv2 - yv1) / (yt - yb)
                  if( y-yp /= 0.0d0 .or. x-xp /= 0.0d0 ) then
                     angle = rad_to_deg*atan2((y-yp)*dindy, (x-xp)*dindx)
                  end if
               end if
               ! Check whether point is inside the window
               xn = (xc-xl)/(xr-xl)
               yn = (yc-yb)/(yt-yb)
               if( xn >= 0.0d0 .and. xn <= 1.0d0 .and.                  &
                  yn >= 0.0d0 .and. yn <= 1.0d0 ) then
                  ! Save current text background and set to erase
                  ! anything under the textbox.
                  call pgqtbg(tb)
                  call pgstbg(0)
                  ! Find bounding box of label
                  call pgqtxt(xc, yc, angle, 0.5d0, label, xbox, ybox)
                  xo = 0.5d0*(xbox(1)+xbox(3))
                  yo = 0.5d0*(ybox(1)+ybox(3))
                  ! Plot label with bounding box centered at (xc, yc)
                  call pgptxt( 2.0d0*xc-xo, 2.0d0*yc-yo, angle,         &
                               0.5d0, 0.0d0, label(1:lab_len),          &
                               to_be_trimmed=.false., clipping=.true. )
                  ! Restore text background
                  call pgstbg(tb)
               end if

            end if

            xp = x
            yp = y

         end do

      end do

   end subroutine mf_contour_labelling
