!_______________________________________________________________________
!
   subroutine mf_contourF_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "contour_filled"

      integer :: i, k, k_max, n, n_level
      integer :: icolor, icolor_old
      real(kind=MF_DOUBLE) :: lev
      logical :: found

      type(mfArray) :: Ind, Area, xp, yp, mf_tmp, FA, IA
      integer :: ii, ncurves, nl, nb_colors, icol, offset, j, jj, I_jj
      integer :: ipos
      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: r_area, c_axis_min, c_axis_max,           &
                              col_rgb(3), level, new_lev, orientation

      real(kind=MF_DOUBLE), allocatable :: CS(:,:)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Contour_Filled", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Contour_Filled", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      if( PRINTING_EPS .or. PRINTING_PDF ) then
         ! For EPS or PDF devices, it is sufficient to call GRSLS only one
         ! time (the reset the dash offset to zero between contours is done
         ! by another way...).
         call grsls( 1 ) ! set line style
      end if

      ! All contours have been computed in Contour_aux.
      n_level = grobj%struct%npt

      ! Get effective size
      k_max = size( grobj%struct%abs_mat, 2 )
      allocate( CS(2,k_max) )
!### TODO: copie nécessaire ?
      CS(:,:) = grobj%struct%abs_mat(:,:)

      ! Find the indices of the curves in the CS matrix, and get the
      ! area of closed curves in order to draw patches correctly.
      ii = 1
      ncurves = 0
      !Ind  = []
      !Area = []
      orientation = grobj%struct%ang_text
      do while( ii < size(CS,2) )
         nl = CS( 2, ii )
         ncurves = ncurves + 1
         call msSet( dble(ii), Ind, ncurves )
         xp = CS( 1, ii+[(i, i = 1, nl)] )
         yp = CS( 2, ii+[(i, i = 1, nl)] )
         mf_tmp = mfSum( mfDiff(xp)*(mfGet(yp,1.to.nl-1)+mfGet(yp,2.to.nl))/2.0d0 )
         call msSet( orientation*mf_tmp, Area, ncurves )
         ii = ii + nl + 1
      end do

!!print *, "ncurves = ", ncurves
!!call msDisplay( .t.Area, "Area" )
!!call msDisplay( .t.Ind, "Ind (ptr in CS)" )

      ! Plot patches in order of decreasing size. This makes sure that
      ! all the levels get drawn, not matter if we are going up a hill or
      ! down into a hole. When going down we shift levels though, you can
      ! tell whether we are going up or down by checking the sign of the
      ! area (since curves are oriented so that the high side is always
      ! the same side). Lowest curve is largest and encloses higher data
      ! always.
      call msSort( mfOut(FA,IA), mfAbs(Area), dim=2, mode="des" )

!### TODO: reporter le calcul de l'aire des courbes et leur tri en amont
!          (dans la routine appelante, avant de stocker les données dans le
!           grobj...)

      win => mf_win_db(CURRENT_WIN_ID)
!!print *, "mf_contourF_draw: win%current_axes(:) = ", win%current_axes(:)
      offset = win%colormap_ci_low - 1
      nb_colors = win%colormap_ci_high - offset
      c_axis_min = win%color_axes(1)
      c_axis_max = win%color_axes(2)

      do j = 1, ncurves
         jj = mfGet(IA,j)
         I_jj = mfGet( Ind, jj )
         nl = CS( 2, I_jj )
         level = CS( 1, I_jj )
         r_area = mfGet( Area, jj )
         ! compute colormap index
         if( r_area >= 0.0d0 ) then
            icol = (level-c_axis_min)/(c_axis_max-c_axis_min)*(nb_colors-1) + 1
         else
            ! Color must be down-shifted by 1
            do ipos = 1, n_level
               if( level == grobj%struct%lev_tab(ipos) ) exit
            end do
            if( ipos > 1 ) then
               ! Get previous color
               new_lev = grobj%struct%lev_tab(ipos-1)
               icol = (new_lev-c_axis_min)/(c_axis_max-c_axis_min)*(nb_colors-1) + 1
            else
               ! Set color to white
               icol = 0
            end if
         end if
         if( icol == 0 ) then
            call grsci( icol ) ! set color index
         else
            call grsci( icol+offset ) ! set color index
         end if

         call pgpoly( nl, CS(1,I_jj+1:I_jj+nl),                         &
                          CS(2,I_jj+1:I_jj+nl) )

      end do

      call grslw( grobj%struct%linewidth ) ! set line width

      call grsci( 1 ) ! set color index
      do j = 1, ncurves
         jj = mfGet( Ind, j )
         nl = CS( 2, jj )
         call pgline( nl, CS(1,jj+1:jj+nl),                             &
                          CS(2,jj+1:jj+nl) )
      end do

      if( grobj%struct%bool1 ) then
         call mf_contourF_labelling( grobj )
      end if

      call grslw( 1.0d0 ) ! default line width
      call grsls( 1 ) ! default line style

      call msRelease( Ind, Area, xp, yp, mf_tmp, FA, IA )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Contour_Filled", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Contour_Filled", 0 )
         end if
      end if

   end subroutine mf_contourF_draw
!_______________________________________________________________________
!
   subroutine mf_contourF_labelling( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! New algorithm to choose location of each label; it is not based on
      ! the number of points (as previously) but on the distance between
      ! the points and the total lenth of each contour.
      !
      ! This second version is adapted to the 'contour filled' case: since
      ! some parts of a given contour may be located exactly on or outside
      ! the domain boundary, all exterior points are removed and this
      ! process leads to new segmets of contour which are all inside the
      ! domain.

      integer :: j, k, kk, k_max, n
      integer :: tb, lab_len, nb_writes, estim_nb_writes
      real(kind=MF_DOUBLE) :: x, y, lev, x1, y1
      logical :: draw_here, bool_1, bool_2, closed_contour
      real(kind=MF_DOUBLE) :: xc, yc, xv1, xv2, yv1, yv2, xl, xr, yb, yt
      real(kind=MF_DOUBLE) :: xn, yn, angle, xo, yo, xp, yp, dindx, dindy
      real(kind=MF_DOUBLE) :: xbox(4), ybox(4)
      real(kind=MF_DOUBLE) :: lab_len_wc, total_len, distance,          &
                              len_backward, len_forward
      character(len=15) :: label

      real(kind=MF_DOUBLE), allocatable :: tmp_cont(:,:)
      integer :: tmp_n, ii
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max

   !------ end of declarations -- execution starts hereafter  ------

      !use again (min,max) functions because, here, we don't know axis direction
      x_min = min( grobj%struct%range(1), grobj%struct%range(2) )
      x_max = max( grobj%struct%range(1), grobj%struct%range(2) )
      y_min = min( grobj%struct%range(3), grobj%struct%range(4) )
      y_max = max( grobj%struct%range(3), grobj%struct%range(4) )

      ! Draw labels over the contours
      gr_pdf_color_intent = 2 ! Fill
      call grsci( grobj%struct%color )
      call pgsch( grobj%struct%height_text )

      k = 0 ! Current position in grobj%struct%abs_mat
      k_max = size( grobj%struct%abs_mat, 2 )
      do ! Loop over all contours

         ! Get infos for this contour
         k = k + 1
         if( k > k_max ) exit
         lev = grobj%struct%abs_mat(1,k) ! level value
         n = grobj%struct%abs_mat(2,k) ! nb of points
         if( n == 0 ) cycle

         ! Create a tempo structure for segments (=sub-contours).
         if( allocated(tmp_cont) ) then
            if( size(tmp_cont,2) < n ) then
               deallocate( tmp_cont )
               allocate( tmp_cont(2,n) )
            end if
         else
            allocate( tmp_cont(2,n) )
         end if

         write(label,'(1X,ES9.2)') lev
         lab_len = len_trim(label) + 1
         ! Find label length in world coordinates (dummy position)
         call pgqtxt( 0.0d0, 0.0d0, 0.0d0, 0.5d0, label, xbox, ybox)
         lab_len_wc = abs( xbox(3) - xbox(1) )

         ! 'lab_len_wc' is the reference length on which is based the
         ! algorithm for chosing the location of labels: it is the
         ! length (in World Coordinates) of the label itself.
         ! The first label is put when the cumulative distance from the
         ! beginning of the curve is at least equal to this reference
         ! length, and then each distance equal to five time this length.
         ! Another criterion is the distance to the end of the curve.

         ii = 0 ! nb of points already processed
         do ! Loop over segments of contour

            if( ii == n ) exit

            ! Filling the sub-contour with interior points;
            ! stop at the end or whenever an exterior point is found.
            tmp_n = 0
            do

               if( ii+1 > n ) exit
               ii = ii + 1
               k = k + 1
               if( .not. point_is_interior(k) ) exit

               tmp_n = tmp_n + 1
               tmp_cont(:,tmp_n) = grobj%struct%abs_mat(:,k)

            end do

            if( tmp_n == 0 ) cycle

            ! Go to the first point of this contour
            kk = 1
            x1 = tmp_cont(1,kk)
            y1 = tmp_cont(2,kk)

            ! Check for a closed contour
            x = tmp_cont(1,tmp_n)
            y = tmp_cont(2,tmp_n)
            if( x1 == x .and. y1 == y ) then
               closed_contour = .true.
            else
               closed_contour = .false.
            end if

            ! Compute the total length of the curve
            xp = x1
            yp = y1
            total_len = 0.0d0
            do j = 2, tmp_n ! loop over points
               kk = kk + 1
               x = tmp_cont(1,kk)
               y = tmp_cont(2,kk)
               total_len = total_len + sqrt( (x-xp)**2 + (y-yp)**2 )
               xp = x
               yp = y
            end do

            ! Only for opened curves, estimate the number of labels.
            ! (later on, if this number is equal to 1, we will locate it
            !  at the center of the curve)
            if( .not. closed_contour ) then
               if( total_len >= lab_len_wc ) then
                  estim_nb_writes = 1 + (total_len-lab_len_wc)/(5*lab_len_wc)
                  if( estim_nb_writes >= 2 ) then
                     estim_nb_writes = estim_nb_writes - 1
                  end if
               else
                  estim_nb_writes = 0
               end if
            else
               estim_nb_writes = -1 ! means not estimated
            end if

            len_backward = 0.0d0
            len_forward  = total_len
            nb_writes = 0
            kk = 1

            ! save first point
            xp = x1
            yp = y1

            do j = 2, tmp_n ! Loop over points

               kk = kk + 1
               x = tmp_cont(1,kk)
               y = tmp_cont(2,kk)
               distance = sqrt( (x-xp)**2 + (y-yp)**2 )
               len_backward = len_backward + distance
               len_forward  = len_forward - distance
               if( estim_nb_writes == 1 ) then
                  if( nb_writes == 0 ) then
                     draw_here = len_backward >= total_len/2.
                  else
                     draw_here = .false.
                  end if
               else
                  bool_1 = len_backward >= lab_len_wc + 5*nb_writes*lab_len_wc
                  if( nb_writes == 0 ) then
                     bool_2 = .true.
                  else
                     bool_2 = len_forward  >= lab_len_wc + 5*lab_len_wc
                  end if
                  draw_here = bool_1 .and. bool_2
               end if

               if( draw_here ) then

                  nb_writes = nb_writes + 1
                  ! Find center of the label
                  xc = (x+xp)*0.5d0
                  yc = (y+yp)*0.5d0
                  ! Find slope of this segment (angle)
                  call pgqvp(1, xv1, xv2, yv1, yv2)
                  call pgqwin(xl, xr, yb, yt)
                  angle = 0.0d0
                  if( xr /= xl .and. yt /= yb ) then
                     dindx = (xv2 - xv1) / (xr - xl)
                     dindy = (yv2 - yv1) / (yt - yb)
                     if( y-yp /= 0.0d0 .or. x-xp /= 0.0d0 ) then
                        angle = rad_to_deg*atan2((y-yp)*dindy, (x-xp)*dindx)
                     end if
                  end if
                  ! Check whether point is inside the window
                  xn = (xc-xl)/(xr-xl)
                  yn = (yc-yb)/(yt-yb)
                  if( xn >= 0.0d0 .and. xn <= 1.0d0 .and.               &
                      yn >= 0.0d0 .and. yn <= 1.0d0 ) then
                     ! Save current text background and set to erase
                     ! anything under the textbox.
                     call pgqtbg(tb)
                     call pgstbg(0)
                     ! Find bounding box of label
                     call pgqtxt(xc, yc, angle, 0.5d0, label, xbox, ybox)
                     xo = 0.5d0*(xbox(1)+xbox(3))
                     yo = 0.5d0*(ybox(1)+ybox(3))
                     ! Plot label with bounding box centered at (xc, yc)
                     call pgptxt( 2.0d0*xc-xo, 2.0d0*yc-yo, angle,      &
                                  0.5d0, 0.0d0, label(1:lab_len),       &
                                  to_be_trimmed=.false., clipping=.true. )
                     ! Restore text background
                     call pgstbg(tb)
                  end if

               end if

               xp = x
               yp = y

            end do ! Loop over points

         end do ! Loop over segments of contour

      end do ! Loop over all contours

   contains
   !____________________________________________________________________
   !
      function point_is_interior( i ) result( bool )

         integer, intent(in) :: i
         logical             :: bool
         !------ API end ------

         real(kind=MF_DOUBLE) :: x, y

         bool = .false.

         x = grobj%struct%abs_mat(1,i)
         y = grobj%struct%abs_mat(2,i)

         if( x <= x_min .or. x_max <= x ) return
         if( y <= y_min .or. y_max <= y ) return

         bool = .true.

      end function
   !____________________________________________________________________
   !
   end subroutine mf_contourF_labelling
