!_______________________________________________________________________
!
   function ContourFVec( mat, n_level, draw_labels, lab_color, lab_size, &
                         linewidth, x, y, levels_sto_pg )               &
   result( handle )

      real(kind=MF_DOUBLE), pointer            :: mat(:,:)
      integer,                      intent(in) :: n_level
      logical,                      intent(in) :: draw_labels
      integer,                      intent(in) :: lab_color
      real(kind=MF_DOUBLE),         intent(in) :: lab_size, linewidth
      real(kind=MF_DOUBLE), pointer,  optional :: x(:), y(:)
      real(kind=MF_DOUBLE), pointer,  optional :: levels_sto_pg(:)

      integer :: handle
      !------ API end ------

      ! Attention : convention différente de Matlab
      ! i -> y (inversed)
      ! j -> x                       (idem Spy)

      ! data are supposed to be "vertex-centered" !

      ! PGCONX -- contour map of a 2D data array.
      ! Un seul appel à 'PGCONX' est possible si on stocke, pour chaque
      ! point d'un contour donné, la cellule (i,j) d'origine, car la
      ! transformation (i,j) -> (x,y) peut être non-linéaire, c'est-à-dire
      ! linéarisée différemment dans chaque cellule.
      ! À cause de la nature de x et y (y(i) et x(j)), le maillage global ne
      ! peut être que rectangulaire.

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      real(kind=MF_DOUBLE) :: range(4)
      integer :: i, j, k, n, ni, nj, hdle, ii, jj
      logical :: x_and_y_present
      real(kind=MF_DOUBLE), pointer :: level_array(:)
      integer, pointer :: icol_array(:)
      real(kind=MF_DOUBLE) :: tr(6), fact_icol, fact_level
      real(kind=MF_DOUBLE), allocatable :: x_tmp(:), y_tmp(:)
      real(kind=MF_DOUBLE) :: dx, dy
      logical :: linear_axis, x_axis_inv, y_axis_inv
      character(len=20) :: string
      real(kind=MF_DOUBLE) :: curr_char_size

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

      integer :: n_points
      real(kind=MF_DOUBLE), pointer :: XXYY_cont(:,:)

      integer, parameter :: order = 1

   !------ end of declarations -- execution starts hereafter  ------

      ni = size(mat,1) ! rows    = ny
      nj = size(mat,2) ! columns = nx

      win => mf_win_db(CURRENT_WIN_ID)

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      ! levels check or setting
      if( present(levels_sto_pg) ) then
         do j = 1, n_level
            if( levels_sto_pg(j) < win%color_axes(1) .or.               &
                levels_sto_pg(j) > win%color_axes(2) ) then
               write(string,"(G0.5)") levels_sto_pg(j)
               call PrintMessage( "msContourF", "W",                    &
                      "The specified level " // trim(string) // " is outside the", &
                      "color axis; therefore the corresponding level curve", &
                      "will not be drawn!" )
            end if
         end do
         level_array => levels_sto_pg
      else
         allocate( level_array(n_level) )
         ! by default, min and max are taken from the Color Axis
         ! the levels do not include the extremal values,
         !   e.g. 0.1:0.1:0.9 if whole range is [0,1]
         fact_level = (win%color_axes(2)-win%color_axes(1)) / (n_level+1.0d0)

         do j = 1, n_level
            level_array(j) = win%color_axes(1) + fact_level*j
         end do
      end if

      ! here, only computation of the contours, in (i,j) axes!

      ! on ré-initialise si besoin le stockage des contours
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      if( allocated(IJ_cont) ) then
         deallocate( IJ_cont )
      end if
      XY_cont_size = 0
      XY_cont_nb_cont = 0

      call pgcont_ec( mat, ni, nj, level_array, n_level, order )

      ! on ferme le dernier contour (si nécessaire)
      if( XY_cont_nb_cont > 0 ) then
         n_points = XY_cont_current_pos - XY_cont_current_beg
         XY_cont(2,XY_cont_current_beg) = n_points
      end if

      allocate( XXYY_cont(2,XY_cont_current_pos) )

      !-------------------------------------------------------------------
      ! TR: array defining a transformation between the I,J grid of the
      ! array and the world coordinates. The world coordinates of the array
      ! point A(I,J) are given by:
      !                  X = TR(1) + TR(2)*I + TR(3)*J
      !                  Y = TR(4) + TR(5)*I + TR(6)*J
      ! Usually TR(3) and TR(5) are zero - unless the coordinate
      ! transformation involves a rotation or shear.
      !-------------------------------------------------------------------

      linear_axis = .true.

      x_and_y_present = present(x) .and. present(y)

      ! les [nouveaux] axes doivent être prêts
      if( x_and_y_present ) then
         range(1) = min( x(1), x(nj) ) ! x_min
         range(2) = max( x(1), x(nj) ) ! x_max
         range(3) = min( y(1), y(ni) ) ! y_min
         range(4) = max( y(1), y(ni) ) ! y_max

         x_axis_inv = x(nj) < x(1)
         y_axis_inv = y(ni) < y(1)
!!print *, "ContourFVec: x_axis_inv, y_axis_inv = ", x_axis_inv, y_axis_inv
!!pause

         ! check if vectors x(:) and y(:) are linear
         allocate( x_tmp(nj) )
         x_tmp = mfLinSpace( dble(x(1)), dble(x(nj)), nj )
         dx = abs( x(nj) - x(1) )
         if( maxval(abs( x - x_tmp ))/dx > 1.0d-4 ) then
            linear_axis = .false.
            deallocate( x_tmp )
            go to 10
         end if
         deallocate( x_tmp )

         allocate( y_tmp(ni) )
         y_tmp = mfLinSpace( dble(y(1)), dble(y(ni)), ni )
         dy = abs( y(ni) - y(1) )
         if( maxval(abs( y - y_tmp ))/dy > 1.0d-4 ) then
            linear_axis = .false.
         end if
         deallocate( y_tmp )

 10      continue

      end if

      call pgbbuf()

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      ! color setting
      allocate( icol_array(n_level) )

      do j = 1, n_level
         fact_icol = (level_array(j)-win%color_axes(1))/(win%color_axes(2)-win%color_axes(1))
         icol_array(j) = win%colormap_ci_low +                          &
                         fact_icol*(win%colormap_ci_high-win%colormap_ci_low)
      end do

      ! Here, we are sure that tr(2) and tr(6) are always zero, because:
      !                    x <-> j
      !                    y <-> i
      if( x_and_y_present ) then

         if( linear_axis ) then

            ! les valeurs de 'x' et 'y', si elles sont présentes, ne
            ! servent qu'à définir les échelles (car le mapping de MFPLOT
            ! est linéaire).

            if( x_axis_inv ) then ! x axis inverse
               !  x_min = tr(1) + tr(3)*nj         [ j = nj ]
               !  x_max = tr(1) + tr(3)            [ j = 1  ]
               tr(3) = (range(1)-range(2)) / (nj-1.0d0)
               tr(1) = range(2) - tr(3)
            else ! x axis normal
               !  x_min = tr(1) + tr(3)            [ j = 1  ]
               !  x_max = tr(1) + tr(3)*nj         [ j = nj ]
               tr(3) = (range(2)-range(1)) / (nj-1.0d0)
               tr(1) = range(1) - tr(3)
            end if

            if( y_axis_inv ) then ! y axis inverse
               !  y_min = tr(4) + tr(5)*ni         [ i = ni ]
               !  y_max = tr(4) + tr(5)            [ i = 1  ]
               tr(5) = (range(3)-range(4)) / (ni-1.0d0)
               tr(4) = range(4) - tr(5)
            else ! y axis normal
               !  y_min = tr(4) + tr(5)            [ i = 1  ]
               !  y_max = tr(4) + tr(5)*ni         [ i = ni ]
               tr(5) = (range(4)-range(3)) / (ni-1.0d0)
               tr(4) = range(3) - tr(5)
            end if

            k = 0 ! current position
            do i = 1, XY_cont_nb_cont ! loop over contours

               k = k + 1
               ! copie first column (contour level and nb of points)
               XXYY_cont(1:2,k) = XY_cont(1:2,k)
               ! get nb of points for this contour
               n = XY_cont(2,k)
               do j = 1, n ! loop over points
                  k = k + 1
                  XXYY_cont(1,k) = tr(1) + tr(3)*XY_cont(2,k)
                  XXYY_cont(2,k) = tr(4) + tr(5)*XY_cont(1,k)
               end do

            end do

         else ! non-linear axis

            k = 0 ! current position
            do i = 1, XY_cont_nb_cont ! loop over contours

               k = k + 1
               ! copie first column (contour level and nb of points)
               XXYY_cont(1:2,k) = XY_cont(1:2,k)
               ! get nb of points for this contour
               n = XY_cont(2,k)
               do j = 1, n ! loop over points
                  k = k + 1
                  ! get cell (i,j)
                  if( j == 1 ) then
                     ii = IJ_cont(1,k) !   row  index for y(:)
                     jj = IJ_cont(2,k) ! column index for x(:)
                  else
                     ii = IJ_cont(1,k-1) !   row  index for y(:)
                     jj = IJ_cont(2,k-1) ! column index for x(:)
                  end if
                  !  x(j)   = tr(1) + tr(3)*j
                  !  x(j+1) = tr(1) + tr(3)*(j+1)
                  tr(3) = x(jj+1)-x(jj)
                  tr(1) = x(jj) - tr(3)*jj
                  !  y(i)   = tr(4) + tr(5)*i
                  !  y(i+1) = tr(4) + tr(5)*(i+1)
                  tr(5) = y(ii+1)-y(ii)
                  tr(4) = y(ii) - tr(5)*ii
                  XXYY_cont(1,k) = tr(1) + tr(3)*XY_cont(2,k)
                  XXYY_cont(2,k) = tr(4) + tr(5)*XY_cont(1,k)
               end do

            end do

         end if

      else

         ! tr(1:6) = [ 0, 0, 1, 0, 1, 0 ] so transformation becomes simply:
         !   xx = y
         !   yy = x

         k = 0 ! current position
         do i = 1, XY_cont_nb_cont ! loop over contours

            k = k + 1
            ! copie first column (contour level and nb of points)
            XXYY_cont(1:2,k) = XY_cont(1:2,k)
            ! get nb of points for this contour
            n = XY_cont(2,k)
            do j = 1, n ! loop over points
               k = k + 1
               ! fix due to the added surrounding
               XXYY_cont(1,k) = XY_cont(2,k) - 1.0d0
               XXYY_cont(2,k) = XY_cont(1,k) - 1.0d0
            end do

         end do

      end if

      ! Update XY_cont (perhaps it will be retrieved from mfOut)
      XY_cont(1:2,1:XY_cont_current_pos) = XXYY_cont(1:2,1:XY_cont_current_pos)

      ! now that the transformation has been done, fix range(:)
      if( x_and_y_present ) then
         range(1) = min( x(2), x(nj-1) ) ! x_min
         range(2) = max( x(2), x(nj-1) ) ! x_max
         range(3) = min( y(2), y(ni-1) ) ! y_min
         range(4) = max( y(2), y(ni-1) ) ! y_max
      else
         range(:) = [ 1, nj-2, ni-2, 1 ]
      end if
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      if( present(x) ) then
         deallocate( x, y )
      end if
      deallocate( mat )

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "contour_filled"
      grobj%struct%range = range

      grobj%struct%npt = n_level
      grobj%struct%npt2 = XY_cont_nb_cont
      grobj%struct%npt3 = XY_cont_current_pos

      grobj%struct%abs_mat => XXYY_cont

      grobj%struct%ang_text = +1.0d0

      grobj%struct%bool1 = draw_labels
      grobj%struct%color = lab_color

      call pgqch( curr_char_size )
      grobj%struct%height_text = curr_char_size*lab_size ! absolute size

      allocate( grobj%struct%lev_tab(n_level) )
      grobj%struct%lev_tab(:) = level_array(1:n_level)

      allocate( grobj%struct%col_tab(n_level) )
      grobj%struct%col_tab(:) = icol_array(1:n_level)
      grobj%struct%linewidth = linewidth

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_contourF_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
         ! x, y and mat already deallocated by 'delete_grobj_inside'
      else
         if( present(levels_sto_pg) ) then
            deallocate( levels_sto_pg )
         else
            deallocate( level_array )
         end if

         deallocate( icol_array )
      end if

      win%blank = .false.
      win%empty = .false.

   end function ContourFVec
!_______________________________________________________________________
!
   function ContourFMat( mat, n_level, draw_labels, lab_color, lab_size, &
                         linewidth, x, y, levels_sto_pg )               &
   result( handle )

      real(kind=MF_DOUBLE), pointer            :: mat(:,:)
      integer,                      intent(in) :: n_level
      logical,                      intent(in) :: draw_labels
      integer,                      intent(in) :: lab_color
      real(kind=MF_DOUBLE),         intent(in) :: lab_size, linewidth
      real(kind=MF_DOUBLE), pointer            :: x(:,:), y(:,:)
      real(kind=MF_DOUBLE), pointer,  optional :: levels_sto_pg(:)

      integer :: handle
      !------ API end ------

      ! data are supposed to be "vertex-centered" !

      ! PGCONX -- contour map of a 2D data array

      ! Ici, contrairement à 'ContourVec', on connait les coordonnées
      ! de chaque point (i,j). Le maillage peut donc être formé de mailles
      ! non rectangulaires, quelconques, mais convexes. La tranformation
      ! passant du carré unité au quadrilatère est bilinéaire.

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      real(kind=MF_DOUBLE) :: range(4)
      integer :: i, j, k, n, ni, nj, hdle, ii, jj
      real(kind=MF_DOUBLE), pointer :: level_array(:)
      integer, pointer :: icol_array(:)
      real(kind=MF_DOUBLE) :: tr(6), fact_icol, fact_level
      logical :: linear_axis
      character(len=20) :: string
      real(kind=MF_DOUBLE) :: curr_char_size
      integer :: s1, s2

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

      integer :: n_points, n_order_2, kk
      real(kind=MF_DOUBLE), pointer :: XXYY_cont(:,:)
      real(kind=MF_DOUBLE) :: a, b, c, d, ap, bp, cp, dp
      real(kind=MF_DOUBLE) :: tmp_1, tmp_2, z0, orientation

      integer, parameter :: order = 1

   !------ end of declarations -- execution starts hereafter  ------

      ni = size(mat,1) ! rows    = ny
      nj = size(mat,2) ! columns = nx

      win => mf_win_db(CURRENT_WIN_ID)

      ! for printing in EPS and PDF...
      win%colormap_used = .true.

      ! levels check or setting
      if( present(levels_sto_pg) ) then
         do j = 1, n_level
            if( levels_sto_pg(j) < win%color_axes(1) .or.               &
                levels_sto_pg(j) > win%color_axes(2) ) then
               write(string,"(G0.5)") levels_sto_pg(j)
               call PrintMessage( "msContourF", "W",                    &
                      "The specified level " // trim(string) // " is outside the", &
                      "color axis; therefore the corresponding level curve", &
                      "will not be drawn!" )
            end if
         end do
         level_array => levels_sto_pg
      else
         allocate( level_array(n_level) )
         ! by default, min and max are taken from the Color Axis
         ! the levels do not include the extremal values,
         !   e.g. 0.1:0.1:0.9 if whole range is [0,1]
         fact_level = (win%color_axes(2)-win%color_axes(1)) / (n_level+1.0d0)

         do j = 1, n_level
            level_array(j) = win%color_axes(1) + fact_level*j
         end do
      end if

      ! here, only computation of the contours, in (i,j) axes!

      ! on ré-initialise si besoin le stockage des contours
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
      end if
      if( allocated(IJ_cont) ) then
         deallocate( IJ_cont )
      end if
      if( allocated(IS_cont) ) then
         deallocate( IS_cont )
      end if
      XY_cont_size = 0
      XY_cont_nb_cont = 0

      call pgcontxy_ec( mat, x, y, ni, nj, level_array, n_level, order )

      ! on ferme le dernier contour (s'il existe)
      if( XY_cont_nb_cont > 0 ) then
         n_points = XY_cont_current_pos - XY_cont_current_beg
         XY_cont(2,XY_cont_current_beg) = n_points
      end if

      linear_axis = .false.

      ! les [nouveaux] axes doivent être prêts
      range(1) = minval( x(2:ni-1,2:nj-1) ) ! x_min
      range(2) = maxval( x(2:ni-1,2:nj-1) ) ! x_max
      range(3) = minval( y(2:ni-1,2:nj-1) ) ! y_min
      range(4) = maxval( y(2:ni-1,2:nj-1) ) ! y_max

      ! Compute orientation of the first quadrangle. Used to sign the area
      ! of contours in 'ContourF_draw'.
      orientation = (x(2,1)-x(1,1))*(y(1,2)-y(2,1)) -                   &
                    (x(1,2)-x(2,1))*(y(2,1)-y(1,1))
      orientation = sign( 1.0d0, -orientation )
!!print *, "ContourFMat: orientation = ", orientation
!!pause

      call pgbbuf()

      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      ! color setting (depends on levels)
      allocate( icol_array(n_level) )

      do j = 1, n_level
         fact_icol = (level_array(j)-win%color_axes(1))/(win%color_axes(2)-win%color_axes(1))
         icol_array(j) = win%colormap_ci_low +                          &
                         fact_icol*(win%colormap_ci_high-win%colormap_ci_low)
      end do

      allocate( XXYY_cont(2,XY_cont_current_pos) )
      XXYY_cont = XY_cont(:,1:XY_cont_current_pos)

      ! Update XY_cont (perhaps it will be retrieved from mfOut)
      XY_cont(1:2,1:XY_cont_current_pos) = XXYY_cont(1:2,1:XY_cont_current_pos)

      ! Here, no further need of 'mat', we can deallocate it
      deallocate( x, y, mat )

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "contour_filled"
      grobj%struct%range = range

      grobj%struct%npt = n_level
      grobj%struct%npt2 = XY_cont_nb_cont
      grobj%struct%npt3 = XY_cont_current_pos

      grobj%struct%abs_mat => XXYY_cont

      grobj%struct%ang_text = orientation

      grobj%struct%bool1 = draw_labels
      grobj%struct%color = lab_color

      call pgqch( curr_char_size )
      grobj%struct%height_text = curr_char_size*lab_size ! absolute size

      allocate( grobj%struct%lev_tab(n_level) )
      grobj%struct%lev_tab(:) = level_array(1:n_level)

      allocate( grobj%struct%col_tab(n_level) )
      grobj%struct%col_tab(:) = icol_array(1:n_level)
      grobj%struct%linewidth = linewidth

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_contourF_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      else
         if( present(levels_sto_pg) ) then
            deallocate( levels_sto_pg )
         else
            deallocate( level_array )
         end if

         deallocate( icol_array )
      end if

      win%blank = .false.
      win%empty = .false.

   end function ContourFMat
