!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfContourF_z( z,                                            &
                          nb_levels, levels, linewidth,                 &
                          labels, labelscolor, labelsize )              &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msContourF_z( z,                                          &
                            nb_levels, levels, linewidth,               &
                            labels, labelscolor, labelsize )
#endif

      type(mfArray)                              :: z
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize


      integer :: handle
      !------ API end ------

      ! makes contours of equidistant data stored in the matrix z
      !
      ! coordinates are integer values corresponding to the matrix
      ! indexes

      type(mfArray) :: levels_copy

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: mat_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: z_min_max_exist
      type(mf_win_info), pointer :: win
      integer :: i, j, ii, jj
      real(kind=MF_DOUBLE) :: linewidth_d, val_prev, val_curr
      logical :: present_color

      logical :: draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: ni, nj, n_level
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfContourF"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msContourF"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( z )
      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ni = size(z_ptr,1)
      nj = size(z_ptr,2)

      if( ni < 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "number of rows is too small!" )
         go to 99
      end if
      if( nj < 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "number of columns is too small!" )
         go to 99
      end if

      z_min = minval(z_ptr)
      z_max = maxval(z_ptr)

      win => mf_win_db(CURRENT_WIN_ID)
      if( .not. win%color_axis_set ) then
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      ! Surround the matrix by a very low region to get closed contours,
      ! and replace any NaN with low numbers as well.
      allocate( mat_sto_pg(ni+2,nj+2) )

      mat_sto_pg(2:ni+1,2:nj+1) = z_ptr(:,:)
      mat_sto_pg(1,:)    = MF_NAN
      mat_sto_pg(ni+2,:) = MF_NAN
      mat_sto_pg(:,1)    = MF_NAN
      mat_sto_pg(:,nj+2) = MF_NAN

      do i = 1, ni+2
         do j = 1, nj + 2
            if( isnan(mat_sto_pg(i,j)) ) then
               mat_sto_pg(i,j) = z_min-1.0d4*(z_max-z_min)
            end if
         end do
      end do

      call msFreePointer( z, z_ptr )

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
      end if

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Colormap has not yet been defined!",       &
                            "(you may obtain strange or unexpected results;", &
                            " in particular, colors may differ between X11", &
                            " screen and printed figure)" )
         end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(levels) ) then
         levels_copy = levels
         ! Sort the levels by increasing values
         levels_copy = mfSort( levels_copy )
         ! If needed, remove duplicated values
         i = 2
         val_prev = mfGet(levels_copy,1)
         do
            if( i > size(levels_copy) ) exit
            val_curr = mfGet(levels_copy,i)
            if( val_curr == val_prev ) then
               call msSet( MF_EMPTY, levels_copy, i )
            else
               i = i + 1
               val_prev = val_curr
            end if
         end do
         ! Extracting the levels' vector
         call msPointer( levels_copy, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels_copy, levels_ptr )
         call msRelease( levels_copy )

         handle = ContourFVec( mat_sto_pg, n_level,                     &
                               draw_labels, lab_color, lab_size,        &
                               linewidth_d, levels_sto_pg=levels_sto_pg )
      else
         handle = ContourFVec( mat_sto_pg, n_level,                     &
                               draw_labels, lab_color, lab_size,        &
                               linewidth_d )
      end if

 99   continue

      call msFreeArgs( z )
      call msAutoRelease( z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
         deallocate( IJ_cont )
      end if
      if( allocated(IS_cont) ) then
         deallocate( IS_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfContourF_z
#endif
#ifdef _MF_SUBR
   end subroutine msContourF_z
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfContourF_xyz( x, y, z,                                    &
                            nb_levels, levels, linewidth,               &
                            labels, labelscolor, labelsize )            &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msContourF_xyz( x, y, z,                                  &
                              nb_levels, levels, linewidth,             &
                              labels, labelscolor, labelsize )
#endif

      type(mfArray)                              :: x, y, z
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer :: handle
      !------ API end ------

      type(mfArray) :: levels_copy

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_abs_sto_pg(:,:), mat_ord_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: z_min_max_exist
      type(mf_win_info), pointer :: win
      integer :: i, j, ii, jj
      real(kind=MF_DOUBLE) :: linewidth_d, val_prev, val_curr
      logical :: present_color

      logical :: full_matrix, draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: ni, nj, nx_pg, ny_pg, p_dim, n_level
      integer :: nx_abs, ny_abs, nx_ord, ny_ord
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfContourF"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msContourF"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z )

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! All checks on 'x', 'y' and 'z' must be done first!

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      ! End of checks -----------------------------------!

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      full_matrix = .false.
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! matrix
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         allocate( mat_abs_sto_pg(ny_abs+2,nx_abs+2) )
         mat_abs_sto_pg(2:ny_abs+1,2:nx_abs+1) = x_ptr(:,:)
         ! North side
         do jj = 2, nx_abs+1
            j = jj - 1
            mat_abs_sto_pg(1,jj) = 2*x_ptr(1,j) - x_ptr(2,j)
         end do
         ! South side
         do jj = 2, nx_abs+1
            j = jj - 1
            mat_abs_sto_pg(ny_abs+2,jj) = 2*x_ptr(ny_abs,j) - x_ptr(ny_abs-1,j)
         end do
         ! West side
         do ii = 2, ny_abs+1
            i = ii - 1
            mat_abs_sto_pg(ii,1) = 2*x_ptr(i,1) - x_ptr(i,2)
         end do
         ! East side
         do ii = 2, ny_abs+1
            i = ii - 1
            mat_abs_sto_pg(ii,nx_abs+2) = 2*x_ptr(i,nx_abs) - x_ptr(i,nx_abs-1)
         end do
         ! NW corner
         mat_abs_sto_pg(1,1) = 2*x_ptr(1,1) - x_ptr(2,2)
         ! NE corner
         mat_abs_sto_pg(1,nx_abs+2) = 2*x_ptr(1,nx_abs) - x_ptr(2,nx_abs-1)
         ! SE corner
         mat_abs_sto_pg(ny_abs+2,nx_abs+2) = 2*x_ptr(ny_abs,nx_abs) - x_ptr(ny_abs-1,nx_abs-1)
         ! SW corner
         mat_abs_sto_pg(ny_abs+2,1) = 2*x_ptr(ny_abs,1) - x_ptr(ny_abs-1,2)
      else                                               ! vector
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         nx_pg = size(x_ptr,p_dim)
         allocate( x_sto_pg(nx_pg+2) )
         if( p_dim == 1 ) then
            x_sto_pg(2:nx_pg+1) = x_ptr(:,1)
            x_sto_pg(1) = 2*x_ptr(1,1) - x_ptr(2,1)
            x_sto_pg(nx_pg+2) = 2*x_ptr(nx_pg,1) - x_ptr(nx_pg-1,1)
         else
            x_sto_pg(2:nx_pg+1) = x_ptr(1,:)
            x_sto_pg(1) = 2*x_ptr(1,1) - x_ptr(1,2)
            x_sto_pg(nx_pg+2) = 2*x_ptr(1,nx_pg) - x_ptr(1,nx_pg-1)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         allocate( mat_ord_sto_pg(ny_ord+2,nx_ord+2) )
         mat_ord_sto_pg(2:ny_ord+1,2:nx_ord+1) = y_ptr(:,:)
         ! North side
         do jj = 2, nx_ord+1
            j = jj - 1
            mat_ord_sto_pg(1,jj) = 2*y_ptr(1,j) - y_ptr(2,j)
         end do
         ! South side
         do jj = 2, nx_ord+1
            j = jj - 1
            mat_ord_sto_pg(ny_ord+2,jj) = 2*y_ptr(ny_ord,j) - y_ptr(ny_ord-1,j)
         end do
         ! West side
         do ii = 2, ny_ord+1
            i = ii - 1
            mat_ord_sto_pg(ii,1) = 2*y_ptr(i,1) - y_ptr(i,2)
         end do
         ! East side
         do ii = 2, ny_ord+1
            i = ii - 1
            mat_ord_sto_pg(ii,nx_ord+2) = 2*y_ptr(i,nx_ord) - y_ptr(i,nx_ord-1)
         end do
         ! NW corner
         mat_ord_sto_pg(1,1) = 2*y_ptr(1,1) - y_ptr(2,2)
         ! NE corner
         mat_ord_sto_pg(1,nx_ord+2) = 2*y_ptr(1,nx_ord) - y_ptr(2,nx_ord-1)
         ! SE corner
         mat_ord_sto_pg(ny_ord+2,nx_ord+2) = 2*y_ptr(ny_ord,nx_ord) - y_ptr(ny_ord-1,nx_abs-1)
         ! SW corner
         mat_ord_sto_pg(ny_ord+2,1) = 2*y_ptr(ny_ord,1) - y_ptr(ny_ord-1,2)
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         ny_pg = size(y_ptr,p_dim)
         allocate( y_sto_pg(ny_pg+2) )
         if( p_dim == 1 ) then
            y_sto_pg(2:ny_pg+1) = y_ptr(:,1)
            y_sto_pg(1) = 2*y_ptr(1,1) - y_ptr(2,1)
            y_sto_pg(ny_pg+2) = 2*y_ptr(ny_pg,1) -y_ptr(ny_pg-1,1)
         else
            y_sto_pg(2:ny_pg+1) = y_ptr(1,:)
            y_sto_pg(1) = 2*y_ptr(1,1) - y_ptr(1,2)
            y_sto_pg(ny_pg+2) = 2*y_ptr(1,ny_pg) - y_ptr(1,ny_pg-1)
         end if
      end if

      call msFreePointer( y, y_ptr )

      call msPointer( z, z_ptr, no_crc=.true. )

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      ni = size(z_ptr,1)
      nj = size(z_ptr,2)

      if( full_matrix ) then ! coords (x,y) are matrices

         if( ni /= ny_abs .or. nj /= nx_abs ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'x' and 'z' don't match!" )
            go to 99
         end if
         if( ni /= ny_ord .or. nj /= nx_ord ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'y' and 'z' don't match!" )
            go to 99
         end if

      else ! not full matrix i.e. coords (x,y) are vectors

         if( nj /= nx_pg ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'x' and 'z' don't match!" )
            go to 99
         end if
         if( ni /= ny_pg ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'y' and 'z' don't match!" )
            go to 99
         end if

      end if

      z_min = minval(z_ptr)
      z_max = maxval(z_ptr)

      if( .not. win%color_axis_set ) then
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      ! Surround the matrix by a very low region to get closed contours,
      ! and replace any NaN with low numbers as well.
      allocate( mat_sto_pg(ni+2,nj+2) )

      mat_sto_pg(2:ni+1,2:nj+1) = z_ptr(:,:)
      mat_sto_pg(1,:)    = MF_NAN
      mat_sto_pg(ni+2,:) = MF_NAN
      mat_sto_pg(:,1)    = MF_NAN
      mat_sto_pg(:,nj+2) = MF_NAN

      do i = 1, ni+2
         do j = 1, nj + 2
            if( isnan(mat_sto_pg(i,j)) ) then
               mat_sto_pg(i,j) = z_min-1.0d4*(z_max-z_min)
            end if
         end do
      end do

      call msFreePointer( z, z_ptr )

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Colormap has not yet been defined!",       &
                            "(you may obtain strange or unexpected results;", &
                            " in particular, colors may differ between X11", &
                            " screen and printed figure)" )
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(levels) ) then
         levels_copy = levels
         ! Sort the levels by increasing values
         levels_copy = mfSort( levels_copy )
         ! If needed, remove duplicated values
         i = 2
         val_prev = mfGet(levels_copy,1)
         do
            if( i > size(levels_copy) ) exit
            val_curr = mfGet(levels_copy,i)
            if( val_curr == val_prev ) then
               call msSet( MF_EMPTY, levels_copy, i )
            else
               i = i + 1
               val_prev = val_curr
            end if
         end do
         ! Extracting the levels' vector
         call msPointer( levels_copy, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels_copy, levels_ptr )
         call msRelease( levels_copy )
      end if

      if( full_matrix ) then
         ! full matrix case
         if( present(levels) ) then
            handle = ContourFMat( mat_sto_pg, n_level,                  &
                                  draw_labels, lab_color, lab_size,     &
                                  linewidth_d,                          &
                                  mat_abs_sto_pg, mat_ord_sto_pg,       &
                                  levels_sto_pg=levels_sto_pg )
         else
            handle = ContourFMat( mat_sto_pg, n_level,                  &
                                  draw_labels, lab_color, lab_size,     &
                                  linewidth_d,                          &
                                  mat_abs_sto_pg, mat_ord_sto_pg )
         end if

      else ! not full matrix

         ! vector case
         if( present(levels) ) then
            handle = ContourFVec( mat_sto_pg, n_level,                  &
                                  draw_labels, lab_color, lab_size,     &
                                  linewidth_d,                          &
                                  x_sto_pg, y_sto_pg,                   &
                                  levels_sto_pg=levels_sto_pg )
         else
            handle = ContourFVec( mat_sto_pg, n_level,                  &
                                  draw_labels, lab_color, lab_size,     &
                                  linewidth_d,                          &
                                  x_sto_pg, y_sto_pg )
         end if

      end if

 99   continue

      call msFreeArgs( x, y, z )
      call msAutoRelease( x, y, z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
         deallocate( IJ_cont )
      end if
      if( allocated(IS_cont) ) then
         deallocate( IS_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfContourF_xyz
#endif
#ifdef _MF_SUBR
   end subroutine msContourF_xyz
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfContourF_xyz_out( out, x, y, z,                           &
                                nb_levels, levels, linewidth,           &
                                labels, labelscolor, labelsize )        &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msContourF_xyz_out( out, x, y, z,                         &
                                  nb_levels, levels, linewidth,         &
                                  labels, labelscolor, labelsize )
#endif

      type(mf_Out)                               :: out
      type(mfArray)                              :: x, y, z
      integer,              intent(in), optional :: nb_levels
      type(mfArray),        intent(in), optional :: levels
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer :: handle
      !------ API end ------

      type(mfArray) :: levels_copy

      ! pointers for manipulating mfArray out of fml module
      type(mfArray), pointer :: out1
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_abs_sto_pg(:,:), mat_ord_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      type(mf_win_info), pointer :: win
      integer :: i, j, ii, jj
      real(kind=MF_DOUBLE) :: linewidth_d, val_prev, val_curr
      logical :: present_color

      logical :: full_matrix, draw_labels
      integer :: lab_color
      real(kind=MF_DOUBLE) :: lab_size
      integer :: ni, nj, nx_pg, ny_pg, p_dim, n_level
      integer :: nx_abs, ny_abs, nx_ord, ny_ord
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfContourF"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msContourF"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z )

      ! must have exactly one output argument in mfOut()
      if( out%n /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "exactly one output argument is required!" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, x, y, z, levels ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if
      out1 => out%ptr1

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! All checks on 'x', 'y' and 'z' must be done first!

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      ! End of checks -----------------------------------!

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      full_matrix = .false.
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! matrix
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         allocate( mat_abs_sto_pg(ny_abs+2,nx_abs+2) )
         mat_abs_sto_pg(2:ny_abs+1,2:nx_abs+1) = x_ptr(:,:)
         ! North side
         do jj = 2, nx_abs+1
            j = jj - 1
            mat_abs_sto_pg(1,jj) = 2*x_ptr(1,j) - x_ptr(2,j)
         end do
         ! South side
         do jj = 2, nx_abs+1
            j = jj - 1
            mat_abs_sto_pg(ny_abs+2,jj) = 2*x_ptr(ny_abs,j) - x_ptr(ny_abs-1,j)
         end do
         ! West side
         do ii = 2, ny_abs+1
            i = ii - 1
            mat_abs_sto_pg(ii,1) = 2*x_ptr(i,1) - x_ptr(i,2)
         end do
         ! East side
         do ii = 2, ny_abs+1
            i = ii - 1
            mat_abs_sto_pg(ii,nx_abs+2) = 2*x_ptr(i,nx_abs) - x_ptr(i,nx_abs-1)
         end do
         ! NW corner
         mat_abs_sto_pg(1,1) = 2*x_ptr(1,1) - x_ptr(2,2)
         ! NE corner
         mat_abs_sto_pg(1,nx_abs+2) = 2*x_ptr(1,nx_abs) - x_ptr(2,nx_abs-1)
         ! SE corner
         mat_abs_sto_pg(ny_abs+2,nx_abs+2) = 2*x_ptr(ny_abs,nx_abs) - x_ptr(ny_abs-1,nx_abs-1)
         ! SW corner
         mat_abs_sto_pg(ny_abs+2,1) = 2*x_ptr(ny_abs,1) - x_ptr(ny_abs-1,2)
      else                                               ! vector
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         nx_pg = size(x_ptr,p_dim)
         allocate( x_sto_pg(nx_pg+2) )
         if( p_dim == 1 ) then
            x_sto_pg(2:nx_pg+1) = x_ptr(:,1)
            x_sto_pg(1) = 2*x_ptr(1,1) - x_ptr(2,1)
            x_sto_pg(nx_pg+2) = 2*x_ptr(nx_pg,1) - x_ptr(nx_pg-1,1)
         else
            x_sto_pg(2:nx_pg+1) = x_ptr(1,:)
            x_sto_pg(1) = 2*x_ptr(1,1) - x_ptr(1,2)
            x_sto_pg(nx_pg+2) = 2*x_ptr(1,nx_pg) - x_ptr(1,nx_pg-1)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         allocate( mat_ord_sto_pg(ny_ord+2,nx_ord+2) )
         mat_ord_sto_pg(2:ny_ord+1,2:nx_ord+1) = y_ptr(:,:)
         ! North side
         do jj = 2, nx_ord+1
            j = jj - 1
            mat_ord_sto_pg(1,jj) = 2*y_ptr(1,j) - y_ptr(2,j)
         end do
         ! South side
         do jj = 2, nx_ord+1
            j = jj - 1
            mat_ord_sto_pg(ny_ord+2,jj) = 2*y_ptr(ny_ord,j) - y_ptr(ny_ord-1,j)
         end do
         ! West side
         do ii = 2, ny_ord+1
            i = ii - 1
            mat_ord_sto_pg(ii,1) = 2*y_ptr(i,1) - y_ptr(i,2)
         end do
         ! East side
         do ii = 2, ny_ord+1
            i = ii - 1
            mat_ord_sto_pg(ii,nx_ord+2) = 2*y_ptr(i,nx_ord) - y_ptr(i,nx_ord-1)
         end do
         ! NW corner
         mat_ord_sto_pg(1,1) = 2*y_ptr(1,1) - y_ptr(2,2)
         ! NE corner
         mat_ord_sto_pg(1,nx_ord+2) = 2*y_ptr(1,nx_ord) - y_ptr(2,nx_ord-1)
         ! SE corner
         mat_ord_sto_pg(ny_ord+2,nx_ord+2) = 2*y_ptr(ny_ord,nx_ord) - y_ptr(ny_ord-1,nx_abs-1)
         ! SW corner
         mat_ord_sto_pg(ny_ord+2,1) = 2*y_ptr(ny_ord,1) - y_ptr(ny_ord-1,2)
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         ny_pg = size(y_ptr,p_dim)
         allocate( y_sto_pg(ny_pg+2) )
         if( p_dim == 1 ) then
            y_sto_pg(2:ny_pg+1) = y_ptr(:,1)
            y_sto_pg(1) = 2*y_ptr(1,1) - y_ptr(2,1)
            y_sto_pg(ny_pg+2) = 2*y_ptr(ny_pg,1) -y_ptr(ny_pg-1,1)
         else
            y_sto_pg(2:ny_pg+1) = y_ptr(1,:)
            y_sto_pg(1) = 2*y_ptr(1,1) - y_ptr(1,2)
            y_sto_pg(ny_pg+2) = 2*y_ptr(1,ny_pg) - y_ptr(1,ny_pg-1)
         end if
      end if

      call msFreePointer( y, y_ptr )

      call msPointer( z, z_ptr, no_crc=.true. )

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      ni = size(z_ptr,1)
      nj = size(z_ptr,2)

      if( full_matrix ) then ! coords (x,y) are matrices

         if( ni /= ny_abs .or. nj /= nx_abs ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'x' and 'z' don't match!" )
            go to 99
         end if
         if( ni /= ny_ord .or. nj /= nx_ord ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'y' and 'z' don't match!" )
            go to 99
         end if

      else ! not full matrix i.e. coords (x,y) are vectors

         if( nj /= nx_pg ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'x' and 'z' don't match!" )
            go to 99
         end if
         if( ni /= ny_pg ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'y' and 'z' don't match!" )
            go to 99
         end if

      end if

      z_min = minval(z_ptr)
      z_max = maxval(z_ptr)

      if( .not. win%color_axis_set ) then
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      ! Surround the matrix by a very low region to get closed contours,
      ! and replace any NaN with low numbers as well.
      allocate( mat_sto_pg(ni+2,nj+2) )

      mat_sto_pg(2:ni+1,2:nj+1) = z_ptr(:,:)
      mat_sto_pg(1,:)    = MF_NAN
      mat_sto_pg(ni+2,:) = MF_NAN
      mat_sto_pg(:,1)    = MF_NAN
      mat_sto_pg(:,nj+2) = MF_NAN

      do i = 1, ni+2
         do j = 1, nj + 2
            if( isnan(mat_sto_pg(i,j)) ) then
               mat_sto_pg(i,j) = z_min-1.0d4*(z_max-z_min)
            end if
         end do
      end do

      call msFreePointer( z, z_ptr )

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "Colormap has not yet been defined!",       &
                            "(you may obtain strange or unexpected results;", &
                            " in particular, colors may differ between X11", &
                            " screen and printed figure)" )
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(levels) ) then
         levels_copy = levels
         ! Sort the levels by increasing values
         levels_copy = mfSort( levels_copy )
         ! If needed, remove duplicated values
         i = 2
         val_prev = mfGet(levels_copy,1)
         do
            if( i > size(levels_copy) ) exit
            val_curr = mfGet(levels_copy,i)
            if( val_curr == val_prev ) then
               call msSet( MF_EMPTY, levels_copy, i )
            else
               i = i + 1
               val_prev = val_curr
            end if
         end do
         ! Extracting the levels' vector
         call msPointer( levels_copy, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels_copy, levels_ptr )
         call msRelease( levels_copy )
      end if

      if( full_matrix ) then
         ! full matrix case
         if( present(levels) ) then
            handle = ContourFMat( mat_sto_pg, n_level,                  &
                                  draw_labels, lab_color, lab_size,     &
                                  linewidth_d,                          &
                                  mat_abs_sto_pg, mat_ord_sto_pg,       &
                                  levels_sto_pg=levels_sto_pg )
         else
            handle = ContourFMat( mat_sto_pg, n_level,                  &
                                  draw_labels, lab_color, lab_size,     &
                                  linewidth_d,                          &
                                  mat_abs_sto_pg, mat_ord_sto_pg )
         end if

      else ! not full matrix

         ! vector case
         if( present(levels) ) then
            handle = ContourFVec( mat_sto_pg, n_level,                  &
                                  draw_labels, lab_color, lab_size,     &
                                  linewidth_d,                          &
                                  x_sto_pg, y_sto_pg,                   &
                                  levels_sto_pg=levels_sto_pg )
         else
            handle = ContourFVec( mat_sto_pg, n_level,                  &
                                  draw_labels, lab_color, lab_size,     &
                                  linewidth_d,                          &
                                  x_sto_pg, y_sto_pg )
         end if

      end if

      if( XY_cont_nb_cont > 0 ) then
         out1 = XY_cont(1:2,1:XY_cont_current_pos)
      end if

 99   continue

      call msFreeArgs( x, y, z )
      call msAutoRelease( x, y, z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
         deallocate( IJ_cont )
      end if
      if( allocated(IS_cont) ) then
         deallocate( IS_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfContourF_xyz_out
#endif
#ifdef _MF_SUBR
   end subroutine msContourF_xyz_out
#endif
