!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfContour_z( z,                                             &
                         nb_levels, levels, order,                      &
                         linespec, linewidth,                           &
                         labels, labelscolor, labelsize )               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msContour_z( z,                                           &
                           nb_levels, levels, order,                    &
                           linespec, linewidth,                         &
                           labels, labelscolor, labelsize )
#endif

      type(mfArray)                              :: z
      integer,              intent(in), optional :: nb_levels, order
      type(mfArray),        intent(in), optional :: levels
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize


      integer :: handle
      !------ API end ------

      ! makes contours of equidistant data stored in the matrix z
      !
      ! coordinates are integer values corresponding to the matrix
      ! indexes

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: mat_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: z_min_max_exist
      type(mf_win_info), pointer :: win
      integer :: icolor, istyle, imarker
      real(kind=MF_DOUBLE) :: linewidth_d
      logical :: present_color

      logical :: draw_labels
      integer :: lab_color, order_0
      real(kind=MF_DOUBLE) :: lab_size
      integer :: ni, nj, n_level
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfContour"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msContour"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( z )
      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      call msPointer( z, z_ptr, no_crc=.true. )

      ni = size(z_ptr,1)
      nj = size(z_ptr,2)

      if( ni < 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "number of rows is too small!" )
         go to 99
      end if
      if( nj < 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "number of columns is too small!" )
         go to 99
      end if

      allocate( mat_sto_pg(ni,nj) )

      mat_sto_pg(:,:) = z_ptr(:,:)

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'ij' axis mode is selected
      win%axis_mode_xy = .false.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      z_min_max_exist = .false.
      if( .not. win%color_axis_set ) then
         z_min = minval(mat_sto_pg(:,:))
         z_max = maxval(mat_sto_pg(:,:))
         z_min_max_exist = .true.
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( .not. z_min_max_exist ) then
            z_min = minval(mat_sto_pg(:,:))
            z_max = maxval(mat_sto_pg(:,:))
         end if
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
      end if

      call msFreePointer( z, z_ptr )

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, icolor, istyle, imarker )
         if( icolor == -127 ) then
            present_color = .false.
         else
            present_color = .true.
         end if
         if( istyle == -127 ) then
            istyle = 1
         end if
         if( imarker /= -127 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "Marker cannot be selected!",            &
                               "(a continuous line will be used, as default)" )
         end if
      else
         present_color = .false.
         istyle = 1 ! continuous
      end if

      if( .not. present_color ) then
         if( .not. win%colormap_init ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "Colormap has not yet been defined!",    &
                               "(you may obtain strange or unexpected results;", &
                               " in particular, colors may differ between X11", &
                               " screen and printed figure)" )
         end if
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(order) ) then
         order_0 = order
      else
         order_0 = 1
      end if

      if( order_0 < 1 .or. 2 < order_0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'order' must be equal to 1 or 2!" )
         go to 99
      end if

      if( present(levels) ) then
         ! extracting the levels' vector
         call msPointer( levels, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels, levels_ptr )

         handle = ContourVec( mat_sto_pg, n_level,                      &
                              draw_labels, lab_color, lab_size,         &
                              icolor, present_color, istyle, linewidth_d, &
                              order=order_0, levels_sto_pg=levels_sto_pg )
      else
         handle = ContourVec( mat_sto_pg, n_level,                      &
                              draw_labels, lab_color, lab_size,         &
                              icolor, present_color, istyle, linewidth_d, &
                              order=order_0 )
      end if

 99   continue

      call msFreeArgs( z )
      call msAutoRelease( z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
         deallocate( IJ_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfContour_z
#endif
#ifdef _MF_SUBR
   end subroutine msContour_z
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfContour_xyz( x, y, z,                                     &
                           nb_levels, levels, order,                    &
                           linespec, linewidth,                         &
                           labels, labelscolor, labelsize )             &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msContour_xyz( x, y, z,                                   &
                             nb_levels, levels, order,                  &
                             linespec, linewidth,                       &
                             labels, labelscolor, labelsize )
#endif

      type(mfArray)                              :: x, y, z
      integer,              intent(in), optional :: nb_levels, order
      type(mfArray),        intent(in), optional :: levels
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_abs_sto_pg(:,:), mat_ord_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: z_min_max_exist
      type(mf_win_info), pointer :: win
      integer :: icolor, istyle, imarker
      real(kind=MF_DOUBLE) :: linewidth_d
      logical :: present_color

      logical :: full_matrix, draw_labels
      integer :: lab_color, order_0
      real(kind=MF_DOUBLE) :: lab_size
      integer :: ni, nj, nx_pg, ny_pg, p_dim, n_level
      integer :: nx_abs, ny_abs, nx_ord, ny_ord
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfContour"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msContour"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z )

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! All checks on 'x', 'y' and 'z' must be done first!

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      ! End of checks -----------------------------------!

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      full_matrix = .false.
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! matrix
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         allocate( mat_abs_sto_pg(ny_abs,nx_abs) )

         mat_abs_sto_pg(:,:) = x_ptr(:,:)
      else                                               ! vector
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         nx_pg = size(x_ptr,p_dim)
         allocate( x_sto_pg(nx_pg) )

         if( p_dim == 1 ) then
            x_sto_pg(:) = x_ptr(:,1)
         else
            x_sto_pg(:) = x_ptr(1,:)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         allocate( mat_ord_sto_pg(ny_ord,nx_ord) )

         mat_ord_sto_pg(:,:) = y_ptr(:,:)
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         ny_pg = size(y_ptr,p_dim)
         allocate( y_sto_pg(ny_pg) )

         if( p_dim == 1 ) then
            y_sto_pg(:) = y_ptr(:,1)
         else
            y_sto_pg(:) = y_ptr(1,:)
         end if
      end if

      call msFreePointer( y, y_ptr )

      call msPointer( z, z_ptr, no_crc=.true. )

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      ni = size(z_ptr,1)
      nj = size(z_ptr,2)

      if( full_matrix ) then ! coords (x,y) are matrices

         if( ni /= ny_abs .or. nj /= nx_abs ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'x' and 'z' don't match!" )
            go to 99
         end if
         if( ni /= ny_ord .or. nj /= nx_ord ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'y' and 'z' don't match!" )
            go to 99
         end if

      else ! not full matrix i.e. coords (x,y) are vectors

         if( nj /= nx_pg ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'x' and 'z' don't match!" )
            go to 99
         end if
         if( ni /= ny_pg ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'y' and 'z' don't match!" )
            go to 99
         end if

      end if

      allocate( mat_sto_pg(ni,nj) )

      mat_sto_pg(:,:) = z_ptr(:,:)

      call msFreePointer( z, z_ptr )

      z_min_max_exist = .false.
      if( .not. win%color_axis_set ) then
         z_min = minval(mat_sto_pg(:,:))
         z_max = maxval(mat_sto_pg(:,:))
         z_min_max_exist = .true.
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( .not. z_min_max_exist ) then
            z_min = minval(mat_sto_pg(:,:))
            z_max = maxval(mat_sto_pg(:,:))
         end if
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, icolor, istyle, imarker )
         if( icolor == -127 ) then
            present_color = .false.
         else
            present_color = .true.
         end if
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         present_color = .false.
         istyle = 1 ! continuous
      end if

      if( .not. present_color ) then
         if( .not. win%colormap_init ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "Colormap has not yet been defined!",     &
                              "(you may obtain strange or unexpected results;", &
                              " in particular, colors may differ between X11", &
                              " screen and printed figure)" )
         end if
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(order) ) then
         order_0 = order
      else
         order_0 = 1
      end if

      if( order_0 < 1 .or. 2 < order_0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'order' must be equal to 1 or 2!" )
         go to 99
      end if

      if( present(levels) ) then
         ! extracting the levels' vector
         call msPointer( levels, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels, levels_ptr )
      end if

      if( full_matrix ) then

         ! full matrix case
         if( present(levels) ) then
            handle = ContourMat( mat_sto_pg, n_level,                   &
                                 draw_labels, lab_color, lab_size,      &
                                 icolor, present_color, istyle, linewidth_d, &
                                 order_0, mat_abs_sto_pg, mat_ord_sto_pg, &
                                 levels_sto_pg=levels_sto_pg )
         else
            handle = ContourMat( mat_sto_pg, n_level,                   &
                                 draw_labels, lab_color, lab_size,      &
                                 icolor, present_color, istyle, linewidth_d, &
                                 order_0, mat_abs_sto_pg, mat_ord_sto_pg )
         end if

      else ! not full matrix

         ! vector case
         if( present(levels) ) then
            handle = ContourVec( mat_sto_pg, n_level,                   &
                                 draw_labels, lab_color, lab_size,      &
                                 icolor, present_color, istyle, linewidth_d, &
                                 order_0, x_sto_pg, y_sto_pg,           &
                                 levels_sto_pg=levels_sto_pg )
         else
            handle = ContourVec( mat_sto_pg, n_level,                   &
                                 draw_labels, lab_color, lab_size,      &
                                 icolor, present_color, istyle, linewidth_d, &
                                 order_0, x_sto_pg, y_sto_pg )
         end if

      end if

 99   continue

      call msFreeArgs( x, y, z )
      call msAutoRelease( x, y, z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
         deallocate( IJ_cont )
      end if
      if( allocated(IS_cont) ) then
         deallocate( IS_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfContour_xyz
#endif
#ifdef _MF_SUBR
   end subroutine msContour_xyz
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfContour_xyz_out( out, x, y, z,                            &
                               nb_levels, levels, order,                &
                               linespec, linewidth,                     &
                               labels, labelscolor, labelsize )         &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msContour_xyz_out( out, x, y, z,                          &
                                 nb_levels, levels, order,              &
                                 linespec, linewidth,                   &
                                 labels, labelscolor, labelsize )
#endif

      type(mf_Out)                               :: out
      type(mfArray)                              :: x, y, z
      integer,              intent(in), optional :: nb_levels, order
      type(mfArray),        intent(in), optional :: levels
      character(len=*),     intent(in), optional :: linespec
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth
      logical,              intent(in), optional :: labels
      character(len=*),     intent(in), optional :: labelscolor
      real(kind=MF_DOUBLE), intent(in), optional :: labelsize

      integer :: handle
      !------ API end ------

      ! pointers for manipulating mfArray out of fml module
      type(mfArray), pointer :: out1
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:), z_ptr(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: mat_abs_sto_pg(:,:), mat_ord_sto_pg(:,:)
      real(kind=MF_DOUBLE), pointer :: levels_sto_pg(:)
      real(kind=MF_DOUBLE) :: z_min, z_max
      logical :: z_min_max_exist
      type(mf_win_info), pointer :: win
      integer :: icolor, istyle, imarker
      real(kind=MF_DOUBLE) :: linewidth_d
      logical :: present_color

      logical :: full_matrix, draw_labels
      integer :: lab_color, order_0
      real(kind=MF_DOUBLE) :: lab_size
      integer :: ni, nj, nx_pg, ny_pg, p_dim, n_level
      integer :: nx_abs, ny_abs, nx_ord, ny_ord
      integer :: mf_message_level_save

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfContour"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msContour"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call msInitArgs( x, y, z )

      ! must have exactly one output argument in mfOut()
      if( out%n /= 1 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "exactly one output argument is required!" )
         go to 99
      end if

      ! check args of mfOut
      if( .not. args_mfout_ok( out, x, y, z, levels ) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "output arguments cannot be tempo, or cannot share",&
                            "same memory as another input argument." )
         go to 99
      end if
      out1 => out%ptr1

      if( present(levels) ) then
         call msInitArgs( levels )
         ! 'levels' must be a vector
         if( .not. (mfIsVector(levels) .or. mfIsScalar(levels)) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'levels' must be a vector!" )
            go to 99
         end if
      end if

      ! All checks on 'x', 'y' and 'z' must be done first!

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      ! 'x' cannot contain NaN values
      if( Any(mfIsNaN(x)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot contain NaN values!" )
         go to 99
      end if

      ! checking that 'y' is allocated
      if( mfIsEqual(y,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' not allocated!" )
         go to 99
      end if

      ! 'y' must be real
      if( .not. mfIsReal(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' must be real!" )
         go to 99
      end if

      ! 'y' cannot be sparse
      if( mfIsSparse(y) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot be sparse!" )
         go to 99
      end if

      ! 'y' cannot contain NaN values
      if( Any(mfIsNaN(y)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'y' cannot contain NaN values!" )
         go to 99
      end if

      ! checking that 'z' is allocated
      if( mfIsEqual(z,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' not allocated!" )
         go to 99
      end if

      ! 'z' must be real
      if( .not. mfIsReal(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' must be real!" )
         go to 99
      end if

      ! 'z' cannot be sparse
      if( mfIsSparse(z) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot be sparse!" )
         go to 99
      end if

      ! 'z' cannot contain NaN values
      if( Any(mfIsNaN(z)) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'z' cannot contain NaN values!" )
         go to 99
      end if

      ! End of checks -----------------------------------!

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

      full_matrix = .false.
      if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then ! matrix
         full_matrix = .true.
         ny_abs = size(x_ptr,1)
         nx_abs = size(x_ptr,2)
         allocate( mat_abs_sto_pg(ny_abs,nx_abs) )

         mat_abs_sto_pg(:,:) = x_ptr(:,:)
      else                                               ! vector
         if( size(x_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         nx_pg = size(x_ptr,p_dim)
         allocate( x_sto_pg(nx_pg) )

         if( p_dim == 1 ) then
            x_sto_pg(:) = x_ptr(:,1)
         else
            x_sto_pg(:) = x_ptr(1,:)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then ! matrix
         if( .not. full_matrix ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' should be a full matrix, as 'x'!" )
            go to 99
         end if
         ny_ord = size(y_ptr,1)
         nx_ord = size(y_ptr,2)
         allocate( mat_ord_sto_pg(ny_ord,nx_ord) )

         mat_ord_sto_pg(:,:) = y_ptr(:,:)
      else                                               ! vector
         if( size(y_ptr,1) == 1 ) then
            p_dim = 2
         else
            p_dim = 1
         end if
         ny_pg = size(y_ptr,p_dim)
         allocate( y_sto_pg(ny_pg) )

         if( p_dim == 1 ) then
            y_sto_pg(:) = y_ptr(:,1)
         else
            y_sto_pg(:) = y_ptr(1,:)
         end if
      end if

      call msFreePointer( y, y_ptr )

      call msPointer( z, z_ptr, no_crc=.true. )

      if( present(nb_levels) ) then
         if( present(levels) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'nb_levels' and 'levels' optional arguments cannot be used together!" )
         end if
         n_level = nb_levels
      else
         if( .not. present(levels) ) then
            n_level = 9 ! e.g. 0.1:0.1:0.9 if whole range is [0,1]
         end if
      end if

      if( present(labels) ) then
         draw_labels = labels
      else
         draw_labels = .true.
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! 'xy' axis mode is selected
      win%axis_mode_xy = .true.
      ! If axis are in the 'manual' mode, keep them as is.
      if( win%axis_manual_x == 0 ) then
         win%axis_manual_x = 2 ! 'tight'
      end if
      if( win%axis_manual_y == 0 ) then
         win%axis_manual_y = 2 ! 'tight'
      end if
      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      ni = size(z_ptr,1)
      nj = size(z_ptr,2)

      if( full_matrix ) then ! coords (x,y) are matrices

         if( ni /= ny_abs .or. nj /= nx_abs ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'x' and 'z' don't match!" )
            go to 99
         end if
         if( ni /= ny_ord .or. nj /= nx_ord ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'y' and 'z' don't match!" )
            go to 99
         end if

      else ! not full matrix i.e. coords (x,y) are vectors

         if( nj /= nx_pg ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'x' and 'z' don't match!" )
            go to 99
         end if
         if( ni /= ny_pg ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "dimension of 'y' and 'z' don't match!" )
            go to 99
         end if

      end if

      allocate( mat_sto_pg(ni,nj) )

      mat_sto_pg(:,:) = z_ptr(:,:)

      call msFreePointer( z, z_ptr )

      z_min_max_exist = .false.
      if( .not. win%color_axis_set ) then
         z_min = minval(mat_sto_pg(:,:))
         z_max = maxval(mat_sto_pg(:,:))
         z_min_max_exist = .true.
         call set_color_axis( win, [ z_min, z_max ] )
      end if

      ! warning if some data lead to color overflow (only for the
      ! shading="interp" case, because when shading is flat, this will
      ! be processed elsewhere)
      if( win%shading == "interp" ) then
         if( .not. z_min_max_exist ) then
            z_min = minval(mat_sto_pg(:,:))
            z_max = maxval(mat_sto_pg(:,:))
         end if
         if( z_min < win%color_axes(1) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
         if( z_max > win%color_axes(2) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "data is out of Color Axis:",            &
                               "-> this will lead to strange colors!" )
         end if
      end if

      if( present(labelscolor) ) then
         call decode_colorspec( labelscolor, lab_color )
      else
         if( BLACK_ON_WHITE == 1 ) then
            lab_color = 1
         else
            lab_color = 0
         end if
      end if

      if( present(labelsize) ) then
         lab_size = labelsize
      else
         lab_size = 1.0 ! default character size
      end if

      if( present(linespec) ) then
         call decode_linespec( linespec, icolor, istyle, imarker )
         if( icolor == -127 ) then
            present_color = .false.
         else
            present_color = .true.
         end if
         if( istyle == -127 ) then
            istyle = 1
         end if
      else
         present_color = .false.
         istyle = 1 ! continuous
      end if

      if( .not. present_color ) then
         if( .not. win%colormap_init ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "Colormap has not yet been defined!",     &
                              "(you may obtain strange or unexpected results;", &
                              " in particular, colors may differ between X11", &
                              " screen and printed figure)" )
         end if
      end if

      if( present(linewidth) ) then
         linewidth_d = linewidth
      else
         linewidth_d = 1.0
      end if

      if( present(order) ) then
         order_0 = order
      else
         order_0 = 1
      end if

      if( order_0 < 1 .or. 2 < order_0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'order' must be equal to 1 or 2!" )
         go to 99
      end if

      if( present(levels) ) then
         ! extracting the levels' vector
         call msPointer( levels, levels_ptr, no_crc=.true. )
         if( size(levels_ptr,1) == 1 ) then
            n_level = size(levels_ptr,2)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(1,:)
         else
            n_level = size(levels_ptr,1)
            allocate( levels_sto_pg(n_level) )

            levels_sto_pg(:) = levels_ptr(:,1)
         end if
         call msFreePointer( levels, levels_ptr )
      end if

      if( full_matrix ) then

         ! full matrix case
         if( present(levels) ) then
            handle = ContourMat( mat_sto_pg, n_level,                   &
                                 draw_labels, lab_color, lab_size,      &
                                 icolor, present_color, istyle, linewidth_d, &
                                 order_0, mat_abs_sto_pg, mat_ord_sto_pg, &
                                 levels_sto_pg=levels_sto_pg )
         else
            handle = ContourMat( mat_sto_pg, n_level,                   &
                                 draw_labels, lab_color, lab_size,      &
                                 icolor, present_color, istyle, linewidth_d, &
                                 order_0, mat_abs_sto_pg, mat_ord_sto_pg )
         end if

      else ! not full matrix

         ! vector case
         if( present(levels) ) then
            handle = ContourVec( mat_sto_pg, n_level,                   &
                                 draw_labels, lab_color, lab_size,      &
                                 icolor, present_color, istyle, linewidth_d, &
                                 order_0, x_sto_pg, y_sto_pg,           &
                                 levels_sto_pg=levels_sto_pg )
         else
            handle = ContourVec( mat_sto_pg, n_level,                   &
                                 draw_labels, lab_color, lab_size,      &
                                 icolor, present_color, istyle, linewidth_d, &
                                 order_0, x_sto_pg, y_sto_pg )
         end if

      end if

      if( XY_cont_nb_cont > 0 ) then
         out1 = XY_cont(1:2,1:XY_cont_current_pos)
      end if

 99   continue

      call msFreeArgs( x, y, z )
      call msAutoRelease( x, y, z )
      if( present(levels) ) then
         call msFreeArgs( levels )
         call msAutoRelease( levels )
      end if

#ifndef _OPTIM
      if( allocated(XY_cont) ) then
         deallocate( XY_cont )
         deallocate( IJ_cont )
      end if
      if( allocated(IS_cont) ) then
         deallocate( IS_cont )
      end if
      XY_cont_current_pos = 0
      XY_cont_size = 0
      XY_cont_nb_cont = 0
#endif

#ifdef _MF_FUNC
   end function mfContour_xyz_out
#endif
#ifdef _MF_SUBR
   end subroutine msContour_xyz_out
#endif
