!_______________________________________________________________________
!
   function mfColormapSize( ) result ( size )

      integer :: size
      !------ API end ------

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "mfColormapSize"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no selected device!" )
         size = -1
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      size = win%colormap_ci_high - win%colormap_ci_low + 1

   end function mfColormapSize
!_______________________________________________________________________
!
   subroutine msColormapSize_string( string )

      character(len=*), intent(in) :: string
      !------ API end ------

      ! bien que les valeurs 'colormap_ci_low' et 'colormap_ci_high'
      ! soient définies statiquement dans le module 'fgl_win_db', cette
      ! routine permet de revenir aux valeurs par défaut si entre temps
      ! on a choisit un nombre de couleurs supérieur.

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msColormapSize"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
      end if

      if( to_lower(string) /= "auto" ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            'only "auto" is the valid string!' )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! same as default in mod_win_db.F90
      win%colormap_ci_low  = NCOLORS
      win%colormap_ci_high = NCOLORS + DEFAULT_NB_COLORS - 1

      call pgscir( win%colormap_ci_low, win%colormap_ci_high )

   end subroutine msColormapSize_string
!_______________________________________________________________________
!
   subroutine msColormapSize_size( size )

      integer, intent(in) :: size
      !------ API end ------

      character(len=8) :: str1, str2
      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msColormapSize"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
      end if

      if( size < 2 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "minimum number of colors is 2!" )
         return
      end if

      if( 4096 < size ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "maximum number of colors is 4096!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      win%colormap_ci_low  = 42
      win%colormap_ci_high = 42 + size - 1

      call pgscir( win%colormap_ci_low, win%colormap_ci_high )

   end subroutine msColormapSize_size
