!_______________________________________________________________________
!
   subroutine msColorbar( mode, position, label )

      character(len=*), intent(in) :: mode ! "on"|"off"
      character(len=*), intent(in), optional :: position ! "vert"|"horiz"
      character(len=*), intent(in), optional :: label
      !------ API end ------

      character(len=2) :: colorbar_pos
      character(len=80) :: colorbar_label

      real(kind=MF_DOUBLE) :: emin, emax, disp
      integer :: i, dev_width, dev_height, just, colbar
      integer :: axis_manual_save_x, axis_manual_save_y
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msColorbar"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( mode == "off" ) then
         win%colorbar = 0
         call mf_win_redraw( CURRENT_WIN_ID )
         return
      end if

      if( .not. win%colormap_init ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "colormap is not yet initialized!" )
         ! no return here... the colorbar will be drawn as soon as the
         ! colormap is defined.
      end if
      win%colormap_used = .true.

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      if( win%blank ) then
         call mf_win_draw_box( CURRENT_WIN_ID ) ! if needed
      end if

      if( mode == "on" ) then

         ! Default : colorbar is "vert" or "horiz", according the device
         ! length of the viewport.
         ! "ri" stands for "right side" and "image" (i.e. colored gradient)
         ! "bi" stands for "bottom side" and "image"

         ! Get the initial viewport dimension in device units.
         ! In all cases, this device dimension is changed, by decreasing
         ! the smaller side by a constant percentage, in order to make
         ! the colorbar and its label visible.
         dev_width  = grxmax(grcide) - grxmin(grcide)
         dev_height = grymax(grcide) - grymin(grcide)
         if( dev_width > dev_height ) then
            colorbar_pos = "bi"
         else
            colorbar_pos = "ri"
         end if

         if( present(position) ) then
            if( position == "vert" ) then
               colorbar_pos = "ri"
            else if( position == "horiz" ) then
               colorbar_pos = "bi"
            else
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "'position' arg. must be 'vert' or 'horiz'" )
            end if
         end if

         !### TODO 2: fix for a strange inversion of colors
         !            when colorbar is displayed in a vertical position...
         if( colorbar_pos == "ri" ) then
            COLORBAR_VERT = .true.
         else
            COLORBAR_VERT = .false.
         end if

         if( present(label) ) then
            colorbar_label = label
         else
            colorbar_label = ""
         end if

         ! side = colorbar_pos
         ! disp = computed during each redraw (see mf_win_redraw)
         ! width = 3.5 (constant value, see mf_win_redraw)
         ! (These values will be computed during each redraw)
         win%colorbar       = 1 ! lin
         win%colorbar_pos   = colorbar_pos
         win%colorbar_label = colorbar_label

         win%blank = .false.
         win%empty = .false.

         ! Because the viewport dimensions have changed, we must redraw
         ! all the figure...
         call mf_win_redraw( CURRENT_WIN_ID )

      else
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'mode' arg. should be 'on' or 'off'" )
      end if

   end subroutine msColorbar
