!_______________________________________________________________________
!
   function mfCAxis( ) result ( out )

      type(mfArray) :: out
      !------ API end ------

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "mfCAxis"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      out = win%color_axes(:)

      call msReturnArray( out ) ! set to tempo

   end function mfCAxis
!_______________________________________________________________________
!
   subroutine msCAxis_real_range( col_range )

      real(kind=MF_DOUBLE), intent(in) :: col_range(2)
      !------ API end ------

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msCAxis"

      real(kind=MF_DOUBLE) :: cr(2), old_color_axis(2)

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! check that the two numerical values are ordered
      if( col_range(1) > col_range(2) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "First value must be less than the second one." )
         return
      end if

      cr(:) = col_range(:)

      win%color_axis_extensible = .false.

      old_color_axis(:) = win%color_axes(:)

      call set_color_axis( win, cr )

      if( any( old_color_axis /= win%color_axes ) ) then
         ! the plot must be redrawn
         call mf_win_redraw( CURRENT_WIN_ID )
      end if

   end subroutine msCAxis_real_range
!_______________________________________________________________________
!
   subroutine msCAxis_mf_range( mf_range )

      type(mfArray) :: mf_range
      !------ API end ------

      type(mf_win_info), pointer :: win

      real(kind=MF_DOUBLE) :: dp_range(2)
      integer :: status
      character(len=80) :: string

      character(len=*), parameter :: ROUTINE_NAME = "msCAxis"

      real(kind=MF_DOUBLE) :: cr(2), old_color_axis(2)

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( mf_range )

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         go to 99
      end if

      ! checking that mf_range is allocated
      if( mfIsEqual(mf_range,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range' not initialized!" )
         go to 99
      end if

      ! 'mf_range' must be real
      if( .not. mfIsReal(mf_range) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range' must be real!" )
         go to 99
      end if

      ! 'mf_range' cannot be sparse
      if( mfIsSparse(mf_range) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range' cannot be sparse!" )
         go to 99
      end if

      ! 'mf_range' must be a vector
      if( .not. mfIsVector(mf_range) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range' must be a vector!" )
         go to 99
      end if

      call extract_vector_from_mfArray( mf_range, dp_range,             &
                                        status, string )
      if( status > 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range'" // trim(string) )
         go to 99
      end if

      if( status < 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range'" // trim(string),               &
                            "Imaginary parts of complex arg ignored." )
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      ! check that the two numerical values are ordered
      if( dp_range(1) > dp_range(2) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "First value must be less than the second one." )
         return
      end if

      cr(:) = dp_range(:)

      win%color_axis_extensible = .false.

      old_color_axis(:) = win%color_axes(:)

      call set_color_axis( win, cr )

      if( any( old_color_axis /= win%color_axes ) ) then
         ! the plot must be redrawn
         call mf_win_redraw( CURRENT_WIN_ID )
      end if

 99   continue

      call msFreeArgs( mf_range )
      call msAutoRelease( mf_range )

   end subroutine msCAxis_mf_range
!_______________________________________________________________________
!
   subroutine msCAxis_string( string )

      character(len=*), intent(in) :: string
      !------ API end ------

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msCAxis"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      if( string /= "reset" ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "bad argument value.",                      &
                            '(when the argument is a string, the only possible', &
                            ' value is "reset")' )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      win%color_axes(:) = [ 0.0d0, 1.0d0 ]

      win%color_axis_set = .false.

      win%color_axis_extensible = .true.

   end subroutine msCAxis_string
!_______________________________________________________________________
!
   subroutine set_color_axis( win, col_range )

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE), intent(in) :: col_range(2)
      !------ API end ------

      character(len=*), parameter :: ROUTINE_NAME = "msCAxis"

      real(kind=MF_DOUBLE) :: tmp, mean

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. win%color_axis_extensible .or.                          &
          ( win%color_axis_extensible .and. .not. win%color_axis_set ) ) then

         win%color_axes(:) = col_range(:)

         ! the factor "50.0" cannot be smaller! It has been chosen after
         ! a try-and-check process
         tmp = 50.0*epsilon(1.0)*(win%color_axes(1)+win%color_axes(2))
         if( tmp == 0.0d0 ) then
            tmp = 50.0*epsilon(1.0)
         end if
         if( abs(win%color_axes(1)-win%color_axes(2)) <= tmp ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "the range for the Color Axis is too small!", &
                              "-> this range has been slightly enlarged by MUESLI." )
            mean = (win%color_axes(1)+win%color_axes(2))*0.5
            if( win%color_axes(1) <= win%color_axes(2) ) then
               win%color_axes(1) = mean - 0.5*tmp
               win%color_axes(2) = mean + 0.5*tmp
            else
               win%color_axes(2) = mean - 0.5*tmp
               win%color_axes(1) = mean + 0.5*tmp
            end if
         end if

         win%color_axis_set = .true.

      else ! win%color_axis_extensible

         win%color_axes(1) = min( win%color_axes(1), col_range(1) )
         win%color_axes(2) = max( win%color_axes(2), col_range(2) )

      end if

   end subroutine set_color_axis
