!_______________________________________________________________________
!
   subroutine msClose( win_id )

      integer, intent(in), optional :: win_id
      !------ API end ------

      type(mf_win_info), pointer :: win
      integer :: win_id_eff, win_pos(4)
      character(len=4) :: win_id_char, win_nb_char

      character(len=*), parameter :: ROUTINE_NAME = "msClose"

   !------ end of declarations -- execution starts hereafter  ------

      if( present(win_id) ) then

         if( win_id < 1 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "window ID arg. must be >= 1!" )
            return
         end if

         if( MF_WIN_NB_MAX < win_id ) then
            write(win_id_char,"(I0)") win_id
            write(win_nb_char,"(I0)") MF_WIN_NB_MAX
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "window ID:" // trim(adjustl(win_id_char)) // &
                               " cannot exist!",                        &
                               "(max. nb of windows:" // win_nb_char // ")" )
            return
         end if

         if( mf_win_db(win_id)%mfplot_id == 0 ) then
            write(win_id_char,"(I0)") win_id
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "window ID:" // trim(adjustl(win_id_char)) // &
                               " doesn't exist!",                       &
                               "(it has not been created)" )
            return
         end if

         win_id_eff = win_id

      else

         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "no X11 device selected." )
            return
         end if

         win_id_eff = CURRENT_WIN_ID

      end if

      win => mf_win_db(win_id_eff)

      call pgslct( win%mfplot_id )
      if( X11_DEVICE ) then
         if( win%save_geometry ) then
            ! pgclos_ec() = pgclos() + infos sur la position de la
            !                          fenêtre fermée
            call pgclos_ec(win_pos)
            if( X11_DEVICE ) then
               call update_mf_win_pos_db( win_id_eff, win_pos )
            end if
         else
            call pgclos()
         end if
      end if

      call dealloc_mf_win( win_id_eff )
      ! in MFPLOT, no other window is automatically selected
      CURRENT_WIN_ID = 0

   end subroutine msClose
