!_______________________________________________________________________
!
   subroutine msCharInPixels( mode )

      character(len=*), intent(in) :: mode
      !------ API end ------

      ! mode = "off" : [default] character size is proportional to the
      !                window size (actually, unit is 1/40th of a
      !                reference length, which is the side of a square
      !                of same area)
      !                [in MFPLOT, unit is 1/40th of the smaller dimension
      !                 of the view surface]
      ! mode = "on"  : character size is absolute (x 12 pixels)

      character(len=*), parameter :: ROUTINE_NAME = "msCharInPixels"

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( to_lower(mode) == "on" ) then
         win%char_height_pixel = .true.
      else if( to_lower(mode) == "off" ) then
         win%char_height_pixel = .false.
      else
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "arg: " // trim(mode) // " ignored!" )
         return
      end if

   end subroutine msCharInPixels
