!_______________________________________________________________________
!
   subroutine mf_bar_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "bar"

      type(mf_win_info), pointer :: win

      integer :: i, n_pg
      real(kind=MF_DOUBLE) :: baseline0, baseline_X, barwidth
      real(kind=MF_DOUBLE), allocatable :: y_log10(:)

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Bar", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Bar", 0 )
         end if
         gr_pdf_color_intent = 2 ! Fill
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      call grsci(grobj%struct%color) ! set color index
      n_pg = grobj%struct%npt

      baseline0 = grobj%struct%linewidth
      barwidth = grobj%struct%alpha_transp

      if( win%axis_scale_y == 1 ) then
         ! Y linear
         baseline_X = baseline0
         call pgbar_ec( n_pg,                                           &
                        grobj%struct%abs_tab,                           &
                        grobj%struct%ord_tab,                           &
                        barwidth, baseline_X )
         gr_pdf_color_intent = 1 ! Stroke
         call grsci(1)
         call pgline( 2, win%current_axes(1:2), [baseline_X,baseline_X] )
      else
         ! Y log
         baseline_X = log10(baseline0)
         allocate( y_log10(n_pg) )
         do i = 1, n_pg
            if( grobj%struct%ord_tab(i) == 0.0d0 ) then
               ! avoid -INF (anyway, log of negative values will give NaN)
               y_log10(i) = MF_NAN
            else
               y_log10(i) = log10(grobj%struct%ord_tab(i))
            end if
         end do
         call pgbar_ec( n_pg,                                           &
                        grobj%struct%abs_tab,                           &
                        y_log10,                                        &
                        barwidth, baseline_X )
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Bar", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Bar", 0 )
         end if
      end if

   end subroutine mf_bar_draw
!_______________________________________________________________________
!
   subroutine mf_bar_groups_stacks_draw( grobj )

      type(grobj_elem), intent(in out) :: grobj
      !------ API end ------

      ! grobj type = "bar_groups_stacks"

      type(mf_win_info), pointer :: win

      integer :: i, j, n_pg, n_groups, ldy
      real(kind=MF_DOUBLE) :: baseline0, baseline_X, barwidth
      real(kind=MF_DOUBLE) :: width, val
      real(kind=MF_DOUBLE), allocatable :: y_log10(:,:)
      logical :: lin_yaxis

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of BarGroups", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of BarGroups", 0 )
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      n_pg = grobj%struct%npt
      n_groups = size(grobj%struct%ord_mat,2)

      baseline0 = grobj%struct%linewidth ! don't take care of the name
      width = grobj%struct%alpha_transp ! id.
      ldy = n_pg
      lin_yaxis = grobj%struct%bool1

      if( win%axis_scale_y == 1 ) then
         ! Y linear
         if( lin_yaxis ) then
            baseline_X = baseline0
         else ! previously: log_yaxis
            ! Oucht, previous Y-axis was LOG.
            baseline_X = 0.0d0 ! Default value
            grobj%struct%linewidth = baseline_X
            grobj%struct%bool1 = .true.
         end if
         gr_pdf_color_intent = 2 ! Fill
         if( grobj%struct%linestyle == 1 ) then
            call pgbar_groups_ec( n_pg, n_groups,                       &
                                  grobj%struct%abs_tab,                 &
                                  ldy, grobj%struct%ord_mat,            &
                                  width, baseline_X,                    &
                                  grobj%struct%col_tab )
         else ! style = 2
            call pgbar_stacks_ec( n_pg, n_groups,                       &
                                  grobj%struct%abs_tab,                 &
                                  ldy, grobj%struct%ord_mat,            &
                                  width, baseline_X,                    &
                                  grobj%struct%col_tab )
         end if
         gr_pdf_color_intent = 1 ! Stroke
         ! draw an additional line of foreground color
         call grsci(1)
         call pgline( 2, win%current_axes(1:2), [baseline_X,baseline_X] )
      else
         ! Y log (WARNING: nothing must be taken with log.
         ! Log function must be applied just before drawing (sum of logs
         ! is not log of sum!)
         if( lin_yaxis ) then
            ! Oucht, previous Y-axis was LIN.
            call PrintMessage( "Bar", "I",                              &
                               "for sure, you have swapped from LIN Y-axis to LOG Y-axis...", &
                               "and we have to redefined 'baseline' because it may be zero." )
            ! in log axis, baseline is computed as the minimum value of all
            ! positive data (null or negative ones are discarded).
            baseline_X = huge(1.0d0)
            do i = 1, n_pg
               do j = 1, n_groups
                  val = grobj%struct%ord_mat(i,j)
                  if( val > 0.0d0 ) then
                     if( val < baseline_X ) baseline_X = val
                  end if
               end do
            end do
            grobj%struct%linewidth = baseline_X
            grobj%struct%bool1 = .false.
         else ! previously: log_yaxis
            baseline_X = baseline0
         end if
         gr_pdf_color_intent = 2 ! Fill
         if( grobj%struct%linestyle == 1 ) then
            call pgbar_groups_ec( n_pg, n_groups,                       &
                                  grobj%struct%abs_tab,                 &
                                  ldy, grobj%struct%ord_mat,            &
                                  width, baseline_X,                    &
                                  grobj%struct%col_tab )
         else ! style = 2
            call pgbar_stacks_log_ec( n_pg, n_groups,                   &
                                      grobj%struct%abs_tab,             &
                                      ldy, grobj%struct%ord_mat,        &
                                      width, baseline_X,                &
                                      grobj%struct%col_tab )
         end if
      end if

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of BarGroups", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of BarGroups", 0 )
         end if
      end if

   end subroutine mf_bar_groups_stacks_draw
