!_______________________________________________________________________
!
   function BarVec( x_pg, y_pg, colorindex, width, baseline )           &
   result( handle )

      real(kind=MF_DOUBLE), pointer  :: x_pg(:), y_pg(:)
      integer                        :: colorindex
      real(kind=MF_DOUBLE)           :: width
      real(kind=MF_DOUBLE), optional :: baseline

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: barwidth, x_min, x_max, x_w
      real(kind=MF_DOUBLE) :: baseline0, baseline_X
      integer :: i, n_pg, hdle
      real(kind=MF_DOUBLE) :: range(4)
      integer :: axis_manual_save_x, axis_manual_save_y

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      ! Test about an already opened figure is made in the calling routine
      win => mf_win_db(CURRENT_WIN_ID)

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      if( win%axis_scale_x == 2 ) then
         call PrintMessage( "Bar", "E",                                 &
                            "only logarithmic Y-axis is supported!" )
         go to 99
      end if

      call pgbbuf()

      call mf_save_and_disable_fpe( )

      n_pg = size(x_pg)

      x_w = (maxval(x_pg)-minval(x_pg))/(n_pg-1)
      barwidth = x_w * width
      x_min = minval(x_pg) - x_w/2.
      x_max = maxval(x_pg) + x_w/2.

      ! prepare baseline
      if( win%axis_scale_y == 1 ) then
         ! Y linear
         if( present(baseline) ) then
            baseline0 = baseline
            ! no check: baseline can take any values
         else
            baseline0 = 0.
         end if
      else
         ! Y log
         if( present(baseline) ) then
            baseline0 = baseline
            ! in log axe, baseline must be stricly positive
            if( baseline0 <= 0.0d0 ) then
               call PrintMessage( "Bar", "W",                           &
                                  "bad value for 'baseline', which must be stricly positive in log axe!", &
                                  "-> this arg has been modified to the default value: 0.01" )
               baseline0 = 0.01d0
            end if
         else
            baseline0 = 0.01d0
         end if
      end if

      ! les [nouveaux] axes doivent être prêts
      range(1) = x_min
      range(2) = x_max
      if( win%axis_scale_y == 1 ) then
         ! Y linear
         range(3) = min(baseline0,minval(y_pg))
      else
         ! Y log
         range(3) = baseline0
      end if
      range(4) = maxval(y_pg)
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         ! caution: axes must have been defined before
         call X11_clip_on_viewport()
      end if

      handle = 0

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd          =  "bar"
      grobj%struct%npt          =  n_pg
      grobj%struct%abs_tab      => x_pg
      grobj%struct%ord_tab      => y_pg
      grobj%struct%color        =  colorindex
      grobj%struct%alpha_transp =  barwidth
      grobj%struct%linewidth    =  baseline0

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_bar_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

 99   continue

      call mf_restore_fpe( )

   end function BarVec
!_______________________________________________________________________
!
   function BarMat( x_pg, mat_y_pg, colorindex, width, style, baseline )                            &
   result( handle )

      real(kind=MF_DOUBLE), pointer  :: x_pg(:), mat_y_pg(:,:)
      integer,              pointer  :: colorindex(:)
      real(kind=MF_DOUBLE)           :: width
      integer                        :: style
      real(kind=MF_DOUBLE), optional :: baseline

      integer :: handle
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj

      real(kind=MF_DOUBLE) :: x_min, x_max, x_w, val
      real(kind=MF_DOUBLE) :: baseline0, width0, baseline_X
      integer :: i, j, n_pg, n_groups, ldy, hdle, ind_next_color
      real(kind=MF_DOUBLE) :: range(4)
      logical :: color_undefined, discarded, lin_yaxis

      integer :: itmp
      character(len=3) :: answer
      logical :: device_has_cursor

   !------ end of declarations -- execution starts hereafter  ------

      ! Test about an already opened figure is made in the calling routine
      win => mf_win_db(CURRENT_WIN_ID)

      ! préparation de l'échelle des axes. par défaut : linéaires
      ! scale index : 0 = undef., 1 = linear, 2 = log10
      if( win%axis_scale_x == 0 ) then
         win%axis_scale_x = 1
      end if
      if( win%axis_scale_y == 0 ) then
         win%axis_scale_y = 1
      end if

      if( win%axis_scale_x == 2 ) then
         call PrintMessage( "Bar", "E",                                 &
                            "only logarithmic Y-axis is supported!" )
         go to 99
      end if

      call pgbbuf()

      call mf_save_and_disable_fpe( )

      n_pg = size(x_pg)
      n_groups = size(mat_y_pg,2)

      x_w = (maxval(x_pg)-minval(x_pg))/(n_pg-1)
      x_min = minval(x_pg) - x_w/2.
      x_max = maxval(x_pg) + x_w/2.

      width0 = width

      ! very important: baseline mode of calculation depends whether
      ! the Y-axis is LIN or LOG. Therefore, we have to keep the mode
      ! to avoid a computation of baseline at each redraw (this may be
      ! coastly, especially for a big matrix).

      ! prepare baseline
      if( win%axis_scale_y == 1 ) then
         ! Y linear
         if( present(baseline) ) then
            baseline0 = baseline
            ! no check: baseline can take any values
         else
            baseline0 = 0.0d0
         end if
         lin_yaxis = .true.
      else
         ! Y log
         if( present(baseline) ) then
            call PrintMessage( "Bar", "W",                              &
                               "'baseline' argument discarded for logarithmic Y-axis!" )
         end if
         ! in log axis, baseline is computed as the minimum value of all
         ! positive data (null or negative ones are discarded).
         baseline0 = huge(1.0d0)
         discarded = .false.
         do i = 1, n_pg
            do j = 1, n_groups
               val = mat_y_pg(i,j)
               if( val > 0.0d0 ) then
                  if( val < baseline0 ) baseline0 = val
               else
                  discarded = .true.
               end if
            end do
         end do
         if( discarded ) then
            call PrintMessage( "Bar", "I",                              &
                               "some null or negative value(s) have been discarded (logarithmic Y-axis)!" )
         end if
         lin_yaxis = .false.
      end if

      ! les [nouveaux] axes doivent être prêts
      range(1) = x_min
      range(2) = x_max
      if( win%axis_scale_y == 1 ) then
         ! Y linear
         range(3) = min(baseline0,minval(mat_y_pg))
      else
         ! Y log
         range(3) = baseline0
      end if
      if( style == 1 ) then
         range(4) = maxval(mat_y_pg)
      else ! style = 2
         range(4) = maxval( sum(mat_y_pg,1) )
      end if
      call mf_prepare_axes( CURRENT_WIN_ID, range )

      ! plotting something is always clipped at viewport
      if( X11_DEVICE ) then
         call X11_clip_on_viewport()
      end if

      handle = 0

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "bar_groups_stacks"
      grobj%struct%linestyle    = style
      grobj%struct%range        =  range
      grobj%struct%npt          =  n_pg
      grobj%struct%abs_tab      => x_pg
      grobj%struct%ord_mat      => mat_y_pg
      grobj%struct%alpha_transp =  width
      grobj%struct%linewidth    =  baseline0
      grobj%struct%bool1        =  lin_yaxis
      grobj%struct%col_tab      => colorindex

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      call mf_bar_groups_stacks_draw( grobj )

      call pgebuf()

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

 99   continue

      call mf_restore_fpe( )

   end function BarMat
