!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfBar_color_str_1( x, y, color, width, baseline, style)                                               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msBar_color_str_1( x, y, color, width, baseline, style )
#endif

      type(mfArray)                              :: x
      type(mfArray),                    optional :: y
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: width
      real(kind=MF_DOUBLE), intent(in), optional :: baseline
      character(len=*),     intent(in), optional :: style

      integer :: handle
      !------ API end ------

      ! * Only X is mandatory (Y is optional) [user point of view: x is optional]
      ! * X is only vector, Y is vector or matrix, of same nb of row
      ! * X equally spaced, or any permutation of an equally spaced sequence
      ! * Log axis possible for Y only
      ! * 'msBar' must be the first command in a figure (except msAxis)
      !     => easy to change ? useful to have mixed grobj in a figure ?

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_y_sto_pg(:,:)
      integer :: p_dim, p_dim_y, n_pg, n_groups
      integer :: i, j, status
      real(kind=MF_DOUBLE) :: width0
      integer :: pgflag, style0, ier

      integer :: icol
      character(len=4) :: i_str
      logical :: matrix_data, color_undefined

      integer :: mf_message_level_save

      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfBar"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msBar"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      call msInitArgs( x )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! we must detect early if data is under vector or matrix form...
      if( present(y) ) then

         call msInitArgs( y )

         ! checking that 'y' is allocated
         if( mfIsEqual(y,MF_EMPTY) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' not allocated!" )
            go to 99
         end if

         ! 'y' must be Real
         if( .not. mfIsReal(y) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' must be real!" )
            go to 99
         end if

         ! 'y' cannot be sparse
         if( mfIsSparse(y) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' cannot be sparse!" )
            go to 99
         end if

         call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

         if( size(y_ptr,1)==0 .or. size(y_ptr,2)==0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "nothing to plot" )
            go to 99
         end if

         if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
            matrix_data = .true.
            ! 'x' must be a column vector only
            if( size(x_ptr,2)/=1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when data 'y' is a matrix, 'x' must be a column vector!" )
               go to 99
            end if
            n_pg = size(x_ptr,1)
            if( size(y_ptr,1) /= n_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when data 'y' is a matrix, 'x' and 'y' must have the same nb of rows!" )
               go to 99
            end if
            n_groups = size(y_ptr,2)
         else
            matrix_data = .false.
            ! 'x' must be a vector (row or col)
            if( size(x_ptr,1) == 1 ) then
               n_pg = size(x_ptr,2)
               p_dim = 2
            else if( size(x_ptr,2) == 1 ) then
               n_pg = size(x_ptr,1)
               p_dim = 1
            else
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'x' cannot be a matrix!" )
               go to 99
            end if
            if( any(shape(x_ptr)/=shape(y_ptr)) ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'x' and 'y' must have the same shape!" )
               go to 99
            end if
         end if

      else ! y not present (but x plays the role of data)

         if( size(x_ptr,1)==1 ) then
            matrix_data = .false.
            n_pg = size(x_ptr,2)
            n_groups = 1
            p_dim = 2
         else if( size(x_ptr,2)==1 ) then
            matrix_data = .false.
            n_pg = size(x_ptr,1)
            n_groups = 1
            p_dim = 1
         else if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
            matrix_data = .true.
            n_pg = size(x_ptr,1)
            n_groups = size(x_ptr,2)
         end if

      end if

      ! The matrix case cannot occur with this interface
      if( matrix_data ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "When 'y' is a matrix, 'color' cannot be a scalar!" )
         go to 99
      end if

      ! here, n_pg and n_groups are known

      ! define now what is abscissa and what is data
      allocate( x_sto_pg(n_pg) )
      allocate( y_sto_pg(n_pg) )
      if( present(y) ) then
         if( p_dim == 1 ) then
            x_sto_pg(:) = x_ptr(:,1)
            y_sto_pg(:) = y_ptr(:,1)
         else
            x_sto_pg(:) = x_ptr(1,:)
            y_sto_pg(:) = y_ptr(1,:)
         end if
      else
         x_sto_pg(:) = [ (i, i=1,n_pg) ]
         if( p_dim == 1 ) then
            y_sto_pg(:) = x_ptr(:,1)
         else
            y_sto_pg(:) = x_ptr(1,:)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( present(y) ) then
         call msFreePointer( y, y_ptr )
      end if

      if( present(width) ) then
         width0 = width
         if( width0 < 0.0 .or. 1.0 < width0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad value for 'width', the relative width of the bars!", &
                               "-> this arg has been modified to lie in [0,1]" )
            if( width0 < 0.0 ) then
               width0 = 0.05
            else ! width0 > 1.0
               width0 = 0.95
            end if
         end if
      else
         width0 = 0.8
      end if

      if( present(style) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'style' cannot be present for vector data!", &
                            "-> this arg is discarded" )
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      color_undefined = .false.
      ! must disambiguate a color code of 1 letter or escaped
      ! sequence, from a color name of the RGB database...
      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to foreground color)" )
            icol = 1
         end if
      else
         call decode_col_name( color, icol )
      end if
      if( icol == -127 ) then
         color_undefined = .true.
      end if
      if( color_undefined ) then
         win => mf_win_db(CURRENT_WIN_ID)
         select case( win%color_scheme )
            case( 1 )
               icol = COL_CYCLE_TAB_1(1)
            case( 2 )
               icol = COL_CYCLE_TAB_2(1)
            case( 3 )
               icol = COL_CYCLE_TAB_3(1)
            case( 4 )
               icol = COL_CYCLE_TAB_4(1)
            case default
               write(STDERR,*) "(FGL mf/msBar:) Internal error."
               write(STDERR,*) "     Bad value for color_scheme."
               pause "only for debugging purpose"
               stop
         end select
      end if

      if( present(baseline) ) then
         handle = BarVec( x_sto_pg, y_sto_pg, icol, width0, baseline )
      else
         handle = BarVec( x_sto_pg, y_sto_pg, icol, width0 )
      end if

 99   continue

      call msFreeArgs( x )
      call msAutoRelease( x )

      if( present(y) ) then
         call msFreeArgs( y )
         call msAutoRelease( y )
      end if

#ifdef _MF_FUNC
   end function mfBar_color_str_1
#endif
#ifdef _MF_SUBR
   end subroutine msBar_color_str_1
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfBar_color_rgb_1( x, y, color, width, baseline, style)     &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msBar_color_rgb_1( x, y, color, width, baseline, style )
#endif

      type(mfArray)                              :: x
      type(mfArray),                    optional :: y
      real(kind=MF_DOUBLE), intent(in)           :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: width
      real(kind=MF_DOUBLE), intent(in), optional :: baseline
      character(len=*),     intent(in), optional :: style

      integer :: handle
      !------ API end ------

      ! * Only X is mandatory (Y is optional) [user point of view: x is optional]
      ! * X is only vector, Y is vector or matrix, of same nb of row
      ! * X equally spaced, or any permutation of an equally spaced sequence
      ! * Log axis possible for Y only
      ! * 'msBar' must be the first command in a figure (except msAxis)
      !     => easy to change ? useful to have mixed grobj in a figure ?

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_y_sto_pg(:,:)
      integer :: p_dim, p_dim_y, n_pg, n_groups
      integer :: i, j, status
      real(kind=MF_DOUBLE) :: width0
      integer :: pgflag, style0

      integer :: icol, ind_next_color
      logical :: matrix_data, color_undefined

      integer :: mf_message_level_save

      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfBar"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msBar"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      call msInitArgs( x )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! we must detect early if data is under vector or matrix form...
      if( present(y) ) then

         call msInitArgs( y )

         ! checking that 'y' is allocated
         if( mfIsEqual(y,MF_EMPTY) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' not allocated!" )
            go to 99
         end if

         ! 'y' must be Real
         if( .not. mfIsReal(y) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' must be real!" )
            go to 99
         end if

         ! 'y' cannot be sparse
         if( mfIsSparse(y) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' cannot be sparse!" )
            go to 99
         end if

         call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

         if( size(y_ptr,1)==0 .or. size(y_ptr,2)==0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "nothing to plot" )
            go to 99
         end if

         if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
            matrix_data = .true.
            ! 'x' must be a column vector only
            if( size(x_ptr,2)/=1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when data 'y' is a matrix, 'x' must be a column vector!" )
               go to 99
            end if
            n_pg = size(x_ptr,1)
            if( size(y_ptr,1) /= n_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when data 'y' is a matrix, 'x' and 'y' must have the same nb of rows!" )
               go to 99
            end if
            n_groups = size(y_ptr,2)
         else
            matrix_data = .false.
            ! 'x' must be a vector (row or col)
            if( size(x_ptr,1) == 1 ) then
               n_pg = size(x_ptr,2)
               p_dim = 2
            else if( size(x_ptr,2) == 1 ) then
               n_pg = size(x_ptr,1)
               p_dim = 1
            else
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'x' cannot be a matrix!" )
               go to 99
            end if
            if( any(shape(x_ptr)/=shape(y_ptr)) ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'x' and 'y' must have the same shape!" )
               go to 99
            end if
         end if

      else ! y not present (but x plays the role of data)

         if( size(x_ptr,1)==1 ) then
            matrix_data = .false.
            n_pg = size(x_ptr,2)
            n_groups = 1
            p_dim = 2
         else if( size(x_ptr,2)==1 ) then
            matrix_data = .false.
            n_pg = size(x_ptr,1)
            n_groups = 1
            p_dim = 1
         else if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
            matrix_data = .true.
            n_pg = size(x_ptr,1)
            n_groups = size(x_ptr,2)
         end if

      end if

      ! The matrix case cannot occur with this interface
      if( matrix_data ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "When 'y' is a matrix, 'color' cannot be a scalar!" )
         go to 99
      end if

      ! here, n_pg and n_groups are known

      ! define now what is abscissa and what is data
      allocate( x_sto_pg(n_pg) )
      allocate( y_sto_pg(n_pg) )
      if( present(y) ) then
         if( p_dim == 1 ) then
            x_sto_pg(:) = x_ptr(:,1)
            y_sto_pg(:) = y_ptr(:,1)
         else
            x_sto_pg(:) = x_ptr(1,:)
            y_sto_pg(:) = y_ptr(1,:)
         end if
      else
         x_sto_pg(:) = [ (i, i=1,n_pg) ]
         if( p_dim == 1 ) then
            y_sto_pg(:) = x_ptr(:,1)
         else
            y_sto_pg(:) = x_ptr(1,:)
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( present(y) ) then
         call msFreePointer( y, y_ptr )
      end if

      if( present(width) ) then
         width0 = width
         if( width0 < 0.0 .or. 1.0 < width0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad value for 'width', the relative width of the bars!", &
                               "-> this arg has been modified to lie in [0,1]" )
            if( width0 < 0.0 ) then
               width0 = 0.05
            else ! width0 > 1.0
               width0 = 0.95
            end if
         end if
      else
         width0 = 0.8
      end if

      if( present(style) ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "'style' cannot be present for vector data!", &
                            "-> this arg is discarded" )
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      color_undefined = .false.
      call decode_col_rgb( color, icol )
      if( icol == -127 ) then
         color_undefined = .true.
      end if
      if( color_undefined ) then
         win => mf_win_db(CURRENT_WIN_ID)
         select case( win%color_scheme )
            case( 1 )
               icol = COL_CYCLE_TAB_1(1)
            case( 2 )
               icol = COL_CYCLE_TAB_2(1)
            case( 3 )
               icol = COL_CYCLE_TAB_3(1)
            case( 4 )
               icol = COL_CYCLE_TAB_4(1)
            case default
               write(STDERR,*) "(FGL mf/msBar:) Internal error."
               write(STDERR,*) "     Bad value for color_scheme."
               pause "only for debugging purpose"
               stop
         end select
      end if

      if( present(baseline) ) then
         handle = BarVec( x_sto_pg, y_sto_pg, icol, width0, baseline )
      else
         handle = BarVec( x_sto_pg, y_sto_pg, icol, width0 )
      end if

 99   continue

      call msFreeArgs( x )
      call msAutoRelease( x )

      if( present(y) ) then
         call msFreeArgs( y )
         call msAutoRelease( y )
      end if

#ifdef _MF_FUNC
   end function mfBar_color_rgb_1
#endif
#ifdef _MF_SUBR
   end subroutine msBar_color_rgb_1
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfBar_color_str_2( x, y, color, width, baseline, style)                                               &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msBar_color_str_2( x, y, color, width, baseline, style )
#endif

      type(mfArray)                              :: x
      type(mfArray),                    optional :: y
      character(len=*),     intent(in)           :: color(:)
      real(kind=MF_DOUBLE), intent(in), optional :: width
      real(kind=MF_DOUBLE), intent(in), optional :: baseline
      character(len=*),     intent(in), optional :: style

      integer :: handle
      !------ API end ------

      ! * Only X is mandatory (Y is optional) [user point of view: x is optional]
      ! * X is only vector, Y is vector or matrix, of same nb of row
      ! * X equally spaced, or any permutation of an equally spaced sequence
      ! * Log axis possible for Y only
      ! * 'msBar' must be the first command in a figure (except msAxis)
      !     => easy to change ? useful to have mixed grobj in a figure ?

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_y_sto_pg(:,:)
      integer :: p_dim, p_dim_y, n_pg, n_groups
      integer :: i, j, status
      real(kind=MF_DOUBLE) :: width0
      integer :: pgflag, style0, ier

      integer :: icol
      integer, pointer  :: icol_vec(:)
      character(len=4) :: i_str
      logical :: matrix_data, color_undefined

      integer :: mf_message_level_save

      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfBar"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msBar"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      call msInitArgs( x )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! we must detect early if data is under vector or matrix form...
      if( present(y) ) then

         call msInitArgs( y )

         ! checking that 'y' is allocated
         if( mfIsEqual(y,MF_EMPTY) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' not allocated!" )
            go to 99
         end if

         ! 'y' must be Real
         if( .not. mfIsReal(y) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' must be real!" )
            go to 99
         end if

         ! 'y' cannot be sparse
         if( mfIsSparse(y) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' cannot be sparse!" )
            go to 99
         end if

         call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

         if( size(y_ptr,1)==0 .or. size(y_ptr,2)==0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "nothing to plot" )
            go to 99
         end if

         if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
            matrix_data = .true.
            ! 'x' must be a column vector only
            if( size(x_ptr,2)/=1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when data 'y' is a matrix, 'x' must be a column vector!" )
               go to 99
            end if
            n_pg = size(x_ptr,1)
            if( size(y_ptr,1) /= n_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when data 'y' is a matrix, 'x' and 'y' must have the same nb of rows!" )
               go to 99
            end if
            n_groups = size(y_ptr,2)
         else
            matrix_data = .false.
            ! 'x' must be a vector (row or col)
            if( size(x_ptr,1) == 1 ) then
               n_pg = size(x_ptr,2)
               p_dim = 2
            else if( size(x_ptr,2) == 1 ) then
               n_pg = size(x_ptr,1)
               p_dim = 1
            else
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'x' cannot be a matrix!" )
               go to 99
            end if
            if( any(shape(x_ptr)/=shape(y_ptr)) ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'x' and 'y' must have the same shape!" )
               go to 99
            end if
         end if

      else ! y not present (but x plays the role of data)

         if( size(x_ptr,1)==1 ) then
            matrix_data = .false.
            n_pg = size(x_ptr,2)
            n_groups = 1
            p_dim = 2
         else if( size(x_ptr,2)==1 ) then
            matrix_data = .false.
            n_pg = size(x_ptr,1)
            n_groups = 1
            p_dim = 1
         else if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
            matrix_data = .true.
            n_pg = size(x_ptr,1)
            n_groups = size(x_ptr,2)
         end if

      end if

      ! here, n_pg and n_groups are known

      ! define now what is abscissa and what is data
      allocate( x_sto_pg(n_pg) )
      if( matrix_data ) then
         allocate( mat_y_sto_pg(n_pg,n_groups) )
         if( present(y) ) then
            x_sto_pg(:) = x_ptr(:,1)
            mat_y_sto_pg(:,:) = y_ptr(:,:)
         else
            x_sto_pg(:) = [ (i, i=1,n_pg) ]
            mat_y_sto_pg(:,:) = x_ptr(:,:)
         end if
      else ! vector data
         allocate( y_sto_pg(n_pg) )
         if( present(y) ) then
            if( p_dim == 1 ) then
               x_sto_pg(:) = x_ptr(:,1)
               y_sto_pg(:) = y_ptr(:,1)
            else
               x_sto_pg(:) = x_ptr(1,:)
               y_sto_pg(:) = y_ptr(1,:)
            end if
         else
            x_sto_pg(:) = [ (i, i=1,n_pg) ]
            if( p_dim == 1 ) then
               y_sto_pg(:) = x_ptr(:,1)
            else
               y_sto_pg(:) = x_ptr(1,:)
            end if
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( present(y) ) then
         call msFreePointer( y, y_ptr )
      end if

      if( present(width) ) then
         width0 = width
         if( width0 < 0.0 .or. 1.0 < width0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad value for 'width', the relative width of the bars!", &
                               "-> this arg has been modified to lie in [0,1]" )
            if( width0 < 0.0 ) then
               width0 = 0.05
            else ! width0 > 1.0
               width0 = 0.95
            end if
         end if
      else
         width0 = 0.8
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      if( matrix_data ) then

         if( present(style) ) then
            if( trim(style) == "groups" ) then
               style0 = 1
            else if( trim(style) == "stacked" ) then
               style0 = 2
            else
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "'style' must be 'groups' or 'stacked!", &
                                  "-> this arg is modified to 'groups'" )
               style0 = 1
            end if
         else
            style0 = 1
         end if

         if( size(color) /= n_groups ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "Bad dimension for 'color'!" )
            go to 99
         end if

         allocate( icol_vec(n_groups) )
         do i = 1, n_groups
            ! must disambiguate a color code of 1 letter or escaped
            ! sequence, from a color name of the RGB database...
            if( len_trim(color(i)) == 1 .or. color(i)(1:1) == "\" ) then
               call decode_linespec( color(i), icol_vec(i), ier=ier )
               if( ier /= 0 ) then
                  write(i_str,"(I0)") i
                  if( i == 1 ) then
                     i_str = adjustl(i_str) // "st"
                  else if( i == 2 ) then
                     i_str = adjustl(i_str) // "nd"
                  else if( i == 3 ) then
                     i_str = adjustl(i_str) // "rd"
                  else
                     i_str = adjustl(i_str) // "th"
                  end if
                  call PrintMessage( trim(ROUTINE_NAME), "W",           &
                                    "bad " // trim(i_str) // " component for the 'color' argument!", &
                                    "(line color will be set to foreground color)" )
                  icol_vec(i) = 1
               end if
            else
               call decode_col_name( color(i), icol_vec(i) )
            end if
         end do

         if( present(baseline) ) then
            handle = BarMat( x_sto_pg, mat_y_sto_pg, icol_vec,          &
                             width0, style0, baseline )
         else
            handle = BarMat( x_sto_pg, mat_y_sto_pg, icol_vec,          &
                             width0, style0 )
         end if

      else ! vector data

         if( present(style) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "'style' cannot be present for vector data!", &
                               "-> this arg is discarded" )
         end if

         if( size(color) /= 1 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "When 'y' is a vector, 'color' must be declared as dimension(1)!" )
            go to 99
         end if
         color_undefined = .false.
         ! must disambiguate a color code of 1 letter or escaped
         ! sequence, from a color name of the RGB database...
         if( len_trim(color(1)) == 1 .or. color(1)(1:1) == "\" ) then
            call decode_linespec( color(1), icol, ier=ier )
            if( ier /= 0 ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                 "bad 'color' argument!",               &
                                 "(line color will be set to foreground color)" )
               icol = 1
            end if
         else
            call decode_col_name( color(1), icol )
         end if
         if( icol == -127 ) then
            color_undefined = .true.
         end if
         if( color_undefined ) then
            win => mf_win_db(CURRENT_WIN_ID)
            select case( win%color_scheme )
               case( 1 )
                  icol = COL_CYCLE_TAB_1(1)
               case( 2 )
                  icol = COL_CYCLE_TAB_2(1)
               case( 3 )
                  icol = COL_CYCLE_TAB_3(1)
               case( 4 )
                  icol = COL_CYCLE_TAB_4(1)
               case default
                  write(STDERR,*) "(FGL mf/msBar:) Internal error."
                  write(STDERR,*) "     Bad value for color_scheme."
                  pause "only for debugging purpose"
                  stop
            end select
         end if

         if( present(baseline) ) then
            handle = BarVec( x_sto_pg, y_sto_pg, icol, width0, baseline )
         else
            handle = BarVec( x_sto_pg, y_sto_pg, icol, width0 )
         end if

      end if

 99   continue

      call msFreeArgs( x )
      call msAutoRelease( x )

      if( present(y) ) then
         call msFreeArgs( y )
         call msAutoRelease( y )
      end if

#ifdef _MF_FUNC
   end function mfBar_color_str_2
#endif
#ifdef _MF_SUBR
   end subroutine msBar_color_str_2
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfBar_color_rgb_2( x, y, color, width, baseline, style)     &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msBar_color_rgb_2( x, y, color, width, baseline, style )
#endif

      type(mfArray)                              :: x
      type(mfArray),                    optional :: y
      real(kind=MF_DOUBLE), intent(in), optional :: color(:,:)
      real(kind=MF_DOUBLE), intent(in), optional :: width
      real(kind=MF_DOUBLE), intent(in), optional :: baseline
      character(len=*),     intent(in), optional :: style

      integer :: handle
      !------ API end ------

      ! * Only X is mandatory (Y is optional) [user point of view: x is optional]
      ! * X is only vector, Y is vector or matrix, of same nb of row
      ! * X equally spaced, or any permutation of an equally spaced sequence
      ! * Log axis possible for Y only
      ! * 'msBar' must be the first command in a figure (except msAxis)
      !     => easy to change ? useful to have mixed grobj in a figure ?

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: x_ptr(:,:), y_ptr(:,:)

      real(kind=MF_DOUBLE), pointer :: x_sto_pg(:), y_sto_pg(:), mat_y_sto_pg(:,:)
      integer :: p_dim, p_dim_y, n_pg, n_groups
      integer :: i, j, status
      real(kind=MF_DOUBLE) :: width0
      integer :: pgflag, style0

      integer :: icol, ind_next_color
      integer, pointer  :: icol_vec(:)
      logical :: matrix_data, color_undefined

      integer :: mf_message_level_save

      type(mf_win_info), pointer :: win

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfBar"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msBar"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      call msInitArgs( x )

      ! checking that 'x' is allocated
      if( mfIsEqual(x,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' not allocated!" )
         go to 99
      end if

      ! 'x' must be Real
      if( .not. mfIsReal(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' must be real!" )
         go to 99
      end if

      ! 'x' cannot be sparse
      if( mfIsSparse(x) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'x' cannot be sparse!" )
         go to 99
      end if

      call msPointer( x, x_ptr, no_crc=.true., intern_call=.true. )

      if( size(x_ptr,1)==0 .or. size(x_ptr,2)==0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "nothing to plot" )
         go to 99
      end if

      ! we must detect early if data is under vector or matrix form...
      if( present(y) ) then

         call msInitArgs( y )

         ! checking that 'y' is allocated
         if( mfIsEqual(y,MF_EMPTY) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' not allocated!" )
            go to 99
         end if

         ! 'y' must be Real
         if( .not. mfIsReal(y) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' must be real!" )
            go to 99
         end if

         ! 'y' cannot be sparse
         if( mfIsSparse(y) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "'y' cannot be sparse!" )
            go to 99
         end if

         call msPointer( y, y_ptr, no_crc=.true., intern_call=.true. )

         if( size(y_ptr,1)==0 .or. size(y_ptr,2)==0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "nothing to plot" )
            go to 99
         end if

         if( size(y_ptr,1)/=1 .and. size(y_ptr,2)/=1 ) then
            matrix_data = .true.
            ! 'x' must be a column vector only
            if( size(x_ptr,2)/=1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when data 'y' is a matrix, 'x' must be a column vector!" )
               go to 99
            end if
            n_pg = size(x_ptr,1)
            if( size(y_ptr,1) /= n_pg ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when data 'y' is a matrix, 'x' and 'y' must have the same nb of rows!" )
               go to 99
            end if
            n_groups = size(y_ptr,2)
         else
            matrix_data = .false.
            ! 'x' must be a vector (row or col)
            if( size(x_ptr,1) == 1 ) then
               n_pg = size(x_ptr,2)
               p_dim = 2
            else if( size(x_ptr,2) == 1 ) then
               n_pg = size(x_ptr,1)
               p_dim = 1
            else
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'x' cannot be a matrix!" )
               go to 99
            end if
            if( any(shape(x_ptr)/=shape(y_ptr)) ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "'x' and 'y' must have the same shape!" )
               go to 99
            end if
         end if

      else ! y not present (but x plays the role of data)

         if( size(x_ptr,1)==1 ) then
            matrix_data = .false.
            n_pg = size(x_ptr,2)
            n_groups = 1
            p_dim = 2
         else if( size(x_ptr,2)==1 ) then
            matrix_data = .false.
            n_pg = size(x_ptr,1)
            n_groups = 1
            p_dim = 1
         else if( size(x_ptr,1)/=1 .and. size(x_ptr,2)/=1 ) then
            matrix_data = .true.
            n_pg = size(x_ptr,1)
            n_groups = size(x_ptr,2)
         end if

      end if

      ! here, n_pg and n_groups are known

      ! define now what is abscissa and what is data
      allocate( x_sto_pg(n_pg) )
      if( matrix_data ) then
         allocate( mat_y_sto_pg(n_pg,n_groups) )
         if( present(y) ) then
            x_sto_pg(:) = x_ptr(:,1)
            mat_y_sto_pg(:,:) = y_ptr(:,:)
         else
            x_sto_pg(:) = [ (i, i=1,n_pg) ]
            mat_y_sto_pg(:,:) = x_ptr(:,:)
         end if
      else ! vector data
         allocate( y_sto_pg(n_pg) )
         if( present(y) ) then
            if( p_dim == 1 ) then
               x_sto_pg(:) = x_ptr(:,1)
               y_sto_pg(:) = y_ptr(:,1)
            else
               x_sto_pg(:) = x_ptr(1,:)
               y_sto_pg(:) = y_ptr(1,:)
            end if
         else
            x_sto_pg(:) = [ (i, i=1,n_pg) ]
            if( p_dim == 1 ) then
               y_sto_pg(:) = x_ptr(:,1)
            else
               y_sto_pg(:) = x_ptr(1,:)
            end if
         end if
      end if

      call msFreePointer( x, x_ptr )

      if( present(y) ) then
         call msFreePointer( y, y_ptr )
      end if

      if( present(width) ) then
         width0 = width
         if( width0 < 0.0 .or. 1.0 < width0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "bad value for 'width', the relative width of the bars!", &
                               "-> this arg has been modified to lie in [0,1]" )
            if( width0 < 0.0 ) then
               width0 = 0.05
            else ! width0 > 1.0
               width0 = 0.95
            end if
         end if
      else
         width0 = 0.8
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      if( matrix_data ) then

         if( present(style) ) then
            if( trim(style) == "groups" ) then
               style0 = 1
            else if( trim(style) == "stacked" ) then
               style0 = 2
            else
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "'style' must be 'groups' or 'stacked!", &
                                  "-> this arg is modified to 'groups'" )
               style0 = 1
            end if
         else
            style0 = 1
         end if

         if( present(color) ) then
            if( size(color,1) /= 3 .or. size(color,2) /= n_groups ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "Bad dimension for 'color'!" )
               go to 99
            end if
         end if

         allocate( icol_vec(n_groups) )
         color_undefined = .true.
         if( present(color) ) then
            do i = 1, n_groups
               call decode_col_rgb( color(:,i), icol_vec(i) )
            end do
            color_undefined = .false.
         end if

         win => mf_win_db(CURRENT_WIN_ID)

         if( color_undefined ) then
            select case( win%color_scheme )
               case( 1 )
                  icol_vec(1) = COL_CYCLE_TAB_1(1)
                  ind_next_color = 2
                  do i = 2, n_groups
                     icol_vec(i) = COL_CYCLE_TAB_1(ind_next_color)
                     if( ind_next_color == 6 ) then
                        ind_next_color = 1
                     else
                        ind_next_color = ind_next_color + 1
                     end if
                  end do
               case( 2 )
                  icol_vec(1) = COL_CYCLE_TAB_2(1)
                  ind_next_color = 2
                  do i = 2, n_groups
                     icol_vec(i) = COL_CYCLE_TAB_2(ind_next_color)
                     if( ind_next_color == 7 ) then
                        ind_next_color = 1
                     else
                        ind_next_color = ind_next_color + 1
                     end if
                  end do
               case( 3 )
                  icol_vec(1) = COL_CYCLE_TAB_3(1)
                  ind_next_color = 2
                  do i = 2, n_groups
                     icol_vec(i) = COL_CYCLE_TAB_3(ind_next_color)
                     if( ind_next_color == 7 ) then
                        ind_next_color = 1
                     else
                        ind_next_color = ind_next_color + 1
                     end if
                  end do
               case( 4 )
                  icol_vec(1) = COL_CYCLE_TAB_4(1)
                  ind_next_color = 2
                  do i = 2, n_groups
                     icol_vec(i) = COL_CYCLE_TAB_4(ind_next_color)
                     if( ind_next_color == 12 ) then
                        ind_next_color = 1
                     else
                        ind_next_color = ind_next_color + 1
                     end if
                  end do
               case default
                  write(STDERR,*) "(FGL mf/msBar:) Internal error."
                  write(STDERR,*) "     Bad value for color_scheme."
                  pause "only for debugging purpose"
                  stop
            end select
         end if

         if( present(baseline) ) then
            handle = BarMat( x_sto_pg, mat_y_sto_pg, icol_vec,          &
                             width0, style0, baseline )
         else
            handle = BarMat( x_sto_pg, mat_y_sto_pg, icol_vec,          &
                             width0, style0 )
         end if

      else ! vector data

         if( present(style) ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "'style' cannot be present for vector data!", &
                               "-> this arg is discarded" )
         end if

         color_undefined = .true.
         if( present(color) ) then
            if( any(shape(color)/=[3,1]) ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "When 'y' is a vector, 'color' must be declared as dimension(3,1)!" )
               go to 99
            end if
            color_undefined = .false.
            call decode_col_rgb( color(:,1), icol )
            if( icol == -127 ) then
               color_undefined = .true.
            end if
         end if
         if( color_undefined ) then
            win => mf_win_db(CURRENT_WIN_ID)
            select case( win%color_scheme )
               case( 1 )
                  icol = COL_CYCLE_TAB_1(1)
               case( 2 )
                  icol = COL_CYCLE_TAB_2(1)
               case( 3 )
                  icol = COL_CYCLE_TAB_3(1)
               case( 4 )
                  icol = COL_CYCLE_TAB_4(1)
               case default
                  write(STDERR,*) "(FGL mf/msBar:) Internal error."
                  write(STDERR,*) "     Bad value for color_scheme."
                  pause "only for debugging purpose"
                  stop
            end select
         end if

         if( present(baseline) ) then
            handle = BarVec( x_sto_pg, y_sto_pg, icol, width0, baseline )
         else
            handle = BarVec( x_sto_pg, y_sto_pg, icol, width0 )
         end if

      end if

 99   continue

      call msFreeArgs( x )
      call msAutoRelease( x )

      if( present(y) ) then
         call msFreeArgs( y )
         call msAutoRelease( y )
      end if

#ifdef _MF_FUNC
   end function mfBar_color_rgb_2
#endif
#ifdef _MF_SUBR
   end subroutine msBar_color_rgb_2
#endif
