!_______________________________________________________________________
!
   subroutine msAxisLineWidth( width )

      real(kind=MF_DOUBLE), intent(in) :: width
      !------ API end ------

      ! ne sert que pour les traits d'axes.
      ! (la largeur de trait pour le texte ou les labels peut se
      !  définir dans d'autres routines)

      type(mf_win_info), pointer :: win

      character(len=*), parameter :: ROUTINE_NAME = "msAxisLineWidth"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected." )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( width <= 0.0d0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "width must be positive." )
         return
      end if

      if( width > 3.0d0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "width is too big.",                        &
                            "(it has been set to the max value, i.e. 3)" )
         win%axis_line_width = 3.0d0
         pg_axis_lin_width(pgid) = 3.0d0
      else if( width <= 0.5d0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "W",                    &
                            "width is too small.",                      &
                            "(it has been set to the min value, i.e. 0.5)" )
         win%axis_line_width = 0.5d0
         pg_axis_lin_width(pgid) = 0.5d0
      else
         win%axis_line_width = width
         pg_axis_lin_width(pgid) = width
      end if

      ! le redessinement complet est inutile si 'msAxis' n'a pas été
      ! appelée auparavant :
      if( win%axis_scale_x == 0 .or. win%axis_scale_y == 0 ) then
         return
      end if

      call mf_win_redraw( CURRENT_WIN_ID )

   end subroutine msAxisLineWidth
