!_______________________________________________________________________
!
   function mfAxis( axis ) result( mf_range )

      type(mfArray)                   :: mf_range
      character, intent(in), optional :: axis
      !------ API end ------

      type(mf_win_info), pointer :: win

      ! pointers for manipulating mfArray out of fml module
      real(kind=MF_DOUBLE), pointer :: range_ptr(:,:)

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( "mfAxis", "E",                              &
                            "no selected device!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( present(axis) ) then
         call msAssign( mf_range, mfZeros(1,2) )
      else
         call msAssign( mf_range, mfZeros(1,4) )
      end if

      call msPointer( mf_range, range_ptr, no_crc=.true. )

      if( present(axis) ) then
         if( axis == "x" ) then
            range_ptr(1,:) = win%current_axes(1:2)
         else if( axis == "y" ) then
            range_ptr(1,:) = win%current_axes(3:4)
         else
            call PrintMessage( "mfAxis", "E",                           &
                              "optional argument 'axis' must be equal to 'x' or 'y'!" )
            return
         end if
      else
         range_ptr(1,:) = win%current_axes(:)
      end if

      call msFreePointer( mf_range, range_ptr )

      call msReturnArray( mf_range ) ! set to tempo

   end function mfAxis
!_______________________________________________________________________
!
   subroutine msAxis_mode( mode, axis )

      character(len=*), intent(in)           :: mode
      character(len=1), intent(in), optional :: axis
      !------ API end ------

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: tmp, tmp_axes(4)
      integer :: axis_manual_save_x, axis_manual_save_y
      logical :: good, must_be_redraw, true_min_max_must_be_computed
      integer :: just, colbar, xlabel_pos

      character(len=*), parameter :: ROUTINE_NAME = "msAxis"

   !------ end of declarations -- execution starts hereafter  ------

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( to_lower(mode) == "inverted" ) then
         if( .not. present(axis) ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "when 'mode' is equal to 'inverted', the second", &
                              "arg 'axis' must be present!" )
            return
         end if
      end if

      if( present(axis) ) then
         if( to_lower(axis) /= "x" .and. to_lower(axis) /= "y" ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "the second arg 'axis' must be equal to 'x' or 'y'!" )
            return
         end if
         good = .false.
         if( to_lower(mode) == "inverted" ) good = .true.
         if( to_lower(mode) == "auto"     ) good = .true.
         if( to_lower(mode) == "tight"    ) good = .true.
         if( to_lower(mode) == "manual"   ) good = .true.
         if( .not. good ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "when the second arg 'axis' is present,", &
                              "'mode' must be equal to 'inverted', 'auto',", &
                              "'tight' or 'manual'!" )
            return
         end if
      end if

      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      select case( to_lower(mode) )

         case( "on" )
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! linear axes by default
               win%axis_scale_x = 1
               win%axis_scale_y = 1
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( win%axis_on ) return
            win%axis_on = .true.
            ! drawing the box only
            call mf_win_draw_box( CURRENT_WIN_ID )

         case( "off" )
            if( win%axis_on ) then
               must_be_redraw = .true.
            else
               must_be_redraw = .false.
            end if
            win%axis_on = .false.
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! linear axes by default
               win%axis_scale_x = 1
               win%axis_scale_y = 1
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( must_be_redraw ) then
               if( .not. win%blank ) then
                  ! must redraw all the plot (cannot erase the box only)
                  call mf_win_redraw( CURRENT_WIN_ID )
               end if
            end if

         case( "xy" )
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! linear axes by default
               win%axis_scale_x = 1
               win%axis_scale_y = 1
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( win%axis_mode_xy ) return
            win%axis_mode_xy = .true.
            tmp = win%current_axes(3)
            win%current_axes(3) = win%current_axes(4)
            win%current_axes(4) = tmp
            ! in all cases, the plot must be redrawn
            call mf_win_redraw( CURRENT_WIN_ID )

         case( "ij" )
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! linear axes by default
               win%axis_scale_x = 1
               win%axis_scale_y = 1
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( .not. win%axis_mode_xy ) return
            win%axis_mode_xy = .false.
            tmp = win%current_axes(3)
            win%current_axes(3) = win%current_axes(4)
            win%current_axes(4) = tmp
            ! in all cases, the plot must be redrawn
            call mf_win_redraw( CURRENT_WIN_ID )

         case( "manual" )
            if( present(axis) ) then
               if( to_lower(axis) == "x") then
                  win%axis_manual_x = 1
               else ! axis) == "y"
                  win%axis_manual_y = 1
               end if
            else
               win%axis_manual_x = 1
               win%axis_manual_y = 1
            end if
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if

         case( "equal" )
            if( win%axis_scale_x==1 .neqv. win%axis_scale_y==1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "for 'lin'/'log' axes, 'equal' has no meaning!" )
               return
            end if
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! linear axes by default
               win%axis_scale_x = 1
               win%axis_scale_y = 1
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( win%axis_equal ) return
            win%axis_equal = .true.
            if( win%blank ) then
               ! drawing the box only
               call mf_win_draw_box( CURRENT_WIN_ID )
            else
               call mf_win_redraw( CURRENT_WIN_ID )
            end if

         case( "unequal" )
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! linear axes by default
               win%axis_scale_x = 1
               win%axis_scale_y = 1
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( .not. win%axis_equal ) return
            win%axis_equal = .false.
            if( win%blank ) then
               ! drawing the box only
               call mf_win_draw_box( CURRENT_WIN_ID )
            else
               call mf_win_redraw( CURRENT_WIN_ID )
            end if

         case( "auto" )
            true_min_max_must_be_computed = .false.
            if( present(axis) ) then
               if( to_lower(axis) == "x") then
                  if( win%axis_manual_x /= 0 ) then
                     true_min_max_must_be_computed = .true.
                  end if
               else ! axis) == "y"
                  if( win%axis_manual_y /= 0 ) then
                     true_min_max_must_be_computed = .true.
                  end if
               end if
            else
               if( win%axis_manual_x /= 0 .or. win%axis_manual_y /= 0 ) then
                  true_min_max_must_be_computed = .true.
               end if
            end if

            if( true_min_max_must_be_computed ) then
               ! compute the true min-max of all the grobj
               tmp_axes(:) = get_true_min_max(CURRENT_WIN_ID)
            end if

            must_be_redraw = .false.
            if( present(axis) ) then
               if( to_lower(axis) == "x") then
                  if( win%axis_manual_x /= 0 ) then
                     win%axis_manual_x = 0
                     win%current_axes(1:2) = smart_max( tmp_axes(1:2), "x" )
                     if( all( win%current_axes(1:2) == 0.0d0 ) ) then
                        ! par défaut, on choisit des échelles linéaires.
                        win%axis_scale_x = 1
                        ! set the whole graphic env, keeping the 'manual' status
                        axis_manual_save_x = win%axis_manual_x
                        call msAxis( [ 0.0d0, 1.0d0 ], axis="x" )
                        win%axis_manual_x = axis_manual_save_x
                     end if
                     must_be_redraw = .true.
                  end if
               else ! axis) == "y"
                  if( win%axis_manual_y /= 0 ) then
                     win%axis_manual_y = 0
                     win%current_axes(3:4) = smart_max( tmp_axes(3:4), "y" )
                     if( all( win%current_axes(3:4) == 0.0d0 ) ) then
                        ! par défaut, on choisit des échelles linéaires.
                        win%axis_scale_y = 1
                        ! set the whole graphic env, keeping the 'manual' status
                        axis_manual_save_y = win%axis_manual_y
                        call msAxis( [ 0.0d0, 1.0d0 ], axis="y" )
                        win%axis_manual_y = axis_manual_save_y
                     end if
                     must_be_redraw = .true.
                  end if
               end if
            else
               if( win%axis_manual_x /= 0 .or. win%axis_manual_y /= 0 ) then
                  win%axis_manual_x = 0
                  win%axis_manual_y = 0
                  win%current_axes(1:2) = smart_max( tmp_axes(1:2), "x" )
                  win%current_axes(3:4) = smart_max( tmp_axes(3:4), "y" )
                  if( all( win%current_axes(:) == 0.0d0 ) ) then
                     ! par défaut, on choisit des échelles linéaires.
                     win%axis_scale_x = 1
                     win%axis_scale_y = 1
                     ! set the whole graphic env, keeping the 'manual' status
                     axis_manual_save_x = win%axis_manual_x
                     axis_manual_save_y = win%axis_manual_y
                     call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
                     win%axis_manual_x = axis_manual_save_x
                     win%axis_manual_y = axis_manual_save_y
                  end if
                  must_be_redraw = .true.
               end if
            end if
            if( must_be_redraw ) then
               call mf_win_redraw( CURRENT_WIN_ID )
            end if

         case( "tight" )
            true_min_max_must_be_computed = .false.
            if( present(axis) ) then
               if( to_lower(axis) == "x") then
                  if( win%axis_manual_x /= 2 ) then
                     true_min_max_must_be_computed = .true.
                  end if
               else ! axis) == "y"
                  if( win%axis_manual_y /= 2 ) then
                     true_min_max_must_be_computed = .true.
                  end if
               end if
            else
               if( win%axis_manual_x /= 2 .or. win%axis_manual_y /= 2 ) then
                  true_min_max_must_be_computed = .true.
               end if
            end if

            if( true_min_max_must_be_computed ) then
               ! compute the true min-max of all the grobj
               tmp_axes(:) = get_true_min_max(CURRENT_WIN_ID)
            end if

            must_be_redraw = .false.
            if( present(axis) ) then
               if( to_lower(axis) == "x") then
                  if( win%axis_manual_x /= 2 ) then
                     win%axis_manual_x = 2
                     win%current_axes(1:2) = tmp_axes(1:2)
                     if( all( win%current_axes(1:2) == 0.0d0 ) ) then
                        ! par défaut, on choisit des échelles linéaires.
                        win%axis_scale_x = 1
                        ! set the whole graphic env, keeping the 'manual' status
                        axis_manual_save_x = win%axis_manual_x
                        call msAxis( [ 0.0d0, 1.0d0 ], axis="x" )
                        win%axis_manual_x = axis_manual_save_x
                     end if
                     must_be_redraw = .true.
                  end if
               else ! axis) == "y"
                  if( win%axis_manual_y /= 2 ) then
                     win%axis_manual_y = 2
                     win%current_axes(3:4) = tmp_axes(3:4)
                     if( all( win%current_axes(3:4) == 0.0d0 ) ) then
                        ! par défaut, on choisit des échelles linéaires.
                        win%axis_scale_y = 1
                        ! set the whole graphic env, keeping the 'manual' status
                        axis_manual_save_y = win%axis_manual_y
                        call msAxis( [ 0.0d0, 1.0d0 ], axis="y" )
                        win%axis_manual_y = axis_manual_save_y
                     end if
                     must_be_redraw = .true.
                  end if
               end if
            else
               if( win%axis_manual_x /= 2 .or. win%axis_manual_y /= 2 ) then
                  win%axis_manual_x = 2
                  win%axis_manual_y = 2
                  win%current_axes(:) = tmp_axes(:)
                  if( all( win%current_axes(:) == 0.0d0 ) ) then
                     ! par défaut, on choisit des échelles linéaires.
                     win%axis_scale_x = 1
                     win%axis_scale_y = 1
                     ! set the whole graphic env, keeping the 'manual' status
                     axis_manual_save_x = win%axis_manual_x
                     axis_manual_save_y = win%axis_manual_y
                     call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
                     win%axis_manual_x = axis_manual_save_x
                     win%axis_manual_y = axis_manual_save_y
                  end if
                  must_be_redraw = .true.
               end if
            end if
            if( must_be_redraw ) then
               call mf_win_redraw( CURRENT_WIN_ID )
            end if

         case( "inverted" )
            if( present(axis) ) then
               if( to_lower(axis) == "x" ) then
                  tmp = win%current_axes(1)
                  win%current_axes(1) = win%current_axes(2)
                  win%current_axes(2) = tmp
                  ! in all cases, the plot must be redrawn
                  call mf_win_redraw( CURRENT_WIN_ID )
               else  if( to_lower(axis) == "y" ) then
                  tmp = win%current_axes(3)
                  win%current_axes(3) = win%current_axes(4)
                  win%current_axes(4) = tmp
                  ! in all cases, the plot must be redrawn
                  call mf_win_redraw( CURRENT_WIN_ID )
               else
                  call PrintMessage( trim(ROUTINE_NAME), "E",           &
                                     "when the second arg 'axis' is present,", &
                                     "it must be equal to 'x' or 'y'!" )
                  return
               end if
            else
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "when 'mode' is equal to 'inverted',", &
                                  "the second arg 'axis' must be present!" )
               return
            end if

         case( "linlin" )
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( win%axis_scale_x /= 1 .or. win%axis_scale_y /= 1 ) then
               ! scale index : 0 = undef., 1 = linear, 2 = log10
               win%axis_scale_x = 1
               win%axis_scale_y = 1
               call mf_win_redraw( CURRENT_WIN_ID )
            end if

         case( "loglin" )
            if( win%axis_equal ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "for 'lin'/'log' axes, 'equal' mode has no meaning',", &
                                  "therefore it has been disabled!" )
               win%axis_equal = .false.
            end if
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 1.0d0, 10.0d0, 0.0d0, 1.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( win%axis_scale_x /= 2 .or. win%axis_scale_y /= 1 ) then
               ! scale index : 0 = undef., 1 = linear, 2 = log10
               win%axis_scale_x = 2
               win%axis_scale_y = 1
if( win%axis_manual_x == 0 ) then
   ! We are currently in "auto" mode, and it is possible that the smart
   ! algorithm chose a zero for the min value. Therefore, it is necessary
   ! to recompute the true min-max values.
   tmp_axes(:) = get_true_min_max(CURRENT_WIN_ID)
   win%current_axes(1:2) = tmp_axes(1:2)
end if
               call mf_win_redraw( CURRENT_WIN_ID )
            end if

         case( "linlog" )
            if( win%axis_equal ) then
               call PrintMessage( trim(ROUTINE_NAME), "W",              &
                                  "for 'lin'/'log' axes, 'equal' mode has no meaning',", &
                                  "therefore it has been disabled!" )
               win%axis_equal = .false.
            end if
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 0.0d0, 1.0d0, 1.0d0, 10.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( win%axis_scale_x /= 1 .or. win%axis_scale_y /= 2 ) then
               ! scale index : 0 = undef., 1 = linear, 2 = log10
               win%axis_scale_x = 1
               win%axis_scale_y = 2
if( win%axis_manual_y == 0 ) then
   ! We are currently in "auto" mode, and it is possible that the smart
   ! algorithm chose a zero for the min value. Therefore, it is necessary
   ! to recompute the true min-max values.
   tmp_axes(:) = get_true_min_max(CURRENT_WIN_ID)
   win%current_axes(3:4) = tmp_axes(3:4)
end if
               call mf_win_redraw( CURRENT_WIN_ID )
            end if

         case( "loglog" )
            if( all( win%current_axes(:) == 0.0d0 ) ) then
               ! set the whole graphic env, keeping the 'manual' status
               axis_manual_save_x = win%axis_manual_x
               axis_manual_save_y = win%axis_manual_y
               call msAxis( [ 1.0d0, 10.0d0, 1.0d0, 10.0d0 ] )
               win%axis_manual_x = axis_manual_save_x
               win%axis_manual_y = axis_manual_save_y
            end if
            if( win%axis_scale_x /= 2 .or. win%axis_scale_y /= 2 ) then
               ! scale index : 0 = undef., 1 = linear, 2 = log10
               win%axis_scale_x = 2
               win%axis_scale_y = 2
if( win%axis_manual_x == 0 ) then
   ! We are currently in "auto" mode, and it is possible that the smart
   ! algorithm chose a zero for the min value. Therefore, it is necessary
   ! to recompute the true min-max values.
   tmp_axes(:) = get_true_min_max(CURRENT_WIN_ID)
   win%current_axes(1:2) = tmp_axes(1:2)
end if
if( win%axis_manual_y == 0 ) then
   ! We are currently in "auto" mode, and it is possible that the smart
   ! algorithm chose a zero for the min value. Therefore, it is necessary
   ! to recompute the true min-max values.
   tmp_axes(:) = get_true_min_max(CURRENT_WIN_ID)
   win%current_axes(3:4) = tmp_axes(3:4)
end if
               call mf_win_redraw( CURRENT_WIN_ID )
            end if

         case default
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "unknown keyword : '" // trim(mode) // "'" )
            return

      end select

   end subroutine msAxis_mode
!_______________________________________________________________________
!
   subroutine msAxis_real_range( dp_range, axis )

      real(kind=MF_DOUBLE), intent(in)           :: dp_range(:)
      character(len=1),     intent(in), optional :: axis
      !------ API end ------

      type(mf_win_info), pointer :: win
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max
      logical :: warning

      character(len=*), parameter :: ROUTINE_NAME = "msAxis"

   !------ end of declarations -- execution starts hereafter  ------

      if( present(axis) ) then
         if( size(dp_range) /= 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "when 'axis' is present, 'dp_range' must contain 2 values!" )
            return
         end if
      else
         if( size(dp_range) /= 4 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'dp_range' must contain 4 values!" )
            return
         end if
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .and. win%axis_scale_y == 0 ) then
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      end if
      if( .not. present(axis) ) then
         x_min = dp_range(1)
         x_max = dp_range(2)
         y_min = dp_range(3)
         y_max = dp_range(4)
         win%axis_manual_x = 1
         win%axis_manual_y = 1
      else
         if( to_lower(axis) == "x" ) then
            x_min = dp_range(1)
            x_max = dp_range(2)
            y_min = win%current_axes(3)
            y_max = win%current_axes(4)
            win%axis_manual_x = 1
         else if( to_lower(axis) == "y" ) then
            x_min = win%current_axes(1)
            x_max = win%current_axes(2)
            y_min = dp_range(1)
            y_max = dp_range(2)
            win%axis_manual_y = 1
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'axis' must be equal to 'x' or 'y'!" )
            return
         end if
      end if
      ! to avoid invalid axes in MFPLOT, and also to avoid
      ! floating-point absorption.
      call fix_min_max_for_axes( x_min, x_max, warning )
      if( warning ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "x_min and x_max values have been fixed!" )
      end if
      call fix_min_max_for_axes( y_min, y_max, warning )
      if( warning ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "y_min and y_max values have been fixed!" )
      end if

      win%current_axes(:) = [ x_min, x_max, y_min, y_max ]

      if( win%blank ) then
         ! drawing the box only
         call mf_win_draw_box( CURRENT_WIN_ID )
      else
         call mf_win_redraw( CURRENT_WIN_ID )
      end if

   end subroutine msAxis_real_range
!_______________________________________________________________________
!
   subroutine msAxis_mf_range( mf_range, axis )

      type(mfArray)                          :: mf_range
      character(len=1), intent(in), optional :: axis
      !------ API end ------

      type(mf_win_info), pointer :: win

      real(kind=MF_DOUBLE), pointer :: dp_range(:)
      character(len=80) :: string
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max
      logical :: warning

      character(len=*), parameter :: ROUTINE_NAME = "msAxis"

   !------ end of declarations -- execution starts hereafter  ------

      call msInitArgs( mf_range )

      ! checking that 'mf_range' is allocated
      if( mfIsEqual(mf_range,MF_EMPTY) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range' not allocated!" )
         go to 99
      end if

      ! 'mf_range' must be real
      if( .not. mfIsReal(mf_range) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range' must be real!" )
         go to 99
      end if

      ! 'mf_range' cannot be sparse
      if( mfIsSparse(mf_range) ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "'mf_range' cannot be sparse!" )
         go to 99
      end if

      call msPointer( mf_range, dp_range, no_crc=.true., intern_call=.true. )

      if( present(axis) ) then
         if( size(dp_range) /= 2 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "when 'axis' is present, 'dp_range' must contain 2 values!" )
            return
         end if
      else
         if( size(dp_range) /= 4 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'dp_range' must contain 4 values!" )
            return
         end if
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            go to 99
         end if
      end if

      call unset_smart_ticks_x()
      call unset_smart_ticks_y()

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%axis_scale_x == 0 .and. win%axis_scale_y == 0 ) then
         win%axis_scale_x = 1
         win%axis_scale_y = 1
      end if
      if( .not. present(axis) ) then
         x_min = dp_range(1)
         x_max = dp_range(2)
         y_min = dp_range(3)
         y_max = dp_range(4)
         win%axis_manual_x = 1
         win%axis_manual_y = 1
      else
         if( to_lower(axis) == "x" ) then
            x_min = dp_range(1)
            x_max = dp_range(2)
            y_min = win%current_axes(3)
            y_max = win%current_axes(4)
            win%axis_manual_x = 1
         else if( to_lower(axis) == "y" ) then
            x_min = win%current_axes(1)
            x_max = win%current_axes(2)
            y_min = dp_range(1)
            y_max = dp_range(2)
            win%axis_manual_y = 1
         else
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                              "'axis' must be equal to 'x' or 'y'!" )
            return
         end if
      end if

      call msFreePointer( mf_range, dp_range )

      ! to avoid invalid axes in MFPLOT, and also to avoid
      ! floating-point absorption.
      call fix_min_max_for_axes( x_min, x_max, warning )
      if( warning ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "x_min and x_max values have been fixed!" )
      end if
      call fix_min_max_for_axes( y_min, y_max, warning )
      if( warning ) then
         call PrintMessage( trim(ROUTINE_NAME), "I",                    &
                            "y_min and y_max values have been fixed!" )
      end if

      win%current_axes(:) = [ x_min, x_max, y_min, y_max ]

      if( win%empty ) then
         ! drawing the box only
         call mf_win_draw_box( CURRENT_WIN_ID )
      else
         call mf_win_redraw( CURRENT_WIN_ID )
      end if

 99   continue

      call msFreeArgs( mf_range )
      call msAutoRelease( mf_range )

   end subroutine msAxis_mf_range
