!_______________________________________________________________________
!
   subroutine mf_arrow_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "arrow"

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Arrow", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Arrow", 0 )
         end if
         gr_pdf_color_intent = 3 ! Stroke & Fill
      end if

      call grsci(grobj%struct%color) ! set color index
      call grslw(grobj%struct%linewidth) ! line width
      call grsls(1)                       ! default line style
      call pgsch(grobj%struct%height_symb) ! char. height

      ! Draw the arrow; its headsize is proportional to the char. height
      call pgarro( grobj%struct%x_text, grobj%struct%y_text,            &
                   grobj%struct%ang_text, grobj%struct%just_text,       &
                   clipping=grobj%struct%bool1 )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Arrow", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Arrow", 0 )
         end if
      end if

   end subroutine mf_arrow_draw
!_______________________________________________________________________
!
   subroutine mf_arrow_head_draw( grobj )

      type(grobj_elem), intent(in) :: grobj
      !------ API end ------

      ! grobj type = "arrow_head_only"

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(1)

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Arrow (head only)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Arrow (head only)", 0 )
         end if
         gr_pdf_color_intent = 2 ! Fill
      end if

      call grsci(grobj%struct%color) ! set color index
      call grsls(1)                      ! default line style
      call pgsch(grobj%struct%height_symb) ! char. height

      ! Draw the arrow head; its size is proportional to the char. height
      call pgarro_head_only( grobj%struct%x_text,                       &
                             grobj%struct%y_text,                       &
                             grobj%struct%ang_text )

      if( PRINTING_EPS ) then
         if( COMMENTS_IN_EPS ) then
            ibuf(1) = 0
            call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Arrow (head only)", 0 )
         end if
      end if
      if( PRINTING_PDF ) then
         if( COMMENTS_IN_PDF ) then
            call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Arrow (head only)", 0 )
         end if
      end if

   end subroutine mf_arrow_head_draw
