! Optional args.:
!
!   'color' : a string containing either the encoded color
!             (e.g. "b" = blue, "r" = red) but also an escaped sequence;
!
!             either a color name (present in the RGB database);
!
!             either a triplet of real containing the RGB components.
!
!   'linewidth' : a real factor around 1.0, concerning the width of
!                 the line; by default, linewidth is 1.0
!   'headsize' : a real factor around 1.0, concerning the head of
!                the arrow; by default, width is 1.0
!

!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfArrow_pos_real_str( x_start, y_start, x_end, y_end,       &
                                  color, linewidth, headsize, clipping ) &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msArrow_pos_real_str( x_start, y_start, x_end, y_end,     &
                                    color, linewidth, headsize, clipping )
#endif

      real(kind=MF_DOUBLE), intent(in)           :: x_start, y_start,   &
                                                    x_end, y_end
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, headsize
      logical,              intent(in), optional :: clipping

      integer :: handle
      !------ API end ------

      integer :: i, icol, hdle, ier
      real(kind=MF_DOUBLE) :: x(2), y(2), intensity, r, g, b
      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      real(kind=MF_DOUBLE) :: linewidth_0, headsize_0
      logical :: clipped
      integer :: axis_manual_save_x, axis_manual_save_y

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfArrow"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msArrow"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      x(1:2) = [ x_start, x_end ]
      y(1:2) = [ y_start, y_end ]

      ! Contrary to the case of 'PlotCore', there is no need to prepare axes
      !
      ! The default behavior is then: Arrow is superimposed on the graph and
      ! there is no need to hold the plot (like Text, it is considered as an
      ! annotation).

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to light grey)" )
            icol = -127
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0d0
      end if

      if( present(headsize) ) then
         headsize_0 = headsize
      else
         headsize_0 = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( .not. clipped ) then
         win%at_least_one_grobj_not_clipped = .true.
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "arrow"
      grobj%struct%x_text = x(1)
      grobj%struct%y_text = y(1)
      grobj%struct%ang_text = x(2)
      grobj%struct%just_text = y(2)
      grobj%struct%color = icol
      grobj%struct%linewidth = linewidth_0
      grobj%struct%height_symb = headsize_0
      grobj%struct%bool1 = clipped

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      call mf_arrow_draw( grobj )

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

#ifdef _MF_FUNC
   end function mfArrow_pos_real_str
#endif
#ifdef _MF_SUBR
   end subroutine msArrow_pos_real_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfArrow_pos_real_rgb( x_start, y_start, x_end, y_end,       &
                                  color, linewidth, headsize, clipping ) &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msArrow_pos_real_rgb( x_start, y_start, x_end, y_end,     &
                                    color, linewidth, headsize, clipping )
#endif

      real(kind=MF_DOUBLE), intent(in)           :: x_start, y_start,   &
                                                    x_end, y_end
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: linewidth, headsize
      logical,              intent(in), optional :: clipping

      integer :: handle
      !------ API end ------

      integer :: i, icol, hdle
      real(kind=MF_DOUBLE) :: x(2), y(2), intensity, r, g, b
      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      real(kind=MF_DOUBLE) :: linewidth_0, headsize_0
      logical :: clipped
      integer :: axis_manual_save_x, axis_manual_save_y

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfArrow"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msArrow"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      x(1:2) = [ x_start, x_end ]
      y(1:2) = [ y_start, y_end ]

      ! Contrary to the case of 'PlotCore', there is no need to prepare axes
      !
      ! The default behavior is then: Arrow is superimposed on the graph and
      ! there is no need to hold the plot (like Text, it is considered as an
      ! annotation).

      ! Default values
      icol = 1 ! foreground color

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(linewidth) ) then
         linewidth_0 = linewidth
      else
         linewidth_0 = 1.0d0
      end if

      if( present(headsize) ) then
         headsize_0 = headsize
      else
         headsize_0 = 1.0d0
      end if

      if( present(clipping) ) then
         clipped = clipping
      else
         clipped = .true.
      end if

      if( .not. clipped ) then
         win%at_least_one_grobj_not_clipped = .true.
      end if

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "arrow"
      grobj%struct%x_text = x(1)
      grobj%struct%y_text = y(1)
      grobj%struct%ang_text = x(2)
      grobj%struct%just_text = y(2)
      grobj%struct%color = icol
      grobj%struct%linewidth = linewidth_0
      grobj%struct%height_symb = headsize_0
      grobj%struct%bool1 = clipped

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      call mf_arrow_draw( grobj )

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

#ifdef _MF_FUNC
   end function mfArrow_pos_real_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msArrow_pos_real_rgb
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfArrow_Head_pos_real_str( x, y, angle,                     &
                                       color, headsize )                                &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msArrow_Head_pos_real_str( x, y, angle,                   &
                                         color, headsize )
#endif

      real(kind=MF_DOUBLE), intent(in)           :: x, y, angle
      character(len=*),     intent(in)           :: color
      real(kind=MF_DOUBLE), intent(in), optional :: headsize

      integer :: handle
      !------ API end ------

      integer :: i, icol, hdle, ier
      real(kind=MF_DOUBLE) :: xy(2), intensity, r, g, b
      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      real(kind=MF_DOUBLE) :: headsize_0
      integer :: axis_manual_save_x, axis_manual_save_y

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfArrowHead"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msArrowHead"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      xy(1:2) = [ x, y ]

      ! Contrary to the case of 'PlotCore', there is no need to prepare axes
      !
      ! The default behavior is then: Arrow is superimposed on the graph and
      ! there is no need to hold the plot (like Text, it is considered as an
      ! annotation).

      if( len_trim(color) == 1 .or. color(1:1) == "\" ) then
         call decode_linespec( color, icol, ier=ier )
         if( ier /= 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                              "bad 'color' argument!",                  &
                              "(line color will be set to light grey)" )
            icol = 1
         end if
      else
         call decode_col_name( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(headsize) ) then
         headsize_0 = headsize
      else
         headsize_0 = 1.0d0
      end if

      win => mf_win_db(CURRENT_WIN_ID)

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "arrow_head_only"
      grobj%struct%x_text = xy(1)
      grobj%struct%y_text = xy(2)
      grobj%struct%ang_text = angle
      grobj%struct%color = icol
      grobj%struct%height_symb = headsize_0

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      call mf_arrow_head_draw( grobj )

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

#ifdef _MF_FUNC
   end function mfArrow_Head_pos_real_str
#endif
#ifdef _MF_SUBR
   end subroutine msArrow_Head_pos_real_str
#endif
!_______________________________________________________________________
!
#ifdef _MF_FUNC
   function mfArrow_Head_pos_real_rgb( x, y, angle,                     &
                                       color, headsize )                                &
   result( handle )
#endif
#ifdef _MF_SUBR
   subroutine msArrow_Head_pos_real_rgb( x, y, angle,                   &
                                         color, headsize )
#endif

      real(kind=MF_DOUBLE), intent(in)           :: x, y, angle
      real(kind=MF_DOUBLE), intent(in), optional :: color(3)
      real(kind=MF_DOUBLE), intent(in), optional :: headsize

      integer :: handle
      !------ API end ------

      integer :: i, icol, hdle
      real(kind=MF_DOUBLE) :: xy(2), intensity, r, g, b
      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj
      real(kind=MF_DOUBLE) :: headsize_0
      integer :: axis_manual_save_x, axis_manual_save_y

#ifdef _MF_FUNC
      character(len=*), parameter :: ROUTINE_NAME = "mfArrowHead"
#endif
#ifdef _MF_SUBR
      character(len=*), parameter :: ROUTINE_NAME = "msArrowHead"
#endif

   !------ end of declarations -- execution starts hereafter  ------

#ifdef _MF_FUNC
      handle = 0
#endif

      if( CURRENT_WIN_ID == 0 ) then
         call msFigure()
         if( CURRENT_WIN_ID == 0 ) then
            call PrintMessage( trim(ROUTINE_NAME), "E",                 &
                               "cannot plot: no window created!" )
            return
         end if
      end if

      win => mf_win_db(CURRENT_WIN_ID)
      if( all( win%current_axes(:) == 0.0d0 ) ) then
         ! set the whole graphic env, keeping the 'manual' status
         axis_manual_save_x = win%axis_manual_x
         axis_manual_save_y = win%axis_manual_y
         call msAxis( [ 0.0d0, 1.0d0, 0.0d0, 1.0d0 ] )
         win%axis_manual_x = axis_manual_save_x
         win%axis_manual_y = axis_manual_save_y
      end if

      xy(1:2) = [ x, y ]

      ! Contrary to the case of 'PlotCore', there is no need to prepare axes
      !
      ! The default behavior is then: Arrow is superimposed on the graph and
      ! there is no need to hold the plot (like Text, it is considered as an
      ! annotation).

      ! Default values
      icol = 1 ! foreground color

      if( present(color) ) then
         call decode_col_rgb( color, icol )
      end if

      if( icol == -127 ) then
         icol = MFPLOT_LIGHT_GREY
      end if

      if( present(headsize) ) then
         headsize_0 = headsize
      else
         headsize_0 = 1.0d0
      end if

      win => mf_win_db(CURRENT_WIN_ID)

!++++++++++++++++++ Storage in DB ++++++++++++++++++

      ! new grobj
      if( win%mf_win_db_active ) then
         ! create a new grobj and insert it in the linked list
         call create_grobj( win, grobj )
      else
         ! just allocate the grobj
         allocate( grobj )
      end if

      grobj%struct%cmd = "arrow_head_only"
      grobj%struct%x_text = xy(1)
      grobj%struct%y_text = xy(2)
      grobj%struct%ang_text = angle
      grobj%struct%color = icol
      grobj%struct%height_symb = headsize_0

      if( win%mf_win_db_active ) then
         hdle = mf_win_get_free_handle(CURRENT_WIN_ID)
         win%handles(hdle)%ptr => grobj
         grobj%struct%hdle = hdle
         handle = encode_handle( CURRENT_WIN_ID, hdle )
      end if

!+++++++++++++++++++++++++++++++++++++++++++++++++++

      win%blank = .false.
      win%empty = .false.

!------------------ Drawing GrObj ------------------

      call mf_arrow_head_draw( grobj )

!---------------------------------------------------

      if( .not. win%mf_win_db_active ) then
         call delete_grobj_inside( grobj )
         deallocate( grobj )
      end if

#ifdef _MF_FUNC
   end function mfArrow_Head_pos_real_rgb
#endif
#ifdef _MF_SUBR
   end subroutine msArrow_Head_pos_real_rgb
#endif
