!_______________________________________________________________________
!
   subroutine msAnimation( mode )

      character(len=*), intent(in) :: mode
      !------ API end ------

      type(mf_win_info), pointer :: win

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character :: chr

      character(len=*), parameter :: ROUTINE_NAME = "msAnimation"

   !------ end of declarations -- execution starts hereafter  ------

      if( .not. X11_DEVICE ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "X11 device is ""off"".",                   &
                            "('" // trim(ROUTINE_NAME) // "' is an interactive routine which requires X11)" )
         return
      end if

      if( CURRENT_WIN_ID == 0 ) then
         call PrintMessage( trim(ROUTINE_NAME), "E",                    &
                            "no X11 device selected!" )
         return
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      select case( to_lower(mode) )
         case("on")

            ! avoid many calls to this routine without setting
            ! msAnimation("off")
            if( .not. win%mf_win_db_active ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "Animation is already in progress!",  &
                                  '(forget to call msAnimation("off")?)' )
               return
            end if

            if( win%axis_manual_x /= 1 .or. win%axis_manual_y /= 1 ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "Animation requires constant axis!",  &
                                  "(forget to call 'msAxis'?)" )
               return
            end if

            win%mf_win_db_active = .false.

            call msHold( "on" )

            call dealloc_all_grobjs( CURRENT_WIN_ID )

            ! Disable the update of the screen by the X11 command 'xw_flush'.
            ! To update manually, use the 'msShowNow' routine.
            ibuf(1) = 0
            call grexec( grgtyp, X11_FLUSH_POLICY, rbuf, ibuf, chr, lchr )

            ! Disable also he change of focus. Otherwise, a loop could
            ! change repeatedly the focus to the terminal, blocking the
            ! use of the graphical environment!
            FOCUS_CHANGE_DISABLE = .true.

         case("off")

            ! avoid many calls to this routine without setting
            ! msAnimation("on")
            if( win%mf_win_db_active ) then
               call PrintMessage( trim(ROUTINE_NAME), "E",              &
                                  "Animation is not in progress!",      &
                                  '(forget to call msAnimation("on")?)' )
               return
            end if

            win%mf_win_db_active = .true.

            !re-initialize the color cycled tab.
            win%ind_next_color = 1

            ! back to default state
            call msHold( "off" )

            ! Re-enable the update of the screen by the X11 command 'xw_flush'.
            ibuf(1) = 1
            call grexec( grgtyp, X11_FLUSH_POLICY, rbuf, ibuf, chr, lchr )

            ! Re-enable the change of focus.
            FOCUS_CHANGE_DISABLE = .false.

            ! Change focus to the terminal
            call set_focus_mfplot_win( 0 )

         case default
            call PrintMessage( trim(ROUTINE_NAME), "W",                 &
                               "unknown keyword : '" // trim(mode) // "'" )
            return
      end select

   end subroutine msAnimation
