! f90 include file

!_______________________________________________________________________
!
   subroutine PG2DPROJ_X( z, ni, nj, forward, flat, gd, gd_col, gd_step, &
                          xx, yy, lighting, scaling_xyz )

      integer,              intent(in)           :: ni, nj
      real(kind=MF_DOUBLE), intent(in)           :: z(ni,nj)
      logical,              intent(in)           :: forward, flat, gd
      integer,              intent(in)           :: gd_col, gd_step(2)
      real(kind=MF_DOUBLE), intent(in), optional :: xx(nj), yy(ni)
      logical,              intent(in), optional :: lighting
      real(kind=MF_DOUBLE), intent(in), optional :: scaling_xyz(3)

      ! Projection of the Z(Y,X) surface onto the (X,Z) plane.
      !
      ! Arguments (all input):
      !  Z(NI,NJ): the data array to be plotted.
      !  FORWARD : forward view if true, else backward view.
      !  FLAT: Shading for filling the quadrilateral cells.
      !  GD : Boolean to know whether a grid (i.e. the cells boundaries) must
      !       be drawn or not.
      !  GD_COL: Color index to use for drawing the grid.
      !  GD_STEP: Step for drawing the grid; this avoid a too dark figure,
      !           when the number of rows/columns of Z is large.
      !  XX : The abscissae of the panels to be plotted. The program assumes
      !       that the X value for Z(Y,X) is the same for all Y.
      !  YY : The other ordinates of the panels, not always used (actually,
      !       only when lighting=TRUE), Y is this case. The program assumes
      !       that the Y value for Z(Y,X) is the same for all X.
      !  LIGHTING: Color the surface from the orientation of the normal.
      !  SCAL_X, SCAL_Y, SCAL_Z: Needed for the lighting of the surface.
      !--
      ! 21-Apr-2020 - Created from PG2DPROJ_Y routine [EC].
      ! 21-Apr-2020 - Added the GD argument to show the cell boundaries.
      !               Changed names of many variables [EC].
      !  7-May-2020 - Added the LIGHTING optional argument, in order to
      !               better emphasize the 3D shape of the surface [EC].
      ! 19-May-2020 - Simplify the behavior by removing I1, I2, J1, J2
      !               arguments [EC].
      !-----------------------------------------------------------------------

      type(mf_win_info), pointer :: win

      integer :: s, i, j, ii, jj, m, n, i_beg, i_end
      integer :: icol, c3(3), type_of_patch
      real(kind=MF_DOUBLE) :: x4(4), y4(4), x3(3), y3(3)
      real(kind=MF_DOUBLE) :: u1, v1, u2, v2, orient_123, orient_134, xi, yi
      real(kind=MF_DOUBLE) :: fact, mean, x(nj), y(ni), color
      real(kind=MF_DOUBLE) :: ux, uy, uz, vx, vy, vz, cp_x, cp_y, cp_z, xnorm
      logical :: light

      ! Check arguments.
      if( ni < 2 ) return
      if( nj < 2 ) return

      win => mf_win_db(CURRENT_WIN_ID)

      if( present(xx) ) then
         x(:) = xx(:)
      else
         x = [ (j, j = 1, nj) ]
      end if

      if( present(yy) ) then
         y(:) = yy(:)
      else
         y = [ (i, i = 1, ni) ]
      end if

      if( present(lighting) ) then
         light = lighting
      else
         light = .false.
      end if

      ! Check i order.
      if( forward ) then
         s = 1
         i_beg = 1
         i_end = ni - 1
      else
         s = -1
         i_beg = ni
         i_end = 2
      end if

      call pgbbuf()

      if( light ) then
         fact = (pgmxci(pgid)-pgmnci(pgid))
      else
         fact = (pgmxci(pgid)-pgmnci(pgid))/(win%color_axes(2)-win%color_axes(1))
      end if

      ! Loop through matrix rows.
      do i = i_beg, i_end, s

         ! Loop through matrix columns.
         do j = 1, nj-1

            x4(1) = x(j)
            y4(1) = z(i,j)
            x4(2) = x(j+1)
            y4(2) = z(i,j+1)
            x4(3) = x4(2)
            y4(3) = z(i+s,j+1)
            x4(4) = x4(1)
            y4(4) = z(i+s,j)

            if( flat ) then

               if( light ) then
                  ux = ( x(j+1) - x(j) )/scaling_xyz(1)
                  uy = ( y(i+s) - y(i) )/scaling_xyz(2)
                  uz = ( z(i+s,j+1) - z(i,j) )/scaling_xyz(3)

                  vx = -ux
                  vy = uy
                  vz = ( z(i+s,j) - z(i,j+1) )/scaling_xyz(3)

                  cp_x = uy*vz - uz*vy
                  cp_y = uz*vx - ux*vz
                  cp_z = ux*vy - uy*vx
                  xnorm = sqrt( cp_x**2 + cp_y**2 + cp_z**2 )
                  mean = abs( cp_y/xnorm )

                  ! Selecting color from current colormap
                  icol = nint( pgmnci(pgid) + fact*mean )
               else
                  mean = ( z(i,j) + z(i,j+1) + z(i+s,j+1) + z(i+s,j) ) / 4.0d0

                  ! Selecting color from current colormap
                  icol = nint( pgmnci(pgid) + fact*(mean-win%color_axes(1)) )
               end if
               gr_pdf_color_intent = 2 ! Fill
               call check_color_overflow_scal( icol )
               call grsci( icol ) ! selecting the requested color

               ! Draw the polygon filled with a flat color
               call pgpoly( 4, x4, y4 )

            else ! .not. flat

               ! We always split the quadrangle in two triangles
               ! (direct orientation will be checked in PatchTriCore)
               ! first is triangle 1-2-3
               x3(1) = x4(1)
               y3(1) = y4(1)
               x3(2) = x4(2)
               y3(2) = y4(2)
               x3(3) = x4(3)
               y3(3) = y4(3)
               if( light ) then
                  call compute_light_xy( x, y, z, ni, nj, i, j, "XZ",   &
                                        scaling_xyz, color )
                  c3(1) = nint( pgmnci(pgid) + fact*color )
                  call compute_light_xy( x, y, z, ni, nj, i, j+1, "XZ", &
                                        scaling_xyz, color )
                  c3(2) = nint( pgmnci(pgid) + fact*color )
                  call compute_light_xy( x, y, z, ni, nj, i+s, j+1, "XZ", &
                                        scaling_xyz, color )
                  c3(3) = nint( pgmnci(pgid) + fact*color )
               else
                  c3(:) = nint( pgmnci(pgid) + fact*(y3(:)-win%color_axes(1)) )
               end if
               call check_color_overflow_vec( c3 )
               if( PRINTING_EPS .or. PRINTING_PDF ) then
                  if( j == 1 ) then
                     type_of_patch = 1
                  else
                     type_of_patch = 0
                  end if
                  call PatchTriCore_PS_PDF_shad( x3, y3, c3, type_of_patch, &
                                                 opacity=1.0d0 )
               else
                  call PatchTriCore( x3, y3, c3, opacity=1.0d0)
               end if
               ! second is triangle 1-3-4
               x3(1) = x4(1)
               y3(1) = y4(1)
               x3(2) = x4(3)
               y3(2) = y4(3)
               x3(3) = x4(4)
               y3(3) = y4(4)
               if( light ) then
                  call compute_light_xy( x, y, z, ni, nj, i, j, "XZ",   &
                                        scaling_xyz, color )
                  c3(1) = nint( pgmnci(pgid) + fact*color )
                  call compute_light_xy( x, y, z, ni, nj, i+s, j+1, "XZ", &
                                        scaling_xyz, color )
                  c3(2) = nint( pgmnci(pgid) + fact*color )
                  call compute_light_xy( x, y, z, ni, nj, i+s, j, "XZ", &
                                        scaling_xyz, color )
                  c3(3) = nint( pgmnci(pgid) + fact*color )
               else
                  c3(:) = nint( pgmnci(pgid) + fact*(y3(:)-win%color_axes(1)) )
               end if
               call check_color_overflow_vec( c3 )
               if( PRINTING_EPS .or. PRINTING_PDF ) then
                  if( j == nj-1 ) then
                     type_of_patch = 2
                  else
                     type_of_patch = 0
                  end if
                  call PatchTriCore_PS_PDF_shad( x3, y3, c3, type_of_patch, &
                                                 opacity=1.0d0 )
               else
                  call PatchTriCore( x3, y3, c3, opacity=1.0d0)
               end if

            end if

         end do

         if( gd ) then
            gr_pdf_color_intent = 1 ! Stroke
            call grsci(gd_col)
            ! Draw the i-lines (i=cst)
            if( mod(i-1,gd_step(1))==0 ) then
               call pgline( nj, x, z(i,1:nj) )
            end if
         end if

      end do

      if( gd ) then
         gr_pdf_color_intent = 1 ! Stroke
         call grsci(gd_col) ! selecting the requested color

         ! Draw the last i-line
         ! (after the previous i-loop, the index has been incremented)
         if( mod(i-1,gd_step(1))==0 ) then
            call pgline( nj, x, z(i,1:nj) )
         end if

         ! Draw the j-lines
         do j = 1, nj
            if( mod(j-1,gd_step(2))==0 ) then
               call pgline( ni, [ (x(j),i=1,ni) ], z(1:ni,j) )
            end if
         end do

      end if

      call pgebuf()

   end subroutine PG2DPROJ_X
