! f90 include file

!_______________________________________________________________________
!
   subroutine PG2DPROJ_MATY( z, x, y, ni, nj, forward, flat,            &
                             gd, gd_col, gd_step, ref_l_gd,             &
                             lighting, scaling_xyz )

      real(kind=MF_DOUBLE), intent(in) :: z(ni,nj), x(ni,nj), y(ni,nj)
      integer,              intent(in) :: ni, nj
      logical,              intent(in) :: forward, flat, gd
      integer,              intent(in) :: gd_col, gd_step(2)
      real(kind=MF_DOUBLE), intent(in) :: ref_l_gd
      logical,              intent(in), optional :: lighting
      real(kind=MF_DOUBLE), intent(in), optional :: scaling_xyz(3)

      ! Projection of the Z(Y,X) surface onto the (Y,Z) plane.
      !
      ! Arguments (all input):
      !  Z   : the data array to be plotted.
      !  X   : the array containing the abscissae of all data points.
      !  Y   : the array containing the ordinates of all data points.
      !  FORWARD : forward view if true, else backward view.
      !  FLAT: Shading for filling the quadrilateral cells.
      !  GD  : Boolean to know whether a grid (i.e. the cells boundaries) must
      !        be drawn or not.
      !  GD_COL: Color index to use for drawing the grid.
      !  GD_STEP: Step for drawing the grid; this avoid a too dark figure,
      !           when the number of rows/columns of Z is large.
      !  REF_L_GD: Reference length used when drawing the grid after the
      !            shaded colors in the cells (to remove too short segments).
      !  LIGHTING: Color the surface from the orientation of the normal.
      !  SCAL_X, SCAL_Y, SCAL_Z: Needed for the lighting of the surface.
      !--
      ! 23-Apr-2020 - Created from PG2DPROJ_Y [EC].
      !  9-May-2020 - Added the LIGHTING optional argument, in order to
      !               better emphasize the 3D shape of the surface [EC].
      ! 16-May-2020 - In case of shading=interp, draw the grid after the
      !               colored cells, in order to group the shading items
      !               in one PDF object [EC].
      !-----------------------------------------------------------------------

      type(mf_win_info), pointer :: win

      integer :: i, j, k, nt, nt2, kk
      integer :: icol, c3(3), type_of_patch
      real(kind=MF_DOUBLE) :: xp(5), yp(5), x3(3), y3(3)
      integer, allocatable :: ind_x(:)
      real(kind=MF_DOUBLE), allocatable :: x_cm(:)
      real(kind=MF_DOUBLE) :: fact, mean, color
      character(len=3) :: sort_mode
      real(kind=MF_DOUBLE) :: ux, uy, uz, vx, vy, vz, cp_x, cp_y, cp_z, xnorm
      logical :: light, first_triangle

      ! Check arguments.
      if( ni < 2 ) return
      if( nj < 2 ) return

      win => mf_win_db(CURRENT_WIN_ID)

      if( forward ) then
         sort_mode = "des"
      else
         sort_mode = "asc"
      end if

      if( present(lighting) ) then
         light = lighting
      else
         light = .false.
      end if

      if( light ) then
         fact = (pgmxci(pgid)-pgmnci(pgid))
      else
         fact = (pgmxci(pgid)-pgmnci(pgid))/(win%color_axes(2)-win%color_axes(1))
      end if

      if( flat ) then

         ! keeping the quadrilateral shapes

         nt = (ni-1)*(nj-1)
         allocate( x_cm(nt), ind_x(nt) )
         ! build the list of X position of mass center of all cells
         !
         ! the inverse formula to find (i,j) from k is:
         !   i = k / (nj-1) + 1
         !   j = mod( k, nj-1 )
         !   if( j == 0 ) j = nj-1; i = i-1
         !
         do i = 1, ni-1
            do j = 1, nj-1
               k = (i-1)*(nj-1) + j
               ind_x(k) = k
               x_cm(k) = ( x(i,j) + x(i+1,j) + x(i+1,j+1) + x(i,j+1) ) / 4.0d0
            end do
         end do
         ! sort the x_cm list and the associated indices
         call quick_sort_3( mode=sort_mode, A=x_cm, ind=ind_x )

         call pgbbuf()

         ! loop over all cells, in specific order
         do k = 1, nt

            kk = ind_x(k)
            i = kk/(nj-1) + 1
            j = mod( kk, nj-1 )
            if( j == 0 ) then
               j = nj-1
               i = i - 1
            end if

            xp(1) = y(i,j)
            yp(1) = z(i,j)
            xp(2) = y(i+1,j)
            yp(2) = z(i+1,j)
            xp(3) = y(i+1,j+1)
            yp(3) = z(i+1,j+1)
            xp(4) = y(i,j+1)
            yp(4) = z(i,j+1)

            if( light ) then
               ux = ( x(i+1,j+1) - x(i,j) )/scaling_xyz(1)
               uy = ( y(i+1,j+1) - y(i,j) )/scaling_xyz(2)
               uz = ( z(i+1,j+1) - z(i,j) )/scaling_xyz(3)
               vx = ( x(i,j+1) - x(i+1,j) )/scaling_xyz(1)
               vy = ( y(i,j+1) - y(i+1,j) )/scaling_xyz(2)
               vz = ( z(i,j+1) - z(i+1,j) )/scaling_xyz(3)
               cp_x = uy*vz - uz*vy
               cp_y = uz*vx - ux*vz
               cp_z = ux*vy - uy*vx
               xnorm = sqrt( cp_x**2 + cp_y**2 + cp_z**2 )
               mean = abs( cp_x/xnorm )

               ! Selecting color from current colormap
               icol = nint( pgmnci(pgid) + fact*mean )
            else
               mean = ( z(i,j) + z(i+1,j) + z(i+1,j+1) + z(i,j+1) ) / 4.0d0

               ! Selecting color from current colormap
               icol = nint( pgmnci(pgid) + fact*(mean-win%color_axes(1)) )
            end if
            gr_pdf_color_intent = 2 ! Fill
            call check_color_overflow_scal( icol )
            call grsci( icol ) ! selecting the requested color

            ! Draw the polygon filled with a flat color
            call pgpoly( 4, xp, yp )

            if( gd ) then
               gr_pdf_color_intent = 1 ! Stroke
               call grsci(gd_col)
               ! Draw the boundary line of the cell
               if( gd_step(1)==1 .and. gd_step(2)==1 ) then
                  ! quick way
                  xp(5) = xp(1)
                  yp(5) = yp(1)
                  call pgline( 5, xp, yp )
               else
                  ! 1-2 segment
                  if( mod(j-1,gd_step(2))==0 ) then
                     call pgline( 2, xp(1:2), yp(1:2) )
                  end if
                  ! 2-3 segment
                  if( mod(i,gd_step(1))==0 ) then
                     call pgline( 2, xp(2:3), yp(2:3) )
                  end if
                  ! 3-4 segment
                  if( mod(j,gd_step(2))==0 ) then
                     call pgline( 2, xp(3:4), yp(3:4) )
                  end if
                  ! 4-1 segment
                  if( mod(i-1,gd_step(1))==0 ) then
                     call pgline( 2, [xp(4),xp(1)], [yp(4),yp(1)] )
                  end if
               end if
            end if

         end do

         call pgebuf()

      else ! .not. flat

         ! splitting each quadrilateral shape in two triangles

         nt = (ni-1)*(nj-1)
         nt2 = 2*nt
         allocate( x_cm(nt2), ind_x(nt2) )
         ! build the list of X position of mass center of all cells
         !
         ! the inverse formula to find (i,j) from k is:
         !   if( k > nt ) k = k - nt
         !     i = k / (nj-1) + 1
         !     j = mod( k, nj-1 )
         !     if( j == 0 ) j = nj-1; i = i-1
         !
         do i = 1, ni-1
            do j = 1, nj-1
               ! first is triangle 1-2-3
               k = (i-1)*(nj-1) + j
               ind_x(k) = k
               x_cm(k) = ( x(i,j) + x(i+1,j) + x(i+1,j+1) ) / 3.0d0
               ! second is triangle 1-3-4
               k = k + nt
               ind_x(k) = k
               x_cm(k) = ( x(i,j) + x(i+1,j+1) + x(i,j+1) ) / 3.0d0
            end do
         end do
         ! sort the x_cm list and the associated indices
         call quick_sort_3( mode=sort_mode, A=x_cm, ind=ind_x )

         call pgbbuf()

         do k = 1, nt2

            kk = ind_x(k)
            if( kk > nt ) then
               kk = kk - nt
               first_triangle = .false.
            else
               first_triangle = .true.
            end if
            i = kk/(nj-1) + 1
            j = mod( kk, nj-1 )
            if( j == 0 ) then
               j = nj-1
               i = i - 1
            end if

            if( first_triangle ) then
               x3(1) = y(i,j)
               y3(1) = z(i,j)
               x3(2) = y(i+1,j)
               y3(2) = z(i+1,j)
               x3(3) = y(i+1,j+1)
               y3(3) = z(i+1,j+1)
               if( light ) then
                  call compute_light( x, y, z, ni, nj, i,   j,   "YZ",  &
                                      scaling_xyz, color )
                  c3(1) = nint( pgmnci(pgid) + fact*color )
                  call compute_light( x, y, z, ni, nj, i+1, j,   "YZ",  &
                                      scaling_xyz, color )
                  c3(2) = nint( pgmnci(pgid) + fact*color )
                  call compute_light( x, y, z, ni, nj, i+1, j+1, "YZ",  &
                                      scaling_xyz, color )
                  c3(3) = nint( pgmnci(pgid) + fact*color )
               end if
            else ! second triangle
               x3(1) = y(i,j)
               y3(1) = z(i,j)
               x3(2) = y(i+1,j+1)
               y3(2) = z(i+1,j+1)
               x3(3) = y(i,j+1)
               y3(3) = z(i,j+1)
               if( light ) then
                  call compute_light( x, y, z, ni, nj, i,   j,   "YZ",  &
                                      scaling_xyz, color )
                  c3(1) = nint( pgmnci(pgid) + fact*color )
                  call compute_light( x, y, z, ni, nj, i+1, j+1, "YZ",  &
                                      scaling_xyz, color )
                  c3(2) = nint( pgmnci(pgid) + fact*color )
                  call compute_light( x, y, z, ni, nj, i,   j+1, "YZ",  &
                                      scaling_xyz, color )
                  c3(3) = nint( pgmnci(pgid) + fact*color )
               end if
            end if

            if( .not. light ) then
               c3(:) = nint( pgmnci(pgid) + fact*(y3(:)-win%color_axes(1)) )
            end if

            call check_color_overflow_vec( c3 )
            if( PRINTING_EPS .or. PRINTING_PDF ) then
               if( k == 1 ) then
                  type_of_patch = 1
               else  if( k == nt2 ) then
                  type_of_patch = 2
               else
                  type_of_patch = 0
               end if
               call PatchTriCore_PS_PDF_shad( x3, y3, c3, type_of_patch, &
                                              opacity=1.0d0 )
            else
               call PatchTriCore( x3, y3, c3, opacity=1.0d0 )
            end if

         end do

         if( gd ) then

            gr_pdf_color_intent = 1 ! Stroke
            call grsci(gd_col)

            call draw_quad_grid_after( y, z, ind_x, gd_step, ref_l_gd )

         end if

         call pgebuf()

      end if

   end subroutine PG2DPROJ_MATY
