! f90 include file

!_______________________________________________________________________
!
   subroutine check_color_overflow_scal( icol )

      integer :: icol
      !------ API end ------

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      ! detecting color-overflow and modify colors if required
      if( COLOR_OVERFLOW_LOW_POLICY == 0 ) then
         if( BLACK_ON_WHITE == 1 ) then
            if( icol <  win%colormap_ci_low ) then
               icol = 1 ! true black
            end if
         else
            if( icol <  win%colormap_ci_low ) then
               icol = MFPLOT_QUASI_BLACK
            end if
         end if
      else
         if( icol <  win%colormap_ci_low ) then
            icol =  win%colormap_ci_low
         end if
      end if
      if( COLOR_OVERFLOW_HIGH_POLICY == 0 ) then
         if( BLACK_ON_WHITE == 1 ) then
            if( icol > win%colormap_ci_high ) then
               icol = MFPLOT_QUASI_WHITE
            end if
         else
            if( icol > win%colormap_ci_high ) then
               icol = 1 ! true white
            end if
         end if
      else
         if( icol > win%colormap_ci_high ) then
            icol = win%colormap_ci_high
         end if
      end if

   end subroutine check_color_overflow_scal
!_______________________________________________________________________
!
   subroutine check_color_overflow_vec( icol )

      integer :: icol(:)
      !------ API end ------

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      ! detecting color-overflow and modify colors if required
      if( COLOR_OVERFLOW_LOW_POLICY == 0 ) then
         if( BLACK_ON_WHITE == 1 ) then
            where( icol < win%colormap_ci_low )
               icol = 1 ! true black
            end where
         else
            where( icol < win%colormap_ci_low )
               icol = MFPLOT_QUASI_BLACK
            end where
         end if
      else
         where( icol < win%colormap_ci_low )
            icol =  win%colormap_ci_low
         end where
      end if
      if( COLOR_OVERFLOW_HIGH_POLICY == 0 ) then
         if( BLACK_ON_WHITE == 1 ) then
            where( icol > win%colormap_ci_high )
               icol = MFPLOT_QUASI_WHITE
            end where
         else
            where( icol > win%colormap_ci_high )
               icol = 1 ! true white
            end where
         end if
      else
         where( icol > win%colormap_ci_high )
            icol = win%colormap_ci_high
         end where
      end if

   end subroutine check_color_overflow_vec
!_______________________________________________________________________
!
   subroutine compute_light( x, y, z, ni, nj, i, j, view,               &
                             scaling_xyz, color )

      integer,              intent(in) :: ni, nj, i, j
      real(kind=MF_DOUBLE), intent(in) :: x(ni,nj), y(ni,nj), z(ni,nj)
      character(len=2),     intent(in) :: view
      real(kind=MF_DOUBLE), intent(in) :: scaling_xyz(3)
      real(kind=MF_DOUBLE)             :: color

      integer :: i1, i2, j1, j2
      real(kind=MF_DOUBLE) :: ux, uy, uz, vx, vy, vz, cp_x, cp_y, cp_z, xnorm

   !------ end of declarations -- execution starts hereafter  ------

      ! When shading is not flat (i.e. shading=interp), we must compute
      ! the vector normal to the surface exactly at node (i,j).

      if( i == 1 ) then
         i1 = i + 1
         i2 = i
      else if( i == ni ) then
         i1 = i
         i2 = i - 1
      else
         i1 = i + 1
         i2 = i - 1
      end if
      ux = ( x(i1,j) - x(i2,j) )/scaling_xyz(1)
      uy = ( y(i1,j) - y(i2,j) )/scaling_xyz(2)
      uz = ( z(i1,j) - z(i2,j) )/scaling_xyz(3)

      if( j == 1 ) then
         j1 = j + 1
         j2 = j
      else if( j == nj ) then
         j1 = j
         j2 = j - 1
      else
         j1 = j + 1
         j2 = j - 1
      end if
      vx = ( x(i,j1) - x(i,j2) )/scaling_xyz(1)
      vy = ( y(i,j1) - y(i,j2) )/scaling_xyz(2)
      vz = ( z(i,j1) - z(i,j2) )/scaling_xyz(3)

      cp_x = uy*vz - uz*vy
      cp_y = uz*vx - ux*vz
      cp_z = ux*vy - uy*vx
      xnorm = sqrt( cp_x**2 + cp_y**2 + cp_z**2 )
      if( view == "XZ" ) then
         color = abs( cp_y/xnorm )
      else if( view == "YZ" ) then
         color = abs( cp_x/xnorm )
      else
         print *, "(FGL:) compute_light: internal error ***"
         print *, "       bad value for 'view' argument!"
         pause "only for debugging purpose"
         stop
      end if

   end subroutine compute_light
!_______________________________________________________________________
!
   subroutine compute_light_xy( x, y, z, ni, nj, i, j, view,            &
                               scaling_xyz, color )

      integer,              intent(in) :: ni, nj, i, j
      real(kind=MF_DOUBLE), intent(in) :: x(nj), y(ni), z(ni,nj)
      character(len=2),     intent(in) :: view
      real(kind=MF_DOUBLE), intent(in) :: scaling_xyz(3)
      real(kind=MF_DOUBLE)             :: color

      integer :: i1, i2, j1, j2
      real(kind=MF_DOUBLE) :: ux, uy, uz, vx, vy, vz, cp_x, cp_y, cp_z, xnorm

   !------ end of declarations -- execution starts hereafter  ------

      ! When shading is not flat (i.e. shading=interp), we must compute
      ! the vector normal to the surface exactly at node (i,j).

      ! for u vector: index i is fixed ---------------------
      if( j == 1 ) then
         j1 = j + 1
         j2 = j
      else if( j == nj ) then
         j1 = j
         j2 = j - 1
      else
         j1 = j + 1
         j2 = j - 1
      end if
      ux = ( x(j1) - x(j2) )/scaling_xyz(1)
      uy = 0.0d0
      uz = ( z(i,j1) - z(i,j2) )/scaling_xyz(3)

      ! for v vector: index j is fixed ---------------------
      if( i == 1 ) then
         i1 = i + 1
         i2 = i
      else if( i == ni ) then
         i1 = i
         i2 = i - 1
      else
         i1 = i + 1
         i2 = i - 1
      end if
      vx = 0.0d0
      vy = ( y(i1) - y(i2) )/scaling_xyz(2)
      vz = ( z(i1,j) - z(i2,j) )/scaling_xyz(3)

      cp_x = uy*vz - uz*vy
      cp_y = uz*vx - ux*vz
      cp_z = ux*vy - uy*vx
      xnorm = sqrt( cp_x**2 + cp_y**2 + cp_z**2 )
      if( view == "XZ" ) then
         color = abs( cp_y/xnorm )
      else if( view == "YZ" ) then
         color = abs( cp_x/xnorm )
      else
         print *, "(FGL:) compute_light_xy: internal error ***"
         print *, "       bad value for 'view' argument!"
         pause "only for debugging purpose"
         stop
      end if

   end subroutine compute_light_xy
!_______________________________________________________________________
!
   subroutine find_intersect_12_34( x1, y1, x2, y2, x3, y3, x4, y4,     &
                                    xi, yi )

      real(kind=MF_DOUBLE), intent(in)  :: x1, y1, x2, y2, x3, y3, x4, y4
      real(kind=MF_DOUBLE), intent(out) :: xi, yi

      ! * finds the intersection of segment 1-2 and 3-4 (should never fail)
      !
      !   returns the coords of the intersection in (xi,yi)

      !   (xi,yi) is on the segment 1-2:
      !
      !      xi - x1 = mu*( x2 - x1 )
      !      yi - y1 = mu*( y2 - y1 )
      !
      !   (xi,yi) is also on the segment 3-4:
      !
      !      xi - x3 = nu*( x4 - x3 )
      !      yi - y3 = nu*( y4 - y3 )
      !
      !   This leads to the system of two equations for (mu,nu):
      !
      !      x1 + mu*( x2 - x1 ) = x3 + nu*( x4 - x3 )
      !      y1 + mu*( y2 - y1 ) = y3 + nu*( y4 - y3 )
      !
      !   mu can be found first, and then (xP,yP).

      real(kind=MF_DOUBLE) :: delta, mu, nu

   !------ end of declarations -- execution starts hereafter  ------

      delta = (x2-x1)*(y4-y3) - (y2-y1)*(x4-x3)
      mu = ( (x3-x1)*(y4-y3) - (y3-y1)*(x4-x3) ) / delta

      xi = x1 + mu*( x2 - x1 )
      yi = y1 + mu*( y2 - y1 )

   end subroutine find_intersect_12_34
!_______________________________________________________________________
!
   subroutine find_intersect( x1, y1, x2, y2, x3, y3, x4, y4,           &
                              xi, yi, failed )

      real(kind=MF_DOUBLE), intent(in)  :: x1, y1, x2, y2, x3, y3, x4, y4
      real(kind=MF_DOUBLE), intent(out) :: xi, yi
      logical,              intent(out) :: failed

      ! * first try to find a valid intersection of segment 1-2 and 3-4
      !
      !   returns the coords of the intersection in (xi,yi)

      !   (xi,yi) is on the segment 1-2:
      !
      !      xi - x1 = mu*( x2 - x1 )
      !      yi - y1 = mu*( y2 - y1 )
      !
      !   (xi,yi) is also on the segment 3-4:
      !
      !      xi - x3 = nu*( x4 - x3 )
      !      yi - y3 = nu*( y4 - y3 )
      !
      !   This leads to the system of two equations for (mu,nu):
      !
      !      x1 + mu*( x2 - x1 ) = x3 + nu*( x4 - x3 )
      !      y1 + mu*( y2 - y1 ) = y3 + nu*( y4 - y3 )
      !
      !   mu can be found first, and then (xP,yP).
      !
      ! * if it fails, then finds the intersection using other segments.

      real(kind=MF_DOUBLE) :: delta, mu, nu

   !------ end of declarations -- execution starts hereafter  ------

      failed = .false.

      delta = (x2-x1)*(y4-y3) - (y2-y1)*(x4-x3)
      mu = ( (x3-x1)*(y4-y3) - (y3-y1)*(x4-x3) ) / delta
      nu = ( (x3-x1)*(y2-y1) - (y3-y1)*(x2-x1) ) / delta

      if( 0.0d0 <= mu .and. mu <= 1.0d0 .and.                           &
          0.0d0 <= nu .and. nu <= 1.0d0 ) then
         xi = x1 + mu*( x2 - x1 )
         yi = y1 + mu*( y2 - y1 )
         return
      end if

      ! first part failed. Consider now segment 2-3 and 4-1

      delta = (x3-x2)*(y1-y4) - (y3-y2)*(x1-x4)
      mu = ( (x4-x2)*(y1-y4) - (y4-y2)*(x1-x4) ) / delta
      nu = ( (x4-x2)*(y3-y2) - (y4-y2)*(x3-x2) ) / delta

      if( 0.0d0 <= mu .and. mu <= 1.0d0 .and.                           &
          0.0d0 <= nu .and. nu <= 1.0d0 ) then
         xi = x2 + mu*( x3 - x2 )
         yi = y2 + mu*( y3 - y2 )
      else
         failed = .true.
      end if

   end subroutine find_intersect
!_______________________________________________________________________
!
   subroutine draw_grid_pcolor_vec( i_max, i_step, j_max, j_step,       &
                                    axis_scale_x, axis_scale_y,         &
                                    cell_centered, x, y )

      implicit none

      integer,              intent(in) :: i_max, i_step, j_max, j_step
      integer,              intent(in) :: axis_scale_x, axis_scale_y
      logical,              intent(in) :: cell_centered
      real(kind=MF_DOUBLE), intent(in), optional :: x(:), y(:)

      integer :: i, j
      real(kind=MF_DOUBLE) :: xx1, xx2, yy1, yy2
      real(kind=MF_DOUBLE) :: xx_min, xx_max, yy_min, yy_max
      logical :: x_inverted, y_inverted, line_outside

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      ! Manual clipping is done only for printing, to lead to smaller file size
      if( PRINTING_EPS .or. PRINTING_PDF ) then
         x_left_QR  = win%current_axes(1)
         x_right_QR = win%current_axes(2)
         y_bottom_QR = win%current_axes(3)
         y_top_QR    = win%current_axes(4)
         if( win%current_axes(1) < win%current_axes(2) ) then
            x_inverted = .false.
         else
            x_inverted = .true.
         end if

         if( win%current_axes(3) < win%current_axes(4) ) then
            y_inverted = .false.
         else
            y_inverted = .true.
         end if
      end if

      ! horizontal lines
      do i = 1, i_max, i_step
         if( present(x) .and. present(y) ) then
            xx1 = x(1)
            yy1 = y(i)
            xx2 = x(j_max)
            if( axis_scale_x == 2 ) then
               xx1 = log10( xx1 )
               xx2 = log10( xx2 )
            end if
            if( axis_scale_y == 2 ) then
               yy1 = log10( yy1 )
            end if
         else
            if( cell_centered ) then
               xx1 = 0.5
               yy1 = i-0.5
               xx2 = j_max-0.5
            else
               xx1 = 1
               yy1 = i
               xx2 = j_max
            end if
         end if
         if( PRINTING_EPS .or. PRINTING_PDF ) then
            line_outside = .false.
            xx_min = min( xx1, xx2 )
            xx_max = max( xx1, xx2 )
            if( x_inverted ) then
               if( xx_max < x_right_QR .or. x_left_QR < xx_min ) then
                  line_outside = .true.
               end if
            else
               if( xx_max < x_left_QR .or. x_right_QR < xx_min ) then
                  line_outside = .true.
               end if
            end if
            if( y_inverted ) then
               if( yy1 < y_top_QR .or. y_bottom_QR < yy1 ) then
                  line_outside = .true.
               end if
            else
               if( yy1 < y_bottom_QR .or. y_top_QR < yy1 ) then
                  line_outside = .true.
               end if
            end if
            if( line_outside ) cycle
         end if
         call grmova( xx1, yy1 )
         call grlina( xx2, yy1 )
      end do

      ! vertical lines
      do j = 1, j_max, j_step
         if( present(x) .and. present(y) ) then
            xx1 = x(j)
            yy1 = y(1)
            yy2 = y(i_max)
            if( axis_scale_x == 2 ) then
               xx1 = log10( xx1 )
               yy2 = log10( yy2 )
            end if
            if( axis_scale_y == 2 ) then
               yy1 = log10( yy1 )
            end if
         else
            if( cell_centered ) then
               xx1 = j-0.5
               yy1 = 0.5
               yy2 = i_max-0.5
            else
               xx1 = j
               yy1 = 1
               yy2 = i_max
            end if
         end if
         if( PRINTING_EPS .or. PRINTING_PDF ) then
            line_outside = .false.
            yy_min = min( yy1, yy2 )
            yy_max = max( yy1, yy2 )
            if( x_inverted ) then
               if( xx1 < x_right_QR .or. x_left_QR < xx1 ) then
                  line_outside = .true.
               end if
            else
               if( xx1 < x_left_QR .or. x_right_QR < xx1 ) then
                  line_outside = .true.
               end if
            end if
            if( y_inverted ) then
               if( yy_max < y_top_QR .or. y_bottom_QR < yy_min ) then
                  line_outside = .true.
               end if
            else
               if( yy_max < y_bottom_QR .or. y_top_QR < yy_min ) then
                  line_outside = .true.
               end if
            end if
            if( line_outside ) cycle
         end if
         call grmova( xx1, yy1 )
         call grlina( xx1, yy2 )
      end do

   end subroutine draw_grid_pcolor_vec
!_______________________________________________________________________
!
   subroutine draw_grid_pcolor_mat( x, y, nx, ny, grid_step )

      implicit none

      real(kind=MF_DOUBLE), intent(in) :: x(:,:), y(:,:)
      integer,              intent(in) :: nx, ny
      integer,              intent(in) :: grid_step(2)
      real(kind=MF_DOUBLE) :: xx_min, xx_max, yy_min, yy_max
      logical :: x_inverted, y_inverted, line_outside

      type(mf_win_info), pointer :: win

      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      if( PRINTING_EPS .or. PRINTING_PDF ) then
         ! Manual clipping is done only for printing, to lead to smaller file size
         x_left_QR  = win%current_axes(1)
         x_right_QR = win%current_axes(2)
         y_bottom_QR = win%current_axes(3)
         y_top_QR    = win%current_axes(4)
         if( win%current_axes(1) < win%current_axes(2) ) then
            x_inverted = .false.
         else
            x_inverted = .true.
         end if

         if( win%current_axes(3) < win%current_axes(4) ) then
            y_inverted = .false.
         else
            y_inverted = .true.
         end if

         ! i=cst lines
         do i = 1, nx, grid_step(1)
            do j = 2, ny
               line_outside = .false.
               xx_min = min( x(i,j-1), x(i,j) )
               xx_max = max( x(i,j-1), x(i,j) )
               yy_min = min( y(i,j-1), y(i,j) )
               yy_max = max( y(i,j-1), y(i,j) )
               if( x_inverted ) then
                  if( xx_max < x_right_QR .or. x_left_QR < xx_min ) then
                     line_outside = .true.
                  end if
               else
                  if( xx_max < x_left_QR .or. x_right_QR < xx_min ) then
                     line_outside = .true.
                  end if
               end if
               if( y_inverted ) then
                  if( yy_max < y_top_QR .or. y_bottom_QR < yy_min ) then
                     line_outside = .true.
                  end if
               else
                  if( yy_max < y_bottom_QR .or. y_top_QR < yy_min ) then
                     line_outside = .true.
                  end if
               end if
               if( line_outside ) cycle
               call grmova( x(i,j-1), y(i,j-1) )
               call grlina( x(i,j), y(i,j) )
            end do
         end do

         ! j=cst lines
         do j = 1, ny, grid_step(2)
            do i = 2, nx
               line_outside = .false.
               xx_min = min( x(i-1,j), x(i,j) )
               xx_max = max( x(i-1,j), x(i,j) )
               yy_min = min( y(i-1,j), y(i,j) )
               yy_max = max( y(i-1,j), y(i,j) )
               if( x_inverted ) then
                  if( xx_max < x_right_QR .or. x_left_QR < xx_min ) then
                     line_outside = .true.
                  end if
               else
                  if( xx_max < x_left_QR .or. x_right_QR < xx_min ) then
                     line_outside = .true.
                  end if
               end if
               if( y_inverted ) then
                  if( yy_max < y_top_QR .or. y_bottom_QR < yy_min ) then
                     line_outside = .true.
                  end if
               else
                  if( yy_max < y_bottom_QR .or. y_top_QR < yy_min ) then
                     line_outside = .true.
                  end if
               end if
               if( line_outside ) cycle
               call grmova( x(i-1,j), y(i-1,j) )
               call grlina( x(i,j), y(i,j) )
            end do
         end do

      else

         ! i=cst lines
         do i = 1, nx, grid_step(1)
            call grmova( x(i,1), y(i,1) )
            do j = 2, ny
               call grlina( x(i,j), y(i,j) )
            end do
         end do

         ! j=cst lines
         do j = 1, ny, grid_step(2)
            call grmova( x(1,j), y(1,j) )
            do i = 2, nx
               call grlina( x(i,j), y(i,j) )
            end do
         end do

      end if

   end subroutine draw_grid_pcolor_mat
!_______________________________________________________________________
!
   subroutine draw_quad_grid_after( x, y, ind, gd_step, ref_length_grid )

      real(kind=MF_DOUBLE) :: x(:,:), y(:,:)
      integer              :: ind(:), gd_step(2)
      real(kind=MF_DOUBLE) :: ref_length_grid
      !------ API end ------

      ! A structured mesh of quadrilateral cells is given; the coordinates
      ! of its vertices are stored in (x,y).
      !
      ! Each quadrilateral cell is splitted in two triangles; all the
      ! triangles must be drawn in the order provided by the vector of
      ! indices ind.

      type(segment), pointer :: tmp

      integer :: ni, nj, nt, nt2, k, i, j, kk
      logical :: first_triangle, sides_class(3)
      real(kind=MF_DOUBLE) :: x_tri(3), y_tri(3), copy, value

   !------ end of declarations -- execution starts hereafter  ------

      ni = size(x,1)
      nj = size(x,2)
      nt = (ni-1)*(nj-1)
      nt2 = size(ind)

      ! Registering segments (cell boundaries and not triangle boundaries)
      ! by following the indices stored in ind.
      head => null()
      do k = 1, nt2

         kk = ind(k)
         if( kk > nt ) then
            kk = kk - nt
            first_triangle = .false.
         else
            first_triangle = .true.
         end if
         i = kk/(nj-1) + 1
         j = mod( kk, nj-1 )
         if( j == 0 ) then
            j = nj-1
            i = i - 1
         end if

         if( first_triangle ) then

            x_tri(1) = x(i,j)
            y_tri(1) = y(i,j)
            x_tri(2) = x(i+1,j)
            y_tri(2) = y(i+1,j)
            x_tri(3) = x(i+1,j+1)
            y_tri(3) = y(i+1,j+1)

            ! triangle orientation must be positive
            value = cross_product( x_tri(2)-x_tri(1), y_tri(2)-y_tri(1), &
                                   x_tri(3)-x_tri(1), y_tri(3)-y_tri(1) )
            if( value < 0.0d0 ) then
               ! swapping vertices 2 and 3
               copy = x_tri(2)
               x_tri(2) = x_tri(3)
               x_tri(3) = copy
               copy = y_tri(2)
               y_tri(2) = y_tri(3)
               y_tri(3) = copy
            end if

            ! virtually draw the white triangle above the previous segments
            ! (i.e. find which segments are masked by the triangle)
            if( value /= 0.0d0 ) then
               sides_class = [ .true., .true., .true. ]
               call process_all_segments( x_tri, y_tri,                 &
                                          sides_class, ref_length_grid )
            end if

            ! always two segments to draw for the first triangle...
            ! (but the effective drawing depends on the grid step)

            ! first segment = side #3 or #1
            if( mod(j-1,gd_step(2))==0 ) then
               allocate( tmp )
               tmp%x1 = x_tri(1)
               tmp%y1 = y_tri(1)
               if( value < 0.0d0 ) then ! side #3
                  tmp%x2 = x_tri(3)
                  tmp%y2 = y_tri(3)
               else                     ! side #1
                  tmp%x2 = x_tri(2)
                  tmp%y2 = y_tri(2)
               end if
               tmp%next => head
               head => tmp
            end if

            ! second segment = side #2
            if( mod(i,gd_step(1))==0 ) then
               allocate( tmp )
               tmp%x1 = x_tri(2)
               tmp%y1 = y_tri(2)
               tmp%x2 = x_tri(3)
               tmp%y2 = y_tri(3)
               tmp%next => head
               head => tmp
            end if

         else ! second triangle

            x_tri(1) = x(i,j)
            y_tri(1) = y(i,j)
            x_tri(2) = x(i+1,j+1)
            y_tri(2) = y(i+1,j+1)
            x_tri(3) = x(i,j+1)
            y_tri(3) = y(i,j+1)

            ! triangle orientation must be positive
            value = cross_product( x_tri(2)-x_tri(1), y_tri(2)-y_tri(1), &
                                   x_tri(3)-x_tri(1), y_tri(3)-y_tri(1) )
            if( value < 0.0d0 ) then
               ! swapping vertices 2 and 3
               copy = x_tri(2)
               x_tri(2) = x_tri(3)
               x_tri(3) = copy
               copy = y_tri(2)
               y_tri(2) = y_tri(3)
               y_tri(3) = copy
            end if

            ! virtually draw the white triangle above the previous segments
            ! (i.e. find which segments are masked by the triangle)
            if( value /= 0.0d0 ) then
               sides_class = [ .false., .false., .false. ]
               if( j+1 == nj ) sides_class(2) = .true.
               if( i == 1 ) then
                  if( value < 0.0d0 ) then
                     sides_class(1) = .true.
                  else
                     sides_class(3) = .true.
                  end if
               end if
               call process_all_segments( x_tri, y_tri,                 &
                                          sides_class, ref_length_grid )
            end if

            ! the number of segments to draw depends of (i,j)

            ! first segment = side #2
            if( mod(j,gd_step(2))==0 ) then
               if( j+1 == nj ) then
                  allocate( tmp )
                  tmp%x1 = x_tri(2)
                  tmp%y1 = y_tri(2)
                  tmp%x2 = x_tri(3)
                  tmp%y2 = y_tri(3)
                  tmp%next => head
                  head => tmp
               end if
            end if

            ! second segment = side #1 or #3
            if( mod(i-1,gd_step(1))==0 ) then
               if( i == 1 ) then
                  allocate( tmp )
                  if( value < 0.0d0 ) then ! side #1
                     tmp%x1 = x_tri(2)
                     tmp%y1 = y_tri(2)
                  else                     ! side #3
                     tmp%x1 = x_tri(3)
                     tmp%y1 = y_tri(3)
                  end if
                  tmp%x2 = x_tri(1)
                  tmp%y2 = y_tri(1)
                  tmp%next => head
                  head => tmp
               end if
            end if

         end if

      end do

      ! now the remaining segments can be drawn
      tmp => head
      do
         if( .not. associated(tmp) ) exit
         call pgline( 2, [ tmp%x1, tmp%x2 ], [ tmp%y1, tmp%y2 ] )
         tmp => tmp%next
      end do

   end subroutine draw_quad_grid_after
!_______________________________________________________________________
!
   subroutine process_all_segments( x_tri, y_tri,                       &
                                    sides_class, ref_length_grid )

      real(kind=MF_DOUBLE) :: x_tri(3), y_tri(3)
      logical, intent(in) :: sides_class(3)
      real(kind=MF_DOUBLE) :: ref_length_grid

      type(segment), pointer :: prev, tmp, tmp2
      integer :: status_1, status_2, status_adv_1, status_adv_2
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max,               &
                              x1, y1, x2, y2
      real(kind=MF_DOUBLE) :: value, cp_1A_12, cp_1B_12, cp_1C_12
      integer :: cp_sides_1(3), cp_sides_2(3)

   !------ end of declarations -- execution starts hereafter  ------

      ! BBox of the triangle
      x_min = minval(x_tri)
      x_max = maxval(x_tri)
      y_min = minval(y_tri)
      y_max = maxval(y_tri)

      ! Traversal of the list to find all segments which has some connection
      ! with the triangle
      prev => null()
      tmp => head
      do

         if( .not. associated(tmp) ) exit

         ! first, remove too short segments
         if( abs(tmp%x1-tmp%x2) < 1.0d-5*ref_length_grid .and.          &
             abs(tmp%y1-tmp%y2) < 1.0d-5*ref_length_grid ) then
            call remove_segment ( prev, tmp )
            cycle
         end if

         ! a quick check about the BBoxes can accelerate the algorithm
         if( min(tmp%x1,tmp%x2) >= x_max ) go to 99
         if( max(tmp%x1,tmp%x2) <= x_min ) go to 99
         if( min(tmp%y1,tmp%y2) >= y_max ) go to 99
         if( max(tmp%y1,tmp%y2) <= y_min ) go to 99

         ! relative position of each segment end-points with respect to
         ! the three triangle sides

         ! first endpoint
         call pos_wrt_triangle( x_tri, y_tri, tmp%x1, tmp%y1, cp_sides_1 )

         ! second endpoint
         call pos_wrt_triangle( x_tri, y_tri, tmp%x2, tmp%y2, cp_sides_2 )

         ! status is the large region of the point with respect to each side
         ! (only four posibilities: 0, 1, 2 or 3)
         status_1 = get_status( cp_sides_1, sides_class )

         status_2 = get_status( cp_sides_2, sides_class )

         if( (status_1 == 0 .and. status_2 == 0) ) then
            ! the segment is completely inside the triangle
            call remove_segment ( prev, tmp )
            cycle
         end if

         if( status_1 == status_2 ) then
            ! nothing to do: the segment is outside the triangle
            go to 99
         end if

         if( status_1 == 0 ) then
            ! only endpoint #1 is modified
            if( status_2 == 1 ) then
               ! check cross product (1-A,1-2)
               if( cross_product( x_tri(1)-tmp%x1, tmp%x2-tmp%x1,       &
                                  y_tri(1)-tmp%y1, tmp%y2-tmp%y1 ) < 0.0d0 ) then
                  ! consider intersection with side 3
                  call find_intersect_seg_seg( tmp%x1, tmp%y1,          &
                                               tmp%x2, tmp%y2,          &
                                               x_tri(3), y_tri(3),      &
                                               x_tri(1), y_tri(1),      &
                                               x1, y1 )
               else
                  ! check cross product (1-B,1-2)
                  if( cross_product( x_tri(2)-tmp%x1, tmp%x2-tmp%x1,    &
                                     y_tri(2)-tmp%y1, tmp%y2-tmp%y1 ) > 0.0d0 ) then
                     ! consider intersection with side 2
                     call find_intersect_seg_seg( tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x_tri(2), y_tri(2),   &
                                                  x_tri(3), y_tri(3),   &
                                                  x1, y1 )
                  else
                     ! consider intersection with side 1
                     call find_intersect_seg_seg( tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x_tri(1), y_tri(1),   &
                                                  x_tri(2), y_tri(2),   &
                                                  x1, y1 )
                  end if
               end if
            else if( status_2 == 2 ) then
               ! check cross product (1-C,1-2)
               if( cross_product( x_tri(3)-tmp%x1, tmp%x2-tmp%x1,       &
                                  y_tri(3)-tmp%y1, tmp%y2-tmp%y1 ) > 0.0d0 ) then
                  ! consider intersection with side 3
                  call find_intersect_seg_seg( tmp%x1, tmp%y1,          &
                                               tmp%x2, tmp%y2,          &
                                               x_tri(3), y_tri(3),      &
                                               x_tri(1), y_tri(1),      &
                                               x1, y1 )
               else
                  ! consider intersection with side 2
                  call find_intersect_seg_seg( tmp%x1, tmp%y1,          &
                                               tmp%x2, tmp%y2,          &
                                               x_tri(2), y_tri(2),      &
                                               x_tri(3), y_tri(3),      &
                                               x1, y1 )
               end if
            else ! status_2 = 3
               ! consider intersection with side 3
               call find_intersect_seg_seg( tmp%x1, tmp%y1,             &
                                            tmp%x2, tmp%y2,             &
                                            x_tri(3), y_tri(3),         &
                                            x_tri(1), y_tri(1),         &
                                            x1, y1 )
            end if
            if( tmp%x2 == x1 .and. tmp%y2 == y1 ) then
               call remove_segment ( prev, tmp )
               cycle
            end if
            tmp%x1 = x1
            tmp%y1 = y1
            go to 99
         end if

         if( status_2 == 0 ) then
            ! only endpoint #2 is modified
            if( status_1 == 1 ) then
               ! check cross product (2-A,2-1)
               if( cross_product( x_tri(1)-tmp%x2, tmp%x1-tmp%x2,       &
                                  y_tri(1)-tmp%y2, tmp%y1-tmp%y2 ) < 0.0d0 ) then
                  ! consider intersection with side 3
                  call find_intersect_seg_seg( tmp%x1, tmp%y1,          &
                                               tmp%x2, tmp%y2,          &
                                               x_tri(3), y_tri(3),      &
                                               x_tri(1), y_tri(1),      &
                                               x2, y2 )
               else
                  ! check cross product (2-B,2-1)
                  if( cross_product( x_tri(2)-tmp%x2, tmp%x1-tmp%x2,    &
                                     y_tri(2)-tmp%y2, tmp%y1-tmp%y2 ) > 0.0d0 ) then
                     ! consider intersection with side 2
                     call find_intersect_seg_seg( tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x_tri(2), y_tri(2),   &
                                                  x_tri(3), y_tri(3),   &
                                                  x2, y2 )
                  else
                     ! consider intersection with side 1
                     call find_intersect_seg_seg( tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x_tri(1), y_tri(1),   &
                                                  x_tri(2), y_tri(2),   &
                                                  x2, y2 )
                  end if
               end if
            else if( status_1 == 2 ) then
               ! check cross product (2-C,2-1)
               if( cross_product( x_tri(3)-tmp%x2, tmp%x1-tmp%x2,       &
                                  y_tri(3)-tmp%y2, tmp%y1-tmp%y2 ) > 0.0d0 ) then
                  ! consider intersection with side 3
                  call find_intersect_seg_seg( tmp%x1, tmp%y1,          &
                                               tmp%x2, tmp%y2,          &
                                               x_tri(3), y_tri(3),      &
                                               x_tri(1), y_tri(1),      &
                                               x2, y2 )
               else
                  ! consider intersection with side 2
                  call find_intersect_seg_seg( tmp%x1, tmp%y1,          &
                                               tmp%x2, tmp%y2,          &
                                               x_tri(2), y_tri(2),      &
                                               x_tri(3), y_tri(3),      &
                                               x2, y2 )
               end if
            else ! status_1 = 3
               ! consider intersection with side 3
               call find_intersect_seg_seg( tmp%x1, tmp%y1,             &
                                            tmp%x2, tmp%y2,             &
                                            x_tri(3), y_tri(3),         &
                                            x_tri(1), y_tri(1),         &
                                            x2, y2 )
            end if
            if( tmp%x1 == x2 .and. tmp%y1 == y2 ) then
               call remove_segment ( prev, tmp )
               cycle
            end if
            tmp%x2 = x2
            tmp%y2 = y2
            go to 99
         end if

         ! status_adv is the small region of the point with respect to each side
         ! (only six posibilities: 1 to 6)
         status_adv_1 = get_status_adv( status_1, cp_sides_1, sides_class )

         status_adv_2 = get_status_adv( status_2, cp_sides_2, sides_class )

         ! pre-compute also some cross-products
         cp_1A_12 = cross_product( x_tri(1)-tmp%x1, tmp%x2-tmp%x1,      &
                                   y_tri(1)-tmp%y1, tmp%y2-tmp%y1 )
         cp_1B_12 = cross_product( x_tri(2)-tmp%x1, tmp%x2-tmp%x1,      &
                                   y_tri(2)-tmp%y1, tmp%y2-tmp%y1 )
         cp_1C_12 = cross_product( x_tri(3)-tmp%x1, tmp%x2-tmp%x1,      &
                                   y_tri(3)-tmp%y1, tmp%y2-tmp%y1 )

         ! the most difficult case: not sure that an intersection exist...
         ! the segment may be splitted in two, or ignored.
         if( status_1*status_2 == 2 ) then
            !    status_1 = 1 and status_2 = 2
            ! or status_1 = 2 and status_2 = 1

            if( status_1 == 1 ) then ! status_2 = 2

               if( status_adv_1 == 4 ) then
                  go to 99
               end if

               if( status_adv_2 == 4 ) then
                  go to 99
               end if

               if( status_adv_1 == 6 ) then

                  if( status_adv_2 == 2 ) then
                     if( cp_1C_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1B_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1A_12 > 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 3, 2, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 1, 2, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  else ! status_adv_2 = 5
                     go to 99
                  end if

               else ! status_adv_1 = 1

                  if( status_adv_2 == 2 ) then
                     if( cp_1B_12 < 0.0d0 ) then
                        go to 99
                     end if
                     call find_intersect_tri_seg( x_tri, y_tri, 1, 2,   &
                                                  tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x1, y1, x2, y2 )
                  else ! status_adv_2 = 5
                     if( cp_1A_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1B_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1C_12 > 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 1, 3, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 1, 2, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  end if

               end if

            else ! status_1 = 2 and status_2 = 1

               if( status_adv_1 == 4 ) then
                  go to 99
               end if

               if( status_adv_2 == 4 ) then
                  go to 99
               end if

               if( status_adv_2 == 6 ) then

                  if( status_adv_1 == 2 ) then
                     if( cp_1C_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1B_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1A_12 < 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 2, 3, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 2, 1, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  else ! status_adv_1 = 5
                     go to 99
                  end if

               else ! status_adv_2 = 1

                  if( status_adv_1 == 2 ) then
                     if( cp_1B_12 > 0.0d0 ) then
                        go to 99
                     end if
                     call find_intersect_tri_seg( x_tri, y_tri, 2, 1,   &
                                                  tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x1, y1, x2, y2 )
                  else ! status_adv_1 = 5
                     if( cp_1A_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1B_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1C_12 < 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 3, 1, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 2, 1, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  end if

               end if

            end if

         else if( status_1*status_2 == 6 ) then
            !    status_1 = 2 and status_2 = 3
            ! or status_1 = 3 and status_2 = 2

            if( status_1 == 2 ) then ! status_2 = 3

               if( status_adv_1 == 5 ) then
                  go to 99
               end if

               if( status_adv_2 == 5 ) then
                  go to 99
               end if

               if( status_adv_1 == 4 ) then

                  if( status_adv_2 == 3 ) then
                     if( cp_1A_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1C_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1B_12 > 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 1, 3, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 2, 3, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  else ! status_adv_2 = 6
                     go to 99
                  end if

               else ! status_adv_1 = 2

                  if( status_adv_2 == 3 ) then
                     if( cp_1C_12 < 0.0d0 ) then
                        go to 99
                     end if
                     call find_intersect_tri_seg( x_tri, y_tri, 2, 3,   &
                                                  tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x1, y1, x2, y2 )
                  else ! status_adv_2 = 6
                     if( cp_1B_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1C_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1A_12 > 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 2, 1, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 2, 3, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  end if

               end if

            else ! status_1 = 3 and status_2 = 2

               if( status_adv_1 == 5 ) then
                  go to 99
               end if

               if( status_adv_2 == 5 ) then
                  go to 99
               end if

               if( status_adv_2 == 4 ) then

                  if( status_adv_1 == 3 ) then
                     if( cp_1A_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1C_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1B_12 < 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 3, 1, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 3, 2, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  else ! status_adv_1 = 6
                     go to 99
                  end if

               else ! status_adv_2 = 2

                  if( status_adv_1 == 3 ) then
                     if( cp_1C_12 > 0.0d0 ) then
                        go to 99
                     end if
                     call find_intersect_tri_seg( x_tri, y_tri, 3, 2,   &
                                                  tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x1, y1, x2, y2 )
                  else ! status_adv_1 = 6
                     if( cp_1B_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1C_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1A_12 < 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 1, 2, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 3, 2, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  end if

               end if

            end if

         else if( status_1*status_2 == 3 ) then
            !    status_1 = 3 and status_2 = 1
            ! or status_1 = 1 and status_2 = 3

            if( status_1 == 3 ) then ! status_2 = 1

               if( status_adv_1 == 6 ) then
                  go to 99
               end if

               if( status_adv_2 == 6 ) then
                  go to 99
               end if

               if( status_adv_1 == 5 ) then

                  if( status_adv_2 == 1 ) then
                     if( cp_1B_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1A_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1C_12 > 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 2, 1, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 3, 1, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  else ! status_adv_2 = 4
                     go to 99
                  end if

               else ! status_adv_1 = 3

                  if( status_adv_2 == 1 ) then
                     if( cp_1A_12 < 0.0d0 ) then
                        go to 99
                     end if
                     call find_intersect_tri_seg( x_tri, y_tri, 3, 1,   &
                                                  tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x1, y1, x2, y2 )
                  else ! status_adv_2 = 4
                     if( cp_1C_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1A_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1B_12 > 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 3, 2, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 3, 1, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  end if

               end if

            else ! status_1 = 1 and status_2 = 3

               if( status_adv_1 == 6 ) then
                  go to 99
               end if

               if( status_adv_2 == 6 ) then
                  go to 99
               end if

               if( status_adv_2 == 5 ) then

                  if( status_adv_1 == 1 ) then
                     if( cp_1B_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1A_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1C_12 < 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 1, 2, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 1, 3, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  else ! status_adv_1 = 4
                     go to 99
                  end if

               else ! status_adv_2 = 3

                  if( status_adv_1 == 1 ) then
                     if( cp_1A_12 > 0.0d0 ) then
                        go to 99
                     end if
                     call find_intersect_tri_seg( x_tri, y_tri, 1, 3,   &
                                                  tmp%x1, tmp%y1,       &
                                                  tmp%x2, tmp%y2,       &
                                                  x1, y1, x2, y2 )
                  else ! status_adv_1 = 4
                     if( cp_1C_12 < 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1A_12 > 0.0d0 ) then
                        go to 99
                     end if
                     if( cp_1B_12 < 0.0d0 ) then
                        call find_intersect_tri_seg( x_tri, y_tri, 2, 3, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     else
                        call find_intersect_tri_seg( x_tri, y_tri, 1, 3, &
                                                     tmp%x1, tmp%y1,    &
                                                     tmp%x2, tmp%y2,    &
                                                     x1, y1, x2, y2 )
                     end if
                  end if

               end if

            end if

         end if

         if( tmp%x2 /= x2 .or. tmp%y2 /= y2 ) then
            ! create a new segment
            allocate( tmp2 )
            tmp2%x1 = x2
            tmp2%y1 = y2
            tmp2%x2 = tmp%x2
            tmp2%y2 = tmp%y2
            ! insert it in the linked list
            tmp2%next => head
            head => tmp2
         end if

         if( tmp%x1 == x1 .and. tmp%y1 == y1 ) then
            call remove_segment ( prev, tmp )
            cycle
         end if
         tmp%x2 = x1
         tmp%y2 = y1

 99      continue
         prev => tmp
         tmp => tmp%next
      end do

   end subroutine process_all_segments
!_______________________________________________________________________
!
   subroutine remove_segment( prev, tmp )

      type(segment), pointer :: prev, tmp

      ! After removing, tmp becomes the next node; if tmp is not
      ! associated, this means that the end of the list has been reached.
      !
      ! Take care that prev association is undefined.

      type(segment), pointer :: tmp2

   !------ end of declarations -- execution starts hereafter  ------

      tmp2 => tmp ! node to be removed

      if( .not. associated(prev) ) then
         ! node is the head
         if( associated(tmp%next) ) then
            ! node is not alone in the list
            head => tmp2%next
            tmp => head
         else
            ! node is alone in the list
            head => null()
            tmp => null()
         end if
      else if( .not. associated(tmp%next) ) then
         ! node is the last one in the list
         tmp => null()
         prev%next => null()
      else
         ! general case
         tmp => tmp2%next
         prev%next => tmp
      end if

      deallocate( tmp2 )

   end subroutine remove_segment
!_______________________________________________________________________
!
   subroutine pos_wrt_triangle( x_tri, y_tri, x, y, cp_sides )

      ! Returns the three cross-product signs to determine if a point M
      ! is on the left or on the right with respect to the sides of the
      ! triangle. So, the vector cp_sides contains integer values which
      ! are only -1, 0, or +1.
      !
      !                     C +
      !                       |\
      !                       | \
      !                       |  \
      !           + M         |   \
      !                       |    \
      !                       |     \
      !                       |      \ B
      !                       +-------+
      !                      A

      ! Requires that the numbering of the nodes for each triangle is
      ! oriented (direct orientation).
      !
      ! If the nodes describing the triangle are n1, n2, n3, then the
      ! faces must be n1-n2, n2-n3, n3-n1 (in this order).

      real(kind=MF_DOUBLE), intent(in)  :: x_tri(3), y_tri(3)
      real(kind=MF_DOUBLE), intent(in)  :: x, y
      integer,              intent(out) :: cp_sides(3)

      real(kind=MF_DOUBLE) :: value

   !------ end of declarations -- execution starts hereafter  ------

      ! (A-B,A-M)
      value = cross_product( x_tri(2)-x_tri(1), y_tri(2)-y_tri(1),      &
                             x-x_tri(1),        y-y_tri(1) )
      if( value == 0.0d0 ) then
         cp_sides(1) = 0
      else
         cp_sides(1) = sign(1.0d0,value)
      end if

      ! (B-C,B-M)
      value = cross_product( x_tri(3)-x_tri(2), y_tri(3)-y_tri(2),      &
                             x-x_tri(2),        y-y_tri(2) )
      if( value == 0.0d0 ) then
         cp_sides(2) = 0
      else
         cp_sides(2) = sign(1.0d0,value)
      end if

      ! (C-A,C-M)
      value = cross_product( x_tri(1)-x_tri(3), y_tri(1)-y_tri(3),      &
                             x-x_tri(3),        y-y_tri(3) )
      if( value == 0.0d0 ) then
         cp_sides(3) = 0
      else
         cp_sides(3) = sign(1.0d0,value)
      end if

   end subroutine pos_wrt_triangle
!_______________________________________________________________________
!
   function get_status( cp_sides, sides_class ) result( status )

      integer, intent(in) :: cp_sides(3)
      logical, intent(in) :: sides_class(3)
      integer             :: status

   !------ end of declarations -- execution starts hereafter  ------

      if( sides_class(1) ) then
         if( cp_sides(1) < 0 ) then
            status = 1
            return
         end if
      else
         if( cp_sides(1) <= 0 ) then
            status = 1
            return
         end if
      end if

      if( sides_class(2) ) then
         if( cp_sides(2) < 0 ) then
            status = 2
            return
         end if
      else
         if( cp_sides(2) <= 0 ) then
            status = 2
            return
         end if
      end if

      if( sides_class(3) ) then
         if( cp_sides(3) < 0 ) then
            status = 3
            return
         end if
      else
         if( cp_sides(3) <= 0 ) then
            status = 3
            return
         end if
      end if

      status = 0

   end function get_status
!_______________________________________________________________________
!
   function get_status_adv( status, cp_sides, sides_class ) result( status_adv )

      integer, intent(in) :: status
      integer, intent(in) :: cp_sides(3)
      logical, intent(in) :: sides_class(3)
      integer             :: status_adv

   !------ end of declarations -- execution starts hereafter  ------

      if( status == 1 ) then

         if( cp_sides(2) <= 0 ) then
            status_adv = 4
         else if( cp_sides(3) <= 0 ) then
            status_adv = 6
         else
            status_adv = 1
         end if

      else if( status == 2 ) then

         if( cp_sides(3) <= 0 ) then
            status_adv = 5
         else if( cp_sides(1) <= 0 ) then
            status_adv = 4
         else
            status_adv = 2
         end if

      else if( status == 3 ) then

         if( cp_sides(1) <= 0 ) then
            status_adv = 6
         else if( cp_sides(2) <= 0 ) then
            status_adv = 5
         else
            status_adv = 3
         end if

      else

         stop "ERROR in get_status_adv: bad value for status!"

      end if

   end function get_status_adv
!_______________________________________________________________________
!
   function cross_product( ux, uy, vx, vy ) result( res )

      real(kind=MF_DOUBLE), intent(in) :: ux, uy, vx, vy
      real(kind=MF_DOUBLE)             :: res

      ! Note: the same result is returned if cross_product( ux, vx, uy, vy )
      !       is computed.

   !------ end of declarations -- execution starts hereafter  ------

      res = ux*vy - uy*vx

   end function cross_product
!_______________________________________________________________________
!
   subroutine find_intersect_seg_seg( x1, y1, x2, y2, x3, y3, x4, y4,   &
                                      xi, yi )

      real(kind=MF_DOUBLE), intent(in) :: x1, y1, x2, y2, x3, y3, x4, y4
      real(kind=MF_DOUBLE)             :: xi, yi

      ! * finds the intersection of segment 1-2 and 3-4 (should never fail)
      !
      !   returns the coords of the intersection in (xi,yi)

      !   (xi,yi) is on the segment 1-2:
      !
      !      xi - x1 = mu*( x2 - x1 )
      !      yi - y1 = mu*( y2 - y1 )
      !
      !   (xi,yi) is also on the segment 3-4:
      !
      !      xi - x3 = nu*( x4 - x3 )
      !      yi - y3 = nu*( y4 - y3 )
      !
      !   This leads to the system of two equations for (mu,nu):
      !
      !      x1 + mu*( x2 - x1 ) = x3 + nu*( x4 - x3 )
      !      y1 + mu*( y2 - y1 ) = y3 + nu*( y4 - y3 )
      !
      !   mu can be found first, and then (xP,yP).

      real(kind=MF_DOUBLE) :: delta, mu, nu

   !------ end of declarations -- execution starts hereafter  ------

      delta = (x2-x1)*(y4-y3) - (y2-y1)*(x4-x3)
      mu = ( (x3-x1)*(y4-y3) - (y3-y1)*(x4-x3) ) / delta

      xi = x1 + mu*( x2 - x1 )
      yi = y1 + mu*( y2 - y1 )

   end subroutine find_intersect_seg_seg
!_______________________________________________________________________
!
   subroutine find_intersect_tri_seg( x_tri, y_tri, side_1, side_2,     &
                                      seg_x1, seg_y1, seg_x2, seg_y2,   &
                                      x1, y1, x2, y2 )

      real(kind=MF_DOUBLE), intent(in) :: x_tri(3), y_tri(3)
      integer,              intent(in) :: side_1, side_2
      real(kind=MF_DOUBLE), intent(in) :: seg_x1, seg_y1, seg_x2, seg_y2
      real(kind=MF_DOUBLE)             :: x1, y1, x2, y2

      ! Given a triangle (x_tri, y_tri), and a segment known by its two
      ! endpoints (seg_x1, seg_y1) and (seg_x2, seg_y2) which are outside
      ! the triangle, find the intersection (x1,y1) of this segment with
      ! the side side_1 of the triangle, and the intersection (x2,y2) with
      ! the other side side_2. It should never fail.

      integer :: i, j

   !------ end of declarations -- execution starts hereafter  ------

      ! first intersection
      i = side_1
      j = side_1 + 1
      if( j == 4 ) j = 1
      call find_intersect_seg_seg( x_tri(i), y_tri(i), x_tri(j), y_tri(j), &
                                   seg_x1, seg_y1, seg_x2, seg_y2,      &
                                   x1, y1 )

      ! second intersection
      i = side_2
      j = side_2 + 1
      if( j == 4 ) j = 1
      call find_intersect_seg_seg( x_tri(i), y_tri(i), x_tri(j), y_tri(j), &
                                   seg_x1, seg_y1, seg_x2, seg_y2,      &
                                   x2, y2 )

   end subroutine find_intersect_tri_seg

