module mod_plot2d

   ! Part of MUESLI Graphic Library
   ! Copyright É. Canot 2004-2025 -- IPR/CNRS

   use mod_mfarray, only: PrintMessage ! private when using FML

   use mod_grobj

#ifdef _SPREAD_MOD
!!   use mod_axes

!!   use mod_window

!!   use mod_win_db

!!   use fml ! MUESLI Numerical Library
#endif

#if defined _INTEL_IFC
   use iflport, only: system, getpid ! (read_any, write_any)
#endif

   implicit none

#ifndef _DEVLP
   private
#endif

   private :: PrintMessage

!-----------------------------------------------------------------------
!                               public
!-----------------------------------------------------------------------

   public :: mfArrow, msArrow, &
             mfContour, msContour, &
             mfContourF, msContourF, &
             msCumulHist, &
             mfImage, msImage, &
             msImRead, msImWrite, &
             mfPatch, msPatch, &
             mfPcolor, msPcolor, &
             mfQuiver, msQuiver, &
             mfPlot, msPlot, &
             mfPlotCubicBezier, msPlotCubicBezier, &
             mfPlotCubicSpline, msPlotCubicSpline, &
             mfPlotHist, msPlotHist, &
             mfPlotQuadrBezier, msPlotQuadrBezier, &
             mfPlotVoronoi, msPlotVoronoi, &
             msShading, &
             mfSpy, msSpy, &
             mfText, msText, &
             mfTriContour, msTriContour, &
             mfTriContourF, msTriContourF, &
             mfTriFill, msTriFill, &
             mfTriMesh, msTriMesh, &
             mfTriPcolor, msTriPcolor, &
             mfTriQuiver, msTriQuiver, &
             mfStreamline, msStreamline, &
             mfTriStreamline, msTriStreamline, &
             mfPlotPLdomain, msPlotPLdomain

   public :: mfBar, msBar, &
             mfErrorBar, msErrorBar

!-----------------------------------------------------------------------
!                             interfaces
!-----------------------------------------------------------------------

   interface mfArrow
      module procedure mfArrow_pos_real_str
      module procedure mfArrow_pos_real_rgb
      module procedure mfArrow_Head_pos_real_str
      module procedure mfArrow_Head_pos_real_rgb
!!      module procedure mfArrow_pos_mf      to display many arrows
   end interface
   !------ API end ------

   interface msArrow
      module procedure msArrow_pos_real_str
      module procedure msArrow_pos_real_rgb
      module procedure msArrow_Head_pos_real_str
      module procedure msArrow_Head_pos_real_rgb
!!      module procedure msArrow_pos_mf      to display many arrows
   end interface
   !------ API end ------

   interface mfQuiver
      module procedure mfQuiver_uv
      module procedure mfQuiver_xyuv
   end interface
   !------ API end ------

   interface msQuiver
      module procedure msQuiver_uv
      module procedure msQuiver_xyuv
   end interface
   !------ API end ------

   interface mfContour
      module procedure mfContour_z
      module procedure mfContour_xyz
      module procedure mfContour_xyz_out
   end interface
   !------ API end ------

   interface msContour
      module procedure msContour_z
      module procedure msContour_xyz
      module procedure msContour_xyz_out
   end interface
   !------ API end ------

   interface mfContourF
      module procedure mfContourF_z
      module procedure mfContourF_xyz
      module procedure mfContourF_xyz_out
   end interface
   !------ API end ------

   interface msContourF
      module procedure msContourF_z
      module procedure msContourF_xyz
      module procedure msContourF_xyz_out
   end interface
   !------ API end ------

   interface mfPatch
      module procedure mfPatch_basic_1_str_2_str
      module procedure mfPatch_basic_1_str_2_rgb
      module procedure mfPatch_basic_1_rgb_2_str
      module procedure mfPatch_basic_1_rgb_2_rgb
      module procedure mfPatch_grad_str
      module procedure mfPatch_grad_rgb
   end interface
   !------ API end ------

   interface msPatch
      module procedure msPatch_basic_1_str_2_str
      module procedure msPatch_basic_1_str_2_rgb
      module procedure msPatch_basic_1_rgb_2_str
      module procedure msPatch_basic_1_rgb_2_rgb
      module procedure msPatch_grad_str
      module procedure msPatch_grad_rgb
   end interface
   !------ API end ------

   interface mfPcolor
      module procedure mfPcolor_z_str
      module procedure mfPcolor_z_rgb
      module procedure mfPcolor_xyz_str
      module procedure mfPcolor_xyz_rgb
   end interface
   !------ API end ------

   interface msPcolor
      module procedure msPcolor_z_str
      module procedure msPcolor_z_rgb
      module procedure msPcolor_xyz_str
      module procedure msPcolor_xyz_rgb
   end interface
   !------ API end ------

   interface mfPlot
      module procedure mfPlot_color_str
      module procedure mfPlot_color_rgb
   end interface
   !------ API end ------

   interface msPlot
      module procedure msPlot_color_str
      module procedure msPlot_color_rgb
   end interface
   !------ API end ------

   interface mfErrorBar
      module procedure mfErrorBar_color_str
      module procedure mfErrorBar_color_rgb
   end interface
   !------ API end ------

   interface msErrorBar
      module procedure msErrorBar_color_str
      module procedure msErrorBar_color_rgb
   end interface
   !------ API end ------

   interface mfPlotQuadrBezier
      module procedure mfPlotQuadrBezier_color_str
      module procedure mfPlotQuadrBezier_color_rgb
   end interface
   !------ API end ------

   interface msPlotQuadrBezier
      module procedure msPlotQuadrBezier_color_str
      module procedure msPlotQuadrBezier_color_rgb
   end interface
   !------ API end ------

   interface mfPlotCubicBezier
      module procedure mfPlotCubicBezier_color_str
      module procedure mfPlotCubicBezier_color_rgb
   end interface
   !------ API end ------

   interface msPlotCubicBezier
      module procedure msPlotCubicBezier_color_str
      module procedure msPlotCubicBezier_color_rgb
   end interface
   !------ API end ------

   interface mfPlotCubicSpline
      module procedure mfPlotCubicSpline_color_str
      module procedure mfPlotCubicSpline_color_rgb
   end interface
   !------ API end ------

   interface msPlotCubicSpline
      module procedure msPlotCubicSpline_color_str
      module procedure msPlotCubicSpline_color_rgb
   end interface
   !------ API end ------

   interface mfPlotHist
      module procedure mfPlotHist_color_str
      module procedure mfPlotHist_color_rgb
   end interface
   !------ API end ------

   interface msPlotHist
      module procedure msPlotHist_color_str
      module procedure msPlotHist_color_rgb
   end interface
   !------ API end ------

   interface mfPlotPLdomain
      module procedure mfPlotPLdomain_color_str
      module procedure mfPlotPLdomain_color_rgb
   end interface
   !------ API end ------

   interface msPlotPLdomain
      module procedure msPlotPLdomain_color_str
      module procedure msPlotPLdomain_color_rgb
   end interface
   !------ API end ------

   interface mfPlotVoronoi
      module procedure msPlotVoronoi_color_str
      module procedure msPlotVoronoi_color_rgb
   end interface
   !------ API end ------

   interface msPlotVoronoi
      module procedure msPlotVoronoi_color_str
      module procedure msPlotVoronoi_color_rgb
   end interface
   !------ API end ------

   interface mfBar
      module procedure mfBar_color_str_1
      module procedure mfBar_color_rgb_1
      module procedure mfBar_color_str_2
      module procedure mfBar_color_rgb_2
   end interface
   !------ API end ------

   interface msBar
      module procedure msBar_color_str_1
      module procedure msBar_color_rgb_1
      module procedure msBar_color_str_2
      module procedure msBar_color_rgb_2
   end interface
   !------ API end ------

   interface mfText
      module procedure mfText_pos_real_1_str_2_str
      module procedure mfText_pos_real_1_str_2_rgb
      module procedure mfText_pos_real_1_rgb_2_str
      module procedure mfText_pos_real_1_rgb_2_rgb
      module procedure mfText_pos_mf_1_str_2_str
      module procedure mfText_pos_mf_1_str_2_rgb
      module procedure mfText_pos_mf_1_rgb_2_str
      module procedure mfText_pos_mf_1_rgb_2_rgb
   end interface
   !------ API end ------

   interface msText
      module procedure msText_pos_real_1_str_2_str
      module procedure msText_pos_real_1_str_2_rgb
      module procedure msText_pos_real_1_rgb_2_str
      module procedure msText_pos_real_1_rgb_2_rgb
      module procedure msText_pos_mf_1_str_2_str
      module procedure msText_pos_mf_1_str_2_rgb
      module procedure msText_pos_mf_1_rgb_2_str
      module procedure msText_pos_mf_1_rgb_2_rgb
   end interface
   !------ API end ------

   interface mfStreamline
      module procedure mfStreamline_uv_str
      module procedure mfStreamline_uv_rgb
      module procedure mfStreamline_xyuv_str
      module procedure mfStreamline_xyuv_rgb
   end interface
   !------ API end ------

   interface msStreamline
      module procedure msStreamline_uv_str
      module procedure msStreamline_uv_rgb
      module procedure msStreamline_xyuv_str
      module procedure msStreamline_xyuv_rgb
   end interface
   !------ API end ------

   interface mfTriMesh
      module procedure mfTriMesh_tri_color_str
      module procedure mfTriMesh_tri_color_rgb
      module procedure mfTriMesh_fac_color_str
      module procedure mfTriMesh_fac_color_rgb
   end interface
   !------ API end ------

   interface msTriMesh
      module procedure msTriMesh_tri_color_str
      module procedure msTriMesh_tri_color_rgb
      module procedure msTriMesh_fac_color_str
      module procedure msTriMesh_fac_color_rgb
   end interface
   !------ API end ------

   interface mfTriContour
      module procedure mfTriContour_xyz
      module procedure mfTriContour_xyz_out
      module procedure mfTriContour_tri_conn
      module procedure mfTriContour_tri_conn_out
   end interface
   !------ API end ------

   interface msTriContour
      module procedure msTriContour_xyz
      module procedure msTriContour_xyz_out
      module procedure msTriContour_tri_conn
      module procedure msTriContour_tri_conn_out
   end interface
   !------ API end ------

   interface mfTriContourF
      module procedure mfTriContourF_xyz
      module procedure mfTriContourF_xyz_out
      module procedure mfTriContourF_tri_conn
      module procedure mfTriContourF_tri_conn_out
   end interface
   !------ API end ------

   interface msTriContourF
      module procedure msTriContourF_xyz
      module procedure msTriContourF_xyz_out
      module procedure msTriContourF_tri_conn
      module procedure msTriContourF_tri_conn_out
   end interface
   !------ API end ------

   interface mfTriStreamline
      module procedure mfTriStreamline_color_str
      module procedure mfTriStreamline_color_rgb
   end interface
   !------ API end ------

   interface msTriStreamline
      module procedure msTriStreamline_color_str
      module procedure msTriStreamline_color_rgb
   end interface
   !------ API end ------

   private :: mfArrow_pos_real_str, msArrow_pos_real_str, &
              mfArrow_pos_real_rgb, msArrow_pos_real_rgb, &
              mfArrow_Head_pos_real_str, msArrow_Head_pos_real_str, &
              mfArrow_Head_pos_real_rgb, msArrow_Head_pos_real_rgb, &
              mfBar_color_str_1, mfBar_color_str_2, &
              mfBar_color_rgb_1, mfBar_color_rgb_2, &
              msBar_color_str_1, msBar_color_str_2, &
              msBar_color_rgb_1, msBar_color_rgb_2, &
              mfQuiver_uv, msQuiver_uv, mfQuiver_xyuv, msQuiver_xyuv, &
              mfContour_z, msContour_z, mfContour_xyz, msContour_xyz, &
              mfContour_xyz_out, msContour_xyz_out, &
              mfContourF_xyz_out, msContourF_xyz_out, &
              mfPatch_basic_1_str_2_str, msPatch_basic_1_str_2_str, &
              mfPatch_basic_1_str_2_rgb, msPatch_basic_1_str_2_rgb, &
              mfPatch_basic_1_rgb_2_str, msPatch_basic_1_rgb_2_str, &
              mfPatch_basic_1_rgb_2_rgb, msPatch_basic_1_rgb_2_rgb, &
              mfPatch_grad_str, msPatch_grad_str, &
              mfPatch_grad_rgb, msPatch_grad_rgb, &
              mfPcolor_z_str, msPcolor_z_str, &
              mfPcolor_z_rgb, msPcolor_z_rgb, &
              mfPcolor_xyz_str, msPcolor_xyz_str, &
              mfPcolor_xyz_rgb, msPcolor_xyz_rgb, &
              mfPlot_color_str, mfPlot_color_rgb, &
              msPlot_color_str, msPlot_color_rgb, &
              mfErrorBar_color_str, mfErrorBar_color_rgb, &
              msErrorBar_color_str, msErrorBar_color_rgb, &
              mfPlotQuadrBezier_color_str, mfPlotQuadrBezier_color_rgb, &
              msPlotQuadrBezier_color_str, msPlotQuadrBezier_color_rgb, &
              mfPlotCubicBezier_color_str, mfPlotCubicBezier_color_rgb, &
              msPlotCubicBezier_color_str, msPlotCubicBezier_color_rgb, &
              mfPlotCubicSpline_color_str, mfPlotCubicSpline_color_rgb, &
              msPlotCubicSpline_color_str, msPlotCubicSpline_color_rgb, &
              mfPlotHist_color_str, mfPlotHist_color_rgb, &
              msPlotHist_color_str, msPlotHist_color_rgb, &
              mfPlotPLdomain_color_str, mfPlotPLdomain_color_rgb, &
              msPlotPLdomain_color_str, msPlotPLdomain_color_rgb, &
              mfText_pos_real_1_str_2_str, msText_pos_real_1_str_2_str, &
              mfText_pos_real_1_str_2_rgb, msText_pos_real_1_str_2_rgb, &
              mfText_pos_real_1_rgb_2_str, msText_pos_real_1_rgb_2_str, &
              mfText_pos_real_1_rgb_2_rgb, msText_pos_real_1_rgb_2_rgb, &
              mfText_pos_mf_1_str_2_str, msText_pos_mf_1_str_2_str, &
              mfText_pos_mf_1_str_2_rgb, msText_pos_mf_1_str_2_rgb, &
              mfText_pos_mf_1_rgb_2_str, msText_pos_mf_1_rgb_2_str, &
              mfText_pos_mf_1_rgb_2_rgb, msText_pos_mf_1_rgb_2_rgb, &
              mfStreamline_uv_str, msStreamline_uv_str, &
              mfStreamline_uv_rgb, msStreamline_uv_rgb, &
              mfStreamline_xyuv_str, msStreamline_xyuv_str, &
              mfStreamline_xyuv_rgb, msStreamline_xyuv_rgb, &
              mfTriMesh_tri_color_str, msTriMesh_tri_color_str, &
              mfTriMesh_tri_color_rgb, msTriMesh_tri_color_rgb, &
              mfTriMesh_fac_color_str, msTriMesh_fac_color_str, &
              mfTriMesh_fac_color_rgb, msTriMesh_fac_color_rgb, &
              mfTriStreamline_color_str, msTriStreamline_color_str, &
              mfTriStreamline_color_rgb, msTriStreamline_color_rgb

   private :: mfTriContour_xyz,           msTriContour_xyz
   private :: mfTriContour_tri_conn,      msTriContour_tri_conn
   private :: mfTriContour_xyz_out,       msTriContour_xyz_out
   private :: mfTriContour_tri_conn_out,  msTriContour_tri_conn_out
   private :: mfTriContourF_xyz,          msTriContourF_xyz
   private :: mfTriContourF_tri_conn,     msTriContourF_tri_conn
   private :: mfTriContourF_xyz_out,      msTriContourF_xyz_out
   private :: mfTriContourF_tri_conn_out, msTriContourF_tri_conn_out

   private :: TriMesh_tri, TriMesh_fac, MeshTri_tri, MeshTri_fac,       &
              MeshBoundary_unstruct

   private :: ContourTri, ContourTriConnect

   private :: ContourFTri, ContourFTriConnect, ProcessAllContours,      &
              points_are_colinear, ProcessClosedPatches,                &
              StoreInternalBoundShape, ShrinkAlignedPoints

!-----------------------------------------------------------------------
!                             parameters
!-----------------------------------------------------------------------

   ! read_xpm, write_xpm
   ! MF_ROW_WIDTH_MAX is used to define the maximum number of characters
   ! in a row of a XPM file.
   integer, parameter :: MF_ROW_WIDTH_MAX = 12000
   private :: MF_ROW_WIDTH_MAX

   ! read_xpm, write_xpm
   ! ASCII subset used as symbol for coding colors
   integer, parameter :: MF_ASCII_start = 35,           &   ! "#" character
                         MF_ASCII_end   = 126               ! "~" character
   integer, parameter :: MF_ASCII_range = MF_ASCII_end  &
                                        - MF_ASCII_start + 1 ! 91
   private :: MF_ASCII_start, MF_ASCII_end, MF_ASCII_range

   ! default value for the curvature tolerance, use in the TriStream
   ! algorithm (computation of streamlines: fgl/aux/Streamline.F90,
   ! fgl/aux/TriStreamline.F90)
   real(kind=MF_DOUBLE) :: MF_TRISTREAM_CURV_TOL = 0.2d0

   logical :: TEXTCORE_INIT = .false.

contains

#include "Bar_aux.f90"

#include "Contour_aux.f90"

#include "ContourF_aux.f90"

#include "CumulHist.f90"

#include "ErrorBar_aux.f90"

#include "Image_aux.f90"

#include "ImRead.F90"

#include "ImWrite.F90"

#include "ImRead_aux.f90"

#include "ImWrite_aux.f90"

#include "ImRead_aux2.F90"

#include "ImWrite_aux2.F90"

#include "Patch_aux.f90"

#include "Pcolor_aux.f90"

#include "Quiver_aux.f90"

#include "Plot_aux.f90"

#include "PlotCubicBezier_aux.f90"

#include "PlotCubicSpline_aux.f90"

#include "PlotQuadrBezier_aux.f90"

#include "PlotVoronoi_aux.f90"

#include "Shading.f90"

#include "Spy_aux.f90"

#include "Streamline_aux.f90"

#include "Text_aux.f90"

#include "TriContour_aux.f90"

#include "TriContourF_aux.f90"

#include "TriContourF_aux2.f90"

#include "TriFill_aux.f90"

#include "TriMesh_aux.f90"

#include "TriPcolor_aux.f90"

#include "TriQuiver_aux.f90"

#include "PlotPLdomain_aux.f90"

#include "mfArrow.f90"
#include "msArrow.f90"

#include "mfBar.f90"
#include "msBar.f90"

#include "mfContour.f90"
#include "msContour.f90"

#include "mfContourF.f90"
#include "msContourF.f90"

#include "mfErrorBar.f90"
#include "msErrorBar.f90"

#include "mfImage.f90"
#include "msImage.f90"

#include "mfPatch.f90"
#include "msPatch.f90"

#include "mfPcolor.f90"
#include "msPcolor.f90"

#include "mfQuiver.f90"
#include "msQuiver.f90"

#include "mfPlot.f90"
#include "msPlot.f90"

#include "mfPlotCubicBezier.f90"
#include "msPlotCubicBezier.f90"

#include "mfPlotCubicSpline.f90"
#include "msPlotCubicSpline.f90"

#include "mfPlotHist.f90"
#include "msPlotHist.f90"

#include "mfPlotQuadrBezier.f90"
#include "msPlotQuadrBezier.f90"

#include "mfPlotVoronoi.f90"
#include "msPlotVoronoi.f90"

#include "mfSpy.f90"
#include "msSpy.f90"

#include "mfStreamline.f90"
#include "msStreamline.f90"

#include "mfText.f90"
#include "msText.f90"

#include "mfTriContour.f90"
#include "msTriContour.f90"

#include "mfTriContourF.f90"
#include "msTriContourF.f90"

#include "mfTriFill.f90"
#include "msTriFill.f90"

#include "mfTriMesh.f90"
#include "msTriMesh.f90"

#include "mfTriPcolor.f90"
#include "msTriPcolor.f90"

#include "mfTriQuiver.f90"
#include "msTriQuiver.f90"

#include "mfTriStreamline.f90"
#include "msTriStreamline.f90"

#include "mfPlotPLdomain.f90"
#include "msPlotPLdomain.f90"

end module mod_plot2d
