module mod_grobj

   ! Part of MUESLI Graphic Library
   ! Copyright É. Canot 2004-2025 -- IPR/CNRS

   use mod_mfarray, only: PrintMessage ! private when using FML

   use mod_axes

#ifdef _SPREAD_MOD
!!   use mod_window

!!   use fgl_aux_2

!!   use mod_win_db

!!   use fml ! MUESLI Numerical Library
#endif

   implicit none

#ifndef _DEVLP
   private
#endif

   private :: PrintMessage

!-----------------------------------------------------------------------
!                               public
!-----------------------------------------------------------------------

   public :: msBBuf, &
             msEBuf, &
             mfGetWinId, &
             msSetWinProp, &
             mfGetAllGrObj, &
             mfGetTypeGrObj, &
             mfSelectTypeGrObj, &
             msSetGrObj, &
             msRemoveGrObj, &
             msSetGBuffer, &
             msSetPdfOC

#ifndef _NO_X11
   public :: msAnimation, &
             msShowNow, &
             msMoveLegend, &
             msPan, &
             msPanAndZoom, &
             msZoom, &
             msMoveGrObj
#endif

!-----------------------------------------------------------------------
!                             interfaces
!-----------------------------------------------------------------------

   interface msSetGrObj
      module procedure msSetGrObj_scalar_int_text
      module procedure msSetGrObj_vector_int_text
      module procedure msSetGrObj_mfArray_text
      module procedure msSetGrObj_scalar_int_real
      module procedure msSetGrObj_mfArray_real
      module procedure msSetGrObj_scalar_int_vec
      module procedure msSetGrObj_scalar_int_coords
   end interface
   !------ API end ------

   interface msRemoveGrObj
      module procedure msRemoveGrObj_scalar_int
      module procedure msRemoveGrObj_vector_int
      module procedure msRemoveGrObj_mfArray
   end interface
   !------ API end ------

   interface msSetPdfOC
      module procedure msSetPdfOC_hdl_scalar_int
      module procedure msSetPdfOC_hdl_vector_int
   end interface
   !------ API end ------

   private :: msSetGrObj_scalar_int_text, msSetGrObj_vector_int_text, &
              msSetGrObj_mfArray_text, msSetGrObj_scalar_int_real, &
              msSetGrObj_mfArray_real, msSetGrObj_scalar_int_vec, &
              msRemoveGrObj_scalar_int, &
              msRemoveGrObj_vector_int, msRemoveGrObj_mfArray, &
              msSetPdfOC_hdl_scalar_int, msSetPdfOC_hdl_vector_int

contains

#include "AttributesManagement.f90"

#include "BBuf.f90"

#include "EBuf.f90"

#include "GetWinId.f90"

#include "RemoveGrObj.f90"

#include "SetGBuffer.f90"

#include "GetAllGrObj.f90"

#include "GetTypeGrObj.f90"

#include "SelectTypeGrObj.f90"

#include "SetGrObj.f90"

#include "SetGrObj_aux.f90"

#include "SetPdfOC.f90"

#ifndef _NO_X11

#include "Animation.f90"

#include "ShowNow.f90"

#include "MoveLegend.f90"

#include "Pan.f90"

#include "PanAndZoom.f90"

#include "Zoom.f90"

#include "MoveGrObj.f90"

#include "MoveGrObj_aux.f90"
#endif

end module mod_grobj
