#ifdef _HAS_LOC
#define _MF_LOC_ANY_OBJ_ loc
#else
#define _MF_LOC_ANY_OBJ_ mf_loc_any_obj
#endif

module mod_fgl_mem_debug

   ! Part of MUESLI Numerical Library
   ! Copyright É. Canot 2004-2025 -- IPR/CNRS

!=======================================================================
!    utilitaires de déboguage pour l'utilisateur
!    (trace des error/warning)
!=======================================================================

   use mod_mfdebug, stderr_old => STDERR

   use mod_mem_debug

   use mod_win_db, stderr_old_2 => STDERR

   implicit none

#ifndef _DEVLP
   private
#endif

   integer, parameter :: STDERR = 0
   private :: STDERR

   interface ptr_to_null
      module procedure ptr_to_null_int4_d1
      module procedure ptr_to_null_real4_d1
      module procedure ptr_to_null_real4_d2
      module procedure ptr_to_null_real8_d2
      module procedure ptr_to_null_cmplx_d2
      module procedure ptr_to_null_grobj_elem
   end interface ptr_to_null
   !------ API end ------

   interface ptr_to_ptr
      module procedure ptr_to_ptr_int4_d1
      module procedure ptr_to_ptr_real4_d1
      module procedure ptr_to_ptr_real4_d2
      module procedure ptr_to_ptr_real8_d2
      module procedure ptr_to_ptr_cmplx_d2
      module procedure ptr_to_ptr_grobj_elem
      module procedure ptr_to_ptr_mf_win_info
   end interface ptr_to_ptr
   !------ API end ------

   interface mf_allocate
      module procedure mf_alloc_type_grobj_elem
      module procedure mf_alloc_type_grobj_hdl
   end interface mf_allocate
   !------ API end ------

   interface mf_deallocate
      module procedure mf_dealloc_type_grobj_elem
      module procedure mf_dealloc_type_grobj_hdl
   end interface mf_deallocate
   !------ API end ------

   public :: ptr_to_null, ptr_to_ptr, mf_allocate, mf_deallocate

contains
!_______________________________________________________________________
!
   subroutine ptr_to_null_int4_d1( ptr, symb, file, line )

      integer, pointer :: ptr(:)
      character(len=*) :: symb, file, line
      !------ API end ------

      character(len=24) :: sym2

   !------ end of declarations -- execution starts hereafter  ------

      sym2 = symb
      write(STDERR,"(A,Z8.8,A)")                                        &
            sym2 // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => 0x00000000 in file: " // &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_null_int4_d1
!_______________________________________________________________________
!
   subroutine ptr_to_null_real4_d1( ptr, symb, file, line )

      real, pointer :: ptr(:)
      character(len=*) :: symb, file, line
      !------ API end ------

      character(len=24) :: sym2

   !------ end of declarations -- execution starts hereafter  ------

      sym2 = symb
      write(STDERR,"(A,Z8.8,A)")                                        &
            sym2 // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => 0x00000000 in file: " // &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_null_real4_d1
!_______________________________________________________________________
!
   subroutine ptr_to_null_real4_d2( ptr, symb, file, line )

      real, pointer :: ptr(:,:)
      character(len=*) :: symb, file, line
      !------ API end ------

      character(len=24) :: sym2

   !------ end of declarations -- execution starts hereafter  ------

      sym2 = symb
      write(STDERR,"(A,Z8.8,A)")                                        &
            sym2 // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => 0x00000000 in file: " // &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_null_real4_d2
!_______________________________________________________________________
!
   subroutine ptr_to_null_real8_d2( ptr, symb, file, line )

      real(kind=MF_DOUBLE), pointer :: ptr(:,:)
      character(len=*) :: symb, file, line
      !------ API end ------

      character(len=24) :: sym2

   !------ end of declarations -- execution starts hereafter  ------

      sym2 = symb
      write(STDERR,"(A,Z8.8,A)")                                        &
            sym2 // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => 0x00000000 in file: " // &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_null_real8_d2
!_______________________________________________________________________
!
   subroutine ptr_to_null_cmplx_d2( ptr, symb, file, line )

      complex(kind=MF_DOUBLE), pointer :: ptr(:,:)
      character(len=*) :: symb, file, line
      !------ API end ------

      character(len=24) :: sym2

   !------ end of declarations -- execution starts hereafter  ------

      sym2 = symb
      write(STDERR,"(A,Z8.8,A)")                                        &
            sym2 // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => 0x00000000 in file: " // &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_null_cmplx_d2
!_______________________________________________________________________
!
   subroutine ptr_to_null_grobj_elem( ptr, symb, file, line )

      type(grobj_elem), pointer :: ptr
      character(len=*) :: symb, file, line
      !------ API end ------

      character(len=24) :: sym2

   !------ end of declarations -- execution starts hereafter  ------

      sym2 = symb
      write(STDERR,"(A,Z8.8,A)")                                        &
            sym2 // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => 0x00000000 in file: " // &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_null_grobj_elem
!_______________________________________________________________________
!
   subroutine ptr_to_ptr_int4_d1( ptr, symb, ptr2, symb2, file, line )

      integer, pointer :: ptr(:), ptr2(:)
      character(len=*) :: symb, symb2, file, line
      !------ API end ------

   !------ end of declarations -- execution starts hereafter  ------

      write(STDERR,"(A,Z8.8,A,Z8.8,A)")                                 &
            symb // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => " // symb2 // " 0x",          &
            _MF_LOC_ANY_OBJ_(ptr2), " in file: " //                                  &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_ptr_int4_d1
!_______________________________________________________________________
!
   subroutine ptr_to_ptr_real4_d1( ptr, symb, ptr2, symb2, file, line )

      real, pointer :: ptr(:), ptr2(:)
      character(len=*) :: symb, symb2, file, line
      !------ API end ------

   !------ end of declarations -- execution starts hereafter  ------

      write(STDERR,"(A,Z8.8,A,Z8.8,A)")                                 &
            symb // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => " // symb2 // " 0x",          &
            _MF_LOC_ANY_OBJ_(ptr2), " in file: " //                                  &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_ptr_real4_d1
!_______________________________________________________________________
!
   subroutine ptr_to_ptr_real4_d2( ptr, symb, ptr2, symb2, file, line )

      real, pointer :: ptr(:,:), ptr2(:,:)
      character(len=*) :: symb, symb2, file, line
      !------ API end ------

   !------ end of declarations -- execution starts hereafter  ------

      write(STDERR,"(A,Z8.8,A,Z8.8,A)")                                 &
            symb // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => " // symb2 // " 0x",          &
            _MF_LOC_ANY_OBJ_(ptr2), " in file: " //                                  &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_ptr_real4_d2
!_______________________________________________________________________
!
   subroutine ptr_to_ptr_real8_d2( ptr, symb, ptr2, symb2, file, line )

      real(kind=MF_DOUBLE), pointer :: ptr(:,:), ptr2(:,:)
      character(len=*) :: symb, symb2, file, line
      !------ API end ------

   !------ end of declarations -- execution starts hereafter  ------

      write(STDERR,"(A,Z8.8,A,Z8.8,A)")                                 &
            symb // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => " // symb2 // " 0x",          &
            _MF_LOC_ANY_OBJ_(ptr2), " in file: " //                                  &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_ptr_real8_d2
!_______________________________________________________________________
!
   subroutine ptr_to_ptr_cmplx_d2( ptr, symb, ptr2, symb2, file, line )

      complex(kind=MF_DOUBLE), pointer :: ptr(:,:), ptr2(:,:)
      character(len=*) :: symb, symb2, file, line
      !------ API end ------

   !------ end of declarations -- execution starts hereafter  ------

      write(STDERR,"(A,Z8.8,A,Z8.8,A)")                                 &
            symb // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => " // symb2 // " 0x",          &
            _MF_LOC_ANY_OBJ_(ptr2), " in file: " //                                  &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_ptr_cmplx_d2
!_______________________________________________________________________
!
   subroutine ptr_to_ptr_grobj_elem( ptr, symb, ptr2, symb2, file, line )

      type(grobj_elem), pointer :: ptr, ptr2
      character(len=*) :: symb, symb2, file, line
      !------ API end ------

   !------ end of declarations -- execution starts hereafter  ------

      write(STDERR,"(A,Z8.8,A,Z8.8,A)")                                 &
            symb // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => " // symb2 // " 0x",          &
            _MF_LOC_ANY_OBJ_(ptr2), " in file: " //                                  &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_ptr_grobj_elem
!_______________________________________________________________________
!
   subroutine ptr_to_ptr_mf_win_info( ptr, symb, ptr2, symb2, file, line )

      type(mf_win_info), pointer :: ptr
      type(mf_win_info) :: ptr2
      character(len=*) :: symb, symb2, file, line
      !------ API end ------

   !------ end of declarations -- execution starts hereafter  ------

      write(STDERR,"(A,Z8.8,A,Z8.8,A)")                                 &
            symb // " 0x", _MF_LOC_ANY_OBJ_(ptr), " => " // symb2 // " 0x",          &
            _MF_LOC_ANY_OBJ_(ptr2), " in file: " //                                  &
            trim(file) // " at line: " // trim(line)

      call flush(STDERR)

   end subroutine ptr_to_ptr_mf_win_info
!_______________________________________________________________________
!
   subroutine mf_alloc_type_grobj_elem( grobj, file, line,              &
                                        symb, unit )
      type(grobj_elem), pointer :: grobj
      character(len=*) :: file, line
      character(len=*), optional :: symb, unit
      !------ API end ------

      character(len=80) :: symb2, unit2

   !------ end of declarations -- execution starts hereafter  ------

      allocate( grobj )

      if( present(symb) ) then
         symb2 = symb
      else
         symb2 = ""
      end if

      if( present(unit) ) then
         unit2 = unit
      else
         unit2 = ""
      end if

      ! printing some infos on STDERR
      write(STDERR,"(A,Z8.8,A,I0,A,A,A)")                               &
            "[+ addr: ", _MF_LOC_ANY_OBJ_(grobj),                                    &
            ", size: ", 132,                                            &
            ", symb: ", trim(symb2),                                    &
            "]"
      write(STDERR,"(A,A,A,A,A,A,A)")                                   &
            "  (in unit: ", trim(unit2),                                &
            ", file: ", trim(file),                                     &
            ", line: ", trim(line), ")"

#ifdef _INTEL_IFC_MEM_TRACEBACK
      call tracebackqq( string="  traceback requested from MUESLI:",    &
                        user_exit_code=-1 )
#endif

      call flush(STDERR)

   end subroutine mf_alloc_type_grobj_elem
!_______________________________________________________________________
!
   subroutine mf_alloc_type_grobj_hdl( grobj_hdl, n, file, line,        &
                                       symb, unit )
      type(grobj_handle), pointer :: grobj_hdl(:)
      integer :: n
      character(len=*) :: file, line
      character(len=*), optional :: symb, unit
      !------ API end ------

      character(len=80) :: symb2, unit2

   !------ end of declarations -- execution starts hereafter  ------

      allocate( grobj_hdl(n) )

      if( present(symb) ) then
         symb2 = symb
      else
         symb2 = ""
      end if

      if( present(unit) ) then
         unit2 = unit
      else
         unit2 = ""
      end if

      ! printing some infos on STDERR
      write(STDERR,"(A,Z8.8,A,I0,A,A,A)")                               &
            "[+ addr: ", _MF_LOC_ANY_OBJ_(grobj_hdl),                                    &
            ", size: ", n*4,                                            &
            ", symb: ", trim(symb2),                                    &
            "]"
      write(STDERR,"(A,A,A,A,A,A,A)")                                   &
            "  (in unit: ", trim(unit2),                                &
            ", file: ", trim(file),                                     &
            ", line: ", trim(line), ")"

#ifdef _INTEL_IFC_MEM_TRACEBACK
      call tracebackqq( string="  traceback requested from MUESLI:",    &
                        user_exit_code=-1 )
#endif

      call flush(STDERR)

   end subroutine mf_alloc_type_grobj_hdl
!_______________________________________________________________________
!
   subroutine mf_dealloc_type_grobj_elem( grobj, file, line,            &
                                          symb, unit )
      type(grobj_elem), pointer :: grobj
      character(len=*) :: file, line
      character(len=*), optional :: symb, unit
      !------ API end ------

      character(len=80) :: symb2, unit2

   !------ end of declarations -- execution starts hereafter  ------

      if( present(symb) ) then
         symb2 = symb
      else
         symb2 = ""
      end if

      if( present(unit) ) then
         unit2 = unit
      else
         unit2 = ""
      end if

      ! printing some infos on STDERR
      write(STDERR,"(A,Z8.8,A,A,A)")                                    &
            "[- addr: ", _MF_LOC_ANY_OBJ_(grobj),                                    &
            ", symb: ", trim(symb2),                                    &
            "]"
      write(STDERR,"(A,A,A,A,A,A,A)")                                   &
            "  (in unit: ", trim(unit2),                                &
            ", file: ", trim(file),                                     &
            ", line: ", trim(line), ")"

      deallocate( grobj )

#ifdef _INTEL_IFC_MEM_TRACEBACK
      call tracebackqq( string="  traceback requested from MUESLI:",    &
                        user_exit_code=-1 )
#endif

      call flush(STDERR)

   end subroutine mf_dealloc_type_grobj_elem
!_______________________________________________________________________
!
   subroutine mf_dealloc_type_grobj_hdl( grobj_hdl, file, line,         &
                                         symb, unit )
      type(grobj_handle), pointer :: grobj_hdl(:)
      character(len=*) :: file, line
      character(len=*), optional :: symb, unit
      !------ API end ------

      character(len=80) :: symb2, unit2

   !------ end of declarations -- execution starts hereafter  ------

      if( present(symb) ) then
         symb2 = symb
      else
         symb2 = ""
      end if

      if( present(unit) ) then
         unit2 = unit
      else
         unit2 = ""
      end if

      ! printing some infos on STDERR
      write(STDERR,"(A,Z8.8,A,A,A)")                                    &
            "[- addr: ", _MF_LOC_ANY_OBJ_(grobj_hdl),                                    &
            ", symb: ", trim(symb2),                                    &
            "]"
      write(STDERR,"(A,A,A,A,A,A,A)")                                   &
            "  (in unit: ", trim(unit2),                                &
            ", file: ", trim(file),                                     &
            ", line: ", trim(line), ")"

      deallocate( grobj_hdl )

#ifdef _INTEL_IFC_MEM_TRACEBACK
      call tracebackqq( string="  traceback requested from MUESLI:",    &
                        user_exit_code=-1 )
#endif

      call flush(STDERR)

   end subroutine mf_dealloc_type_grobj_hdl
!_______________________________________________________________________
!
end module mod_fgl_mem_debug
