module mod_axes

   ! Part of MUESLI Graphic Library
   ! Copyright É. Canot 2004-2025 -- IPR/CNRS

   use mod_mfarray, only: PrintMessage ! private when using FML

   use mod_window

#ifdef _SPREAD_MOD
!!   use fgl_aux_2

!!   use mod_win_db

!!   use fml ! MUESLI Numerical Library
#endif

   implicit none

#ifndef _DEVLP
   private
#endif

   private :: PrintMessage

!-----------------------------------------------------------------------
!                               public
!-----------------------------------------------------------------------

   public :: mfAxis, msAxis, &
             msAxisFontSize, &
             msAxisLineWidth, &
             msAxisLabelFormat, &
             mfCAxis, msCAxis, &
             msClf, msCla, &
             msColorbar, &
             mfColormap, msColormap, &
             mfColormapSize, msColormapSize, &
             msDrawBox, msDrawGrid, &
             msRedrawFigure, &
             msResizeWindow, &
             msGrid, &
             msLabelFontSize, &
             msTitleFontSize, &
             msPrint, &
             msHold, &
             mfTitle, msTitle, &
             mfXLabel, msXLabel, &
             mfYLabel, msYLabel, &
             mfLegend, msLegend, &
             msCharInPixels, &
             msSetClipBox, &
             msRemoveClipBox, &
             mfGetXAxisTicksNb

#ifndef _NO_X11
   public :: mfGinput, msGinput, &
             mfGinputRect, &
             mfGinputCustom, &
             mfGetModKeys, &
             msDefineCustomCursors, &
             msGetX11Pixmap
#endif

!-----------------------------------------------------------------------
!                             interfaces
!-----------------------------------------------------------------------

   interface msAxis
      module procedure msAxis_mode
      module procedure msAxis_real_range
      module procedure msAxis_mf_range
   end interface

   interface msCAxis
      module procedure msCAxis_real_range
      module procedure msCAxis_mf_range
      module procedure msCAxis_string
   end interface

   interface mfColormap
      module procedure mfColormap_noarg
      module procedure mfColormap_status
   end interface

   interface msColormap
      module procedure msColormap_string
      module procedure msColormap_mfArray
   end interface

   interface msColormapSize
      module procedure msColormapSize_string
      module procedure msColormapSize_size
   end interface

   interface msSetClipBox
      module procedure msSetClipBox_real_range
   end interface

   interface msSetWinProp
      module procedure msSetWinProp_real
      module procedure msSetWinProp_char
   end interface

   interface mfLegend
      module procedure mfLegend_args
      module procedure mfLegend_args_subset
      module procedure mfLegend_array
      module procedure mfLegend_array_subset
   end interface

   interface msLegend
      module procedure msLegend_args
      module procedure msLegend_args_subset
      module procedure msLegend_array
      module procedure msLegend_array_subset
   end interface

   interface mfGinputCustom
      module procedure mfGinputCustom_1
      module procedure mfGinputCustom_2
   end interface

   interface msSetXAxisUserLabels
      module procedure msSetXAxisUserLabels_chars
      module procedure msSetXAxisUserLabels_bool
   end interface

   private :: msSetWinProp_real, msSetWinProp_char, &
              msAxis_mode, msAxis_real_range, msAxis_mf_range, &
              msCAxis_real_range, msCAxis_mf_range, mfColormap_noarg, &
              mfColormap_status, msColormap_string, msColormap_mfArray, &
              msColormapSize_string, msColormapSize_size, &
              msSetClipBox_real_range, mfLegend_args, mfLegend_args_subset, &
              mfLegend_array, mfLegend_array_subset, msLegend_args, &
              msLegend_args_subset, msLegend_array, msLegend_array_subset, &
              msSetXAxisUserLabels_chars, msSetXAxisUserLabels_bool

contains

#include "Axis.f90"

#include "AxisFontSize.f90"

#include "AxisLabelFormat.f90"

#include "AxisLineWidth.f90"

#include "CharInPixels.f90"

#include "Cla.f90"

#include "Clf.f90"

#include "ColorAxis.f90"

#include "ColorBar.f90"

#include "ColorMap.f90"

#include "ColorMapSize.f90"

#include "DrawBox.f90"

#include "DrawGrid.f90"

#include "RedrawFigure.f90"

#include "ResizeWindow.f90"

#include "GetXAxisTicksNb.f90"
#include "SetXAxisUserLabels.f90"

#include "Grid.f90"

#include "Hold.f90"

#include "LabelFontSize.f90"
#include "TitleFontSize.f90"

#include "mfLegend.f90"
#include "msLegend.f90"

#include "Print.f90"

#include "Print_aux.F90"

#include "RemoveClipBox.f90"

#include "SetClipBox.f90"

#include "SetWinProp.f90"

#include "mfTitle.f90"
#include "msTitle.f90"

#include "mfXLabel.f90"
#include "msXLabel.f90"

#include "mfYLabel.f90"
#include "msYLabel.f90"

#ifndef _NO_X11
#include "GetX11Pixmap.f90"

#include "Ginput.f90"

#include "GinputRect.f90"

#include "GinputCustom.f90"

#include "GetModKeys.f90"

#include "DefineCustomCursors.f90"
#endif

end module mod_axes
