! f90 include file

!#######################################################################
! Don't forget: before all 'pgsci' calls (color index setting), insert
! a command for the PDF driver:
!   gr_pdf_color_intent = 1 ! Stroke           (i.e. lines, ...)
!   gr_pdf_color_intent = 2 ! Fill             (i.e. text strings, ...)
!   gr_pdf_color_intent = 3 ! Stroke & Fill
!#######################################################################

! The additional optional arguments which have the prefix "stm_" are
! dedicated to "skip for moving" one Graphic Object or the Legend boxes.
! At most one of these optional arg. must be present.

!_______________________________________________________________________
!
   subroutine mf_win_redraw( win_id,                                    &
                             from_print_call,                           &
                             stm_legend_ano, stm_legend_hdl,            &
                             stm_before_hdl, stm_only_hdl, stm_after_hdl, &
                             usual_grobj_only, clear_main_pixmap,       &
                             no_clipping )

      integer, intent(in) :: win_id
      logical, intent(in), optional :: from_print_call
      logical, intent(in), optional :: stm_legend_ano ! anonymous legend
      integer, intent(in), optional :: stm_legend_hdl ! legend with handle
      integer, intent(in), optional :: stm_before_hdl,                  &
                                       stm_only_hdl,                    &
                                       stm_after_hdl
      logical, intent(in), optional :: usual_grobj_only,                &
                                       clear_main_pixmap,               &
                                       no_clipping
      !------ API end ------

      type(mf_win_info), pointer :: win
      type(grobj_elem), pointer :: grobj, grobj_next

      character(len=40) :: cmd
      real(kind=MF_DOUBLE) :: x_min, x_max, y_min, y_max

      character(len=3) :: answer
      logical :: device_has_cursor, grobj_must_be_drawn

      character(len=96) :: xlabel_tmp, ylabel_tmp
      character(len=128) :: title_tmp
      logical :: xlabel_is_not_empty

      real(kind=MF_DOUBLE) :: disp

      integer :: len_text, j, itmp, nb_optional_stm_arg
      logical :: skip_legend_ano, draw_only_flag, draw_after_flag
      integer :: skip_legend_hdl,                                       &
                 draw_before_hdl, draw_only_hdl, draw_after_hdl
      integer :: hdle
      logical :: draw_only_usual_grobj

      logical :: from_print
      integer :: just, colbar, icol_gray, xlabel_pos

      ! adding comments in the EPS or PDF file
      real(kind=MF_DOUBLE) :: rbuf(1)
      integer :: ibuf(3), lchr
      character(len=1) :: chr

      logical :: clear_main_pixmap_0, no_clipping_0, xopt_log, yopt_log, &
                 PDF_OC_skip

   !------ end of declarations -- execution starts hereafter  ------

      ! Added after removing the MFPLOT server. Otherwise the color index 1
      ! (foreground color) is kept in memory and the Quick Return inside GRSCI
      ! don't select it.
      grccol(pgid) = -1 ! color not yet defined

      win => mf_win_db(win_id)

      if( win%blank ) then
         return
      end if

      if( present(from_print_call) ) then
         from_print = from_print_call
      else
         from_print = .false.
      end if

      ! Count the number of optional args. At most one can exist.
      nb_optional_stm_arg = 0
      if( present(stm_legend_ano) ) then
         nb_optional_stm_arg = nb_optional_stm_arg + 1
      end if
      if( present(stm_legend_hdl) ) then
         nb_optional_stm_arg = nb_optional_stm_arg + 1
      end if
      if( present(stm_before_hdl) ) then
         nb_optional_stm_arg = nb_optional_stm_arg + 1
      end if
      if( present(stm_only_hdl) ) then
         nb_optional_stm_arg = nb_optional_stm_arg + 1
      end if
      if( present(stm_after_hdl) ) then
         nb_optional_stm_arg = nb_optional_stm_arg + 1
      end if
      if( present(usual_grobj_only) ) then
         nb_optional_stm_arg = nb_optional_stm_arg + 1
      end if
      if( nb_optional_stm_arg > 1 ) then
         print "(/,2X,A)", "MUESLI: FGL: mf_win_redraw: Internal error"
         print "(2X,A,/)", "        At most one optional arg can be passed!"
         pause "for debugging purpose only"
         stop
      end if

      if( present(stm_legend_ano) ) then
         skip_legend_ano = stm_legend_ano
      else
         skip_legend_ano = .false.
      end if

      if( present(stm_legend_hdl) ) then
         skip_legend_hdl = stm_legend_hdl
      else
         skip_legend_hdl = 0
      end if

      if( present(stm_before_hdl) ) then
         draw_before_hdl = stm_before_hdl
      else
         draw_before_hdl = 0
      end if

      if( present(stm_only_hdl) ) then
         draw_only_hdl = stm_only_hdl
      else
         draw_only_hdl = 0
      end if

      if( present(stm_after_hdl) ) then
         draw_after_hdl = stm_after_hdl
      else
         draw_after_hdl = 0
      end if

      if( present(usual_grobj_only) ) then
         draw_only_usual_grobj = usual_grobj_only
      else
         draw_only_usual_grobj = .false.
      end if

      if( present(clear_main_pixmap) ) then
         clear_main_pixmap_0 = clear_main_pixmap
      else
         clear_main_pixmap_0 = .true.
      end if

      ! inquiring if the device has a cursor
      call pgqinf( "CURSOR", answer, itmp )
      if( to_lower(answer) == "yes" ) then
         device_has_cursor = .true.
         itmp = gr_set_cursor_shape( MF_WATCH_CURSOR )
      else
         device_has_cursor = .false.
      end if

      if( FGL_MFPLOT_BUFFER ) then
         MFPLOT_BUF_LEVEL = MFPLOT_BUF_LEVEL + 1
         call pgbbuf()
      end if

      if( draw_only_hdl == 0 .and. draw_after_hdl == 0 .and. .not. draw_only_usual_grobj ) then

         x_min = win%current_axes(1)
         x_max = win%current_axes(2)
         y_min = win%current_axes(3)
         y_max = win%current_axes(4)

         if( win%axis_scale_x == 2 ) then
            if( x_min <= 0.0d0 .or. x_max <= 0.0d0 ) then
               if( win%empty ) then
                  ! usually, x is in [0,1] or in [1,0]...
                  if( x_min == 0.0d0 ) then
                     x_min = -8.0d0
                     x_max =  0.0d0
                  else if( x_max == 0.0d0 ) then
                     x_min =  0.0d0
                     x_max = -8.0d0
                  else
                     ! don't understand what happens!
                     write(STDERR,*) "(MUESLI mf_win_redraw:) internal error"
                     write(STDERR,*) "                        for an empty figure, X axis range should be in [0,1]..."
                     call msMuesliTrace( pause="yes" )
                     go to 99
                  end if
               else
                  write(STDERR,*) "(MUESLI mf_win_redraw:) info: cannot use log for 'x' axis!"
                  write(STDERR,*) "                        (null or negative values for new min. or max.)"
                  if( win%axis_manual_x == 1 ) then ! "manual mode chosen by the user
                     write(STDERR,*)
                     write(STDERR,*) "                        -> as you have chosen the 'manual' mode for the 'x'"
                     write(STDERR,*) "                           axis, please either change to the 'auto' or"
                     write(STDERR,*) "                           'tight' mode, or restrict your data to strictly"
                     write(STDERR,*) "                           positive values."
                  end if
                  call msMuesliTrace( pause="no" )
                  go to 99
               end if
            else
               x_min = log10( x_min )
               x_max = log10( x_max )
            end if
         end if
         if( win%axis_scale_y == 2 ) then
            if( y_min <= 0.0d0 .or. y_max <= 0.0d0 ) then
               if( win%empty ) then
                  ! usually, y is in [0,1] or in [1,0]...
                  if( y_min == 0.0d0 ) then
                     y_min = -8.0d0
                     y_max =  0.0d0
                  else if( y_max == 0.0d0 ) then
                     y_min =  0.0d0
                     y_max = -8.0d0
                  else
                     ! don't understand what happens!
                     write(STDERR,*) "(MUESLI mf_win_redraw:) internal error"
                     write(STDERR,*) "                        for an empty figure, Y axis range should be in [0,1]..."
                     call msMuesliTrace( pause="yes" )
                     go to 99
                  end if
               else
                  write(STDERR,*) "(MUESLI mf_win_redraw:) info: cannot use log for 'y' axis!"
                  write(STDERR,*) "                        (null or negative values for new min. or max.)"
                  if( win%axis_manual_x == 1 ) then ! "manual mode chosen by the user
                     write(STDERR,*)
                     write(STDERR,*) "                        -> as you have chosen the 'manual' mode for the 'y'"
                     write(STDERR,*) "                           axis, please either change to the 'auto' or"
                     write(STDERR,*) "                           'tight' mode, or restrict your data to strictly"
                     write(STDERR,*) "                           positive values."
                  end if
                  call msMuesliTrace( pause="no" )
                  go to 99
               end if
            else
               y_min = log10( y_min )
               y_max = log10( y_max )
            end if
         end if

         ! si on imprime, il ne faut pas rentrer dans le bloc ci-après,
         ! car il faut conserver le 'ref_length' de la figure X11.
         if( .not. PRINTING_EPS .and. .not. PRINTING_PDF ) then
            call char_height_factor_update( win_id )
         end if
         call pgsch( win%axis_font_size * win%char_height_factor )

         if( win%colorbar == 0 ) then
            colbar = 0
         else
            if( win%colorbar_pos == "ri" ) then
               colbar = 1
            else ! colorbar_pos = "bi"
               colbar = 2
            end if
         end if
         if( win%axis_equal ) then
            ! scaled axis
            just = 1
         else
            ! automatic axis
            just = 0
         end if
         if( win%axis_mode_xy ) then
            xlabel_pos = 1
         else
            xlabel_pos = 2
         end if
         call fix_min_max_for_axes( x_min, x_max )
         call fix_min_max_for_axes( y_min, y_max )
         call pgenv( x_min, x_max, y_min, y_max, just, colbar, xlabel_pos, &
                     clear=clear_main_pixmap_0 )

         ! ici, la fenêtre est entièrement vide

         if( PRINTING_EPS .and. win%axis_on ) then
            if( COMMENTS_IN_EPS ) then
               ibuf(1) = 0
               call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Box", 0 )
            end if
         end if
         if( PRINTING_PDF .and. win%axis_on ) then
            if( COMMENTS_IN_PDF ) then
               call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Box", 0 )
            end if
         end if
         call mf_win_draw_box( win_id )
         if( PRINTING_EPS .and. win%axis_on ) then
            if( COMMENTS_IN_EPS ) then
               ibuf(1) = 0
               call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Box", 0 )
            end if
         end if
         if( PRINTING_PDF .and. win%axis_on ) then
            if( COMMENTS_IN_PDF ) then
               call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Box", 0 )
            end if
         end if

      end if

      ! no_clipping is used from 'Pan' and 'PanAndZoom' for drawing in
      ! the large auxiliary pixmap...
      if( present(no_clipping) ) then
         no_clipping_0 = no_clipping
      else
         no_clipping_0 = .false.
      end if

      ! clipping at viewport for ALL grobjs (unless explicitly specified)
      if( PRINTING_EPS ) then
         call EPS_clip_on_viewport_beg()
      else if( PRINTING_PDF ) then
         call PDF_clip_on_viewport_beg()
      else ! X11 or NULL driver
         if( .not. no_clipping_0 ) then
            if( .not. CLIPPING_IN_AXES ) then
               ibuf(1) = 1 ! set clipping at viewport (used only in X11 driver)
               call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr )
               CLIPPING_IN_AXES = .true.
            end if
         end if
      end if

      if( MF_QR_in_aux_pixmap ) then
         ! This indicates that the redraw is done in the large auxiliary pixmap
         if( win%grid_on ) then
            ! Plotting grid
            if( BLACK_ON_WHITE == 1 ) then
               icol_gray = MFPLOT_LIGHT_GREY
            else
               icol_gray = MFPLOT_DARK_GREY
            end if
            if( win%axis_scale_x == 2 ) then
               xopt_log = .true.
            else
               xopt_log = .false.
            end if
            if( win%axis_scale_y == 2 ) then
               yopt_log = .true.
            else
               yopt_log = .false.
            end if
            call pgsch( win%axis_font_size * win%char_height_factor ) ! character height
            call pggrid_ec( xopt_log, yopt_log, win%minor_grid, icol_gray )
            ! reset to default line style (grid uses dashed lines)
            call grsls(1)
         end if
      end if

      draw_only_flag = .false.
      draw_after_flag = .false.

      grobj => win%grobj_head

      do ! loop for drawing GrObjs ############################################

         if( .not. associated(grobj) ) then
            exit
         end if
         ! WARNING, the following next association must be done now, because
         ! 'pghist' may remove the current 'grobj'!
         grobj_next => grobj%next

         cmd = grobj%struct%cmd

         ! Gets its internal handle and take a decision...
         hdle = grobj%struct%hdle

         if( draw_before_hdl /= 0 ) then
            ! As soon as we get this handle, must quit
            if( hdle == draw_before_hdl ) exit
         end if

         if( draw_only_hdl /= 0 ) then
            ! must draw only this handle
            if( hdle == draw_only_hdl ) then
               ! set a flag to exit the loop at the end
               draw_only_flag = .true.
            else
               grobj => grobj_next
               cycle
            end if
         end if

         if( draw_after_hdl /= 0 ) then
            ! Must wait to reach this handle, then draw all grobj after
            if( .not. draw_after_flag ) then
               if( hdle == draw_after_hdl ) then
                  draw_after_flag = .true.
               end if
               grobj => grobj_next
               cycle
            end if
         end if

         ! grobj is drawn only if its 'visible' property is TRUE;
         ! (but, in a PDF, it must be drawn if it is concerned by an
         !  "optional content")
         grobj_must_be_drawn = grobj%struct%visible
         if( PRINTING_PDF ) then
            if( grobj%struct%PDF_OC ) then
               grobj_must_be_drawn = .true.
            end if
         end if
         if( grobj_must_be_drawn ) then

            ! check for a PDF optional content (whatever the type of the grobj)
            if( PRINTING_PDF ) then
               PDF_OC_skip = .false.
               if( cmd == "xlabel" .or. cmd == "ylabel" .or.            &
                   cmd == "title"  .or. cmd == "legend" ) then
                  ! these commands will be processed in the second loop below
                  PDF_OC_skip = .true.
               end if
               if( grobj%struct%PDF_OC .and. .not. PDF_OC_skip ) then
                  ! insert a BDC tag in the PDF (Begin Marked Content)
                  ibuf(1) = grobj%struct%PDF_OC_num
                  ibuf(2) = grobj%struct%PDF_OC_mutex
                  ibuf(3) = grobj%struct%PDF_OC_mutex_default
                  call pdf_driver( 43, rbuf, ibuf, grobj%struct%PDF_OC_RBGroups_name, 0 )
                  ! additional information for super-groups
                  ibuf(1) = grobj%struct%PDF_OC_sg
                  call pdf_driver( 39, rbuf, ibuf, grobj%struct%PDF_OC_sg_name, 0 )
               end if
            end if

!### New unconditional comment write in EPS (begin), due to the user,
!    via routine msAddGrObjEPSComment().
if( PRINTING_EPS ) then
   if( grobj%struct%add_user_comment_in_EPS ) then
      ibuf(1) = 0
      call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf,     &
                       '%-- begin of GrObj: user comment = "' // &
                       trim(grobj%struct%user_comment_in_EPS) // '"', 0 )
   end if
end if

            select case( cmd )

               case( "xlabel" )

                  ! do nothing: must be drawn at the end, in a second loop

               case( "ylabel" )

                  ! do nothing: must be drawn at the end, in a second loop

               case( "title" )

                  ! do nothing: must be drawn at the end, in a second loop

               case( "legend" )

                  ! do nothing: the legend frames referenced by a handle
                  ! will be redraw at the end of the routine...

               case( "line" )

                  call mf_line_draw( grobj )

               case( "errorbar_x_line" )

                  call mf_errorbar_x_line_draw( grobj )

               case( "errorbar_y_line" )

                  call mf_errorbar_y_line_draw( grobj )

               case( "errorbar_xy_line" )

                  call mf_errorbar_xy_line_draw( grobj )

               case( "point" )

                  call mf_point_draw( grobj )

               case( "errorbar_x_pt" )

                  call mf_errorbar_x_pt_draw( grobj )

               case( "errorbar_y_pt" )

                  call mf_errorbar_y_pt_draw( grobj )

               case( "errorbar_xy_pt" )

                  call mf_errorbar_xy_pt_draw( grobj )

               case( "line+point" )

                  call mf_line_point_draw( grobj )

               case( "errorbar_x_line+pt" )

                  call mf_errorbar_x_line_pt_draw( grobj )

               case( "errorbar_y_line+pt" )

                  call mf_errorbar_y_line_pt_draw( grobj )

               case( "errorbar_xy_line+pt" )

                  call mf_errorbar_xy_line_pt_draw( grobj )

               case( "polygon" )

                  call mf_polygon_draw( grobj )

               case( "text" )

                  call mf_text_draw( grobj )

               case( "arrow" )

                  call mf_arrow_draw( grobj )

               case( "arrow_head_only" )

                  call mf_arrow_head_draw( grobj )

               case( "patch" )

                  call mf_patch_draw( grobj )

               case( "pcolor" )

                  call mf_pcolor_draw( grobj )

               case( "pcolor_spy" )

                  call mf_pcolor_spy_draw( grobj )

               case( "pcolor_proj" )

                  call mf_pcolor_proj_draw( grobj )

               case( "pcolor_mat_proj" )

                  call mf_pcolor_mat_proj_draw( grobj )

               case( "quiver" )

                  call mf_quiver_draw( grobj )

               case( "streamline" )

                  call mf_streamline_draw( grobj )

               case( "pcolor_spy_sparse" )

                  call mf_pcolor_spy_sparse_draw( grobj )

               case( "pcolor_spy_sparse_2" )

                  call mf_pcolor_spy_sparse_2_draw( grobj )

               case( "plot_spy_sparse" )

                  call mf_plot_spy_sparse_draw( grobj )

               case( "tri_pcolor" )

                  call mf_tri_pcolor_draw( grobj )

               case( "image" )

                  call mf_image_draw( grobj )

               case( "contour" )

                  call mf_contour_draw( grobj )

               case( "contour_filled" )

                  call mf_contourF_draw( grobj )

               case( "tri_contour" )

                  call mf_tri_contour_draw( grobj )

               case( "tri_contour_filled" )

                  call mf_tri_contourF_draw( grobj )

               case( "histogram" )

                  call mf_histogram_draw( grobj )

               case( "bar" )

                  call mf_bar_draw( grobj )

               case( "bar_groups_stacks" )

                  call mf_bar_groups_stacks_draw( grobj )

               case( "quadr_bezier" )

                  if( win%axis_scale_x /= 1 .or. win%axis_scale_y /= 1 ) then
                     write(STDERR,*) "(MUESLI mf_win_redraw:) info: cannot use log axis for Quadratic Bezier curves!"
                     call msMuesliTrace( pause="no" )
                     grobj => grobj%next

                     cycle
                  end if

                  call mf_quadr_bezier_draw( grobj )

               case( "cubic_bezier" )

                  if( win%axis_scale_x /= 1 .or. win%axis_scale_y /= 1 ) then
                     write(STDERR,*) "(MUESLI mf_win_redraw:) info: cannot use log axis for Cubic Bezier curves!"
                     call msMuesliTrace( pause="no" )
                     grobj => grobj%next

                     cycle
                  end if

                  call mf_cubic_bezier_draw( grobj )

               case( "set_clip_box" )

                  if( PRINTING_EPS ) then
                     if( COMMENTS_IN_EPS ) then
                        ibuf(1) = 0
                        call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Set_Clip_Box", 0 )
                     end if
                  end if
                  if( PRINTING_PDF ) then
                     if( COMMENTS_IN_PDF ) then
                        call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Set_Clip_Box", 0 )
                     end if
                  end if

                  call change_viewport( grobj%struct%abs_tab(1:4),      &
                                        win%viewport(1:4) )

                  if( PRINTING_EPS ) then
                     if( COMMENTS_IN_EPS ) then
                        ibuf(1) = 0
                        call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Set_Clip_Box", 0 )
                     end if
                  end if
                  if( PRINTING_PDF ) then
                     if( COMMENTS_IN_PDF ) then
                        call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Set_Clip_Box", 0 )
                     end if
                  end if

               case( "remove_clip_box" )

                  if( PRINTING_EPS ) then
                     if( COMMENTS_IN_EPS ) then
                        ibuf(1) = 0
                        call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Remove_Clip_Box", 0 )
                     end if
                  end if
                  if( PRINTING_PDF ) then
                     if( COMMENTS_IN_PDF ) then
                        call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Remove_Clip_Box", 0 )
                     end if
                  end if

                  call restore_viewport( win%viewport(1:4) )

                  if( PRINTING_EPS ) then
                     if( COMMENTS_IN_EPS ) then
                        ibuf(1) = 0
                        call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Remove_Clip_Box", 0 )
                     end if
                  end if
                  if( PRINTING_PDF ) then
                     if( COMMENTS_IN_PDF ) then
                        call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Remove_Clip_Box", 0 )
                     end if
                  end if

               case( "tri_fill" )

                  call mf_tri_fill_draw( grobj )

               case( "trimesh_by_tri" )

                  call mf_trimesh_by_tri_draw( grobj )

               case( "trimesh_by_fac" )

                  call mf_trimesh_by_fac_draw( grobj )

               case( "voronoi" )

                  call mf_plot_voronoi( grobj )

               case( "mesh_boundary_unstruct" )

                  call mf_boundary_mesh_unstruct_draw( grobj )

               case( "tri_quiver" )

                  call mf_tri_quiver_draw( grobj )

               case( "PLdomain" )

                  call mf_PlotPLdomain_draw( grobj )

               case default

                  write(STDERR,*) "(MUESLI mf_win_redraw:) internal ERROR : unknown cmd!"
                  write(STDERR,*) "                        cmd = ", trim(cmd)
                  call msMuesliTrace( pause ="yes" )

            end select ! type of grobj

            ! check for a PDF optional content (whatever the type of the grobj)
            if( PRINTING_PDF ) then
               if( grobj%struct%PDF_OC .and. .not. PDF_OC_skip ) then
                  ! insert a EMC tag in the PDF (End Marked Content)
                  ! record name and value (on|off) in pdf_driver memory
                  ibuf(1) = grobj%struct%PDF_OC_value
                  call pdf_driver( 44, rbuf, ibuf, grobj%struct%PDF_OC_name, 0 )
               end if
            end if

!### New unconditional comment write in EPS (end), due to the user,
!    via routine msAddGrObjEPSComment().
if( PRINTING_EPS ) then
   if( grobj%struct%add_user_comment_in_EPS ) then
      ibuf(1) = 0
      call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf,     &
                       '%-- end of GrObj: user comment = "' // &
                       trim(grobj%struct%user_comment_in_EPS) // '"', 0 )
   end if
end if

         end if ! visible on screen and in printed files

         if( draw_only_flag ) go to 99

         grobj => grobj_next

      end do ! loop for drawing GrObjs ########################################

      ! End of clipping at viewport for ALL grobjs
      if( PRINTING_EPS ) then
         call EPS_clip_on_viewport_end()
      else if( PRINTING_PDF ) then
         call PDF_clip_on_viewport_end()
      else ! X11 or NULL driver
         if( .not. no_clipping_0 ) then
            ibuf(1) = 0 ! no clipping (used only in X11 driver)
            call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr )
            CLIPPING_IN_AXES = .false.
         end if
      end if

      if( draw_only_usual_grobj ) go to 99

      if( draw_after_flag ) go to 99

      if( win%axis_on ) then

         if( PRINTING_EPS .or. PRINTING_PDF ) then
            ! Redraw the axis box, because colored pixels (e.g. from Pcolor)
            ! may have been drawn just over these black lines. It is now
            ! recommanded only for vector graphic devices.
            ! (another constraint is that there must not be any grobj not
            !  clipped)
            if( PRINTING_EPS ) then
               if( COMMENTS_IN_EPS ) then
                  call grterm
                  ibuf(1) = 0
                  call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Box (redraw axis lines)", 0 )
               end if
            end if

            if( PRINTING_PDF ) then
               if( COMMENTS_IN_PDF ) then
                  call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Box (redraw axis lines)", 0 )
               end if
               gr_pdf_color_intent = 1
            end if

            if( .not. win%at_least_one_grobj_not_clipped ) then
               call mf_redraw_axis_lines( win_id )
            end if

            if( PRINTING_EPS ) then
               if( COMMENTS_IN_EPS ) then
                  call grterm
                  ibuf(1) = 0
                  call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Box (redraw axis lines)", 0 )
               end if
            end if

            if( PRINTING_PDF ) then
               if( COMMENTS_IN_PDF ) then
                  call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Box (redraw axis lines)", 0 )
               end if
            end if

         end if

         ! XLabel
         if( associated(win%xlabel_grobj) ) then
            if( associated(win%xlabel_grobj%text) ) then
               len_text = size(win%xlabel_grobj%text)
            else
               len_text = 0
            end if
            if( len_text /= 0 ) then
               do j = 1, len_text
                  xlabel_tmp(j:j) = win%xlabel_grobj%text(j)
               end do
               gr_pdf_color_intent = 2 ! Fill
               call grsci(1) ! default foreground color
               call pgsch( win%label_font_size * win%char_height_factor ) ! character height
               if( win%axis_mode_xy ) then
                  xlabel_pos = 1
               else
                  xlabel_pos = 2
               end if
               if( PRINTING_EPS ) then
                  if( COMMENTS_IN_EPS ) then
                     ibuf(1) = 0
                     call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of X label", 0 )
                  end if
                  call pglab( xlabel_tmp(1:len_text), xlabel_pos, "", "" )
                  if( COMMENTS_IN_EPS ) then
                     ibuf(1) = 0
                     call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of X label", 0 )
                  end if
               else if( PRINTING_PDF ) then
                  if( COMMENTS_IN_PDF ) then
                     call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of X label", 0 )
                  end if
                  call pglab( xlabel_tmp(1:len_text), xlabel_pos, "", "" )
                  if( COMMENTS_IN_PDF ) then
                     call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of X label", 0 )
                  end if
               else
                  call pglab( xlabel_tmp(1:len_text), xlabel_pos, "", "" )
               end if
            end if
         end if

         ! YLabel
         if( associated(win%ylabel_grobj) ) then
            if( associated(win%ylabel_grobj%text) ) then
               len_text = size(win%ylabel_grobj%text)
            else
               len_text = 0
            end if
            if( len_text /= 0 ) then
               do j = 1, len_text
                  ylabel_tmp(j:j) = win%ylabel_grobj%text(j)
               end do
               gr_pdf_color_intent = 2 ! Fill
               call grsci(1) ! default foreground color
               call pgsch( win%label_font_size * win%char_height_factor ) ! character height
               if( PRINTING_EPS ) then
                  if( COMMENTS_IN_EPS ) then
                     ibuf(1) = 0
                     call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Y label", 0 )
                  end if
                  call pglab( "", 0, ylabel_tmp(1:len_text), "" )
                  if( COMMENTS_IN_EPS ) then
                     ibuf(1) = 0
                     call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Y label", 0 )
                  end if
               else if( PRINTING_PDF ) then
                  if( COMMENTS_IN_PDF ) then
                     call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Y label", 0 )
                  end if
                  call pglab( "", 0, ylabel_tmp(1:len_text), "" )
                  if( COMMENTS_IN_PDF ) then
                     call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Y label", 0 )
                  end if
               else
                  call pglab( "", 0, ylabel_tmp(1:len_text), "" )
               end if
            end if
         end if

         ! Title
         if( associated(win%title_grobj) ) then
            if( associated(win%title_grobj%text) ) then
               len_text = size(win%title_grobj%text)
            else
               len_text = 0
            end if
            if( len_text /= 0 ) then
               do j = 1, len_text
                  title_tmp(j:j) = win%title_grobj%text(j)
               end do
               gr_pdf_color_intent = 2 ! Fill
               call grsci(1) ! default foreground color
               call pgsch( win%title_font_size * win%char_height_factor ) ! character height
               if( PRINTING_EPS ) then
                  if( COMMENTS_IN_EPS ) then
                     ibuf(1) = 0
                     call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Title", 0 )
                  end if
                  call pglab( "", xlabel_pos, "", title_tmp(1:len_text) )
                  if( COMMENTS_IN_EPS ) then
                     ibuf(1) = 0
                     call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Title", 0 )
                  end if
               else if( PRINTING_PDF ) then
                  if( COMMENTS_IN_PDF ) then
                     call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Title", 0 )
                  end if
                  call pglab( "", xlabel_pos, "", title_tmp(1:len_text) )
                  if( COMMENTS_IN_PDF ) then
                     call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Title", 0 )
                  end if
               else
                  call pglab( "", xlabel_pos, "", title_tmp(1:len_text) )
               end if
            end if
         end if

      end if

      ! further test needed for the colorbar (see below)
      if( associated(win%xlabel_grobj) ) then
         if( associated(win%xlabel_grobj%text) ) then
            len_text = size(win%xlabel_grobj%text)
         else
            len_text = 0
         end if
      else
         len_text = 0
      end if
      if(len_text > 0 ) then
         xlabel_is_not_empty = .true.
      else
         xlabel_is_not_empty = .false.
      end if

      if( win%colorbar /= 0 ) then ! colorbar present
         if( PRINTING_EPS ) then
            if( COMMENTS_IN_EPS ) then
               ibuf(1) = 0
               call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Colorbar", 0 )
            end if
         end if
         if( PRINTING_PDF ) then
            if( COMMENTS_IN_PDF ) then
               call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Colorbar", 0 )
            end if
         end if
         call grsci(1) ! default foreground color
         call grslw( 1.0d0 ) ! default linewidth
         call grsls( 1 ) ! default line style
         ! Shift in y to encompass the ticks and the numerical labels
         ! (unit is axis_font_size); depends also on 'xy'/'ij' axis mode.
         if( win%colorbar_pos(1:1) == "b" ) then
            if( win%axis_mode_xy ) then
               disp = 2.75d0
               if( win%xlabel_exist ) then
                  ! additional shift to encompass the descriptive label
                  disp = disp + 1.5d0*(win%label_font_size/win%axis_font_size)
               end if
            else ! 'ij'
               disp = 2.0d0
            end if
         else ! "vert"
            disp = 2.25d0
         end if
         ! Very important: the axis font size must be selected just before
         !                 calling pgwedg.
         call pgsch( win%axis_font_size * win%char_height_factor )
         PGBOX_IN_COLORBAR = .true.
         call pgwedg( win%colorbar_pos, disp, 3.5d0,                    &
                      win%color_axes(1), win%color_axes(2),             &
                      win%colorbar_label, win%colorbar )
         PGBOX_IN_COLORBAR = .false.
         if( PRINTING_EPS ) then
            if( COMMENTS_IN_EPS ) then
               ibuf(1) = 0
               call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Colorbar", 0 )
            end if
         end if
         if( PRINTING_PDF ) then
            if( COMMENTS_IN_PDF ) then
               call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Colorbar", 0 )
            end if
         end if
      end if

      ! Legend frame(s) must be printed at the end, because they shouldn't
      ! be overprinted by axes, labels and title...
      ! First: case of standard legend.
      if( associated(win%legend) ) then

         gr_text_in_legend = .true.

         if( PRINTING_EPS .or. PRINTING_PDF ) then
            call redraw_legend_EPS_PDF(win_id)
         else ! X11
            if( .not. skip_legend_ano ) then
               call redraw_legend_X11(win_id)
            end if
         end if

         gr_text_in_legend = .false.

      end if

      ! Second: legend frames which are referenced by a handle.
      ! (a loop over GrObjs is required)
      grobj => win%grobj_head

      do
         if( .not. associated(grobj) ) then
            exit
         end if
         ! WARNING, the following next association must be done now, because
         ! 'pghist' may remove the current 'grobj'!
         grobj_next => grobj%next

         cmd = grobj%struct%cmd

         ! The GrObj is drawn only if its 'visible' property is TRUE;
         ! (but, in a PDF, it must be drawn if it is concerned by an
         !  "optional content")
         grobj_must_be_drawn = grobj%struct%visible
         if( PRINTING_PDF ) then
            if( grobj%struct%PDF_OC ) then
               grobj_must_be_drawn = .true.
            end if
         end if
         if( grobj_must_be_drawn ) then

            ! check for a PDF optional content (whatever the type of the grobj)
            if( PRINTING_PDF ) then
               PDF_OC_skip = .true.
               if( cmd == "xlabel" .or. cmd == "ylabel" .or.            &
                   cmd == "title"  .or. cmd == "legend" ) then
                  ! these commands will be processed in the second loop below
                  PDF_OC_skip = .false.
               end if
               if( grobj%struct%PDF_OC .and. .not. PDF_OC_skip ) then
                  ! insert a BDC tag in the PDF (Begin Marked Content)
                  ibuf(1) = grobj%struct%PDF_OC_num
                  ibuf(2) = grobj%struct%PDF_OC_mutex
                  ibuf(3) = grobj%struct%PDF_OC_mutex_default
                  call pdf_driver( 43, rbuf, ibuf, grobj%struct%PDF_OC_RBGroups_name, 0 )
                  ! additional information for super-groups
                  ibuf(1) = grobj%struct%PDF_OC_sg
                  call pdf_driver( 39, rbuf, ibuf, grobj%struct%PDF_OC_sg_name, 0 )
               end if
            end if

            select case( cmd )

               case( "xlabel" )

                  ! drawing all visible labels (it is the responsability of
                  ! the user to hide all but one...
                  len_text = size(grobj%struct%text)
                  if( len_text /= 0 ) then
                     do j = 1, len_text
                        xlabel_tmp(j:j) = grobj%struct%text(j)
                     end do
                     gr_pdf_color_intent = 2 ! Fill
                     call grsci(1) ! default foreground color
                     call pgsch( win%label_font_size * win%char_height_factor ) ! character height
                     if( win%axis_mode_xy ) then
                        xlabel_pos = 1
                     else
                        xlabel_pos = 2
                     end if
                     if( PRINTING_EPS ) then
                        if( COMMENTS_IN_EPS ) then
                           ibuf(1) = 0
                           call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of X label", 0 )
                        end if
                        call pglab( xlabel_tmp(1:len_text), xlabel_pos, "", "" )
                        if( COMMENTS_IN_EPS ) then
                           ibuf(1) = 0
                           call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of X label", 0 )
                        end if
                     else if( PRINTING_PDF ) then
                        if( COMMENTS_IN_PDF ) then
                           call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of X label", 0 )
                        end if
                        call pglab( xlabel_tmp(1:len_text), xlabel_pos, "", "" )
                        if( COMMENTS_IN_PDF ) then
                           call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of X label", 0 )
                        end if
                     else
                        call pglab( xlabel_tmp(1:len_text), xlabel_pos, "", "" )
                     end if
                  end if

               case( "ylabel" )

                  ! drawing all visible labels (it is the responsability of
                  ! the user to hide all but one...
                  len_text = size(grobj%struct%text)
                  if( len_text /= 0 ) then
                     do j = 1, len_text
                        ylabel_tmp(j:j) = grobj%struct%text(j)
                     end do
                     gr_pdf_color_intent = 2 ! Fill
                     call grsci(1) ! default foreground color
                     call pgsch( win%label_font_size * win%char_height_factor ) ! character height
                     if( PRINTING_EPS ) then
                        if( COMMENTS_IN_EPS ) then
                           ibuf(1) = 0
                           call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Y label", 0 )
                        end if
                        call pglab( "", 0, ylabel_tmp(1:len_text), "" )
                        if( COMMENTS_IN_EPS ) then
                           ibuf(1) = 0
                           call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Y label", 0 )
                        end if
                     else if( PRINTING_PDF ) then
                        if( COMMENTS_IN_PDF ) then
                           call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Y label", 0 )
                        end if
                        call pglab( "", 0, ylabel_tmp(1:len_text), "" )
                        if( COMMENTS_IN_PDF ) then
                           call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Y label", 0 )
                        end if
                     else
                        call pglab( "", 0, ylabel_tmp(1:len_text), "" )
                     end if
                  end if

               case( "title" )

                  ! drawing all visible labels (it is the responsability of
                  ! the user to hide all but one...
                  len_text = size(grobj%struct%text)
                  if( len_text /= 0 ) then
                     do j = 1, len_text
                        title_tmp(j:j) = grobj%struct%text(j)
                     end do
                     gr_pdf_color_intent = 2 ! Fill
                     call grsci(1) ! default foreground color
                     call pgsch( win%title_font_size * win%char_height_factor ) ! character height
                     if( PRINTING_EPS ) then
                        if( COMMENTS_IN_EPS ) then
                           ibuf(1) = 0
                           call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Title", 0 )
                        end if
                        call pglab( "", xlabel_pos, "", title_tmp(1:len_text) )
                        if( COMMENTS_IN_EPS ) then
                           ibuf(1) = 0
                           call eps_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Title", 0 )
                        end if
                     else if( PRINTING_PDF ) then
                        if( COMMENTS_IN_PDF ) then
                           call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- begin of Title", 0 )
                        end if
                        call pglab( "", xlabel_pos, "", title_tmp(1:len_text) )
                        if( COMMENTS_IN_PDF ) then
                           call pdf_driver( ADD_COMMENT_EPS_PDF, rbuf, ibuf, "%-- end of Title", 0 )
                        end if
                     else
                        call pglab( "", xlabel_pos, "", title_tmp(1:len_text) )
                     end if
                  end if

               case( "legend" )

                  gr_text_in_legend = .true.

                  if( PRINTING_EPS .or. PRINTING_PDF ) then
                     call redraw_legend_EPS_PDF(win_id,grobj%struct)
                  else ! X11
                     if( skip_legend_hdl /= grobj%struct%hdle ) then
                        call redraw_legend_X11( win_id, grobj%struct )
                     end if
                  end if

                  gr_text_in_legend = .false.

            end select ! type of grobj

            ! check for a PDF optional content (whatever the type of the grobj)
            if( PRINTING_PDF ) then
               if( grobj%struct%PDF_OC .and. .not. PDF_OC_skip ) then
                  ! insert a EMC tag in the PDF (End Marked Content)
                  ! record name and value (on|off) in pdf_driver memory
                  ibuf(1) = grobj%struct%PDF_OC_value
                  call pdf_driver( 44, rbuf, ibuf, grobj%struct%PDF_OC_name, 0 )
               end if
            end if

         end if ! visible on screen and in printed files

         grobj => grobj_next

      end do

      ! ici, la fenêtre est entièrement redessinée
 99   continue

      if( FGL_MFPLOT_BUFFER ) then
         MFPLOT_BUF_LEVEL = MFPLOT_BUF_LEVEL - 1
         call pgebuf()
      end if

      if( X11_DEVICE ) then
         ibuf(1) = 1 ! clipping at viewport
         call grexec( grgtyp, SET_CLIPPING, rbuf, ibuf, chr, lchr ) ! set clipping
         CLIPPING_IN_AXES = .true.
      end if

      if( device_has_cursor ) then
         itmp = gr_set_cursor_shape( MF_LEFT_ARROW_CURSOR )
      end if

   end subroutine mf_win_redraw
