module fgl_aux_2

   use mod_pgplot

   use mod_mfarray
   use mod_polyfun

#ifdef _SPREAD_MOD
!!   use mod_mfdebug
#endif

#ifndef _OPTIM
   use mod_fgl_mem_debug
#endif

   use mod_win_db

   implicit none

#ifndef _DEVLP
   private
#endif

   public :: MFPLOT_DEBUG

   private :: PrintMessage

   public :: X11_rect_dump_to_PS

   ! the following module variables are used for communication between
   ! 'PatchQuadCorePX_opaque' and 'irreg_bilinear_interp' routines
   integer*8 :: ibi_x21, ibi_y21, ibi_x32, ibi_y32,                     &
                ibi_x34, ibi_y34, ibi_x41, ibi_y41
   integer*8 :: ibi_AA, ibi_BB_cst1, ibi_BB_cst2, ibi_BB_cst3,          &
                ibi_BB_j, ibi_CC_j, ibi_s_j, ibi_t_j
   integer :: ibi_method
   real(kind=MF_DOUBLE) :: ibi_det
   integer, save :: ibi_col_max

   ! the derived type 'segment' and its head are used in some routines
   ! concerning the hidden-line removal algorithm, in pg2dproj.
   type :: segment
      real(kind=MF_DOUBLE) :: x1 = MF_NAN, y1 = MF_NAN ! first endpoint
      real(kind=MF_DOUBLE) :: x2 = MF_NAN, y2 = MF_NAN ! second endpoint
      type(segment), pointer :: next => null()
   end type

   ! head of the linked list of segments
   type(segment), pointer :: head

contains

#include "PS_PDF/PatchQuadCore_flat.inc"

#include "PS_PDF/PatchQuadCore_shad.inc"

#include "PS_PDF/PatchQuadMesh_shad.inc"

#include "PS_PDF/PatchRectCore_flat.inc"

#include "PS_PDF/PatchTriCore_flat.inc"

#include "PS_PDF/PatchTriCore_shad.inc"

#include "PS_PDF/PatchTriMesh_shad.inc"

#include "PS_PDF/X11_rect_dump.inc"

#include "Pix_aux.inc"

#include "pg2dproj/pg2dproj_x.inc"

#include "pg2dproj/pg2dproj_y.inc"

#include "pg2dproj/pg2dproj_matx.inc"

#include "pg2dproj/pg2dproj_maty.inc"

#include "pg2dproj/pg2dproj_aux.inc"

!_______________________________________________________________________
!
   subroutine PatchTriCore( x_pg_3, y_pg_3, c_pg_3, opacity,            &
                            flat, type_of_patch )

      real(kind=MF_DOUBLE), intent(in)           :: x_pg_3(3), y_pg_3(3)
      integer,              intent(in)           :: c_pg_3(3)
      real(kind=MF_DOUBLE), intent(in)           :: opacity
      logical,              intent(in), optional :: flat
      integer,              intent(in), optional :: type_of_patch
      !------ API end ------

      ! driver pour les cas : PX (X11 - mode pixel)
      !                       EPS (PostScript), PDF

      character(len=16) :: TYPE
      integer :: lchr, color, tp
      real(kind=MF_DOUBLE) :: opacity_s
      logical :: flat_color, draw_grid_0

   !------ end of declarations -- execution starts hereafter  ------
      if( opacity < 0.0d0 .or. 1.0d0 < opacity ) then
         call PrintMessage( "PatchTriCore", "W",                        &
                            "opacity must be in [0,1]!" )
         if( opacity < 0.0d0 ) opacity_s = 0.0d0
         if( opacity > 1.0d0 ) opacity_s = 1.0d0
      else
         opacity_s = opacity
      end if

      if( present(flat) ) then
         flat_color = flat
      else
         flat_color = .false.
      end if

      if( present(type_of_patch) ) then
         tp = type_of_patch
      else
         tp = 3
      end if

      call pgqinf( "TYPE", type, lchr )

      if( type == "EPS" .or. type == "PDF" ) then
         if( flat_color ) then
            color = c_pg_3(1) ! same other color
            call PatchTriCore_PS_PDF_flat( x_pg_3, y_pg_3, color,       &
                                           opacity=opacity_s )
         else
            ! using advanced 'shading' feature of PostScript and PDF
            call PatchTriCore_PS_PDF_shad( x_pg_3, y_pg_3, c_pg_3,      &
                                           type_of_patch=tp, opacity=opacity_s )
         end if
      else
         if( type == "XWINDOW" ) then ! if NULL device: do nothing
            call PatchTriCorePX( x_pg_3, y_pg_3, c_pg_3, opacity_s )
         end if
      endif

   end subroutine PatchTriCore
!_______________________________________________________________________
!
   subroutine PatchTriCorePX( x_pg_3, y_pg_3, c_pg_3, opacity )

      real(kind=MF_DOUBLE), intent(in) :: x_pg_3(3), y_pg_3(3)
      integer,              intent(in) :: c_pg_3(3)
      real(kind=MF_DOUBLE), intent(in) :: opacity
      !------ API end ------

      ! tracé en mode PIXELS sur un écran X11.
      !
      ! les routines 'patch' gèrent la transparence alpha.

      integer :: c(3)

      ! -- 4096 : max nb of pixels on one line...
      !           (ok for 4K resolution)
      real(kind=MF_DOUBLE) :: rbuf(1)
      integer   :: ibuf(4096), lchr
      character :: chr
      integer :: color_depth
      character(len=4) :: col_depth_char

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale
      integer :: u1, u2, v1, v2, orient_123
      real(kind=MF_DOUBLE) :: tmp, tl, tr

      integer :: ix(3), iy(3), i, j, ifirst, shift
      integer :: left(2), right(2), cl, cr, il, ir, j_min, j_max

      integer :: ix_clip_min, ix_clip_max, iy_clip_min, iy_clip_max

   !------ end of declarations -- execution starts hereafter  ------

      call grexec( grgtyp, GET_COL_DEPTH, rbuf, ibuf, chr, lchr )
      color_depth = ibuf(1)
      if( .not. (color_depth == 16 .or. color_depth == 24) ) then
         if( X11_DEVICE ) then
            write(col_depth_char,"(I0)") color_depth
            call PrintMessage( "PatchTriCorePX", "E",                   &
                               "color depth = " // col_depth_char,      &
                               "cannot handle this number of colors!",  &
                               "(currently: only 16 or 24 bits)" )
            return
         end if
      end if

      xorg = grxorg(pgid)   ! keep GR-variants for convert Wld to Dev coords
      yorg = gryorg(pgid)   ! (the GR-variants is Pan-aware, not the
      xscale = grxscl(pgid) !  PG-variants)
      yscale = gryscl(pgid)

      ! device coordinates
      ix(:) = nint( xorg + x_pg_3(:)*xscale )
      iy(:) = nint( yorg + y_pg_3(:)*yscale )
      c(:)  = c_pg_3(:)

      ! Numbering is modified in order to have:
      !
      !             1 +
      !              / \
      !             /   \             * triangle 1-2-3 is direct
      !            /     \
      !         2 +       \           * vertex 1 is the highest
      !            \__     \            (and most left if y(2)=y(1))
      !               \__   \
      !                  \__ \
      !                     \_\
      !                        + 3
      !
      ! The change must be done on device coordinates, because scaling
      ! factors pgxscl and pgyscl are not always positive.

      ! triangle 1-2-3 must be direct
      u1 = ix(2) - ix(1)
      u2 = iy(2) - iy(1)
      v1 = ix(3) - ix(1)
      v2 = iy(3) - iy(1)
      orient_123 = u1*v2 - u2*v1
      if( orient_123 < 0 ) then
         ! swap vertices 2 and 3
             i = ix(2)
         ix(2) = ix(3)
         ix(3) = i
             i = iy(2)
         iy(2) = iy(3)
         iy(3) = i
             i = c(2)
          c(2) = c(3)
          c(3) = i
      else if( orient_123 == 0 ) then
         call PrintMessage( "PatchTriCorePX", "I",                       &
                            "Degenerate triangle: discarded." )
         return
      end if

      ! search then the highest (in z) and most left vertex
      ifirst = 1
      do i = 2, 3
         if( iy(i) > iy(ifirst) ) then
            ifirst = i
         else if( iy(i) == iy(ifirst) ) then
            if( ix(i) < ix(ifirst) ) then
               ifirst = i
            end if
         end if
      end do
      ! circular permutation to have vertex 1 at the top-left place
      shift = ifirst - 1
      if( shift /= 0 ) then
         ix = cshift( ix, shift )
         iy = cshift( iy, shift )
          c = cshift(  c, shift )
      end if

      ix_clip_min = nint( grxmin(grcide) )
      ix_clip_max = nint( grxmax(grcide) )
      iy_clip_min = nint( grymin(grcide) )
      iy_clip_max = nint( grymax(grcide) )

      ! Quick return
      if( minval(ix(:)) > ix_clip_max ) return
      if( maxval(ix(:)) < ix_clip_min ) return
      if( minval(iy(:)) > iy_clip_max ) return
      if( maxval(iy(:)) < iy_clip_min ) return

      ! drawing -----

      call pgbbuf()

      ! Convention for X11: usual coords x:i and y:j

      j_max = iy(1)
      j_min = min( iy(2), iy(3) )

      j = j_max
      left = [ 1, 2 ]
      ! particular case for beginning
      if( iy(3) == iy(1) ) then
         ! right side is horizontal
         il = ix(1)
         cl = c(1)
         ir = ix(3)
         cr = c(3)
         call draw_pix_line( j, il, ir, cl, cr )
         j = j - 1
         right = [ 3, 2 ]
      else
         right = [ 1, 3 ]
      end if

      do

         if( j == j_min .and. iy(3) == iy(2) ) then

            ! last line is horizontal
            il = ix(2)
            cl = c(2)
            ir = ix(3)
            cr = c(3)
            call draw_pix_line( j, il, ir, cl, cr )

         else

            ! relative position on left segment (tl in [0,1])
            tl = dble( j - iy(left(1)) ) / ( iy(left(2)) - iy(left(1)) )
            il = nint( ix(left(1)) + tl*( ix(left(2)) - ix(left(1)) ) )
            cl = nint( c(left(1)) + tl*( c(left(2)) - c(left(1)) ) )

            ! relative position on right segment (tr in [0,1])
            tr = dble( j - iy(right(1)) ) / ( iy(right(2)) - iy(right(1)) )
            ir = nint( ix(right(1)) + tr*( ix(right(2)) - ix(right(1)) ) )
            cr = nint( c(right(1)) + tr*( c(right(2)) - c(right(1)) ) )

            call draw_pix_line( j, il, ir, cl, cr )

         end if

         if( j <= j_min ) exit

         if( j == iy(left(2)) ) then
            left(1) = left(2)
            left(2) = left(2) + 1   ! turn anticlockwise
         end if

         if( j == iy(right(2)) ) then
            right(1) = right(2)
            right(2) = right(2) - 1 ! turn clockwise
         end if

         j = j - 1

      end do

      call pgebuf() ! end of drawing -----

   contains
      !---------------------------------------------------------
      subroutine draw_pix_line( j, il, ir, cl, cr )

         integer, intent(in) :: j, il, ir, cl, cr

         ! low-level routine to draw a line of colored pixel on X11
         !       j : vertical position
         !   il, ir: beginning (left) and end (right) of horizontal position
         !   cl, cr: beginning (left) and end (right) of color index

         ! with possible transparency (opacity)

         integer :: npix, i_rgb, i_rgb_new
         integer :: npix0, il0, ir0
         integer :: cxy

         if( ir < ix_clip_min ) return
         if( il > ix_clip_max ) return

         il0 = max( il, ix_clip_min )
         ir0 = min( ir, ix_clip_max )

         ibuf(2) = il0
         ibuf(3) = j
         npix = ir - il + 1 ! even if il==ir, one pixel is drawn
         npix0 = ir0 - il0 + 1
         if( npix < 0 .or. npix0 < 0 ) then
            write(STDERR,*) "(MUESLI:) draw_pix_line: internal error!"
            write(STDERR,*) "          npix or npix0 is negative."
            write(STDERR,*) "          (bad triangle orientation or integer overflow?)"
            pause "only for debugging purpose"
            stop
         end if
         ibuf(1) = npix0 ! nb of pixels to get or to put

         if( opacity /= 1. ) then
            ! read RGB val. of pixels already drawn on screen
            call grexec( grgtyp, GET_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )
         end if

         ! fill buffer with color indices
         do i = il0, ir0
            if( npix == 1 ) then
               ! avoid division by zero
               cxy = cl
            else
               cxy = nint( cl + (cr-cl)*dble(i-il)/(npix-1) )
            end if
            if( opacity /= 1.0d0 ) then
               ! making transparency : switch to RGB
               i_RGB = ibuf(4+i-il0)
               call alpha_transp( color_depth, cxy, opacity,            &
                                  i_RGB, i_RGB_new )
               ibuf(4+i-il0) = i_RGB_new
            else
               ! 'color index'
               ibuf(4+i-il0) = cxy
            end if
         enddo

         if( opacity /= 1.0d0 ) then
            ! device drawing (pixels via RGB val.)
            call grexec( grgtyp, PUT_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )
         else
            ! device drawing (pixels via color index)
            call grexec( grgtyp, PUT_LINE_PIX_CI, rbuf, ibuf, chr, lchr )
         end if

      end subroutine
      !---------------------------------------------------------
   end subroutine PatchTriCorePX
!_______________________________________________________________________
!
   subroutine PatchRectCore( x_pg_4, y_pg_4, c_pg_4, opacity,           &
                             flat, type_of_patch )

      real(kind=MF_DOUBLE), intent(in)           :: x_pg_4(4), y_pg_4(4)
      integer,              intent(in)           :: c_pg_4(4)
      real(kind=MF_DOUBLE), intent(in)           :: opacity
      logical,              intent(in), optional :: flat
      integer,              intent(in), optional :: type_of_patch
      !------ API end ------

      ! driver pour les cas : PX (X11 - mode pixel)
      !                       EPS (PostScript), PDF

      character(len=16) :: TYPE
      integer :: lchr, color, tp
      real(kind=MF_DOUBLE) :: opacity_s
      logical :: flat_color, x_inverted, y_inverted, cell_outside
      integer :: status
      character(len=3) :: file_format
      real(kind=MF_DOUBLE) :: xx_min, xx_max, yy_min, yy_max

      real(kind=MF_DOUBLE) :: x1, x2, y1, y2

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      if( opacity < 0.0d0 .or. 1.0d0 < opacity ) then
         call PrintMessage( "PatchRectCore", "W",                       &
                            "opacity must be in [0,1]!" )
         if( opacity < 0.0d0 ) opacity_s = 0.0d0
         if( opacity > 1.0d0 ) opacity_s = 1.0d0
      else
         opacity_s = opacity
      end if

      if( present(flat) ) then
         flat_color = flat
      else
         flat_color = .false.
      end if

      if( present(type_of_patch) ) then
         tp = type_of_patch
      else
         tp = 3
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%current_axes(1) < win%current_axes(2) ) then
         x_inverted = .false.
      else
         x_inverted = .true.
      end if

      if( win%current_axes(3) < win%current_axes(4) ) then
         y_inverted = .false.
      else
         y_inverted = .true.
      end if

      call pgqinf( "TYPE", type, lchr )

      if( type == "EPS" .or. type == "PDF" ) then

         cell_outside = .false.

         x_left_QR  = win%current_axes(1)
         x_right_QR = win%current_axes(2)
         y_bottom_QR = win%current_axes(3)
         y_top_QR    = win%current_axes(4)

         xx_min = minval( x_pg_4(:) )
         xx_max = maxval( x_pg_4(:) )
         yy_min = minval( y_pg_4(:) )
         yy_max = maxval( y_pg_4(:) )
         if( x_inverted ) then
            if( xx_max < x_right_QR .or. x_left_QR < xx_min ) then
               cell_outside = .true.
            end if
         else
            if( xx_max < x_left_QR .or. x_right_QR < xx_min ) then
               cell_outside = .true.
            end if
         end if
         if( y_inverted ) then
            if( yy_max < y_top_QR .or. y_bottom_QR < yy_min ) then
               cell_outside = .true.
            end if
         else
            if( yy_max < y_bottom_QR .or. y_top_QR < yy_min ) then
               cell_outside = .true.
            end if
         end if

         if( .not. cell_outside ) then
            if( flat_color ) then
               color = c_pg_4(1) ! same other colors
               if( opacity_s == 1.0d0 ) then
                  x1 = x_pg_4(1)
                  if( x_pg_4(2) /= x1 ) then
                     x2 = x_pg_4(2)
                  else
                     x2 = x_pg_4(3)
                  end if
                  y1 = y_pg_4(1)
                  if( y_pg_4(2) /= y1 ) then
                     y2 = y_pg_4(2)
                  else
                     y2 = y_pg_4(3)
                  end if
                  call PatchRectCore_PS_PDF_flat( x1, x2, y1, y2, color)
               else
                  call PatchQuadCore_PS_PDF_flat( x_pg_4, y_pg_4, color, opacity_s)
               end if
            else
               ! using advanced 'shading' feature of PostScript and PDF
               call PatchQuadCore_PS_PDF_shad( x_pg_4, y_pg_4, c_pg_4,  &
                                               type_of_patch=tp,        &
                                               opacity=opacity_s )

            end if
         end if

      else if( type == "XWINDOW" ) then
         if( flat_color .and. opacity_s == 1.0d0 ) then
            color = c_pg_4(1) ! same other colors
            call grsci( color )
            x1 = x_pg_4(1)
            if( x_pg_4(2) /= x1 ) then
               x2 = x_pg_4(2)
            else
               x2 = x_pg_4(3)
            end if
            y1 = y_pg_4(1)
            if( y_pg_4(2) /= y1 ) then
               y2 = y_pg_4(2)
            else
               y2 = y_pg_4(3)
            end if
            call grrect( x1, y1, x2, y2, filled=.true. )
         else
            call PatchRectCorePX_shad( x_pg_4, y_pg_4, c_pg_4, opacity_s )
         end if
      end if
      ! if NULL device: do nothing

   end subroutine PatchRectCore
!_______________________________________________________________________
!
   subroutine PatchRectCorePX_shad( x_pg_4, y_pg_4, c_pg_4, opacity )

      real(kind=MF_DOUBLE), intent(in) :: x_pg_4(4), y_pg_4(4)
      integer,              intent(in) :: c_pg_4(4)
      real(kind=MF_DOUBLE), intent(in) :: opacity
      !------ API end ------

      ! tracé en mode PIXELS sur un écran X11.
      !
      ! les routines 'patch' gèrent la transparence alpha.

      ! -- 4096 : max nb of pixels on one line...
      !           (ok for 4K resolution)
      real(kind=MF_DOUBLE) :: rbuf(1)
      integer   :: ibuf(4096), lchr
      character :: chr

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale, x_mil, y_mil
      real(kind=MF_DOUBLE) :: x, y, xi, yi

      integer :: i, j, il, ir, il0, ir0, npix, npix0, cxy
      integer :: ix(4), iy(4), ic(4), perm(4)
      integer :: i_deb, i_fin, j_deb, j_fin
      integer :: i_rgb, i_rgb_new
      integer :: ix_clip_min, ix_clip_max, iy_clip_min, iy_clip_max

      character(len=4) :: col_depth_char

   !------ end of declarations -- execution starts hereafter  ------
!!print *, "PatchRectCorePX_shad"

      if( opacity < 0. .or. 1. < opacity ) then
         call PrintMessage( "PatchRectCorePX", "W",                     &
                            "opacity must be in [0,1]!" )
      end if

      if( X11_COLOR_DEPTH == -1 ) then
         call grexec( grgtyp, GET_COL_DEPTH, rbuf, ibuf, chr, lchr )
         X11_COLOR_DEPTH = ibuf(1)
      end if
      if( .not. (X11_COLOR_DEPTH == 16 .or.                             &
                 X11_COLOR_DEPTH == 24) ) then
         if( X11_DEVICE ) then
            write(col_depth_char,"(I0)") X11_COLOR_DEPTH
            call PrintMessage( "PatchRectCorePX", "E",                  &
                               "color depth = " // col_depth_char,      &
                               "cannot handle this number of colors!",  &
                               "(currently: only 16 or 24 bits)" )
            return
         end if
      end if

      xorg = grxorg(pgid)   ! keep GR-variants for convert Wld to Dev coords
      yorg = gryorg(pgid)   ! (the GR-variants is Pan-aware, not the
      xscale = grxscl(pgid) !  PG-variants)
      yscale = gryscl(pgid)

      ! device coordinates in pixels
      ix(:) = nint( xorg + x_pg_4(:)*xscale )
      iy(:) = nint( yorg + y_pg_4(:)*yscale )

      ! Numbering is modified in order to obtain the following config.:
      !
      !            4 +---------+ 3
      !              |         |
      !              |         |
      !              |         |
      !              |         |
      !            1 +---------+ 2
      !
      ! The change must be done on device coordinates, because scaling
      ! factors pgxscl and pgyscl are not always positive.

      x_mil = 0.25d0*sum(ix(:))
      y_mil = 0.25d0*sum(iy(:))

      do i = 1, 4
         if( ix(i) < x_mil .and. iy(i) < y_mil ) then
            perm(i) = 1
         else if( ix(i) > x_mil .and. iy(i) < y_mil ) then
            perm(i) = 2
         else if( ix(i) > x_mil .and. iy(i) > y_mil ) then
            perm(i) = 3
         else if( ix(i) < x_mil .and. iy(i) > y_mil ) then
            perm(i) = 4
         else
           call PrintMessage( "PatchRectCorePX", "I",                   &
                              "The rectangle seems degenerated!" )
           return
         end if
      enddo
      ix(perm) = ix(:)
      iy(perm) = iy(:)
      ic(perm) = c_pg_4(:)

      ix_clip_min = nint( grxmin(grcide) )
      ix_clip_max = nint( grxmax(grcide) )
      iy_clip_min = nint( grymin(grcide) )
      iy_clip_max = nint( grymax(grcide) )

      ! Quick return
      if( min(ix(1),ix(2)) > ix_clip_max ) return
      if( max(ix(1),ix(2)) < ix_clip_min ) return
      if( min(iy(1),iy(4)) > iy_clip_max ) return
      if( max(iy(1),iy(4)) < iy_clip_min ) return

      call pgbbuf()

      ! Drawing of the rectangle

      il = ix(1)
      ir = ix(2)
      j_deb = iy(1)
      j_fin = iy(4)

      ! Fix to avoid the overlap of pixels during the assembling.
      ir    = max( il+1, ir-1 )
      j_fin = max( j_deb+1, j_fin-1 )

      do j = j_deb, j_fin

         il0 = max( il, ix_clip_min )
         ir0 = min( ir, ix_clip_max )

         ibuf(2) = il0
         ibuf(3) = j
         npix = ir - il + 1 ! even if il==ir, one pixel is drawn
         npix0 = ir0 - il0 + 1
         ibuf(1) = npix0 ! nb of pixels to get or to put
         y = dble(j-j_deb)/(j_fin-j_deb)

         if( opacity /= 1.0d0 ) then
            ! get pixels line (RGB val.) already displayed on screen
            call grexec( grgtyp, GET_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )
         end if

         do i = il0, ir0
            x = dble(i-il)/(ir-il)
            ! bilinear interpolation
            cxy = nint( (1.0d0-x)*(ic(1)+y*(ic(4)-ic(1))) +             &
                                x*(ic(2)+y*(ic(3)-ic(2))) )
            if( opacity /= 1.0d0 ) then
               ! création de la transparence : on passe en RGB
               i_RGB = ibuf(4+i-il0)
               call alpha_transp( X11_COLOR_DEPTH, cxy, opacity,        &
                                  i_RGB, i_RGB_new )
               ibuf(4+i-il0) = i_RGB_new
            else
               ! on reste en 'color index'
               ibuf(4+i-il0) = cxy
            end if
         enddo

         if( opacity /= 1.0d0 ) then
            ! pixels line (via RGB val.)
            call grexec( grgtyp, PUT_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )
         else
            ! pixels line (via color index)
            call grexec( grgtyp, PUT_LINE_PIX_CI, rbuf, ibuf, chr, lchr )
         end if

      enddo

      call pgebuf()

   end subroutine PatchRectCorePX_shad
!_______________________________________________________________________
!
   subroutine PatchQuadCore( x_pg_4, y_pg_4, c_pg_4, opacity,           &
                             flat, type_of_patch )

      real(kind=MF_DOUBLE), intent(in)           :: x_pg_4(4), y_pg_4(4)
      integer,              intent(in)           :: c_pg_4(4)
      real(kind=MF_DOUBLE), intent(in)           :: opacity
      logical,              intent(in), optional :: flat
      integer,              intent(in), optional :: type_of_patch
      !------ API end ------

      ! driver pour les cas : PX (X11 - mode pixel)
      !                       EPS (PostScript), PDF
      !       flat = T : on peut imprimer sans passer par les pixels
      !       flat = F : il faut imprimer via les pixels

      character(len=16) :: TYPE
      integer :: lchr, color, tp
      real(kind=MF_DOUBLE) :: opacity_s
      logical :: flat_color, x_inverted, y_inverted, cell_outside
      integer :: status
      character(len=3) :: file_format
      real(kind=MF_DOUBLE) :: xx_min, xx_max, yy_min, yy_max

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      if( opacity < 0.0d0 .or. 1.0d0 < opacity ) then
         call PrintMessage( "PatchQuadCore", "W",                        &
                            "opacity must be in [0,1]!" )
         if( opacity < 0.0d0 ) opacity_s = 0.0d0
         if( opacity > 1.0d0 ) opacity_s = 1.0d0
      else
         opacity_s = opacity
      end if

      if( present(flat) ) then
         flat_color = flat
      else
         flat_color = .false.
      end if

      if( present(type_of_patch) ) then
         tp = type_of_patch
      else
         tp = 3
      end if

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%current_axes(1) < win%current_axes(2) ) then
         x_inverted = .false.
      else
         x_inverted = .true.
      end if

      if( win%current_axes(3) < win%current_axes(4) ) then
         y_inverted = .false.
      else
         y_inverted = .true.
      end if

      call pgqinf( "TYPE", type, lchr )

      if( type == "EPS" .or. type == "PDF" ) then

         cell_outside = .false.

         x_left_QR  = win%current_axes(1)
         x_right_QR = win%current_axes(2)
         y_bottom_QR = win%current_axes(3)
         y_top_QR    = win%current_axes(4)

         xx_min = minval( x_pg_4(:) )
         xx_max = maxval( x_pg_4(:) )
         yy_min = minval( y_pg_4(:) )
         yy_max = maxval( y_pg_4(:) )
         if( x_inverted ) then
            if( xx_max < x_right_QR .or. x_left_QR < xx_min ) then
               cell_outside = .true.
            end if
         else
            if( xx_max < x_left_QR .or. x_right_QR < xx_min ) then
               cell_outside = .true.
            end if
         end if
         if( y_inverted ) then
            if( yy_max < y_top_QR .or. y_bottom_QR < yy_min ) then
               cell_outside = .true.
            end if
         else
            if( yy_max < y_bottom_QR .or. y_top_QR < yy_min ) then
               cell_outside = .true.
            end if
         end if

         if( .not. cell_outside ) then
            if( flat_color ) then
               color = c_pg_4(1) ! same other color
               call PatchQuadCore_PS_PDF_flat( x_pg_4, y_pg_4, color,      &
                                               opacity_s )
            else
               ! using advanced 'shading' feature of PostScript and PDF
               call PatchQuadCore_PS_PDF_shad( x_pg_4, y_pg_4, c_pg_4,     &
                                               type_of_patch=tp,           &
                                               opacity=opacity_s )

            end if
         end if

      else if( type == "XWINDOW" ) then
!### TODO:
!!         if( flat_color .and. opacity == 1.0d0 ) then
!!            color = c_pg_4(1) ! same other colors
!!            call PatchQuadCorePX_flat( x_pg_4, y_pg_4, color )
!!         else
            call PatchQuadCorePX( x_pg_4, y_pg_4, c_pg_4, opacity_s )
!!         end if
      end if
      ! if NULL device: do nothing

   end subroutine PatchQuadCore
!_______________________________________________________________________
!
   subroutine PatchQuadCorePX( x_pg_4, y_pg_4, c_pg_4, opacity )

      real(kind=MF_DOUBLE), intent(in) :: x_pg_4(4), y_pg_4(4)
      integer,              intent(in) :: c_pg_4(4)
      real(kind=MF_DOUBLE), intent(in) :: opacity
      !------ API end ------

      ! tracé en mode PIXELS sur un écran X11.
      !
      ! les routines 'patch' gèrent la transparence alpha.

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale
      real(kind=MF_DOUBLE) :: tl, tr

      ! -- 4096 : max nb of pixels on one line...
      !           (ok for 4K resolution)
      real(kind=MF_DOUBLE) :: rbuf(1)
      integer   :: ibuf(4096), lchr
      character :: chr
      integer :: color_depth
      character(len=4) :: col_depth_char

      integer :: ix(4), iy(4), ic(4), i, j, ifirst, shift, itmp
      integer :: left(2), right(2), cl, cr, il, ir, j_min, j_max

      ! need to have high range because the product involves integer
      ! coords to the power 4.
      integer*8 :: orient_123, orient_234, orient_product

      integer :: ix_clip_min, ix_clip_max, iy_clip_min, iy_clip_max
      integer :: ix_min, ix_max, iy_min, iy_max

   !------ end of declarations -- execution starts hereafter  ------

      call grexec( grgtyp, GET_COL_DEPTH, rbuf, ibuf, chr, lchr )
      color_depth = ibuf(1)
      if( .not. (color_depth == 16 .or. color_depth == 24) ) then
         if( X11_DEVICE ) then
            write(col_depth_char,"(I0)") color_depth
            call PrintMessage( "PatchQuadCorePX", "E",                  &
                               "color depth = " // col_depth_char,      &
                               "cannot handle this number of colors!",  &
                               "(currently: only 16 or 24 bits)" )
            return
         end if
      end if

      xorg = grxorg(pgid)   ! keep GR-variants for convert Wld to Dev coords
      yorg = gryorg(pgid)   ! (the GR-variants is Pan-aware, not the
      xscale = grxscl(pgid) !  PG-variants)
      yscale = gryscl(pgid)

      ! device coordinates
      ix(:) = nint( xorg + x_pg_4(:)*xscale )
      iy(:) = nint( yorg + y_pg_4(:)*yscale )

      ! Numbering is modified in order to have:
      !
      !               1 +
      !                / \
      !               /   \           * quadrangle 1-2-3-4 is direct
      !              /     \
      !           2 +       \         * vertex 1 is the highest
      !              \       + 4        (and most left if y(2)=y(1))
      !               \     /
      !                \   /
      !                 \ /
      !                3 +
      !
      ! The change must be done on device coordinates, because scaling
      ! factors pgxscl and pgyscl are not always positive.

      ix_clip_min = nint( grxmin(grcide) )
      ix_clip_max = nint( grxmax(grcide) )
      iy_clip_min = nint( grymin(grcide) )
      iy_clip_max = nint( grymax(grcide) )

      ix_min = minval(ix(:))
      ix_max = maxval(ix(:))
      iy_min = minval(iy(:))
      iy_max = maxval(iy(:))

      ! Quick return
      if( ix_min > ix_clip_max ) return
      if( ix_max < ix_clip_min ) return
      if( iy_min > iy_clip_max ) return
      if( iy_max < iy_clip_min ) return

!### TODO: Avant d'éviter certains dysfonctionnement aux forts niveaux
!          de zoom, on pourrait détecter si le carré
!          (ix_clip_min, ix_clip_max, iy_clip_min, iy_clip_max) est
!          à l'intérieur du quadrangle 1-2-3-4 (test éventuellement
!          décomposé en deux tests sur les triangles 1-2-3 et 1-3-4) ;
!          dans ce cas, si les couleurs des quatres coins est la même
!          ou très proche (cela va dépendre de la densité de la colorbar)
!          alors on remplit simplement le carré du clip avec un aplat
!          de couleur !

      ! copy data
      ic(:) = c_pg_4(:)

      ! Orientation of triangles 1-2-3 and 2-3-4 must be the same.
      orient_123 = (ix(2)-ix(1))*(iy(3)-iy(1)) - (iy(2)-iy(1))*(ix(3)-ix(1))
      orient_234 = (ix(3)-ix(2))*(iy(4)-iy(2)) - (iy(3)-iy(2))*(ix(4)-ix(2))
      orient_product = orient_123*orient_234

      if( abs(orient_product) == 0 ) then
         call PrintMessage( "PatchQuadCorePX", "I",                     &
                            "Degenerate quadrangle." )
      else if( orient_product < 0 ) then
         ! swap vertices 3 and 4
          itmp = ix(3)
         ix(3) = ix(4)
         ix(4) = itmp
          itmp = iy(3)
         iy(3) = iy(4)
         iy(4) = itmp
          itmp = ic(3)
         ic(3) = ic(4)
         ic(4) = itmp
      end if

      ! triangle 1-2-3 must be direct
      orient_123 = (ix(2)-ix(1))*(iy(3)-iy(1)) - (iy(2)-iy(1))*(ix(3)-ix(1))
      if( orient_123 < 0 ) then
         ! swap vertices 2 and 4
          itmp = ix(2)
         ix(2) = ix(4)
         ix(4) = itmp
          itmp = iy(2)
         iy(2) = iy(4)
         iy(4) = itmp
          itmp = ic(2)
         ic(2) = ic(4)
         ic(4) = itmp
      else if( orient_123 == 0 ) then
        call PrintMessage( "PatchQuadCorePX", "I",                      &
                           "Degenerate quadrangle." )
      end if

      ! search then the highest (in z) and most left vertex
      ifirst = 1
      do i = 2, 4
         if( iy(i) > iy(ifirst) ) then
            ifirst = i
         else if( iy(i) == iy(ifirst) ) then
            if( ix(i) < ix(ifirst) ) then
               ifirst = i
            end if
         end if
      end do
      ! circular permutation to have vertex 1 at the top-left place
      shift = ifirst - 1
      if( shift /= 0 ) then
         ix = cshift( ix, shift )
         iy = cshift( iy, shift )
         ic = cshift( ic, shift )
      end if

      call prepare_global_ibi( ix, iy )

      ! Store the maximum value of color; it will be used in case of error.
      ibi_col_max = maxval( ic(:) )

      ! drawing -----

      call pgbbuf()

! color transformation of (x,y) -> color ?

      ! Convention for X11: usual coords x:i and y:j

      j_max = iy(1)
      j_min = min( iy(2), iy(3), iy(4) )

      j = j_max
      left = [ 1, 2 ]
      ! particular case for beginning
      if( iy(4) == iy(1) ) then
         ! right side is horizontal
         il = ix(1)
         cl = ic(1)
         ir = ix(4)
         cr = ic(4)
         call draw_pix_line_2( j, il, ir, cl, cr )
         j = j - 1
         right = [ 4, 3 ]
      else
         right = [ 1, 4 ]
      end if

      do

         if( j == j_min ) then
            ! last line is horizontal?
            if( iy(3) == iy(2) ) then
               il = ix(2)
               cl = ic(2)
               ir = ix(3)
               cr = ic(3)
               if( il <= ir ) then
                  call draw_pix_line_2( j, il, ir, cl, cr )
               end if
            else if( iy(4) == iy(3) ) then
               il = ix(3)
               cl = ic(3)
               ir = ix(4)
               cr = ic(4)
               if( il <= ir ) then
                  call draw_pix_line_2( j, il, ir, cl, cr )
               end if
            end if

         else

            ! relative position on left segment (tl in [0,1])
            tl = dble( j - iy(left(1)) ) / dble( iy(left(2)) - iy(left(1)) )
            il = nint( ix(left(1)) + tl*( ix(left(2)) - ix(left(1)) ) )
            cl = nint( ic(left(1)) + tl*( ic(left(2)) - ic(left(1)) ) )

            ! relative position on right segment (tr in [0,1])
            tr = dble( j - iy(right(1)) ) / dble( iy(right(2)) - iy(right(1)) )
            ir = nint( ix(right(1)) + tr*( ix(right(2)) - ix(right(1)) ) )
            cr = nint( ic(right(1)) + tr*( ic(right(2)) - ic(right(1)) ) )

            ! When the zoom level is too high, il may be greater than ir,
            ! leading to an error in the called routine...
            if( il <= ir ) then
               call draw_pix_line_2( j, il, ir, cl, cr )
            else
print *, " cl, cr = ", cl, cr
            end if

         end if

         if( j <= j_min ) exit

         if( j == iy(left(2)) ) then
            left(1) = left(2)
            left(2) = left(2) + 1   ! turn anticlockwise
         end if

         if( j == iy(right(2)) ) then
            right(1) = right(2)
            right(2) = right(2) - 1 ! turn clockwise
         end if

         j = j - 1

      end do

      call pgebuf() ! end of drawing -----

   contains
      !---------------------------------------------------------
      subroutine draw_pix_line_2( j, il, ir, cl, cr )

         integer, intent(in) :: j, il, ir, cl, cr

         ! low-level routine to draw a line of colored pixel on X11
         !       j : vertical position
         !   il, ir: beginning (left) and end (right) of horizontal position
         !   cl, cr: beginning (left) and end (right) of color index

         ! with possible transparency

         integer :: npix, ii, jj, k, i_rgb, i_rgb_new, npix0, il0, ir0
         integer :: cxy
!!print "(A,I0,A,I0)", "PatchQuadCorePX: draw_pix_line: il = ", il, ", ir = ", ir

         if( ir < ix_clip_min ) return
         if( il > ix_clip_max ) return

         il0 = max( il, ix_clip_min )
         ir0 = min( ir, ix_clip_max )

         jj = j - iy(1)
         call prepare_local_ibi( jj )

         ibuf(2) = il0
         ibuf(3) = j
         npix = ir - il + 1 ! even if il==ir, one pixel is drawn
         npix0 = ir0 - il0 + 1
         if( npix < 0 .or. npix0 < 0 ) then
            write(STDERR,*) "(MUESLI:) draw_pix_line: internal error!"
            write(STDERR,*) "          npix or npix0 is negative."
            write(STDERR,*) "          (bad triangle orientation or integer overflow?)"
print *, "DEBUG: il, ir = ", il, ir
print *, "       il0, ir0 = ", il0, ir0
            pause "only for debugging purpose"
            stop
         end if
         ibuf(1) = npix0 ! nb of pixels to get or to put

         if( opacity /= 1.0d0 ) then
            ! read RGB val. of pixels already drawn on screen
            call grexec( grgtyp, GET_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )
         end if

         ! fill buffer with color indices
         do k = 1, npix0
            i = il0 + (k-1)
            if( i == il ) then
               cxy = cl
            else if( i == ir ) then
               cxy = cr
            else
               ii = i - ix(1)
               cxy = nint( irreg_bilinear_interp( ix, iy, ic, ii, jj ) )
            end if
            if( opacity /= 1. ) then
               ! making transparency : switch to RGB
               i_RGB = ibuf(3+k)
               call alpha_transp( color_depth, cxy, opacity,           &
                                  i_RGB, i_RGB_new )
               ibuf(3+k) = i_RGB_new
            else
               ! 'color index'
               ibuf(3+k) = cxy
            end if
         enddo

         if( opacity /= 1.0d0 ) then
            ! device drawing (pixels via RGB val.)
            call grexec( grgtyp, PUT_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )
         else
            ! device drawing (pixels via color index)
            call grexec( grgtyp, PUT_LINE_PIX_CI, rbuf, ibuf, chr, lchr )
         end if

      end subroutine
      !---------------------------------------------------------
   end subroutine PatchQuadCorePX
!_______________________________________________________________________
!
   subroutine pg_quadr_bezier( nctrl, xctrl, yctrl, linestyle )

      use bezier, only: quadratic_bezier

      implicit none

      integer,              intent(in) :: nctrl
      real(kind=mf_double), intent(in) :: xctrl(nctrl), yctrl(nctrl)
      integer,              intent(in) :: linestyle
      !------ API end ------

      !-- draw a quadratic Bézier curve (defined by its control points)
      !
      ! The curve may contains an arbitrary number of Bézier segments
      ! (each : 3 ctrl pnts).
      ! Moreover, the curve is supposed to be continuous; hence, the length
      ! of the previous coord vectors must be of the form : 2*k+1.
      !
      ! Primitive routine to draw Bézier segments, via the MFPLOT routine
      ! pgline. Hence, the curve is drawn using the current setting of
      ! attributes color-index, line-style, and line-width. The curve is
      ! clipped at the edge of the window. For implementing this features,
      ! the sub-curves may be non continuous.
      !
      ! For pixel-oriented devices, automatic subdivision of each segment
      ! are done by `quadratic_bezier', a routine of the 'bezier' f90 module
      ! (cf. below).
      !
      ! Arguments :
      ! NCTRL  (input) : number of control-points.
      ! XCTRL  (input) : world x-coordinates of the control-points.
      ! YCTRL  (input) : world y-coordinates of the control-points.
      !
      !-- uses `quadratic_bezier' which subdivide, if necessary, each
      !   initial segment.

      real(kind=MF_DOUBLE), pointer :: pa(:)
      integer :: pa_size
      real(kind=MF_DOUBLE) :: ctrl(0:5), ctrl_cub(0:7)
      integer :: i, ii, n, n_seg, k, offset

      real(kind=MF_DOUBLE), allocatable :: xpts(:), ypts(:)
      character(len=6) :: pgvalue
      integer :: length

      character(len=80) :: inline

      logical :: contains_nan

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character(len=20) :: chr

      integer, parameter :: STDERR = 0

      real(kind=MF_DOUBLE) :: xoff, xlen, yoff, ylen
      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale

   !------ end of declarations -- execution starts hereafter  ------

      call pgqinf( "STATE", pgvalue, length )
      if( pgvalue == "CLOSED" ) then
         write(0,*) "*** ERROR (pg_quadr_bezier:) MFPLOT device not open!"
         return
      end if

      ! Check the total number of control points
      n_seg = NCTRL - 1
      if( mod(n_seg,2) /= 0 ) then
         write(0,*) "*** ERROR (pg_quadr_bezier:) bad dim. for args!"
         write(0,*) "    -> number of points must be of the form : 2*k+1."
         return
      end if
      ! Number of segments
      n_seg = n_seg / 2

      ! Clipping rectangular area (in device coords)
      xoff = pgxvp(pgid)
      yoff = pgyvp(pgid)
      xlen = pgxlen(pgid)
      ylen = pgylen(pgid)

      xorg = grxorg(pgid)   ! keep GR-variants for convert Wld to Dev coords
      yorg = gryorg(pgid)   ! (the GR-variants is Pan-aware, not the
      xscale = grxscl(pgid) !  PG-variants)
      yscale = gryscl(pgid)

      call pgqinf( "TYPE", pgvalue, length )
      if( pgvalue == "EPS" ) then

         call gresc("q")

         if( linestyle < 1 .or. 4 < linestyle ) then
            write(STDERR,*) "(MUESLI:) pg_quadr_bezier: internal error!"
            write(STDERR,*) "          unknown value for EPS: linestyle = ", linestyle
            pause "only for debugging purpose"
            stop
         end if

         ibuf(1) = linestyle
         call grexec( grgtyp, SET_LINE_STYLE, rbuf, ibuf, chr, lchr )

         ! Set clipping path in device
         write(inline,100) nint(xoff), nint(yoff),                      &
                           nint(xoff+xlen), nint(yoff),                 &
                           nint(xoff+xlen), nint(yoff+ylen),            &
                           nint(xoff), nint(yoff+ylen)
 100     format( I0, " ", I0, " m ", I0, " ", I0, " l ",                &
                 I0, " ", I0, " l ", I0, " ", I0, " l" )
         call gresc("N ")
         call gresc( trim(inline) )
         call gresc("h clip")

         ! Write each segment directly in the EPS file
         do k = 1, n_seg

            offset = 2*(k-1)

            ctrl(0) = xctrl( offset + 1 )
            ctrl(1) = yctrl( offset + 1 )
            ctrl(2) = xctrl( offset + 2 )
            ctrl(3) = yctrl( offset + 2 )
            ctrl(4) = xctrl( offset + 3 )
            ctrl(5) = yctrl( offset + 3 )

            ! No drawing if any value in ctrl(0:5) contains a NaN
            contains_nan = .false.
            do i = 0, 5
#if defined _INTEL_IFC
               if( isnan( ctrl(i) ) ) then
#else
               if( ctrl(i) /= ctrl(i) ) then
#endif
                  contains_nan = .true.
               end if
            end do
            if( contains_nan ) cycle

            ! convert the quadratic segment to a cubic one (exact formula)
            ! (from: https://fontforge.org/docs/techref/bezier.html#converting-truetype-to-postscript)
            ctrl_cub(0) = ctrl(0)
            ctrl_cub(1) = ctrl(1)
            ctrl_cub(2) = ctrl(0) + 2.0d0/3.0d0*(ctrl(2)-ctrl(0))
            ctrl_cub(3) = ctrl(1) + 2.0d0/3.0d0*(ctrl(3)-ctrl(1))
            ctrl_cub(4) = ctrl(4) + 2.0d0/3.0d0*(ctrl(2)-ctrl(4))
            ctrl_cub(5) = ctrl(5) + 2.0d0/3.0d0*(ctrl(3)-ctrl(5))
            ctrl_cub(6) = ctrl(4)
            ctrl_cub(7) = ctrl(5)

            ! Here: world-coords!
            call pgbezier( ctrl_cub )

         end do

         call gresc("Q")
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.

      else if( pgvalue == "PDF" ) then

         call gresc("q") ! = gsave

         if( linestyle < 1 .or. 4 < linestyle ) then
            write(STDERR,*) "(MUESLI:) pg_quadr_bezier: internal error!"
            write(STDERR,*) "          unknown value for PDF: linestyle = ", linestyle
            pause "only for debugging purpose"
            stop
         end if

         ibuf(1) = linestyle
         call grexec( grgtyp, SET_LINE_STYLE, rbuf, ibuf, chr, lchr )

         ! Set clipping path in device.
         write(inline,100) nint(xoff), nint(yoff),                      &
                           nint(xoff+xlen), nint(yoff),                 &
                           nint(xoff+xlen), nint(yoff+ylen),            &
                           nint(xoff), nint(yoff+ylen)
         call gresc( trim(inline) )
         call gresc("h W n") ! closepath, clip, no fill or stroke

         ! Write each segment directly in the PDF file
         do k = 1, n_seg

            offset = 2*(k-1)

            ctrl(0) = xctrl( offset + 1 )
            ctrl(1) = yctrl( offset + 1 )
            ctrl(2) = xctrl( offset + 2 )
            ctrl(3) = yctrl( offset + 2 )
            ctrl(4) = xctrl( offset + 3 )
            ctrl(5) = yctrl( offset + 3 )

            ! No drawing if any value in ctrl(0:5) contains a NaN
            contains_nan = .false.
            do i = 0, 5
#if defined _INTEL_IFC
               if( isnan( ctrl(i) ) ) then
#else
               if( ctrl(i) /= ctrl(i) ) then
#endif
                  contains_nan = .true.
               end if
            end do
            if( contains_nan ) cycle

            ! convert the quadratic segment to a cubic one (exact formula)
            ! (from: https://fontforge.org/docs/techref/bezier.html#converting-truetype-to-postscript)
            ctrl_cub(0) = ctrl(0)
            ctrl_cub(1) = ctrl(1)
            ctrl_cub(2) = ctrl(0) + 2.0d0/3.0d0*(ctrl(2)-ctrl(0))
            ctrl_cub(3) = ctrl(1) + 2.0d0/3.0d0*(ctrl(3)-ctrl(1))
            ctrl_cub(4) = ctrl(4) + 2.0d0/3.0d0*(ctrl(2)-ctrl(4))
            ctrl_cub(5) = ctrl(5) + 2.0d0/3.0d0*(ctrl(3)-ctrl(5))
            ctrl_cub(6) = ctrl(4)
            ctrl_cub(7) = ctrl(5)

            ! Here: world-coords!
            call pgbezier( ctrl_cub )

         end do

         call gresc("S Q") ! = grestore
!### inutile, seule le clipping a changé
!!         LAST_LINEWIDTH_IS_VALID = .false.
!!         LAST_LINESTYLE_IS_VALID = .false.
!!         LAST_FONT_ATTRIB_IS_VALID = .false.

      else ! X11 or NULL driver

         ! Subdivisions for other devices (i.e. polygonization)

         call grsls(linestyle) ! set line style

         ! Loop on Bézier segments
         do k = 1, n_seg

            ! Convert in pixels (device coords)
            offset = 2*(k-1)

            ctrl(0) = nint( xctrl( offset + 1 )*xscale + xorg )
            ctrl(1) = nint( yctrl( offset + 1 )*yscale + yorg )
            ctrl(2) = nint( xctrl( offset + 2 )*xscale + xorg )
            ctrl(3) = nint( yctrl( offset + 2 )*yscale + yorg )
            ctrl(4) = nint( xctrl( offset + 3 )*xscale + xorg )
            ctrl(5) = nint( yctrl( offset + 3 )*yscale + yorg )

            ! Quick return
            if( maxval(ctrl(0:4:2)) < grxmin(grcide) ) cycle
            if( minval(ctrl(0:4:2)) > grxmax(grcide) ) cycle
            if( maxval(ctrl(1:5:2)) < grymin(grcide) ) cycle
            if( minval(ctrl(1:5:2)) > grymax(grcide) ) cycle

            ! No drawing if any value in ctrl(0:5) contains a NaN
            contains_nan = .false.
            do i = 0, 5
#if defined _INTEL_IFC
               if( isnan( ctrl(i) ) ) then
#else
               if( ctrl(i) /= ctrl(i) ) then
#endif
                  contains_nan = .true.
               end if
            end do
            if( contains_nan )  cycle

            ! Clipping is done in all device drivers!
            call quadratic_bezier( ctrl, pa, pa_size )

            n = pa_size/2
            allocate( xpts(n), ypts(n) )
            do i = 0, pa_size-1, 2
               ii = i/2 + 1
               ! Return to world coordinates
               xpts(ii) = ( pa(i)   - xorg )/xscale
               ypts(ii) = ( pa(i+1) - yorg )/yscale
            end do

            deallocate( pa )

            call pgline( n, xpts, ypts )

            deallocate( xpts, ypts )

         end do

      end if

   end subroutine pg_quadr_bezier
!_______________________________________________________________________
!
   subroutine pg_cubic_bezier( nctrl, xctrl, yctrl, linestyle )

      use bezier, only: cubic_bezier

      implicit none

      integer,              intent(in) :: nctrl
      real(kind=mf_double), intent(in) :: xctrl(nctrl), yctrl(nctrl)
      integer,              intent(in) :: linestyle
      !------ API end ------

      !-- draw a cubic Bézier curve (defined by its control points)
      !
      ! The curve may contains an arbitrary number of Bézier segments
      ! (each : 4 ctrl pnts).
      ! Moreover, the curve is supposed to be continuous; hence, the length
      ! of the previous coord vectors must be of the form : 3*k+1.
      !
      ! Primitive routine to draw Bézier segments, via the MFPLOT routine
      ! pgline. Hence, the curve is drawn using the current setting of
      ! attributes color-index, line-style, and line-width. The curve is
      ! clipped at the edge of the window. For implementing this features,
      ! the sub-curves may be non continuous.
      !
      ! For pixel-oriented devices, automatic subdivision of each segment
      ! are done by `cubic_bezier', a routine of the 'bezier' f90 module
      ! (cf. below).
      !
      ! Arguments :
      ! NCTRL  (input) : number of control-points.
      ! XCTRL  (input) : world x-coordinates of the control-points.
      ! YCTRL  (input) : world y-coordinates of the control-points.
      !
      !-- uses `cubic_bezier' which subdivide, if necessary, each
      !   initial segment.

      real(kind=MF_DOUBLE), pointer :: pa(:)
      integer :: pa_size
      real(kind=MF_DOUBLE) :: ctrl(0:7)
      integer :: i, ii, n, n_seg, k, offset

      real(kind=MF_DOUBLE), allocatable :: xpts(:), ypts(:)
      character(len=6) :: pgvalue
      integer :: length

      character(len=80) :: inline

      logical :: contains_nan

      double precision :: rbuf(1)
      integer :: ibuf(1), lchr
      character(len=20) :: chr

      integer, parameter :: STDERR = 0

      real(kind=MF_DOUBLE) :: xoff, xlen, yoff, ylen
      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale

   !------ end of declarations -- execution starts hereafter  ------

      call pgqinf( "STATE", pgvalue, length )
      if( pgvalue == "CLOSED" ) then
         write(0,*) "*** ERROR (pg_cubic_bezier:) MFPLOT device not open!"
         return
      end if

      ! Check the total number of control points
      n_seg = NCTRL - 1
      if( mod(n_seg,3) /= 0 ) then
         write(0,*) "*** ERROR (pg_cubic_bezier:) bad dim. for args!"
         write(0,*) "    -> number of points must be of the form : 3*k+1."
         return
      end if
      ! Number of segments
      n_seg = n_seg / 3

      ! Clipping rectangular area (in device coords)
      xoff = pgxvp(pgid)
      yoff = pgyvp(pgid)
      xlen = pgxlen(pgid)
      ylen = pgylen(pgid)

      xorg = grxorg(pgid)   ! keep GR-variants for convert Wld to Dev coords
      yorg = gryorg(pgid)   ! (the GR-variants is Pan-aware, not the
      xscale = grxscl(pgid) !  PG-variants)
      yscale = gryscl(pgid)

      call pgqinf( "TYPE", pgvalue, length )
      if( pgvalue == "EPS" ) then

         call gresc("q")

         if( linestyle < 1 .or. 4 < linestyle ) then
            write(STDERR,*) "(MUESLI:) pg_cubic_bezier: internal error!"
            write(STDERR,*) "          unknown value for EPS: linestyle = ", linestyle
            pause "only for debugging purpose"
            stop
         end if

         ibuf(1) = linestyle
         call grexec( grgtyp, SET_LINE_STYLE, rbuf, ibuf, chr, lchr )

         ! Set clipping path in device
         write(inline,100) nint(xoff), nint(yoff),                      &
                           nint(xoff+xlen), nint(yoff),                 &
                           nint(xoff+xlen), nint(yoff+ylen),            &
                           nint(xoff), nint(yoff+ylen)
 100     format( I0, " ", I0, " m ", I0, " ", I0, " l ",                &
                 I0, " ", I0, " l ", I0, " ", I0, " l" )
         call gresc("N ")
         call gresc( trim(inline) )
         call gresc("h clip")

         ! Write each segment directly in the EPS file
         do k = 1, n_seg

            offset = 3*(k-1)

            ctrl(0) = xctrl( offset + 1 )
            ctrl(1) = yctrl( offset + 1 )
            ctrl(2) = xctrl( offset + 2 )
            ctrl(3) = yctrl( offset + 2 )
            ctrl(4) = xctrl( offset + 3 )
            ctrl(5) = yctrl( offset + 3 )
            ctrl(6) = xctrl( offset + 4 )
            ctrl(7) = yctrl( offset + 4 )

            ! No drawing if any value in ctrl(0:7) contains a NaN
            contains_nan = .false.
            do i = 0, 7
#if defined _INTEL_IFC
               if( isnan( ctrl(i) ) ) then
#else
               if( ctrl(i) /= ctrl(i) ) then
#endif
                  contains_nan = .true.
               end if
            end do
            if( contains_nan ) cycle

            ! Here: world-coords!
            call pgbezier( ctrl )

         end do

         call gresc("Q")
         LAST_COLOR_IS_VALID = .false.
         LAST_LINEWIDTH_IS_VALID = .false.
         LAST_LINESTYLE_IS_VALID = .false.
         LAST_FONT_ATTRIB_IS_VALID = .false.

      else if( pgvalue == "PDF" ) then

         call gresc("q") ! = gsave

         if( linestyle < 1 .or. 4 < linestyle ) then
            write(STDERR,*) "(MUESLI:) pg_cubic_bezier: internal error!"
            write(STDERR,*) "          unknown value for PDF: linestyle = ", linestyle
            pause "only for debugging purpose"
            stop
         end if

         ibuf(1) = linestyle
         call grexec( grgtyp, SET_LINE_STYLE, rbuf, ibuf, chr, lchr )

         ! Set clipping path in device.
         write(inline,100) nint(xoff), nint(yoff),                      &
                           nint(xoff+xlen), nint(yoff),                 &
                           nint(xoff+xlen), nint(yoff+ylen),            &
                           nint(xoff), nint(yoff+ylen)
         call gresc( trim(inline) )
         call gresc("h W n") ! closepath, clip, no fill or stroke

         ! Write each segment directly in the PDF file
         do k = 1, n_seg

            offset = 3*(k-1)

            ctrl(0) = xctrl( offset + 1 )
            ctrl(1) = yctrl( offset + 1 )
            ctrl(2) = xctrl( offset + 2 )
            ctrl(3) = yctrl( offset + 2 )
            ctrl(4) = xctrl( offset + 3 )
            ctrl(5) = yctrl( offset + 3 )
            ctrl(6) = xctrl( offset + 4 )
            ctrl(7) = yctrl( offset + 4 )

            ! No drawing if any value in ctrl(0:7) contains a NaN
            contains_nan = .false.
            do i = 0, 7
#if defined _INTEL_IFC
               if( isnan( ctrl(i) ) ) then
#else
               if( ctrl(i) /= ctrl(i) ) then
#endif
                  contains_nan = .true.
               end if
            end do
            if( contains_nan ) cycle

            ! Here: world-coords!
            call pgbezier( ctrl )

         end do

         call gresc("S Q") ! = grestore
!### inutile, seule le clipping a changé
!!         LAST_LINEWIDTH_IS_VALID = .false.
!!         LAST_LINESTYLE_IS_VALID = .false.
!!         LAST_FONT_ATTRIB_IS_VALID = .false.

      else ! X11 or NULL driver

         ! Subdivisions for other devices (i.e. polygonization)

         call grsls(linestyle) ! set line style

         ! Loop on Bézier segments
         do k = 1, n_seg

            ! Convert in pixels (device coords)
            offset = 3*(k-1)

            ctrl(0) = nint( xctrl( offset + 1 )*xscale + xorg )
            ctrl(1) = nint( yctrl( offset + 1 )*yscale + yorg )
            ctrl(2) = nint( xctrl( offset + 2 )*xscale + xorg )
            ctrl(3) = nint( yctrl( offset + 2 )*yscale + yorg )
            ctrl(4) = nint( xctrl( offset + 3 )*xscale + xorg )
            ctrl(5) = nint( yctrl( offset + 3 )*yscale + yorg )
            ctrl(6) = nint( xctrl( offset + 4 )*xscale + xorg )
            ctrl(7) = nint( yctrl( offset + 4 )*yscale + yorg )

            ! Quick return
            if( maxval(ctrl(0:6:2)) < grxmin(grcide) ) cycle
            if( minval(ctrl(0:6:2)) > grxmax(grcide) ) cycle
            if( maxval(ctrl(1:7:2)) < grymin(grcide) ) cycle
            if( minval(ctrl(1:7:2)) > grymax(grcide) ) cycle

            ! No drawing if any value in ctrl(0:7) contains a NaN
            contains_nan = .false.
            do i = 0, 7
#if defined _INTEL_IFC
               if( isnan( ctrl(i) ) ) then
#else
               if( ctrl(i) /= ctrl(i) ) then
#endif
                  contains_nan = .true.
               end if
            end do
            if( contains_nan )  cycle

            ! Clipping is done in all device drivers!
            call cubic_bezier( ctrl, pa, pa_size )

            n = pa_size/2
            allocate( xpts(n), ypts(n) )
            do i = 0, pa_size-1, 2
               ii = i/2 + 1
               ! Return to world coordinates
               xpts(ii) = ( pa(i)   - xorg )/xscale
               ypts(ii) = ( pa(i+1) - yorg )/yscale
            end do

            deallocate( pa )

            call pgline( n, xpts, ypts )

            deallocate( xpts, ypts )

         end do

      end if

   end subroutine pg_cubic_bezier
!_______________________________________________________________________
!
   function will_be_drawn_in_pdf( grobj ) result( bool )

      type(grobj_elem) :: grobj
      logical          :: bool
      !------ API end ------

      character(len=20) :: cmd
      logical :: x_inverted, y_inverted, obj_outside
      real(kind=MF_DOUBLE) :: xx_min, xx_max, yy_min, yy_max

      type(mf_win_info), pointer :: win

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      if( win%current_axes(1) < win%current_axes(2) ) then
         x_inverted = .false.
      else
         x_inverted = .true.
      end if

      if( win%current_axes(3) < win%current_axes(4) ) then
         y_inverted = .false.
      else
         y_inverted = .true.
      end if

      x_left_QR  = win%current_axes(1)
      x_right_QR = win%current_axes(2)
      y_bottom_QR = win%current_axes(3)
      y_top_QR    = win%current_axes(4)

      cmd = grobj%struct%cmd
      select case( cmd )
         case( "patch" )
            obj_outside = .false.
            xx_min = minval( grobj%struct%abs_tab(:) )
            xx_max = maxval( grobj%struct%abs_tab(:) )
            yy_min = minval( grobj%struct%ord_tab(:) )
            yy_max = maxval( grobj%struct%ord_tab(:) )
            if( x_inverted ) then
               if( xx_max < x_right_QR .or. x_left_QR < xx_min ) then
                  obj_outside = .true.
               end if
            else
               if( xx_max < x_left_QR .or. x_right_QR < xx_min ) then
                  obj_outside = .true.
               end if
            end if
            if( y_inverted ) then
               if( yy_max < y_top_QR .or. y_bottom_QR < yy_min ) then
                  obj_outside = .true.
               end if
            else
               if( yy_max < y_bottom_QR .or. y_top_QR < yy_min ) then
                  obj_outside = .true.
               end if
            end if
            bool = .not. obj_outside
         case default
            print "(/,A)", "(MUESLI:) FGL: will_be_drawn_in_pdf: internal error."
            print "(A)",   "          -> grobj type not processed!"
            pause "for debugging purpose only"
            stop
      end select

   end function will_be_drawn_in_pdf
!_______________________________________________________________________
!
end module fgl_aux_2
