module fgl

   ! Part of MUESLI Graphic Library
   ! Copyright É. Canot 2004-2025 -- IPR/CNRS

   use mod_pgplot

   use mod_plot2d

#ifdef _SPREAD_MOD
   use mod_grobj

   use mod_axes

   use mod_window
#endif

   implicit none

   public :: MFPLOT_DEBUG

#ifndef _SPREAD_MOD
   ! from mod_mfdebug
   private :: mf_message_level

   ! from mod_mfaux
   private :: seq_def, func_ptr, &
              rank_1_to_2_real8, rank_1_to_2_cmplx, rank_2_to_1_real8, &
              rank_2_to_1_cmplx, index_in_vector, term_col, build_int_seq, &
              build_tri_conn, find_in_face_n, tsearch, &
              is_in_triangle, adj_triangle, diag_length, &
              digit_round, no_duplicates, to_lower, to_upper, find_unit, &
              mf_max_omitNaN, mf_max_includeNaN, &
              mf_min_omitNaN, mf_min_includeNaN, &
              mf_maxval_omitNaN, mf_maxval_includeNaN, &
              mf_minval_omitNaN, mf_minval_includeNaN, &
              ms_maxval_loc_omitNaN, ms_maxval_loc_includeNaN, &
              ms_minval_loc_omitNaN, ms_minval_loc_includeNaN, &
              full_chk_der_ode, full_chk_der_dae, &
              param_transf

   ! Sometimes, the following routine must be made public for
   ! my prototypes...
   ! (here: merge_1 and merge_2 in .../merging open contours/triangular mesh)
   private :: next_node_and_face_on_boundary

   private :: quick_sort_1_int, quick_sort_1, quick_sort_3

   ! from mod_mfarray
   private :: PrintMessage

   ! from mod_ieee
   private :: int8 ! because it may clashes with iso_fortran_env module.

   ! from mod_core
   private :: msSilentRelease, &
              set_status_restr_to_false

   ! from mod_sparse
   private :: mf_cholmod_amd, mf_cholmod_colamd, mf_cholmod_given, &
              mf_cholmod_metis, mf_cholmod_natural, mf_cholmod_nesdis

   private :: mf_blas_lib_strlen, f90readline_max_length, false, true, &
              fundam_name, gft_prec, gft_r16, gft_r4, gft_r8, kind_1, &
              kind_8, mf_address, mf_arnoldi_iter_max, mf_divbyzero_exc, &
              mf_dt_bool, mf_dt_cmplx, mf_dt_dble, mf_dt_empty, &
              mf_dt_perm_vec, mf_dt_sp_bool, mf_dt_sp_cmplx, &
              mf_endian_native, mf_endian_swap, mf_inf_single, &
              mf_invalid_exc, mf_ln_10, mf_long_int, mf_nan_single, &
              mf_overflow_exc, mf_pn_max_limit, mf_realmax_single, &
              mf_single, mf_tab, mf_uf_long, mf_underflow_exc, &
              mf_usual_excepts, num_base_units, one_kind_1, &
              prop_all_unknown, prop_equal_prop, rat_0, rat_1, rat_2, &
              rat_3, rat_4, rat_m1, rat_m2, rat_m3, rat_num_prec, &
              umfpack_scale, umfpack_scale_none, umfpack_status, &
              umfpack_strategy, umfpack_strategy_symmetric, &
              umfpack_strategy_used, umfpack_warning_singular_matrix, &
              undupli, unhide_prop, unique_entries, unit_zero_dim, &
              unknown, utf8_encoding, varying_string, verif_adim, &
              vs_elem_is_blank, vs_elem_is_same, weak_row_sorted, &
              win_pos_db_name, xercnt, xerhlt, xermsg, xerprn, xersve, &
              xgetua

   private :: xmua, xmua_cmplx_cmplx, xmua_cmplx_real, xmua_real_cmplx, &
              xsetf, xtrcol, xtrcol_cmplx, xtrcols, xtrcols_cmplx, &
              xtrrow, xtrrow_cmplx, yyp, zabs, zacai, zacon, zairy, &
              zasyi, zbesh, zbesi, zbesj, zbesk, zbesy, zbinu, zbiry, &
              zbknu, zbuni, zbunk, zdiv, zero_kind_1, zexp, zgetv0, zkscl, &
              zlog, zmlri, zmlt, zmout, znaitr, znapps, znaup2, znaupd, &
              zneigh, zneupd, zngets, zrati, zs1s2, zseri, zshch, zsortc, &
              zsqrt, zstatn, zuchk, zunhj, zuni1, zuni2, zunik, zunk1, &
              zunk2, zuoik, zvout, zvpinv, zwrsk

   ! from fgl_aux_2
   private :: segment, &
              PatchTriCore, &
              PatchRectCore, &
              Get_Color_Depth, &
              X11_rect_dump, &
              GetOnePX, &
              correct_X11_color, &
              pg2dproj_x, pg2dproj_y, &
              pg2dproj_maty, &
              head
#endif

   private :: x11_driver_num, eps_driver_num, null_driver_num, &
              pdf_driver_num, maxemx, maxemy, &
              mf_dev_type_number, mf_max_cursor_index, mfplot_dark_grey, &
              mfplot_light_grey, mfplot_quasi_background, &
              mfplot_short_max, mfplot_quasi_white, mfplot_quasi_black, &
              rect_draw, ci_high_max, col_cycle_tab_1, col_cycle_tab_2, &
              col_cycle_tab_3, col_cycle_tab_4, default_font_width, &
              default_nb_colors, mf_closed_hand_cursor, mf_crosshair_cursor, &
              mf_left_arrow_cursor, mf_resize_cursor, &
              mf_user1_cursor, mf_user2_cursor, mf_watch_cursor, &
              mf_win_height_def, mf_win_nb_max, mf_win_width_def, &
              mf_win_x_def, mf_win_x_offset, mf_win_y_def, mf_win_y_offset, &
              mf_zoom_cursor, ncolors, will_be_drawn_in_pdf, &
              x11_color_depth, x11_device, x11_rect_dump_to_ps

   ! avoid the call of MFPLOT routines directly by the user program...
   ! from 'mod_grplot':

   ! module variables and parameter:
   private :: grimax, grfnmx, grcide, grgtyp, grpltd, grstat, &
              grunit, grfnln, grtype, grxmxa, grymxa, grstyl, grccol, &
              grcmrk, grmnci, grmxci, grxmin, grymin, grxmax, &
              grymax, grwidt, grxpre, grypre, grxorg, gryorg, grxscl, &
              gryscl, grcfac, grpxpi, grpypi, grfile, &
              grgcap, gr_subscript_scaling, gr_text_in_legend, &
              gr_minus_sign_math_mode, EPS_driver_font_begin, &
              PDF_driver_font_begin, MFPLOT_DIR, NB_MAX_FONTS, &
              PS_Std_Fonts_presence, EnglishBT_embedded, font_metrics, &
              font_heights, &
              LAST_COLOR_IS_VALID, LAST_LINEWIDTH_IS_VALID, &
              LAST_LINESTYLE_IS_VALID, LAST_FONT_ATTRIB_IS_VALID, &
              gr_pdf_color_intent, MF_AFM_READ, PRINTING_EPS, &
              PRINTING_PDF, COMMENTS_IN_EPS, COMMENTS_IN_PDF, &
              CLIPPING_IN_AXES, deg_to_rad, rad_to_deg, FOCUS_CHANGE_DISABLE

   ! routines:
   private :: grarea, grbpic, grclos, grcurs, grdtyp, grepic, gresc, &
              grexec, grfa, grimg0, grimg1, grimg2, grinit, gritoc, &
              grlin0, grlin2, grlin3, grlina, grlinr, grmker, grmova, &
              grmovr, grmsg, gropen, grpage, grpars, grpocl, grqcap, grqci, &
              grqcol, grqcr, grqdev, grqdt, grqls, grqlw, grqpos, grqtyp, &
              grrec0, grrect, grsci, grscr, grslct, grsls, grslw, grterm, &
              grtoup, gr_wld_to_dev, grvct0, grwarn, grxhls, grxrgb, &
              grflun, grgenv, grglun, grclick_ec, grcurs_ec, grnormcurs_ec, &
              change_viewport,  embed_EnglishBT_PFA, grclos_ec, grcurs_dyn, &
              gropen_ec, grpocl_ec, gr_read_AFM_files, gr_set_cursor_shape, &
              ps_font_char_width, raise_mfplot_win, restore_viewport, &
              set_mfplot_background_color, restrict_to_short, &
              restrict_to_short_3, restrict_to_long

   ! from 'mod_pgplot':
   ! module variables and parameter:
   private :: pgmaxd, pgid, pgdevs, pgblev, pgfas, pgchsz, pgahs, &
              pgaha, pgahv, pgtbci, pgmnci, pgmxci, pgitf, pghsa, pghss, &
              pghsp, pgxvp, pgyvp, pgxlen, pgylen, pgxorg, &
              pgyorg, pgxscl, pgyscl, pgxpin, pgypin, pgxsp, pgysp, pgxblc, &
              pgxtrc, pgyblc, pgytrc, pgcint, pgcmin, trans, pgclab, &
              pgclab_len, id_x11, fig_number, EPS_NAME, PDF_NAME, &
              MF_EPS_UNIT, MF_PDF_UNIT, MF_PID, pg_exe_name, win_title, &
              ps_font_size, ps_char_height, CI_HIGH_MAX0, COLORBAR_VERT, &
              MF_DEFLATE_TO_A85, MF_NB_BITMAPS, MF_NB_TRI_GRAD, &
              MF_NB_QUAD_GRAD, MF_CMAP_USED, MF_MARKERS_USED, &
              MF_PDF_IN_COLORBAR, MF_PDF_CURR_CONT, MF_PDF_CURR_IMG, &
              MF_PDF_CURR_CMAP, MF_PDF_CURR_SHT4, MF_PDF_CURR_SHT6, &
              MF_PDF_OFF_CONT, MF_PDF_OFF_IMG, MF_PDF_OFF_CMAP, &
              MF_PDF_OFF_SHT4, MF_PDF_OFF_SHT6, nb_intern_images

   ! routines:
   private :: pgarro, pgbbuf, pgband, pgbin, pgbox1, pgbox, pgcirc, pgcl, &
              pgclos, pgcn01, pgcnsc, pgconb, pgconf, pgconl, &
              pgconx, pgctab, pgebuf, pgerr1, pgerrb, pgerrx, pgerry, &
              pghtch, pgimag, pginit, pglab, pglen, pgline, pgline2, pgmtxt, &
              pgnpl, pgnumb, pgolin, pgopen, pgpage, pgpoly, pgpt, pgptxt, &
              pgqah, pgqch, pgqcir, pgqcs, pgqfs, pgqhs, pgqinf, pgqitf, &
              pgqtbg, pgqtxt, pgqvp, pgqvsz, pgqwin, pgrnd, pgrnge, &
              pgsah, pgsch, pgscir, pgscrn, pgsfs, pgshls, pgshs, pgsitf, &
              pgslct, pgstbg, pgsvp, pgswin, pgtbox, pgtbx1, pgtbx2, pgtbx3, &
              pgtbx4, pgtbx5, pgtbx6, pgtbx7, pgtikl, pgvect, pgvsiz, pgvw, &
              pgwedg, pgwnad, click_ec, cursdev_ec, grtext_xft, &
              grlen_ps_font, pgslices, grparse_ps_font, grtext_pdf_font, &
              grparse_pdf_font, grtext_ps_font, pgarro_head_only, pgbar_ec, &
              pgbar_groups_ec, pgbar_stacks_ec, pgband_dyn, pgbezier, &
              pgclos_ec, pggrid_ec, pghist_ec, pghist_ec_pre, &
              pgopen_ec, pgscir_PS_ec, pg_spline_to_bezier, pgtricons_ec, &
              utf8_to_latin_1, &
              EPS_clip_on_viewport_beg, EPS_clip_on_viewport_end, &
              PDF_clip_on_viewport_beg, PDF_clip_on_viewport_end, &
              X11_clip_on_viewport

   private :: tiny_shift_range

   ! from 'fgl/src/usr/*_aux.f90'
   private :: BarVec, BarMat, ContourVec, ContourMat, ErrorBarX, ErrorBarY, &
              ErrorBarXY, ImageCore, read_xpm, read_any, get_image_infos, &
              write_xpm, write_any, redraw_legend_X11, redraw_legend_EPS_PDF, &
              msMoveGrObj_no_rot, msMoveGrObj_arrow, PolyFillCore, &
              PatchPolyCore, PcolorCoreVec, PcolorCoreMat, PlotCore, &
              decode_linespec, decode_col_name, decode_col_rgb, &
              copy_data_for_plotting, PlotCubicBezierCore, &
              PlotCubicSplineCore, print_eps, print_pdf, QuiverCoreVec, &
              msGSet_grobj, msGSet_grobj_val, msGSet_grobj_val2, &
              msGSet_grobj_val3, PcolorCoreSpy, PcolorCoreSpySparse, &
              PcolorCoreSpySparse2, PlotSpySparse, set_colorbar_log, &
              StreamlineCore, TextCore, decode_colorspec, &
              FillTri, PcolorTri, QuiverTri, set_color_axis

   ! from module 'mod_win_db'
   private :: grobj_struct, legend_struct, grobj_elem, grobj_handle, &
              mf_win_info

   ! from module 'mod_window'
   private :: mf_arrow_draw, mf_arrow_head_draw, &
              mf_line_draw, mf_point_draw, mf_line_point_draw, &
              mf_text_draw, &
              mf_errorbar_x_line_draw, mf_errorbar_x_pt_draw, &
              mf_errorbar_x_line_pt_draw, mf_errorbar_y_line_draw, &
              mf_errorbar_y_pt_draw, mf_errorbar_y_line_pt_draw, &
              mf_errorbar_xy_line_draw, mf_errorbar_xy_pt_draw, &
              mf_errorbar_xy_line_pt_draw, &
              mf_image_draw, mf_polygon_draw, mf_patch_draw, &
              mf_pcolor_spy_draw, mf_pcolor_spy_sparse_draw, &
              mf_pcolor_spy_sparse_2_draw, mf_plot_spy_sparse_draw, &
              mf_pcolor_draw, mf_pcolor_proj_draw, mf_pcolor_mat_proj_draw, &
              mf_quiver_draw, mf_streamline_draw, mf_tri_pcolor_draw, &
              mf_contour_draw, mf_tri_contour_draw, mf_histogram_draw, &
              mf_bar_draw, mf_bar_groups_stacks_draw, mf_cubic_bezier_draw, &
              mf_tri_fill_draw, &
              mf_trimesh_by_tri_draw, mf_trimesh_by_fac_draw, &
              update_mf_win_pos_db, read_mf_win_pos_db, get_default_x11_size, &
              erase_mf_win, erase_viewport, erase_axes_and_labels, &
              dealloc_mf_win, dealloc_all_grobjs, delete_grobj_inside, &
              mf_win_handles_init, mf_win_handles_increase_size, &
              mf_win_get_free_handle, mf_win_redraw_pre_PS, mf_win_draw_box, &
              mf_redraw_axis_lines, mf_prepare_axes, char_height_factor_update, &
              get_true_min_max, fix_min_max_for_axes, count_PDF_objects, &
              encode_handle, decode_handle, smart_max, &
              unset_smart_ticks_x, unset_smart_ticks_y

   private :: GET_DEV_NAME, GET_COL_IND_RANGE, GET_DEV_RESOL, GET_MISC_INFO, &
              GET_DEF_FILENAME, GET_DEF_SIZE, GET_CHAR_SIZE, SELECT_PLOT, &
              OPEN_DEV, CLOSE_DEV, BEGIN_PICT, DRAW_LINE_SEGM, DRAW_POLYLINE, &
              END_PICT, SELECT_COL_IND, FLUSH_BUF, READ_CURSOR, &
              SET_X11_WIN_ID, SET_LINE_STYLE, POLYGON_FILL, SET_COL_REPRES, &
              SET_LINE_WIDTH, ESCAPE, RECT_FILL, SET_LINE_CAP_JOIN_STYLE
   private :: PUT_LINE_PIX_CI, GET_LINE_PIX_RGB, PUT_LINE_PIX_RGB, &
              GET_COL_REPRES, DRAW_BEZIER_SEGM, SET_ANG_CLIP_XFT, &
              SET_FONT_XFT, DRAW_CHAR_STRING, SET_MUESLI_PATH, &
              GET_DEF_SIZE_VIRT, GET_XFT_STRING_BBOX, WRITE_COLORMAP_IF, &
              DRAW_MARKER, PDF_RECORD_OCG, UPDATE_TRANSP_TABLE, BITMAP_IMAGE, &
              ADD_COMMENT_EPS_PDF, PDF_BDC_TAG, PDF_EMC_TAG, UPDATE_BBOX, &
              GET_CURSOR_POS
   private :: GET_CLICK_IN_WIN, RAISE_WIN, WIN_RESIZE, SELECT_BACK_FOREGROUND, &
              GET_COL_DEPTH, SET_EXE_NAME, GET_COLOR_CORR, FINISH_READ_CURSOR, &
              SET_CURSOR_SHAPE, READ_CURSOR_DYN, GET_WIN_SIZE_PIX, &
              READ_CURSOR_DYN_EXCL_BOX, READ_CURSOR_DYN_MULTISPOT, &
              READ_CURSOR_DYN_QUADR_POLYG, GET_DASH_PERIOD, CLEAN_FONTCONFIG, &
              SELECT_AUX_PIXMAP, MOVE_GROBJ_PIXMAP, REDUCE_2ND_AUX_PIXMAP, &
              SET_CLIPPING, SET_1_PIX_CORR, SCROLL_IN_PIXMAP
   private :: GET_INFO_EMPTY_EPS, PREP_ARROW_MOVE, MOVE_ARROW, &
              X11_FLUSH_POLICY, FORCE_FLUSH_BUFFER, FORCE_UPDATE_FROM_PIXMAP, &
              SET_INPUT_FOCUS, SET_VIEWPORT, UPDATE_MAIN_PIXMAP, &
              GET_LABEL_AREA_AROUND, ERASE_LABEL_AREA_AROUND, GET_CLIPPING, &
              SAVE_PIXMAP_ID, COPY_PIXMAP_FROM_ID, REM_FIG_NUM_IN_WIN_TITLE, &
              GET_CURRENT_WIN_GEOM, READ_CURSOR_WITHOUT_WAITING

   private :: CURRENT_WIN_ID

   private :: CH_convex_hull, CH_isLeftOf

   private :: check_color_overflow_scal, check_color_overflow_vec, &
              compute_light, compute_light_xy, find_intersect_12_34, &
              find_intersect, draw_grid_pcolor_vec, draw_grid_pcolor_mat, &
              draw_quad_grid_after, process_all_segments, &
              remove_segment, pos_wrt_triangle, get_status, &
              get_status_adv, cross_product, find_intersect_seg_seg, &
              find_intersect_tri_seg

end module fgl
