! f90 include file

!_______________________________________________________________________
!
   subroutine prepare_global_ibi( x, y )

      integer, intent(in) :: x(4), y(4)
      !------ API end ------

      ! Initialize some constants which doesn't depend on (i,j) of the
      ! interior point (cf. 'irreg_bilinear_interp' function).

      logical :: VertLines_are_parallel, HorzLines_are_parallel

      ibi_x21 = x(2) - x(1)
      ibi_y21 = y(2) - y(1)
      ibi_x32 = x(3) - x(2)
      ibi_y32 = y(3) - y(2)
      ibi_x34 = x(3) - x(4)
      ibi_y34 = y(3) - y(4)
      ibi_x41 = x(4) - x(1)
      ibi_y41 = y(4) - y(1)

      VertLines_are_parallel = sides_are_parallel( 1, 2, 4, 3 )
      HorzLines_are_parallel = sides_are_parallel( 1, 4, 2, 3 )

      if( (.not. VertLines_are_parallel) .and. (.not. HorzLines_are_parallel) ) then
         ibi_method = 1
      else if( (.not. VertLines_are_parallel) .and. HorzLines_are_parallel ) then
         ibi_method = 1
      else if( VertLines_are_parallel .and. (.not. HorzLines_are_parallel) ) then
         ibi_method = 2
      else ! VertLines_are_parallel .and. HorzLines_are_parallel
         ibi_method = 3
      end if

      if( ibi_method == 1 ) then
         ibi_AA = ibi_x21*ibi_y34 - ibi_y21*ibi_x34
         ibi_BB_cst1 = ibi_x34-ibi_x21
         ibi_BB_cst2 = ibi_y34-ibi_y21
         ibi_BB_cst3 = ibi_x21*ibi_y41 - ibi_y21*ibi_x41
      else if( ibi_method == 2 ) then
         ibi_AA = ibi_x41*ibi_y32 - ibi_y41*ibi_x32
         ibi_BB_cst1 = ibi_x32-ibi_x41
         ibi_BB_cst2 = ibi_y32-ibi_y41
         ibi_BB_cst3 = ibi_x41*ibi_y21 - ibi_y41*ibi_x21
      else ! ibi_method == 3
         ibi_det = ibi_x41*ibi_y21 - ibi_y41*ibi_x21
      end if

   contains

      function sides_are_parallel( v1, v2, v3, v4 ) result( res )

         integer, intent(in) :: v1, v2, v3, v4
         logical             :: res

         ! Determine if sides v1-v2 and v3-v4 are parallel.
         if( (x(v1)-x(v2))*(y(v3)-y(v4))                                &
            -(x(v3)-x(v4))*(y(v1)-y(v2)) == 0 ) then
            res = .true.
         else
            res = .false.
         end if

      end function

   end subroutine prepare_global_ibi
!_______________________________________________________________________
!
   subroutine prepare_local_ibi( jj )

      integer, intent(in) :: jj
      !------ API end ------

      ! Initialize some constants which doesn't depend on the index 'i'
      ! of the interior point (cf. 'irreg_bilinear_interp' function).

      if( ibi_method == 1 ) then
         ibi_BB_j = jj*ibi_BB_cst1 + ibi_BB_cst3
         ibi_CC_j = jj*ibi_x41
      else if( ibi_method == 2 ) then
         ibi_BB_j = jj*ibi_BB_cst1 + ibi_BB_cst3
         ibi_CC_j = jj*ibi_x21
      else ! ibi_method == 3
         ibi_s_j = ibi_x21*jj
         ibi_t_j = ibi_x41*jj
      end if

   end subroutine prepare_local_ibi
!_______________________________________________________________________
!
   function irreg_bilinear_interp( x, y, c, i, j ) result( res )

      integer, intent(in)  :: x(4), y(4), c(4), i, j
      real(kind=MF_DOUBLE) :: res
      !------ API end ------

      ! This function makes a bilinear interpolation of the c(:) values
      ! on a general quadrangle defined by its coordinates ix(:) and iy(:).
      ! The c(:) values are defined at the vertices.
      !
      ! The point (i,j) is the output point where we are computing the
      ! interpolated value of c(:), returned in res.
      !
      ! All coordinates are integers because they are device coordinates,
      ! in pixels.
      !
      ! The method comes from A. Hinson (http://www.ahinson.com), but can
      ! be also found elsewhere.
      !----------------------------------------------------------------

      ! Numbering of the vertices must be as follows:
      !
      !               1 +
      !                / \
      !               /   \           * quadrangle 1-2-3-4 is direct
      !              /     \
      !           2 +       \         * vertex 1 is the highest
      !              \       + 4        (and most left if y(2)=y(1))
      !               \     /
      !                \   /
      !                 \ /
      !                3 +
      !

      ! The following variables need to have a big range, due to the power
      ! 4 applied during the solving of the quadratic equation.
      ! (should be ok even for a 4000 pixels width quadrangle)
      integer*8 :: BB, CC, delta

      ! Single precision is sufficient
      real(kind=MF_DOUBLE) :: t, t1, t2, s, s1, s2,                     &
                              xA, yA, xB, yB, xC, yC, xD, yD


      if( ibi_method == 1 ) then
         go to 1
      else if( ibi_method == 2 ) then
         go to 2
      else ! ibi_method == 3
         go to 3
      end if

 1    continue
      BB = ibi_BB_j - i*ibi_BB_cst2
      CC = ibi_CC_j - i*ibi_y41
      delta = BB**2 - 4*ibi_AA*CC
      if( delta < 0 ) then
         if( dble(delta)/dble(BB**2) < 1.0d-3 ) then
            delta = 0
         else
            print *, "(Muesli FGL:) internal error."
            print *, "              function 'irreg_bilinear_interp': delta < 0"
            print *, "              (line 154 of Pix_aux.inc)"
            pause "only for debugging purpose"
!!            stop
            res = 2*ibi_col_max
            return
         end if
      end if
      t1 = (-BB-sqrt(dble(delta)))/2./ibi_AA
      t2 = (-BB+sqrt(dble(delta)))/2./ibi_AA
      if( 0. <= t1 .and. t1 <= 1. ) then
         t = t1
      else if( 0. <= t2 .and. t2 <= 1. ) then
         t = t2
      else
         if( -0.001d0 < t1 .and. t1 < 0. ) then
            t = 0.
         else if( 1. < t1 .and. t1 < 1.001d0 ) then
            t = 1.
         else if( -0.001d0 < t2 .and. t2 < 0. ) then
            t = 0.
         else if( 1. < t2 .and. t2 < 1.001d0 ) then
            t = 1.
         else
            print *, "(Muesli FGL:) internal error."
            print *, "              function 'irreg_bilinear_interp': no solution"
            print *, "              for 't' in the range [0,1]"
            print *, "              (line 180 of Pix_aux.inc)"
            pause "only for debugging purpose"
!!            stop
            res = 2*ibi_col_max
            return
         end if
      end if
      xA = x(1)+t*ibi_x21
      yA = y(1)+t*ibi_y21
      xB = x(4)+t*ibi_x34
      yB = y(4)+t*ibi_y34
      if( abs(yA-yB) > abs(xA-xB) ) then
         s = (j-t*ibi_y21) / (yB-yA)
      else
         s = (i-t*ibi_x21) / (xB-xA)
      end if
      if( s < 0. .or. 1. < s ) then
         if( -0.001d0 < s .and. s < 0. ) then
            s = 0.
         else if( 1. < s .and. s < 1.001d0 ) then
            s = 1.
         else
            print *, "(Muesli FGL:) internal error."
            print *, "              function 'irreg_bilinear_interp': non consistent result"
            print *, "              's' should be in [0,1]!"
            print *, "              (line 205 of Pix_aux.inc)"
            pause "only for debugging purpose"
!!            stop
            res = 2*ibi_col_max
            return
         end if
      end if
      go to 99

 2    continue
      BB = ibi_BB_j - i*ibi_BB_cst2
      CC = ibi_CC_j - i*ibi_y21
      delta = BB**2 - 4*ibi_AA*CC
      if( delta < 0 ) then
         if( dble(delta)/dble(BB**2) < 1.0d-3 ) then
            delta = 0
         else
            print *, "(Muesli FGL:) internal error."
            print *, "              function 'irreg_bilinear_interp': delta < 0"
            print *, "              (line 224 of Pix_aux.inc)"
!!            pause "only for debugging purpose"
!!            stop
            res = 2*ibi_col_max
            return
         end if
      end if
      s1 = (-BB-sqrt(dble(delta)))/2./ibi_AA
      s2 = (-BB+sqrt(dble(delta)))/2./ibi_AA
      if( 0. <= s1 .and. s1 <= 1. ) then
         s = s1
      else if( 0. <= s2 .and. s2 <= 1. ) then
         s = s2
      else
         if( -0.001d0 < s1 .and. s1 < 0. ) then
            s = 0.
         else if( 1. < s1 .and. s1 < 1.001d0 ) then
            s = 1.
         else if( -0.001d0 < s2 .and. s2 < 0. ) then
            s = 0.
         else if( 1. < s2 .and. s2 < 1.001d0 ) then
            s = 1.
         else
            print *, "(Muesli FGL:) internal error."
            print *, "              function 'irreg_bilinear_interp': no solution"
            print *, "              for 's' in the range [0,1]"
            print *, "              (line 250 of Pix_aux.inc)"
!!            pause "only for debugging purpose"
!!            stop
            res = 2*ibi_col_max
            return
         end if
      end if
      xC = x(1)+s*ibi_x41
      yC = y(1)+s*ibi_y41
      xD = x(2)+s*ibi_x32
      yD = y(2)+s*ibi_y32
      if( abs(yC-yD) > abs(xC-xD) ) then
         t = (j-s*ibi_y41) / (yD-yC)
      else
         t = (i-s*ibi_x41) / (xD-xC)
      end if
      if( t < 0. .or. 1. < t ) then
         if( -0.001d0 < t .and. t < 0. ) then
            t = 0.
         else if( 1. < t .and. t < 1.001d0 ) then
            t = 1.
         else
            print *, "(Muesli FGL:) internal error."
            print *, "              function 'irreg_bilinear_interp': non consistent result"
            print *, "              't' should be in [0,1]!"
            print *, "              (line 275 of Pix_aux.inc)"
!!            pause "only for debugging purpose"
!!            stop
            res = 2*ibi_col_max
            return
         end if
      end if
      go to 99

 3    continue
 !### TODO: replace determinant by condition number ?
      if( abs(ibi_det) < MF_EPS ) then
         print *, "(Muesli FGL:) internal error."
         print *, "              function 'irreg_bilinear_interp': singular"
         print *, "              system detected"
         print *, "              (line 290 of Pix_aux.inc)"
!!         pause "only for debugging purpose"
!!         stop
         res = 2*ibi_col_max
         return
      end if
      s = ( ibi_y21*i - ibi_s_j ) / ibi_det
      t = ( ibi_t_j - ibi_y41*i ) / ibi_det

 99   res = c(1)*(1-s)*(1-t) + c(2)*(1-s)*t + c(3)*s*t + c(4)*s*(1-t)

   end function irreg_bilinear_interp
!_______________________________________________________________________
!
   subroutine alpha_transp( color_depth, icol_fore, transp,             &
                            i_RGB_back, i_RGB_new )

      integer,              intent(in) :: color_depth, icol_fore, i_RGB_back
      real(kind=MF_DOUBLE), intent(in) :: transp
      !------ API end ------

      ! Synthèse soustractive
      ! cf. ~/dev/image_processing/transparency/src/add_layer_sup_over_inf.f

      integer, intent(out) :: i_RGB_new

      real(kind=MF_DOUBLE) :: ctransp
      integer :: ir_back, ig_back, ib_back, ir_new, ig_new, ib_new
      real(kind=MF_DOUBLE) :: cr_fore, cg_fore, cb_fore

   !------ end of declarations -- execution starts hereafter  ------

      ctransp = 1. - transp

      ! RGB values between 0. and 1.
      call grqcr( icol_fore, cr_fore, cg_fore, cb_fore )

      ! RGB values are integer
      if( color_depth == 16 ) then

         ir_back = ibits( i_RGB_back, 11, 5 )
         ig_back = ibits( i_RGB_back, 5, 6 )
         ib_back = ibits( i_RGB_back, 0, 5 )

         ir_new = ctransp*(31-ir_back) + transp*(1.-cr_fore)*31
         ig_new = ctransp*(63-ig_back) + transp*(1.-cg_fore)*63
         ib_new = ctransp*(31-ib_back) + transp*(1.-cb_fore)*31

         ir_new = 31 - ir_new
         ig_new = 63 - ig_new
         ib_new = 31 - ib_new

         ! Recombine RGB values in an integer
         i_RGB_new = ishft( ir_new, 11 ) + ishft( ig_new, 5 ) + ib_new

      else if( color_depth == 24 ) then

         ir_back = ibits( i_RGB_back, 16, 8 )
         ig_back = ibits( i_RGB_back, 8, 8 )
         ib_back = ibits( i_RGB_back, 0, 8 )

         ir_new = ctransp*(255-ir_back) + transp*(1.-cr_fore)*255
         ig_new = ctransp*(255-ig_back) + transp*(1.-cg_fore)*255
         ib_new = ctransp*(255-ib_back) + transp*(1.-cb_fore)*255

         ir_new = 255 - ir_new
         ig_new = 255 - ig_new
         ib_new = 255 - ib_new

         ! Recombine RGB values in an integer
         i_RGB_new = ishft( ir_new, 16 ) + ishft( ig_new, 8 ) + ib_new

      end if

   end subroutine alpha_transp
!_______________________________________________________________________
!
   subroutine X11_rect_dump( X11_id, bbox,                              &
                             mat_red, flag_red,                         &
                             mat_green, flag_green,                     &
                             mat_blue, flag_blue )

      integer,              intent(in) :: X11_id
      real(kind=MF_DOUBLE), intent(in) :: bbox(4)
      double precision, pointer :: mat_red(:,:),                        &
                                   mat_green(:,:),                      &
                                   mat_blue(:,:)
      integer :: flag_red, flag_green, flag_blue
      !------ API end ------

      ! X11_id : win%mfplot_id of the X11 window
      !
      ! bbox   : win%current_axes of the X11 window
      !
      ! mat_col : matrix of sise (NXP,NYP) containing the color component
      !           'col' (value in [0.,1.]);
      !           it is a pointer, allocated if necessary, and adjusted
      !           in size if needed.
      !
      ! flag_col : on input, indicates (1/0) if the color 'col' must be
      !            processed. On output, a value equal to -1 indicates that
      !            the array mat_col has got its address modified (by
      !            dealloc/alloc)

      ! Actually, get exact R,G,B color planes only when background color
      ! is black. See also comments in the routine 'msGetX11Pixmap'

      ! -- 4096 : max nb of pixels on one line...
      !           (ok for 4K resolution)
      real(kind=MF_DOUBLE) :: rbuf(1)
      integer   :: ibuf(4096), lchr
      character :: chr
      integer :: color_depth
      character(len=4) :: col_depth_char

      real(kind=MF_DOUBLE) :: xorg_x11, yorg_x11, xscale_x11, yscale_x11
      integer :: ix1, iy1, ix2, iy4
      integer :: nxp, nyp
      integer :: i_deb, i_fin, j_deb, j_fin
      integer :: i, j, i_rgb, ir, ig, ib, ii, jj

   !------ end of declarations -- execution starts hereafter  ------

      call pgslct( X11_id )

      call grexec( grgtyp, GET_COL_DEPTH, rbuf, ibuf, chr, lchr )
      color_depth = ibuf(1)
      if( color_depth /= 16 .and. color_depth /= 24 ) then
         if( X11_DEVICE ) then
            write(col_depth_char,"(I0)") color_depth
            call PrintMessage( "X11_rect_dump", "E",                    &
                               "color depth = " // col_depth_char,      &
                               "cannot handle this number of colors!",  &
                               "(currently: only 16 or 24 bits)" )
            return
         end if
      end if

      xorg_x11 = PGXORG(PGID)
      yorg_x11 = PGYORG(PGID)
      xscale_x11 = PGXSCL(PGID)
      yscale_x11 = PGYSCL(PGID)

      !
      !            4 +---------+ 3
      !              |         |
      !              |         |
      !              |         |
      !              |         |
      !            1 +---------+ 2
      !

      ! Coordinates of the four vertices in pixels
      ix1 = nint(xorg_x11 + bbox(1)*xscale_x11)
      iy1 = nint(yorg_x11 + bbox(3)*yscale_x11)
      ix2 = nint(xorg_x11 + bbox(2)*xscale_x11)
      iy4 = nint(yorg_x11 + bbox(4)*yscale_x11)

      ! Corrections (bad rounding?) :
      ix1 = ix1 + 1
      iy1 = iy1 + 1
      ix2 = ix2 - 1
      iy4 = iy4 - 1

      NXP = ix2 - ix1 + 1
      NYP = iy4 - iy1 + 1

      ! Allocate arrays, and check their size.
      if( flag_red == 1 ) then
         if( .not. associated(mat_red) ) then
#ifndef _TRACE_MEM_ALLOC
            allocate( mat_red(nyp,nxp) )
#else
            call mf_allocate( array=mat_red, m=nyp, n=nxp,              &
                              file="Pix_aux.inc", line="465",           &
                              symb="mat_red", unit="X11_rect_dump" )
#endif
         else
            if( size(mat_red,1) /= NYP .or.                             &
                size(mat_red,2) /= NXP ) then
#ifndef _TRACE_MEM_ALLOC
               deallocate( mat_red )
#else
               call mf_deallocate( array=mat_red,                       &
                                   file="Pix_aux.inc", line="475",      &
                                   symb="mat_red", unit="X11_rect_dump" )
#endif
#ifndef _TRACE_MEM_ALLOC
               allocate( mat_red(nyp,nxp) )
#else
               call mf_allocate( array=mat_red, m=nyp, n=nxp,           &
                                 file="Pix_aux.inc", line="482",        &
                                 symb="mat_red", unit="X11_rect_dump" )
#endif
               flag_red = -1
            end if
         end if
      end if
      if( flag_green == 1 ) then
         if( .not. associated(mat_green) ) then
#ifndef _TRACE_MEM_ALLOC
            allocate( mat_green(nyp,nxp) )
#else
            call mf_allocate( array=mat_green, m=nyp, n=nxp,            &
                              file="Pix_aux.inc", line="495",           &
                              symb="mat_green", unit="X11_rect_dump" )
#endif
         else
            if( size(mat_green,1) /= NYP .or.                           &
                size(mat_green,2) /= NXP ) then
#ifndef _TRACE_MEM_ALLOC
               deallocate( mat_green )
#else
               call mf_deallocate( array=mat_green,                     &
                                   file="Pix_aux.inc", line="505",      &
                                   symb="mat_green", unit="X11_rect_dump" )
#endif
#ifndef _TRACE_MEM_ALLOC
               allocate( mat_green(nyp,nxp) )
#else
               call mf_allocate( array=mat_green, m=nyp, n=nxp,         &
                                 file="Pix_aux.inc", line="512",        &
                                 symb="mat_green", unit="X11_rect_dump" )
#endif
               flag_green = -1
            end if
         end if
      end if
      if( flag_blue == 1 ) then
         if( .not. associated(mat_blue) ) then
#ifndef _TRACE_MEM_ALLOC
            allocate( mat_blue(nyp,nxp) )
#else
            call mf_allocate( array=mat_blue, m=nyp, n=nxp,             &
                              file="Pix_aux.inc", line="525",           &
                              symb="mat_blue", unit="X11_rect_dump" )
#endif
         else
            if( size(mat_blue,1) /= NYP .or.                            &
                size(mat_blue,2) /= NXP ) then
#ifndef _TRACE_MEM_ALLOC
               deallocate( mat_blue )
#else
               call mf_deallocate( array=mat_blue,                      &
                                   file="Pix_aux.inc", line="535",      &
                                   symb="mat_blue", unit="X11_rect_dump" )
#endif
#ifndef _TRACE_MEM_ALLOC
               allocate( mat_blue(nyp,nxp) )
#else
               call mf_allocate( array=mat_blue, m=nyp, n=nxp,          &
                                 file="Pix_aux.inc", line="542",        &
                                 symb="mat_blue", unit="X11_rect_dump" )
#endif
               flag_blue = -1
            end if
         end if
      end if

      ! Draw the rectangle
      i_deb = ix1
      i_fin = ix2
      j_deb = iy1
      j_fin = iy4

      ibuf(1) = 2 + (i_fin - i_deb + 1)
      ibuf(2) = i_deb
      do j = j_deb, j_fin
         ii = j_fin - j + 1

         ibuf(3) = j

         ! Read the RGB value of pixels already present on the screen
         call grexec( grgtyp, GET_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )

         do i = i_deb, i_fin
            jj = i - i_deb + 1
            i_RGB = ibuf(3+jj)
            ! RGB values are integer
            if( color_depth == 16 ) then
               ! Extract and scale to lie in [0.,1.]
               if( flag_red /= 0 ) then
               ir = ibits( i_RGB, 11, 5 )
               mat_red(ii,jj) = ir/31.
               end if
               if( flag_green /= 0 ) then
               ig = ibits( i_RGB, 5, 6 )
               mat_green(ii,jj) = ig/63.
               end if
               if( flag_blue /= 0 ) then
               ib = ibits( i_RGB, 0, 5 )
               mat_blue(ii,jj) = ib/31.
               end if
            else if( color_depth == 24 ) then
               if( flag_red /= 0 ) then
               mat_red(ii,jj) = ibits( i_RGB, 16, 8 )/255.
               end if
               if( flag_green /= 0 ) then
               mat_green(ii,jj) = ibits( i_RGB, 8, 8 )/255.
               end if
               if( flag_blue /= 0 ) then
               mat_blue(ii,jj) = ibits( i_RGB, 0, 8 )/255.
               end if
            end if

         enddo

      enddo

   end subroutine X11_rect_dump
!_______________________________________________________________________
!
   subroutine correct_X11_color( r, g, b )

      real(kind=MF_DOUBLE) :: r, g, b
      !------ API end ------

      ! Input : user-color (r,g,b) real
      !
      ! Output : exact X11-color (r,g,b) real, which should be stored by
      !          the X11 server.
      !          the corrected X11 color depends, of course, of the color
      !          depth.
      !
      ! Rem. in xwdriv.c, index CI_HIGH_MAX is used as temporary index.

      real(kind=MF_DOUBLE) :: rbuf(3)
      integer   :: ibuf(1), lchr
      character :: chr

      rbuf(1) = r
      rbuf(2) = g
      rbuf(3) = b
      call grexec( grgtyp, GET_COLOR_CORR, rbuf, ibuf, chr, lchr )
      r = rbuf(1)
      g = rbuf(2)
      b = rbuf(3)

   end subroutine correct_X11_color
!_______________________________________________________________________
!
   function Get_Color_Depth()

      integer :: Get_Color_Depth
      !------ API end ------

      ! Retrieve the number of X11 colors via a call to the X11 driver.

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer   :: ibuf(1), lchr
      character :: chr

      call grexec( grgtyp, GET_COL_DEPTH, rbuf, ibuf, chr, lchr )
      Get_Color_Depth = ibuf(1)

   end function Get_Color_Depth
!_______________________________________________________________________
!
   subroutine GetOnePX( x, y, r, g, b )

      real(kind=MF_DOUBLE), intent(in) :: x, y
      real(kind=MF_DOUBLE)             :: r, g, b
      !------ API end ------

      ! Get one pixel from the X11 screen

      real(kind=MF_DOUBLE) :: rbuf(1)
      integer   :: ibuf(4), lchr
      character :: chr
      integer :: color_depth

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale
      integer :: i, j
      integer :: i_rgb
      character(len=4) :: col_depth_char

   !------ end of declarations -- execution starts hereafter  ------

      call grexec( grgtyp, GET_COL_DEPTH, rbuf, ibuf, chr, lchr )
      color_depth = ibuf(1)
      if( .not. (color_depth == 16 .or. color_depth == 24) ) then
         if( X11_DEVICE ) then
            write(col_depth_char,"(I0)") color_depth
            call PrintMessage( "PatchTriCorePX", "E",                   &
                               "color depth = " // col_depth_char,      &
                               "cannot handle this number of colors!",  &
                               "(currently only 16- or 24-bit is supported)" )
            return
         end if
      end if

      xorg = PGXORG(PGID)
      yorg = PGYORG(PGID)
      xscale = PGXSCL(PGID)
      yscale = PGYSCL(PGID)

      ! Coordinates in pixels
      i = xorg + x*xscale
      j = yorg + y*yscale

      ibuf(1) = 1 ! nb of pixels to get
      ibuf(2) = i
      ibuf(3) = j

      ! Read the RGB value of pixels already present on the screen
      call grexec( grgtyp, GET_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )

      i_RGB = ibuf(4)

      ! RGB values are integer
      if( color_depth == 16 ) then

         r = ibits( i_RGB, 11, 5 ) / 63.0d0
         g = ibits( i_RGB,  5, 6 ) / 63.0d0
         b = ibits( i_RGB,  0, 5 ) / 63.0d0

      else if( color_depth == 24 ) then

         r = ibits( i_RGB, 16, 8 ) / 255.0d0
         g = ibits( i_RGB,  8, 8 ) / 255.0d0
         b = ibits( i_RGB,  0, 8 ) / 255.0d0

      end if

   end subroutine GetOnePX
