! f90 include file

!_______________________________________________________________________
!
   subroutine X11_rect_dump_to_PS( X11_id, print_id, bbox )

      integer,              intent(in) :: X11_id, print_id
      real(kind=MF_DOUBLE), intent(in) :: bbox(4)
      !------ API end ------

      ! used only for EPS printing (EPS format doesn't support transparency,
      ! while PDF format does).

      ! -- 4096 : max nb of pixels on one line...
      !           (ok for 4K resolution)
      real(kind=MF_DOUBLE) :: rbuf(4)
      integer   :: ibuf(4096), lchr
      character :: chr

      integer :: color_depth

      character(len=80) :: inline
      real(kind=MF_DOUBLE) :: tr(6)

      ! deflate_stream_to_hex support (zlib)

      ! (multiple de 3 car R,G,B)
      integer, parameter :: len_in_max = 98304

      ! CAUTION: 1-byte integer (and not 4-byte as default!)
!### TODO 2: l'écriture devrait être plus standard, avec utilisation de kind
      integer*1 :: int_in(len_in_max)
      integer :: len_in, len_out
      character(len=len_in_max) :: string_out
      interface
         subroutine deflate_stream_to_hex( in_bin_str, len_in_bin,      &
                                           out_hex_str, len_out_hex,    &
                                           job, ier )
            integer*1        :: in_bin_str(*)
            integer          :: len_in_bin
            character(len=*) :: out_hex_str
            integer          :: len_out_hex, job, ier
         end subroutine
         subroutine deflate_stream_to_a85( filename, len_filename,      &
                                           buffer, len_buffer,          &
                                           job, ier )
            character(len=*) :: filename
            integer          :: len_filename
            integer*1        :: buffer(*)
            integer          :: len_buffer, job, ier
         end subroutine
      end interface

      character(len=256), save :: fnameC
      integer, save :: lfnameC

      real(kind=MF_DOUBLE) :: xorg_x11, yorg_x11, xscale_x11, yscale_x11
      integer :: ix1, iy1, ix2, iy4
      integer :: nxp, nyp
      integer :: i1, i2, j1, j2
      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale
      real(kind=MF_DOUBLE) :: dxi, dyj, det, tr11, tr12, tr21, tr22
      real(kind=MF_DOUBLE) :: at, bt, ct, dt, tx, ty
      integer :: job, i_deb, i_fin, j_deb, j_fin
      integer :: i, j, i_rgb, ir, ig, ib, ier, l

      character(len=4) :: col_depth_char

   !------ end of declarations -- execution starts hereafter  ------

      if( PRINTING_PDF ) then
         ! PDF support in this routine has been removed on 2021-02-24
         print *, "MUESLI FGL: Internal Error"
         print *, "            'X11_rect_dump_to_PS' cannot be called for a PDF!"
         pause "for debugging purpose"
         stop
      end if

      call pgslct( X11_id )

      call grexec( grgtyp, GET_COL_DEPTH, rbuf, ibuf, chr, lchr )
      color_depth = ibuf(1)
      if( .not. (color_depth == 16 .or. color_depth == 24) ) then
        if( X11_DEVICE ) then
          write(col_depth_char,"(I0)") color_depth
          call PrintMessage( "X11_rect_dump_to_PS", "E",                &
                             "color depth = " // col_depth_char,        &
                             "cannot handle this number of colors!",    &
                             "(currently: only 16 or 24 bits)" )
          return
        end if
      end if

      xorg_x11 = pgxorg(pgid)
      yorg_x11 = pgyorg(pgid)
      xscale_x11 = pgxscl(pgid)
      yscale_x11 = pgyscl(pgid)

      !
      !            4 +---------+ 3
      !              |         |
      !              |         |
      !              |         |
      !              |         |
      !            1 +---------+ 2
      !

      ! coordonnées des quatre sommets en pixels
      ix1 = nint(xorg_x11 + bbox(1)*xscale_x11)
      iy1 = nint(yorg_x11 + bbox(3)*yscale_x11)
      ix2 = nint(xorg_x11 + bbox(2)*xscale_x11)
      iy4 = nint(yorg_x11 + bbox(4)*yscale_x11)

      NXP = ix2 - ix1 + 1
      NYP = iy4 - iy1 + 1

      ! on simule un appel à PGCELL (PGXTAL)
      I1 = 1
      I2 = 2
      J1 = 1
      J2 = 2

      TR(1) = 2*bbox(1) - bbox(2)
      TR(2) = bbox(2) - bbox(1)
      TR(3) = 0

      ! de manière similaire
      TR(4) = 2*bbox(3) - bbox(4)
      TR(5) = 0
      TR(6) = bbox(4) - bbox(3)

      call pgslct( print_id )

      if( COMMENTS_IN_EPS ) then
         call gresc("%-- begin of X11 dump to bitmap")
      end if

      call EPS_clip_on_viewport_beg()

      xorg = pgxorg(pgid)
      yorg = pgyorg(pgid)
      xscale = pgxscl(pgid)
      yscale = pgyscl(pgid)

      dxi = real(i2-i1)/real(nxp)
      dyj = real(j2-j1)/real(nyp)
      det = tr(2)*tr(6)-tr(3)*tr(5)
      tr11 = +tr(6)/det
      tr12 = -tr(3)/det
      tr21 = -tr(5)/det
      tr22 = +tr(2)/det
      at = tr11/(xscale*dxi)
      bt = tr21/(xscale*dyj)
      ct = tr12/(yscale*dxi)
      dt = tr22/(yscale*dyj)
      tx = -(tr11*(xorg/xscale+tr(1))+tr12*(yorg/yscale+tr(4))+i1)/dxi
      ty = -(tr21*(xorg/xscale+tr(1))+tr22*(yorg/yscale+tr(4))+j1)/dyj

      ! If this is the first thing plotted then set something plotted flag
      ! and for a GREXEC device call BEGIN_PICTURE.
      ! (copied from grlin2)
      if( .not. grpltd(grcide) ) call grbpic

      WRITE(inline, "(A,I0,A)") "/picstr ", NXP, " string def"
      call gresc( trim(inline) )

      call gresc("/inputf")
      call gresc("  currentfile")
      if( MF_DEFLATE_TO_A85 ) then
         call gresc("  /ASCII85Decode filter")
      else
         call gresc("  /ASCIIHexDecode filter")
      end if
      call gresc("  /FlateDecode filter")
      call gresc("def")

      WRITE(inline,110) NXP, NYP, AT, BT, CT, DT, TX, TY
 110  format(I0,1X,I0," 8 [",6(ES10.3,1X),"]")
      call gresc( trim(inline) )

      call gresc("{ inputf picstr readstring not {")
      call gresc("  (ERROR: end of file -- incomplete data?) == flush stop } if")
      call gresc("} false 3 colorimage")

      ! image 24 bits -> 8 bits/comp. -> 2 car. hexa -> Z2
      !                                  ou 1 octet (integer*1)

      job = 1
      ! à l'initialisation, on a besoin de 'len_in' pour allouer
      ! une fois pour toute le tableau de compression 'compr_str'
      len_in = len_in_max
      if( MF_DEFLATE_TO_A85 ) then
         fnameC = trim(EPS_NAME) // char(0)
         lfnameC = len_trim(EPS_NAME) + 1
         close( MF_EPS_UNIT )
         ! the following routine writes directly in the EPS/PDF file.
         call deflate_stream_to_a85( fnameC, lfnameC,                   &
                                     int_in, 0, job, ier )
      else
         string_out = ""
         len_out = len(string_out)
         call deflate_stream_to_hex( int_in, len_in,                    &
                                     string_out, len_out,               &
                                     job, ier )
      end if

      ! dessin du rectangle

      i_deb = ix1
      i_fin = ix2
      j_deb = iy1
      j_fin = iy4
      len_in = 0
      ibuf(1) = (i_fin - i_deb + 1) ! nb of pixels to get
      ibuf(2) = i_deb
      do j = j_deb, j_fin

        ibuf(3) = j

        call pgslct( X11_id )

        ! on lit la valeur RGB des pixels déjà tracés sur l'écran
        call grexec( grgtyp, GET_LINE_PIX_RGB, rbuf, ibuf, chr, lchr )

        call pgslct( print_id )

        do i = i_deb, i_fin
          i_RGB = ibuf(4+i-i_deb)
          ! valeurs RGB entières
          if( color_depth == 16 ) then
            ir = ibits( i_RGB, 11, 5 )
            ig = ibits( i_RGB, 5, 6 )
            ib = ibits( i_RGB, 0, 5 )
            ! scaling pour repasser à l'intervalle [0,255]
            ir = nint(dble(ir)/31.*255.)
            ig = nint(dble(ig)/63.*255.)
            ib = nint(dble(ib)/31.*255.)
          else if( color_depth == 24 ) then
            ir = ibits( i_RGB, 16, 8 )
            ig = ibits( i_RGB, 8, 8 )
            ib = ibits( i_RGB, 0, 8 )
          end if

          if( len_in+3 > len_in_max ) then
            ! on compresse
            job = 2
            if( MF_DEFLATE_TO_A85 ) then
               call deflate_stream_to_a85( "", 0,                       &
                                           int_in, len_in, job, ier )
            else
               call deflate_stream_to_hex( int_in, len_in,              &
                                           string_out, len_out,         &
                                           job, ier )
            end if
            if( ier /= 0 ) then
              call PrintMessage( "X11_rect_dump_to_PS", "E",            &
                                 "while deflating image" )
              return
            end if

            if( .not. MF_DEFLATE_TO_A85 ) then
               L = 0
               ! on écrit la chaîne résultante de ZLIB par ligne de
               ! 132 caractères
               ! (c'est la largeur utilisée dans MFPLOT pour les EPS/PDF)
               do
                  if( L >= len_out ) exit
                  if( L+132 >= len_out ) then
                     call gresc( string_out(L+1:len_out) )
                     exit
                  else
                     call gresc( string_out(L+1:L+132) )
                     L = L + 132
                  end if
               end do
            end if
            len_in = 0
          end if

          ! on remplit un buffer de 32 ko
          len_in = len_in + 1
          int_in(len_in) = IR
          len_in = len_in + 1
          int_in(len_in) = IG
          len_in = len_in + 1
          int_in(len_in) = IB

        enddo

      enddo

      if( len_in /= 0 ) then
         ! on compresse et on écrit dans l'EPS ou le PDF
         job = 3
         if( MF_DEFLATE_TO_A85 ) then
            call deflate_stream_to_a85( "", 0,                          &
                                        int_in, len_in, job, ier )
            ! reopen the file, close at step 1.
            open( MF_EPS_UNIT, file=trim(EPS_NAME), position="append" )
         else
            call deflate_stream_to_hex( int_in, len_in,                 &
                                        string_out, len_out,            &
                                        job, ier )
         end if
         if( ier /= 0 ) then
            call PrintMessage( "X11_rect_dump_to_PS", "E",              &
                               "while deflating image" )
         end if
         if( .not. MF_DEFLATE_TO_A85 ) then
            L = 0
            ! on écrit la chaîne résultante de ZLIB par ligne de
            ! 132 caractères
            ! (c'est la largeur utilisée dans MFPLOT pour les EPS/PDF)
            do
               if( L >= len_out ) exit
               if( L+132 >= len_out ) then
                  call gresc( string_out(L+1:len_out) )
                  exit
               else
                  call gresc( string_out(L+1:L+132) )
                  L = L + 132
               end if
            end do
         end if
      end if

      if( MF_DEFLATE_TO_A85 ) then
         call gresc("~>")
      else
         call gresc(">")
      end if

      call EPS_clip_on_viewport_end()

      if( COMMENTS_IN_EPS ) then
         call gresc("%-- end of X11 dump to bitmap")
      end if

   end subroutine X11_rect_dump_to_PS
