! f90 include file

! This routine is called by 'mf_tri_pcolor_draw' in 'TriPcolor_draw.f90'

!_______________________________________________________________________
!
   subroutine PatchTriMesh_PS_PDF_shad( x, y, c, tri )

      real(kind=MF_DOUBLE), intent(in) :: x(:), y(:)
      real(kind=MF_DOUBLE), intent(in) :: tri(:,:)
      integer,              intent(in) :: c(:)
      !------ API end ------

      ! Unstructured Mesh
      ! Direct writing in EPS or PDF (using shading).

      ! For a given mesh, all triangles are visited, and their vertices are
      ! inserted one by one (with an appropriate "edge flag") in a structure
      ! of type "ShadingType 4" for an EPS or a PDF.

      type(mfArray) :: mf_x, mf_y
      type(mfTriConnect) :: tri_connect

      integer :: nn, nt, nf, i, j, node, job, ier, L
      integer :: current_tri, nb_marked_tri, adj_tri, current_node, face

      logical, allocatable :: marked_nodes(:), marked_tri(:)

      logical :: found
      real(kind=MF_DOUBLE) :: width, height
      integer :: edge_flag, last, pre_last, pre_pre_last

      integer :: MsgLevel_save

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale
      real(kind=MF_DOUBLE) :: xy(2), par_val
      character(len=80) :: inline
      character(len=10) :: str1

      ! deflate_stream_to_hex support (zlib)
      integer, parameter :: len_in_max = 65536
      character(len=len_in_max) :: string_in, string_out
      integer :: len_in, len_out
      interface
         subroutine deflate_stream_to_hex( in_bin_str, len_in_bin,      &
                                           out_hex_str, len_out_hex,    &
                                           job, ier )
            character(len=*) :: in_bin_str, out_hex_str
            integer          :: len_in_bin, len_out_hex, job, ier
         end subroutine
         subroutine deflate_stream_to_a85( filename, len_filename,      &
                                           buffer, len_buffer,          &
                                           job, ier )
            character(len=*) :: filename
            integer          :: len_filename
            character(len=*) :: buffer
            integer          :: len_buffer, job, ier
         end subroutine
      end interface

      character(len=256), save :: fnameC
      integer, save :: lfnameC
      type(mf_win_info), pointer :: win

      integer :: BPC, full_range, coord_shift
      integer, parameter :: nb_try_BPC = 2
      integer, parameter :: BitsPerCoordinate(nb_try_BPC) = [ 16, 24 ]
      character(len=4), parameter :: HexForm(nb_try_BPC) = [ "Z4.4", "Z6.6" ]
      real(kind=MF_DOUBLE) :: range_check(4), rdummy
      character(len=25) :: BitsPerCoordinate_str
      character(len=96) :: Decode_str
      character(len=32) :: hexa_format
      logical :: alert
      logical, save :: alert_already_printed = .false.

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      xorg = pgxorg(pgid)
      yorg = pgyorg(pgid)
      xscale = pgxscl(pgid)
      yscale = pgyscl(pgid)

!### TODO: il n'y a pas de quick-return pour les triangles en dehors de
!          la zone d'impression ! C'est dommage de mettre dans l'image
!          (EPS ou PDF) des données qui ne seront finalement pas tracées.

      range_check(:) = [ minval(x), minval(y), maxval(x), maxval(y) ]
      call transf_coords_and_color( range_check(1:2), rdummy )
      call transf_coords_and_color( range_check(3:4), rdummy )
      ! Check numerical range of these coordinates to see whether they
      ! can be written in hexadecimal using 16 or 24 bits.
      alert = .true.
      do i = 1, nb_try_BPC
         BPC = BitsPerCoordinate(i)
         full_range = 2**BPC - 1
         coord_shift = 2**(BPC-1) - 1 ! half range - 1
         if( all(nint(range_check(1:2))+coord_shift > 0) .and.          &
             all(nint(range_check(3:4))+coord_shift < full_range) ) then
            alert = .false.
            write(BitsPerCoordinate_str,"(I0)") BPC
            ! write, e.g. "  /BitsPerCoordinate 16"
            BitsPerCoordinate_str = "  /BitsPerCoordinate "             &
                                    // trim(BitsPerCoordinate_str)
            ! write, e.g. "  /Decode [ -32767 32768 -32767 32768 0 1 ]"
            write(Decode_str,"('  /Decode [ ',4(I0,1X),'0 1 ]')" )      &
                                    -coord_shift, coord_shift+1,        &
                                    -coord_shift, coord_shift+1!!print *, 'Decode_str = "', trim(Decode_str), '"'
            ! write, e.g. "(Z4.4,Z4.4,Z2.2)"
            hexa_format = "(" // HexForm(i) // "," // HexForm(i) // ",Z2.2)"
            exit
         end if
      end do

      if( alert .and. .not. alert_already_printed ) then
         print *, char(27) // "[38;5;202m" ! to switch to orange printing
         print *, "(MUESLI msPatchTri:) Warning: 'out-of-range' pixel values!"
         print *, "     The algorithm to print a triangular mesh in EPS or PDF is not yet"
         print *, "     reliable when using 'shading'='interp' AND zooming strongly in the"
         print *, "     viewport. Hexadecimal overflows prevent to obtain valid printed image,"
         print *, "     therefore this part of your image is skipped."
         print *
         print *, "  -> The only way to avoid this is to revert to 'shading'='flat' OR to"
         print *, "     unzoom the axis before printing (anyway, most of EPS or PDF viewers"
         print *, "     are able to zoom inside the image)."
         print *
         print *, "  -> Note that this warning is printed only one time. The other patches"
         print *, "     of the current image may have or not the same problem!"
         print *, char(27) // "[0m" ! to revert to normal printing
         alert_already_printed = .true.
         return
      end if

      call msEquiv( x, mf_x )
      call msEquiv( y, mf_y )
      ! cannot use pointer for tri because size mismatch between FGL and
      ! FML
      MsgLevel_save = mfGetMsgLevel()
      call msSetMsgLevel(1)
      call msBuildTriConnect( mf_x, mf_y, mf(tri), tri_connect )
      call msSetMsgLevel(MsgLevel_save)

      nn = size(tri_connect%n_xy,1) ! number of nodes
      nt = size(tri_connect%tri_f,1) ! number of triangles
      nf = size(tri_connect%face_tri,1) ! number of faces

      allocate( marked_nodes(nn) )
      marked_nodes(:) = .false.

      allocate( marked_tri(nt) )
      marked_tri(:) = .false.
      nb_marked_tri = 0

      ! prologue ------------------------
      if( PRINTING_EPS ) then

         call gresc("<<")
         call gresc("  /ShadingType 4")
         call gresc("  /ColorSpace /DeviceRGB")
         call gresc("  /BitsPerFlag 8")
         call gresc( trim(BitsPerCoordinate_str) )
         call gresc("  /BitsPerComponent 8")
         call gresc( trim(Decode_str) )
         call gresc("  /DataSource <")

      else ! PRINTING_PDF

         MF_PDF_CURR_SHT4 = MF_PDF_CURR_SHT4 + 1

         ! close current content
         write(inline,"(A,I0,A)") "/Sht4_", MF_PDF_CURR_SHT4, " sh"
         call gresc( trim(inline) )
         call gresc("endstream")
         call gresc("endobj" )
         call gresc("" )

         write(inline,"(I0,A)") MF_PDF_OFF_SHT4 + MF_PDF_CURR_SHT4,     &
                                " 0 obj <<"
         call gresc( trim(inline) )
         call gresc("  /ShadingType 4")
         call gresc("  /ColorSpace /DeviceRGB")
         call gresc("  /BitsPerFlag 8")
         call gresc( trim(BitsPerCoordinate_str) )
         call gresc("  /BitsPerComponent 8")
         call gresc( trim(Decode_str) )
         write(inline,"(A,I0,A)") "  /Function ",                       &
                                  MF_PDF_OFF_CMAP + MF_PDF_CURR_CMAP, " 0 R"
         call gresc( trim(inline) )
         if( MF_DEFLATE_TO_A85 ) then
            call gresc("  /Filter [ /ASCII85Decode /FlateDecode /ASCIIHexDecode ]")
         else
            call gresc("  /Filter [ /ASCIIHexDecode /FlateDecode /ASCIIHexDecode ]")
         end if
         call gresc("  /Length 0         ")
         call gresc(">>")
         call gresc("stream")

      end if
      ! prologue end---------------------

      ! preparing compression, only for PDF
      if( PRINTING_PDF ) then
         job = 1
         if( MF_DEFLATE_TO_A85 ) then
            fnameC = trim(PDF_NAME) // char(0)
            lfnameC = len_trim(PDF_NAME) + 1
            close( MF_PDF_UNIT )
            ! the following routine writes directly in the PDF file.
            call deflate_stream_to_a85( fnameC, lfnameC,                &
                                        string_in, 0, job, ier )
         else
            string_out = ""
            len_out = len(string_out)
            ! à l'initialisation, on a besoin de 'len_in' pour allouer
            ! une fois pour toute le tableau de compression 'compr_str'
            len_in = len_in_max
            call deflate_stream_to_hex( string_in, len_in,              &
                                        string_out, len_out,            &
                                        job, ier )
         end if
         len_in = 0
      end if

      ! start with the triangle #1
      current_tri = 1
      marked_tri(current_tri) = .true.
      nb_marked_tri = nb_marked_tri + 1
      pre_last = 0; last = 0
      ! insert in the output file ----------
      do i = 1, 3
         node = tri_connect%tri_n(current_tri,i)
         pre_pre_last = pre_last; pre_last = last; last = node
         if( PRINTING_EPS ) then
            call gresc("00") ! flag
         else ! PRINTING_PDF
            string_in(len_in+1:len_in+2) = "00" ! flag
            len_in = len_in + 2
         end if
         xy = tri_connect%n_xy(node,:)
         par_val = c(node)
         call transf_coords_and_color( xy, par_val )
         if( PRINTING_EPS ) then
            write(inline,hexa_format) nint(xy)+coord_shift, nint(par_val*255)
            call gresc( trim(inline) )
         else ! PRINTING_PDF
            write(string_in(len_in+1:len_in+10),hexa_format)            &
                                      nint(xy)+coord_shift, nint(par_val*255)
            len_in = len_in + 10
         end if
      end do
      ! insert end -----------------
      ! mark them as used
      marked_nodes( tri_connect%tri_n(current_tri,:) ) = .true.
      do
         if( PRINTING_PDF ) then
            ! Below, the value 36 comes from the greater number of chars
            ! added to strin_in, for each loop iterate.
            if( len_in+36 > len_in_max ) then
               ! compress string_in and write the output in the PDF file
               job = 2
               if( MF_DEFLATE_TO_A85 ) then
                  call deflate_stream_to_a85( "", 0,                    &
                                              string_in, len_in, job, ier )
               else
                  call deflate_stream_to_hex( string_in, len_in,        &
                                              string_out, len_out,      &
                                              job, ier )
               end if
               if( ier /= 0 ) then
                  call PrintMessage( "PatchTriMesh_PS_PDF_shad", "E",   &
                                     "while deflating data" )
                  return
               end if

               if( .not. MF_DEFLATE_TO_A85 ) then
                  L = 0
                  ! on écrit la chaîne résultante de ZLIB par ligne de
                  ! 132 caractères
                  ! (c'est la largeur utilisée dans MFPLOT pour les EPS/PDF)
                  do
                     if( L >= len_out ) exit
                     if( L+132 >= len_out ) then
                        call gresc( string_out(L+1:len_out) )
                        exit
                     else
                        call gresc( string_out(L+1:L+132) )
                        L = L + 132
                     end if
                  end do
               end if
               len_in = 0
            end if
         end if
         if( nb_marked_tri == nt ) exit
         ! If possible, find a free node (i.e. not marked) in the vicinity
         ! of the last node; so, examine the two faces which contains this
         ! last node...
         found = .false.
 loop1:  do i = 1, 3
            face = tri_connect%tri_f(current_tri,i)
            ! check that this face contains the last node
            if( .not. is_in_face( node=last, face=face ) ) cycle
            ! find the adjacent triangle
            adj_tri = tri_connect%face_tri(face,1)
            if( adj_tri == current_tri ) then
               adj_tri = tri_connect%face_tri(face,2)
            end if
            if( adj_tri <= 0 ) then
               cycle ! for another face
            end if
            if( marked_tri(adj_tri) ) cycle ! for another face
            ! try to find a free node in this adjacent tri
            do j = 1, 3
               if( .not. marked_nodes( tri_connect%tri_n(adj_tri,j) ) ) then
                  found = .true.
                  current_tri = adj_tri
                  current_node = tri_connect%tri_n(adj_tri,j)
                  exit loop1
               end if
            end do
         end do loop1
         if( found ) then
            if( is_in_triangle2( node=pre_last, triangle=current_tri ) ) then
               edge_flag = 1
            else ! node 'pre_pre_last' is in triangle 'current_tri'
               edge_flag = 2
            end if
            ! insert in the output file ----------
            node = current_node
            pre_pre_last = pre_last; pre_last = last; last = node
            if( PRINTING_EPS ) then
               write(inline,"(Z2.2)") edge_flag
               call gresc( trim(inline) )
            else ! PRINTING_PDF
               write(string_in(len_in+1:len_in+2),"(Z2.2)") edge_flag
               len_in = len_in + 2
            end if
            xy = tri_connect%n_xy(node,:)
            par_val = c(node)
            call transf_coords_and_color( xy, par_val )
            if( PRINTING_EPS ) then
               write(inline,hexa_format) nint(xy)+coord_shift, nint(par_val*255)
               call gresc( trim(inline) )
            else ! PRINTING_PDF
               write(string_in(len_in+1:len_in+10),hexa_format)         &
                                         nint(xy)+coord_shift, nint(par_val*255)
               len_in = len_in + 10
            end if
            ! insert end -----------------
            marked_nodes( current_node ) = .true.
            marked_tri(current_tri) = .true.
            nb_marked_tri = nb_marked_tri + 1
         else ! not found
            ! select the first triangle not marked
            do j = 1, nt
               if( .not. marked_tri(j) ) then
                  current_tri = j
                  marked_tri(current_tri) = .true.
                  nb_marked_tri = nb_marked_tri + 1
                  exit
               end if
            end do
            marked_nodes(:) = .false.
            ! insert in the output file ----------
            do i = 1, 3
               node = tri_connect%tri_n(current_tri,i)
               pre_pre_last = pre_last; pre_last = last; last = node
               if( PRINTING_EPS ) then
                  call gresc("00") ! flag
               else ! PRINTING_PDF
                  string_in(len_in+1:len_in+2) = "00" ! flag
                  len_in = len_in + 2
               end if
               xy = tri_connect%n_xy(node,:)
               par_val = c(node)
               call transf_coords_and_color( xy, par_val )
               if( PRINTING_EPS ) then
                  write(inline,hexa_format) nint(xy)+coord_shift, nint(par_val*255)
                  call gresc( trim(inline) )
               else ! PRINTING_PDF
                  write(string_in(len_in+1:len_in+10),hexa_format)      &
                                            nint(xy)+coord_shift, nint(par_val*255)
                  len_in = len_in + 10
               end if
            end do
            ! insert end -----------------
            ! find a free node in the current triangle (for sure, it exists)
            do j = 1, 3
               if( .not. marked_nodes( tri_connect%tri_n(current_tri,j) ) ) then
                  current_node = tri_connect%tri_n(current_tri,j)
                  marked_nodes( current_node ) = .true.
               end if
            end do
         end if
      end do

      if( PRINTING_PDF ) then
         if( len_in /= 0 ) then
            ! compress string_in and write the output in the PDF file
            job = 3
            if( MF_DEFLATE_TO_A85 ) then
               call deflate_stream_to_a85( "", 0,                       &
                                           string_in, len_in, job, ier )
               ! reopen the file, close at step 1.
               open( MF_PDF_UNIT, file=trim(PDF_NAME), position="append" )
            else
               call deflate_stream_to_hex( string_in, len_in,           &
                                           string_out, len_out,         &
                                           job, ier )
            end if
            if( ier /= 0 ) then
               call PrintMessage( "PatchTriMesh_PS_PDF_shad", "E",      &
                                  "while deflating data" )
            end if
            if( .not. MF_DEFLATE_TO_A85 ) then
               L = 0
               ! on écrit la chaîne résultante de ZLIB par ligne de
               ! 132 caractères
               ! (c'est la largeur utilisée dans MFPLOT pour les EPS/PDF)
               do
                  if( L >= len_out ) exit
                  if( L+132 >= len_out ) then
                     call gresc( string_out(L+1:len_out) )
                     exit
                  else
                     call gresc( string_out(L+1:L+132) )
                     L = L + 132
                  end if
               end do
            end if
         end if

         if( MF_DEFLATE_TO_A85 ) then
            call gresc("~>")
         else
            call gresc(">")
         end if
      end if

      ! epilogue -------------
      if( PRINTING_EPS ) then

         call gresc("  >")
         call gresc("  colormap")
         call gresc(">>")
         call gresc("shfill")

      else ! PRINTING_PDF

         call gresc("endstream")
         call gresc("endobj" )
         call gresc("" )

         ! open a new content
         MF_PDF_CURR_CONT = MF_PDF_CURR_CONT + 1
         write(inline,"(I0,A)") MF_PDF_OFF_CONT + MF_PDF_CURR_CONT,     &
                                " 0 obj <<"
         call gresc( trim(inline) )
         call gresc("  /Length 0         ")
         call gresc(">>")
         call gresc("stream")

      end if
      ! epilogue end---------------------

      call msRelease( tri_connect )

   contains

      subroutine transf_coords_and_color( xy, par_val )
         real(kind=MF_DOUBLE) :: xy(2), par_val
         xy(1) = nint( xorg + xscale*xy(1) )
         xy(2) = nint( yorg + yscale*xy(2) )
         if( par_val < win%colormap_ci_low ) then
            par_val = win%colormap_ci_low
         else if( win%colormap_ci_high < par_val ) then
            par_val = win%colormap_ci_high
         end if
         par_val = dble(par_val-win%colormap_ci_low)                        &
                   / (win%colormap_ci_high-win%colormap_ci_low)
      end subroutine

      logical function is_in_face( node, face )
         integer, intent(in) :: node, face
         is_in_face = .false.
         if( tri_connect%face_n(face,1) == node ) then
            is_in_face = .true.
            return
         end if
         if( tri_connect%face_n(face,2) == node ) then
            is_in_face = .true.
            return
         end if
      end function is_in_face

      function is_in_triangle2( node, triangle ) result( res )
         integer, intent(in) :: node, triangle
         logical :: res
         res = .false.
         if( tri_connect%tri_n(triangle,1) == node ) then
            res = .true.
            return
         end if
         if( tri_connect%tri_n(triangle,2) == node ) then
            res = .true.
            return
         end if
         if( tri_connect%tri_n(triangle,3) == node ) then
            res = .true.
            return
         end if
      end function is_in_triangle2

   end subroutine PatchTriMesh_PS_PDF_shad
