! f90 include file

!_______________________________________________________________________
!
   subroutine PatchTriCore_PS_PDF_shad( x_pg_3, y_pg_3, c_pg_3,         &
                                        type_of_patch, opacity )

      real(kind=MF_DOUBLE), intent(in) :: x_pg_3(3), y_pg_3(3), opacity
      integer,              intent(in) :: c_pg_3(3), type_of_patch
      !------ API end ------

      ! Direct writing in EPS or PDF (using shading).
      ! Writing is not compressed.

      ! type_of_patch renseigne sur la position de l'élément dans une
      ! suite :
      !   1 : premier élément   (seul le header du shading est écrit)
      !   0 : élément du milieu (rien d'autre n'est écrit)
      !   2 : dernier élément   (seul le trailer du shading est écrit)
      !
      ! Pour une liste ne comportant qu'un seul élément, on doit combiner
      ! et avoir type_of_patch = 3 (la somme), de manière à tout écrire.

      ! On fait attention à la possibilité de débordement lors de
      ! l'écriture hexadécimale, en adaptant la valeur de
      ! BitsPerCoordinate (Cf. EPS or PDF Standard) à 16 ou 24 bits.
      ! Si, réellement, il y a débordement, le dessin du triangle n'est
      ! pas réalisé.

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale
      real(kind=MF_DOUBLE) :: xx(3), yy(3)
      integer :: icol3(3), i
      logical :: first, last
      real(kind=MF_DOUBLE) :: par_val(3)
      character(len=80) :: inline
      character(len=10) :: str1

      real(kind=MF_DOUBLE) :: rbuf(2)
      integer   :: ibuf(1), lchr
      character :: chr
      type(mf_win_info), pointer :: win

      integer :: BPC, full_range, coord_shift
      integer, parameter :: nb_try_BPC = 2
      integer, parameter :: BitsPerCoordinate(nb_try_BPC) = [ 16, 24 ]
      character(len=4), parameter :: HexForm(nb_try_BPC) = [ "Z4.4", "Z6.6" ]
      real(kind=MF_DOUBLE) :: range_check(4)
      character(len=25) :: BitsPerCoordinate_str
      character(len=96) :: Decode_str
      character(len=32) :: hexa_format
      logical :: alert
      logical, save :: alert_already_printed = .false.

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      xorg = pgxorg(pgid)
      yorg = pgyorg(pgid)
      xscale = pgxscl(pgid)
      yscale = pgyscl(pgid)

      ! device coords
      xx(:) = nint( xorg + xscale*x_pg_3(:) )
      yy(:) = nint( yorg + yscale*y_pg_3(:) )

      ! Check numerical range of these coordinates to see whether they
      ! can be written in hexadecimal using 16 or 24 bits.
      range_check(:) = [ minval(xx), minval(yy), maxval(xx), maxval(yy) ]
      alert = .true.
      do i = 1, nb_try_BPC
         BPC = BitsPerCoordinate(i)
         full_range = 2**BPC - 1
         coord_shift = 2**(BPC-1) - 1 ! half range - 1
         if( all(nint(range_check(1:2))+coord_shift > 0) .and.          &
             all(nint(range_check(3:4))+coord_shift < full_range) ) then
            alert = .false.
            write(BitsPerCoordinate_str,"(I0)") BPC
            ! write, e.g. "  /BitsPerCoordinate 16"
            BitsPerCoordinate_str = "  /BitsPerCoordinate "             &
                                    // trim(BitsPerCoordinate_str)
            ! write, e.g. "  /Decode [ -32767 32768 -32767 32768 0 1 ]"
            write(Decode_str,"('  /Decode [ ',4(I0,1X),'0 1 ]')" )      &
                                    -coord_shift, coord_shift+1,        &
                                    -coord_shift, coord_shift+1!!print *, 'Decode_str = "', trim(Decode_str), '"'
            ! write, e.g. "(Z2.2,Z4.4,Z4.4,Z2.2)"
            hexa_format = "(Z2.2," // HexForm(i) // "," // HexForm(i) // ",Z2.2)"
            exit
         end if
      end do

      if( alert .and. .not. alert_already_printed ) then
         print *, char(27) // "[38;5;202m" ! to switch to orange printing
         print *, "(MUESLI msPatchTri:) Warning: 'out-of-range' pixel values!"
         print *, "     The algorithm to print a triangular patch in EPS or PDF is not yet"
         print *, "     reliable when using 'shading'='interp' AND zooming strongly in the"
         print *, "     viewport. Hexadecimal overflows prevent to obtain valid printed image,"
         print *, "     therefore this part of your image is skipped."
         print *
         print *, "  -> The only way to avoid this is to revert to 'shading'='flat' OR to"
         print *, "     unzoom the axis before printing (anyway, most of EPS or PDF viewers"
         print *, "     are able to zoom inside the image)."
         print *
         print *, "  -> Note that this warning is printed only one time. The other patches"
         print *, "     of the current image may have or not the same problem!"
         print *, char(27) // "[0m" ! to revert to normal printing
         alert_already_printed = .true.
         return
      end if

      icol3(:) = c_pg_3(:)
      where( icol3 < win%colormap_ci_low )
         icol3 = win%colormap_ci_low
      else where( win%colormap_ci_high < icol3 )
         icol3 = win%colormap_ci_high
      end where
      do i = 1, 3
         ! parametric value must be in [0.0, 1.0] as specified in the
         ! shading dictionnary (no need to call pgqcr to get the RGB components)
         par_val(i) = dble(icol3(i)-win%colormap_ci_low)                    &
                      / (win%colormap_ci_high-win%colormap_ci_low)
      end do

      first = mod(type_of_patch,2) == 1
      last = type_of_patch/2 == 1

      if( first ) then
         if( PRINTING_EPS ) then

            call gresc("<<")
            call gresc("  /ShadingType 4")
            call gresc("  /ColorSpace /DeviceRGB")
            call gresc("  /BitsPerFlag 8")
            call gresc( trim(BitsPerCoordinate_str) )
            call gresc("  /BitsPerComponent 8")
            call gresc( trim(Decode_str) )
            call gresc("  /DataSource <")

         else ! PRINTING_PDF

            MF_PDF_CURR_SHT4 = MF_PDF_CURR_SHT4 + 1

            ! close current content
            ! process transparency
            if( opacity < 1.0 ) then
               rbuf(1) = opacity
               call grexec( grgtyp, UPDATE_TRANSP_TABLE, rbuf, ibuf, chr, lchr )
               write(inline,"(I0)") ibuf(1)
               inline = "/Transp_" // trim(inline) // " gs"
               call gresc( trim(inline) )
            end if
            write(inline,"(A,I0,A)") "/Sht4_", MF_PDF_CURR_SHT4, " sh"
            call gresc( trim(inline) )
            call gresc("endstream")
            call gresc("endobj" )
            call gresc("" )

            write(inline,"(I0,A)") MF_PDF_OFF_SHT4 + MF_PDF_CURR_SHT4,  &
                                   " 0 obj <<"
            call gresc( trim(inline) )
            call gresc("  /ShadingType 4")
            call gresc("  /ColorSpace /DeviceRGB")
            call gresc("  /BitsPerFlag 8")
            call gresc( trim(BitsPerCoordinate_str) )
            call gresc("  /BitsPerComponent 8")
            call gresc( trim(Decode_str) )
            write(inline,"(A,I0,A)") "  /Function ",                    &
                                     MF_PDF_OFF_CMAP + MF_PDF_CURR_CMAP, " 0 R"
            call gresc( trim(inline) )
            call gresc("  /Filter /ASCIIHexDecode")
            call gresc("  /Length 0         ")
            call gresc(">>")
            call gresc("stream")

         end if

      end if

      do i = 1, 3
         ! first number ("0") is a flag
         write(inline,hexa_format) 0,                                   &
                                   nint(xx(i))+coord_shift,             &
                                   nint(yy(i))+coord_shift,             &
                                   nint(par_val(i)*255)
         call gresc( trim(inline) )
      end do

      if( last ) then

         if( PRINTING_EPS ) then

            call gresc("  >")
            call gresc("  colormap")
            call gresc(">>")
            call gresc( "shfill" )

         else ! PRINTING_PDF

            call gresc("endstream")
            call gresc("endobj" )
            call gresc("" )

            ! open a new content
            MF_PDF_CURR_CONT = MF_PDF_CURR_CONT + 1
            write(inline,"(I0,A)") MF_PDF_OFF_CONT + MF_PDF_CURR_CONT,  &
                                   " 0 obj <<"
            call gresc( trim(inline) )
            call gresc("  /Length 0         ")
            call gresc(">>")
            call gresc("stream")

         end if

      end if

   end subroutine PatchTriCore_PS_PDF_shad
