! f90 include file

!_______________________________________________________________________
!
   subroutine PatchTriCore_PS_PDF_flat( x_pg_3, y_pg_3, color, opacity )

      real(kind=MF_DOUBLE), intent(in) :: x_pg_3(3), y_pg_3(3), opacity
      integer,              intent(in) :: color
      !------ API end ------

      ! Direct writing in EPS or PDF. (flat color)

      ! For the EPS file, the MFPLOT shortcuts BP, LP, EP are used
      ! (see in the header of the EPS driver)

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale
      integer :: ix(3), iy(3)

      character(len=80) :: inline

      real(kind=MF_DOUBLE) :: rbuf(2)
      integer   :: ibuf(1), lchr
      character :: chr

   !------ end of declarations -- execution starts hereafter  ------

      xorg = PGXORG(PGID)
      yorg = PGYORG(PGID)
      xscale = PGXSCL(PGID)
      yscale = PGYSCL(PGID)

      ix(:) = nint( xorg + x_pg_3(:)*xscale )
      iy(:) = nint( yorg + y_pg_3(:)*yscale )

      gr_pdf_color_intent = 2 ! Fill
      call grsci(color)

      if( PRINTING_EPS ) then
         write(inline,100) ix(1), iy(1), ix(2), iy(2), ix(3), iy(3)
 100     format( I0,1X,I0, " BP ", I0,1X,I0, " LP ", I0,1X,I0, " EP" )
         call gresc( trim(inline) )
      else ! PRINTING_PDF
         ! process transparency
         if( opacity < 1.0 ) then
            rbuf(1) = opacity
            call grexec( grgtyp, UPDATE_TRANSP_TABLE, rbuf, ibuf, chr, lchr )
            write(inline,"(I0)") ibuf(1)
            inline = "/Transp_" // trim(inline) // " gs"
            call gresc( trim(inline) )
         end if
         write(inline,200) ix(1), iy(1), ix(2), iy(2), ix(3), iy(3)
         ! "f" = close and fill
 200     format( I0,1X,I0, " m ", I0,1X,I0, " l ", I0,1X,I0, " l f" )
         call gresc( trim(inline) )
      end if

   end subroutine PatchTriCore_PS_PDF_flat
