! f90 include file

!_______________________________________________________________________
!
   subroutine PatchRectCore_PS_PDF_flat( xmin, xmax, ymin, ymax, color )

      real(kind=MF_DOUBLE), intent(in) :: xmin, xmax, ymin, ymax
      integer,              intent(in) :: color
      !------ API end ------

      ! Direct writing in EPS or PDF. (flat color and no transparency)

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale

      integer :: ixmin, ixmax, iymin, iymax

      character(len=80) :: inline

   !------ end of declarations -- execution starts hereafter  ------

      xorg = pgxorg(pgid)
      yorg = pgyorg(pgid)
      xscale = pgxscl(pgid)
      yscale = pgyscl(pgid)

      ! device coordinates
      ixmin = nint( xorg + xmin*xscale )
      ixmax = nint( xorg + xmax*xscale )
      iymin = nint( yorg + ymin*yscale )
      iymax = nint( yorg + ymax*yscale )

      gr_pdf_color_intent = 2 ! Fill
      call grsci(color)

      if( PRINTING_EPS ) then
         write(inline,100) ixmin, iymin, ixmax-ixmin, iymax-iymin
 100     format( 4(I0,1X)," RF")
         call gresc( trim(inline) )
      else ! PRINTING_PDF
         write(inline,200) ixmin, iymin, ixmax-ixmin, iymax-iymin
 200     format( 4(I0,1X)," re F")
         call gresc( trim(inline) )
      end if

   end subroutine PatchRectCore_PS_PDF_flat
