! f90 include file

!_______________________________________________________________________
!
   subroutine PatchQuadCore_PS_PDF_shad( x_pg_4, y_pg_4, c_pg_4,        &
                                         type_of_patch, opacity )

      real(kind=MF_DOUBLE), intent(in) :: x_pg_4(4), y_pg_4(4), opacity
      integer,              intent(in) :: c_pg_4(4), type_of_patch
      !------ API end ------

      ! General quadrangle

      ! Direct writing in EPS or PDF (using shading).
      ! Writing is not compressed.

      ! type_of_patch renseigne sur la position de l'élément dans une
      ! suite :
      !   1 : premier élément   (seul le header du shading est écrit)
      !   0 : élément du milieu (rien d'autre n'est écrit)
      !   2 : dernier élément   (seul le trailer du shading est écrit)
      !
      ! Pour une liste ne comportant qu'un seul élément, on doit combiner
      ! et avoir type_of_patch = 3 (la somme), de manière à tout écrire.

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale

      integer :: ix(4), iy(4), ic(4), i, ifirst, shift, itmp
      logical :: first, last
      real(kind=MF_DOUBLE) :: par_val(4), one_third(2), two_third(2)

      ! need to have high range because the product involves integer
      ! coords to the power 4.
      integer*8 :: orient_123, orient_234, orient_product

      character(len=80) :: inline
      character(len=10) :: str1
      integer :: max_ix_abs, max_iy_abs, max_data

      real(kind=MF_DOUBLE) :: rbuf(2)
      integer   :: ibuf(1), lchr
      character :: chr
      type(mf_win_info), pointer :: win

      integer :: BPC, full_range, coord_shift
      integer, parameter :: nb_try_BPC = 2
      integer, parameter :: BitsPerCoordinate(nb_try_BPC) = [ 16, 24 ]
      character(len=4), parameter :: HexForm(nb_try_BPC) = [ "Z4.4", "Z6.6" ]
      real(kind=MF_DOUBLE) :: range_check(4)
      character(len=25) :: BitsPerCoordinate_str
      character(len=96) :: Decode_str
      character(len=32) :: hexa_format
      logical :: alert
      logical, save :: alert_already_printed = .false.

   !------ end of declarations -- execution starts hereafter  ------

      win => mf_win_db(CURRENT_WIN_ID)

      xorg = pgxorg(pgid)
      yorg = pgyorg(pgid)
      xscale = pgxscl(pgid)
      yscale = pgyscl(pgid)

      ! Numbering is modified in order to have:
      !
      !               1 +
      !                / \
      !               /   \           * quadrangle 1-2-3-4 is direct
      !              /     \
      !           2 +       \         * vertex 1 is the highest
      !              \       + 4        (and most left if y(2)=y(1))
      !               \     /
      !                \   /
      !                 \ /
      !                3 +
      !

      ! device coordinates
      ix(:) = nint( xorg + x_pg_4(:)*xscale )
      iy(:) = nint( yorg + y_pg_4(:)*yscale )

      ! Check numerical range of these coordinates to see whether they
      ! can be written in hexadecimal using 16 or 24 bits.
      range_check(:) = [ minval(ix), minval(iy), maxval(ix), maxval(iy) ]
      alert = .true.
      do i = 1, nb_try_BPC
         BPC = BitsPerCoordinate(i)
         full_range = 2**BPC - 1
         coord_shift = 2**(BPC-1) - 1 ! half range - 1
         if( all(nint(range_check(1:2))+coord_shift > 0) .and.          &
             all(nint(range_check(3:4))+coord_shift < full_range) ) then
            alert = .false.
            write(BitsPerCoordinate_str,"(I0)") BPC
            ! write, e.g. "  /BitsPerCoordinate 16"
            BitsPerCoordinate_str = "  /BitsPerCoordinate "             &
                                    // trim(BitsPerCoordinate_str)
            ! write, e.g. "  /Decode [ -32767 32768 -32767 32768 0 1 ]"
            write(Decode_str,"('  /Decode [ ',4(I0,1X),'0 1 ]')" )      &
                                    -coord_shift, coord_shift+1,        &
                                    -coord_shift, coord_shift+1!!print *, 'Decode_str = "', trim(Decode_str), '"'
            ! write, e.g. "(6(Z4.4))"
            hexa_format = "(6(" // HexForm(i) // "))"
            exit
         end if
      end do

      if( alert .and. .not. alert_already_printed ) then
         print *, char(27) // "[38;5;202m" ! to switch to orange printing
         print *, "(MUESLI msPatchQuad:) Warning: 'out-of-range' pixel values!"
         print *, "     The algorithm to print a quadrangle patch in EPS or PDF is not yet"
         print *, "     reliable when using 'shading'='interp' AND zooming strongly in the"
         print *, "     viewport. Hexadecimal overflows prevent to obtain valid printed image,"
         print *, "     therefore this part of your image is skipped."
         print *
         print *, "  -> The only way to avoid this is to revert to 'shading'='flat' OR to"
         print *, "     unzoom the axis before printing (anyway, most of EPS or PDF viewers"
         print *, "     are able to zoom inside the image)."
         print *
         print *, "  -> Note that this warning is printed only one time. The other patches"
         print *, "     of the current image may have or not the same problem!"
         print *, char(27) // "[0m" ! to revert to normal printing
         alert_already_printed = .true.
         return
      end if

      ! copy data
      ic(:) = c_pg_4(:)

      ! Orientation of triangles 1-2-3 and 2-3-4 must be the same.
      orient_123 = (ix(2)-ix(1))*(iy(3)-iy(1)) - (iy(2)-iy(1))*(ix(3)-ix(1))
      orient_234 = (ix(3)-ix(2))*(iy(4)-iy(2)) - (iy(3)-iy(2))*(ix(4)-ix(2))
      orient_product = orient_123*orient_234

      if( abs(orient_product) == 0 ) then
         call PrintMessage( "PatchQuadCore_PS_PDF_shad", "I",           &
                            "Degenerate quadrangle." )
      else if( orient_product < 0 ) then
         ! swap vertices 3 and 4
         itmp  = ix(3)
         ix(3) = ix(4)
         ix(4) = itmp
         itmp  = iy(3)
         iy(3) = iy(4)
         iy(4) = itmp
         itmp  = ic(3)
         ic(3) = ic(4)
         ic(4) = itmp
      end if

      ! triangle 1-2-3 must be direct
      orient_123 = (ix(2)-ix(1))*(iy(3)-iy(1)) - (iy(2)-iy(1))*(ix(3)-ix(1))
      if( orient_123 < 0 ) then
         ! swap vertices 2 and 4
         itmp  = ix(2)
         ix(2) = ix(4)
         ix(4) = itmp
         itmp  = iy(2)
         iy(2) = iy(4)
         iy(4) = itmp
         itmp  = ic(2)
         ic(2) = ic(4)
         ic(4) = itmp
      else if( orient_123 == 0 ) then
        call PrintMessage( "PatchQuadCore_PS_PDF_shad", "I",            &
                           "Degenerate quadrangle." )
      end if

      ! search then the highest (in z) and most left vertex
      ifirst = 1
      do i = 2, 4
         if( iy(i) > iy(ifirst) ) then
            ifirst = i
         else if( iy(i) == iy(ifirst) ) then
            if( ix(i) < ix(ifirst) ) then
               ifirst = i
            end if
         end if
      end do
      ! circular permutation to have vertex 1 at the top-left place
      shift = ifirst - 1
      if( shift /= 0 ) then
         ix = cshift( ix, shift )
         iy = cshift( iy, shift )
         ic = cshift( ic, shift )
      end if

      where( ic < win%colormap_ci_low )
         ic = win%colormap_ci_low
      else where( win%colormap_ci_high < ic )
         ic = win%colormap_ci_high
      end where
      ! parametric value must be in [0.0, 1.0] as specified in the
      ! shading dictionnary (no need to call pgqcr to get the RGB components)
      par_val(:) = dble(ic(:)-win%colormap_ci_low)                          &
                   / (win%colormap_ci_high-win%colormap_ci_low)

      first = mod(type_of_patch,2) == 1
      last = type_of_patch/2 == 1

      if( first ) then

         if( PRINTING_EPS ) then

            call gresc("<<")
            call gresc("  /ShadingType 6")
            call gresc("  /ColorSpace /DeviceRGB")
            call gresc("  /BitsPerFlag 8")
            call gresc( trim(BitsPerCoordinate_str) )
            call gresc("  /BitsPerComponent 8")
            call gresc( trim(Decode_str) )
            call gresc("  /DataSource <")

         else ! PRINTING_PDF

            MF_PDF_CURR_SHT6 = MF_PDF_CURR_SHT6 + 1

            ! close current content
            ! process transparency
            if( opacity < 1.0 ) then
               rbuf(1) = opacity
               call grexec( grgtyp, UPDATE_TRANSP_TABLE, rbuf, ibuf, chr, lchr )
               write(inline,"(I0)") ibuf(1)
               inline = "/Transp_" // trim(inline) // " gs"
               call gresc( trim(inline) )
            end if
            write(inline,"(A,I0,A)") "/Sht6_", MF_PDF_CURR_SHT6, " sh"
            call gresc( trim(inline) )
            call gresc("endstream")
            call gresc("endobj")
            call gresc("")

            write(inline,"(I0,A)") MF_PDF_OFF_SHT6 + MF_PDF_CURR_SHT6,  &
                                  " 0 obj <<"
            call gresc( trim(inline) )
            call gresc("  /ShadingType 6")
            call gresc("  /ColorSpace /DeviceRGB")
            call gresc("  /BitsPerFlag 8")
            call gresc( trim(BitsPerCoordinate_str) )
            call gresc("  /BitsPerComponent 8")
            call gresc( trim(Decode_str) )
            write(inline,"(A,I0,A)") "  /Function ",                    &
                                     MF_PDF_OFF_CMAP + MF_PDF_CURR_CMAP, " 0 R"
            call gresc( trim(inline) )
            call gresc("  /Filter /ASCIIHexDecode")
            call gresc("  /Length 0         ")
            call gresc(">>")
            call gresc("stream")

         end if

      end if

      ! quadrangle 1-2-3-4: Warning, position of control points is very
      ! important to obtain a strictly bilinear colour interpolation inside
      ! the rectangle. Indeed, the mapping of the boundary parameter must
      ! be linear itself: therefore, control points must be located at the
      ! thirds (1/3 and 2/3) of each side.
      call gresc("00") ! flag
      do i = 1, 3
         one_third = [ ix(i)*2./3.+ix(i+1)*1./3., iy(i)*2./3.+iy(i+1)*1./3. ]
         two_third = [ ix(i)*1./3.+ix(i+1)*2./3., iy(i)*1./3.+iy(i+1)*2./3. ]
         write(inline,hexa_format) ix(i)+coord_shift, iy(i)+coord_shift, &
                                   nint(one_third)+coord_shift,         &
                                   nint(two_third)+coord_shift
         call gresc( trim(inline) )
      end do
      one_third = [ ix(4)*2./3.+ix(1)*1./3., iy(4)*2./3.+iy(1)*1./3. ]
      two_third = [ ix(4)*1./3.+ix(1)*2./3., iy(4)*1./3.+iy(1)*2./3. ]
      write(inline,hexa_format) ix(4)+coord_shift, iy(4)+coord_shift,   &
                                nint(one_third)+coord_shift,            &
                                nint(two_third)+coord_shift
      call gresc( trim(inline) )
      write(inline,200) nint( par_val(:)*255 )
      call gresc( trim(inline) )
 200  format(4(Z2.2))

      if( last ) then

         if( PRINTING_EPS ) then

            call gresc("  >")
            call gresc("  colormap")
            call gresc(">>")
            call gresc("shfill")

         else ! PRINTING_PDF

            call gresc("endstream")
            call gresc("endobj")
            call gresc("")

            ! open a new content
            MF_PDF_CURR_CONT = MF_PDF_CURR_CONT + 1
            write(inline,"(I0,A)") MF_PDF_OFF_CONT + MF_PDF_CURR_CONT,  &
                                   " 0 obj <<"
            call gresc( trim(inline) )
            call gresc("  /Length 0         ")
            call gresc(">>")
            call gresc("stream")

         end if

      end if

   end subroutine PatchQuadCore_PS_PDF_shad
