! f90 include file

!_______________________________________________________________________
!
   subroutine PatchQuadCore_PS_PDF_flat( x_pg_4, y_pg_4, color, opacity )

      real(kind=MF_DOUBLE), intent(in) :: x_pg_4(4), y_pg_4(4), opacity
      integer,              intent(in) :: color
      !------ API end ------

      ! Direct writing in EPS or PDF. (flat color)

      real(kind=MF_DOUBLE) :: xorg, yorg, xscale, yscale

      integer :: ix(4), iy(4), ifirst, shift, itmp, i

      ! need to have high range because the product involves integer
      ! coords to the power 4.
      integer*8 :: orient_123, orient_234, orient_product

      character(len=80) :: inline

      real(kind=MF_DOUBLE) :: rbuf(2)
      integer   :: ibuf(1), lchr
      character :: chr

   !------ end of declarations -- execution starts hereafter  ------

      xorg = pgxorg(pgid)
      yorg = pgyorg(pgid)
      xscale = pgxscl(pgid)
      yscale = pgyscl(pgid)

      ! Numbering is modified in order to have:
      !
      !               1 +
      !                / \
      !               /   \           * quadrangle 1-2-3-4 is direct
      !              /     \
      !           2 +       \         * vertex 1 is the highest
      !              \       + 4        (and most left if y(2)=y(1))
      !               \     /
      !                \   /
      !                 \ /
      !                3 +
      !

      ! device coordinates
      ix(:) = nint( xorg + x_pg_4(:)*xscale )
      iy(:) = nint( yorg + y_pg_4(:)*yscale )

      ! Orientation of triangles 1-2-3 and 2-3-4 must be the same.
      orient_123 = (ix(2)-ix(1))*(iy(3)-iy(1)) - (iy(2)-iy(1))*(ix(3)-ix(1))
      orient_234 = (ix(3)-ix(2))*(iy(4)-iy(2)) - (iy(3)-iy(2))*(ix(4)-ix(2))
      orient_product = orient_123*orient_234

      if( abs(orient_product) == 0 ) then
         call PrintMessage( "PatchQuadCore_PS_PDF_flat", "I",           &
                            "Degenerate quadrangle." )
      else if( orient_product < 0 ) then
         ! swap vertices 3 and 4
          itmp = ix(3)
         ix(3) = ix(4)
         ix(4) = itmp
          itmp = iy(3)
         iy(3) = iy(4)
         iy(4) = itmp
      end if

      ! triangle 1-2-3 must be direct
      orient_123 = (ix(2)-ix(1))*(iy(3)-iy(1)) - (iy(2)-iy(1))*(ix(3)-ix(1))
      if( orient_123 < 0 ) then
         ! swap vertices 2 and 4
          itmp = ix(2)
         ix(2) = ix(4)
         ix(4) = itmp
          itmp = iy(2)
         iy(2) = iy(4)
         iy(4) = itmp
      else if( orient_123 == 0 ) then
        call PrintMessage( "PatchQuadCore_PS_PDF_flat", "I",            &
                           "Degenerate quadrangle." )
      end if

      ! search then the highest (in z) and most left vertex
      ifirst = 1
      do i = 2, 4
         if( iy(i) > iy(ifirst) ) then
            ifirst = i
         else if( iy(i) == iy(ifirst) ) then
            if( ix(i) < ix(ifirst) ) then
               ifirst = i
            end if
         end if
      end do
      ! circular permutation to have vertex 1 at the top-left place
      shift = ifirst - 1
      if( shift /= 0 ) then
         ix = cshift( ix, shift )
         iy = cshift( iy, shift )
      end if

      gr_pdf_color_intent = 2 ! Fill
      call grsci(color)

      if( PRINTING_EPS ) then
         write(inline,100) ix(1), iy(1), ix(2), iy(2),                  &
                           ix(3), iy(3), ix(4), iy(4)
 100     format( I0,1X,I0, " BP ", I0,1X,I0, " LP ",                    &
                 I0,1X,I0, " LP ", I0,1X,I0, " EP" )
         call gresc( trim(inline) )
      else ! PRINTING_PDF
         ! process transparency
         if( opacity < 1.0 ) then
            rbuf(1) = opacity
            call grexec( grgtyp, UPDATE_TRANSP_TABLE, rbuf, ibuf, chr, lchr )
            write(inline,"(I0)") ibuf(1)
            inline = "/Transp_" // trim(inline) // " gs"
            call gresc( trim(inline) )
         end if
         write(inline,200) ix(1), iy(1), ix(2), iy(2), ix(3), iy(3), ix(4), iy(4)
         ! "f" = close and fill
 200     format( I0,1X,I0, " m ", I0,1X,I0, " l ",                      &
                 I0,1X,I0, " l ", I0,1X,I0, " l f" )
         call gresc( trim(inline) )
      end if

   end subroutine PatchQuadCore_PS_PDF_flat
