! GRNORMCURS_EC -- Change cursor shape to normal.

integer function GRNORMCURS_EC( )

   ! GRNORMCURS_EC: Change cursor shape to normal.
   ! Actually, properly finish a pgband command.
   !
   ! Returns:
   !
   ! GRNORMCURS_EC (integer): 1 if the call was successful;
   !                          0 if the device has no cursor or
   !                            some other error occurs.
   !
   !--
   ! 12-Jun-2006 - new routine. Calls opcode 61 in X11 driver.
   ! 27-Aug-2006 - fix: remove 'CALL GRSLCT(IDENT)', because IDENT was
   !               an unknown and uninitialized variable.
   ! 16-Dec-2007 - remove ERRCNT (unused in MUESLI).
   !  7-Jul-2021 - remove test on grpltd(grcide). Remove also the call
   !               to opcode 1 in X11 driver (useful only if an error was
   !               printed).
   !-----------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr, icurs
   character*16 :: chr

   character :: c

   ! Does the device have a cursor?
   c = grgcap(grcide)(2:2)
   icurs = 0
   if( c == 'C' .or. c == 'X' ) icurs = 1

   if( icurs > 0 ) then
      ! Device does have a cursor.
      call grexec( grgtyp, FINISH_READ_CURSOR, rbuf, ibuf, chr, lchr )
      grnormcurs_ec = 1
   else
      ! Other devices are illegal.
      grnormcurs_ec = 0
   end if

end function
