!*GRCURS_EC -- Read the current cursor position. (no wait)
integer function GRCURS_EC( ident, ix, iy, inside, ilenx, ileny )

   integer :: ident, ix, iy, inside, ilenx, ileny

   ! GRCURS_EC: Read the current cursor position.
   ! The position is returned in absolute device coordinates (pixels).
   !
   ! Returns:
   !
   ! GRCURS_EC (integer): 1 if the call was successful;
   !                      0 if the device has no cursor or
   !                        some other error occurs.
   !
   ! Arguments:
   !
   ! IDENT  (integer, in) : GRPCKG plot identifier (from GROPEN).
   !
   ! IX     (integer, out): the device x-coordinate of the cursor.
   ! IY     (integer, out): the device y-coordinate of the cursor.
   ! INSIDE (integer, out): 1 if the cursor is inside the X11 window
   !                        0          "       outside     "    "
   ! ILENX  (integer, out): useful size (x) of the X11 window (pixels)
   ! ILENY  (integer, out): useful size (y) of the X11 window (pixels)
   !--
   ! 19-Mar-2003 - new routine [É. Canot].
   !               communique avec xwdriv par ifunc=50 (2d arg. grexec)
   !               et par RBUF(3) pour récupérer INSIDE
   !-----------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(3), lchr, icurs, errcnt = 0
   character(len=16) :: chr
   character :: c

   ! Validate identifier, and select device.
   call grslct( ident )

   ! Begin picture if necessary.
   if( .not. grpltd(grcide) ) call grbpic

   ! Does the device have a cursor?

   c = grgcap(grcide)(2:2)
   if( c == 'C' .or. c == 'X' ) then
      icurs = 1
   else
      icurs = 0
   end if
   if( icurs > 0 ) then

      ! Device does have a cursor.
      lchr = 0
      call grexec( grgtyp, GET_CURSOR_POS, rbuf, ibuf, chr, lchr )
      if( ibuf(3) > 0 ) then
         inside = 1
         ix = ibuf(1)
         iy = ibuf(2)
         ilenx = grxmxa(grcide)
         ileny = grymxa(grcide)
      else
         inside = 0
      end if
      grcurs_ec = 1

   else

      ! Other devices are illegal.
      call grexec( grgtyp, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      lchr = index(chr,' ')
      if( errcnt <= 10 ) call grwarn('Output device has no cursor: '//chr(:lchr))
      grcurs_ec = 0
      errcnt = errcnt + 1

   end if

end function
