! GRCLICK_EC -- Get a click with the ? button

integer function GRCLICK_EC( ident, iclick )

   integer :: ident, iclick

   ! GRCLICK_EC: Get a click with the ? button
   !
   ! Returns:
   !
   ! GRCLICK_EC (integer): 1 if the call was successful;
   !                       0 if the device has no cursor or
   !                         some other error occurs.
   !
   ! Arguments:
   !
   ! IDENT  (integer, in) : GRPCKG plot identifier (from GROPEN).
   !
   ! ICLICK (integer, out): 1 if there is a click inside the X11 window
   !                        0 if not
   !--
   ! 13-Mar-2001 - new routine [É. Canot].
   !               communique avec xwdriv par ifunc=51 (2d arg. grexec)
   !               et par RBUF(3) pour récupérer ICLICK
   !-----------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr, icurs, errcnt = 0
   character(len=16) :: chr
   character :: c

   ! Validate identifier, and select device.
   call grslct( ident )

   ! Flush the buffer.
!!print *, "GRCLICK_EC: calling GRTERM..."
!!   call grterm

   ! Begin picture if necessary.
   if( .not. grpltd(grcide) ) call grbpic

   ! Does the device have a cursor?
   c = grgcap(grcide)(2:2)
   if( c == 'C' .or. C == 'X' ) then
      icurs = 1
   else
      icurs = 0
   end if
   if( icurs > 0 ) then

      ! Device does have a cursor.
      lchr = 0
      call grexec( grgtyp, GET_CLICK_IN_WIN, rbuf, ibuf, chr, lchr )
      if( ibuf(1) > 0. ) then
         iclick = 1
      else
         iclick = 0
      end if
      grclick_ec = 1

   else

      ! Other devices are illegal.
      call grexec( grgtyp, GET_DEV_NAME, rbuf, ibuf, chr, lchr )
      lchr = index(chr,' ')
      if( errcnt <= 10 ) call grwarn('Output device has no cursor: '//chr(:lchr))
      grclick_ec = 0
      errcnt = errcnt + 1

   end if

end function
