! CURSDEV_EC -- Read the current cursor position.

integer function CURSDEV_EC( inside, ix, iy )

   integer :: inside, ix, iy

   ! CURSDEV_EC: Read the current cursor position.
   ! The position is returned in device coordinates.
   !
   ! Returns:
   !
   !  CURSDEV_EC     : 1 if the call was successful;
   !                   0 if the device has no cursor or
   !                     some other error occurs.
   ! Arguments:
   !
   !  INSIDE   (out) : 1 if the cursor is inside the X11 window
   !                   0          "       outside     "    "
   !                   (in the latter case, all following variables are
   !                    not relevant and are set to zero)
   !  IX       (out) : the device x-coordinate of the cursor
   !  IY       (out) : the device y-coordinate of the cursor
   !--
   ! 10-Juin-2006 - new routine [É. Canot].
   !-----------------------------------------------------------------------


   integer :: ilenx, ileny

   ! Get cursor position and some parameters of the X11 window
   cursdev_ec = grcurs_ec( pgid, ix, iy, inside, ilenx, ileny )

   ! Inside/outside test
   if( inside == 0 ) then
      ix = 0
      iy = 0
   endif

end function
