/*
 **GRUSER -- get user name (POSIX)
 *+
 *     SUBROUTINE GRUSER( USERNAME, L )
 *     character(len=*), intent(out) :: USERNAME
 *     INTEGER,          intent(out) :: L
 *
 * Get the name of the user running the program.
 *
 * Arguments:
 *  USERNAME : receives user name, truncated or extended with
 *           blanks as necessary.
 *  L      : receives the number of characters in USERNAME, excluding
 *           trailing blanks.
 *--
 * 08-Nov-1994
 *-----------------------------------------------------------------------
 */

#include <unistd.h>

#ifdef UNDERSCORE
#  define GRUSER gruser_
#else
#  define GRUSER gruser
#endif

void GRUSER( char *username, int *length,
             int maxlen ) {
  int i;
   /* Get the login name of the MFPLOT user. */
  char *user = getlogin();

  /* If the user name is not available substitute an empty string. */
  if( !user )
    user = "";
  /* Copy the user name to the output username. */
  for( i=0; i<maxlen && user[i]; i++ )
    username[i] = user[i];
  /* Return the un-padded length of the user name string. */
  *length = i;
  /* Pad to the end of the output string with spaces. */
  for( ; i<maxlen; i++ )
    username[i] = ' ';
}
