! GRGLUN -- get a Fortran logical unit number (UNIX)

subroutine GRGLUN( lun )

   integer, intent(out) :: lun

   ! Get an unused Fortran logical unit number.
   ! Returns a Logical Unit Number that is not currently opened.
   ! After GRGLUN is called, the unit should be opened to reserve
   ! the unit number for future calls.  Once a unit is closed, it
   ! becomes free and another call to GRGLUN could return the same
   ! number.  Also, GRGLUN will not return a number in the range 1-9
   ! as older software will often use these units without warning.
   !
   ! Arguments:
   !  LUN : receives the logical unit number, or -1 on error.
   !--
   ! 12-Feb-1989 [AFT/TJP].
   !-----------------------------------------------------------------------

   integer :: i
   logical :: fopen
   !---
   do i = 99, 10, -1
      inquire( unit=i, opened=fopen )
      if( .not. fopen ) then
         lun = i
         return
      end if
   end do
   call grwarn('GRGLUN: out of units.')
   lun = -1

end subroutine
