! GRGENV -- get value of MFPLOT environment parameter (UNIX)

subroutine GRGENV( name, value, L )

   character(len=*), intent(in)  :: name
   character(len=*), intent(out) :: value
   integer,          intent(out) :: L

   ! Return the value of a MFPLOT environment parameter. Environment
   ! parameters are UNIX environment variables. Translation
   ! is case-sensitive.
   !
   ! Arguments:
   !  NAME   : (input) the name of the parameter to evaluate.
   !  VALUE  : receives the value of the parameter, truncated or extended
   !           with blanks as necessary. If the parameter is undefined,
   !           a blank string is returned.
   !  L      : receives the number of characters in VALUE, excluding
   !           trailing blanks. If the parameter is undefined, zero is
   !           returned.
   !--
   ! 19-Jan-1988
   !-----------------------------------------------------------------------
   integer :: lin
   character(len=32) :: test
   !---

   test = 'MFPLOT_' // name
   lin = len_trim( test )

   call getenv( test(:lin), value )

   L = len_trim( value )

end subroutine
