/*
 * Return the X11 window ID of the terminal which launched this program
 * (or 0 if we cannot open an X11 Display).
 * It is used to change the focus.
 *--
 * 16-Nov-2021 (É. Canot)
 *-----------------------------------------------------------------------
 */

#include <stdio.h>
#include <unistd.h>
#include <X11/Xlib.h>

#ifdef UNDERSCORE
#  define GET_TERMINAL_X11_ID get_terminal_x11_id_
#else
#  define GET_TERMINAL_X11_ID get_terminal_x11_id
#endif

int GET_TERMINAL_X11_ID() {
  Display *display;
  Window window;
  int revert;
  int id;
  char *name;

  display = XOpenDisplay( NULL );
  if( display ) {
    XGetInputFocus( display, &window, &revert );
    id = (int) window;
    XCloseDisplay( display );
    return id;
  } else {
    return 0;
  }
}
