/*
 * Check the status of the keyboard with respect to the SHIFT and the
 * CONTROL keys. Returns 1 if the corresponding key is down during the call.
 *--
 *  8-Jul-2022 (É. Canot)
 *-----------------------------------------------------------------------
 */

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <stdbool.h>
#include <stdio.h>

#ifdef UNDERSCORE
#  define GET_MOD_KEYS get_mod_keys_
#else
#  define GET_MOD_KEYS get_mod_keys
#endif

int GET_MOD_KEYS( int *key ) {
  Display *display;

  display = XOpenDisplay( NULL );
  if( display ) {
    char keys_return[32];
    XQueryKeymap( display, keys_return );
    KeyCode kc;
    bool pressed_1, pressed_2;
    int out;

    if (*key==1) {
      /* Shift keys -------------------------------------------------------- */
      kc = XKeysymToKeycode( display, XK_Shift_L );
      pressed_1 = !!( keys_return[ kc>>3 ] & ( 1<<(kc&7) ) );
//      printf("\n  ShiftLeft is %spressed\n", pressed_1 ? "" : "not ");

      kc = XKeysymToKeycode( display, XK_Shift_R );
      pressed_2 = !!( keys_return[ kc>>3 ] & ( 1<<(kc&7) ) );
//      printf("  ShiftRight is %spressed\n", pressed_2 ? "" : "not ");

      if (pressed_1 | pressed_2) {
         out = 1;
      } else {
         out = 0;
      }
    } else { /* key==2 */
      /* Control keys ------------------------------------------------------ */
      kc = XKeysymToKeycode( display, XK_Control_L );
      pressed_1 = !!( keys_return[ kc>>3 ] & ( 1<<(kc&7) ) );
//      printf("\n  ControlLeft is %spressed\n", pressed_1 ? "" : "not ");

      kc = XKeysymToKeycode( display, XK_Control_R );
      pressed_2 = !!( keys_return[ kc>>3 ] & ( 1<<(kc&7) ) );
//      printf("  ControlRight is %spressed\n", pressed_2 ? "" : "not ");

      if (pressed_1 | pressed_2) {
         out = 1;
      } else {
         out = 0;
      }
    }
    XCloseDisplay( display );
    return out;
  } else {
    return 0;
  }
}
