!##############################################################################
! Warning: this file contains mixed character set (ISO-8859-15 for comments,
!          and UTF-8 for references in the 'to_latin_1()' routine).
!          => Don't recode it in other charset!
!          (file encoding should be detected as ISO-8859-15)
!##############################################################################

   function utf8_to_latin_1( string ) result( res )

      character(len=*) :: string
      character(len=256) :: res
      !------ API end ------

      ! convert a UTF-8 string into Latin-1 character set.
      ! *******************************************************************
      ! *** WARNING: only 2byte-characters are processed                ***
      ! ***          using 3byte-characters may lead to strange results ***
      ! *******************************************************************
      !
      ! the correspondence is perhaps not complete... don't hesitate
      ! to mail to: Edouard.Canot@univ-rennes.fr in order to get other
      ! glyphs.

      integer, parameter :: max_len = 256
      integer :: i, ii, n

      character(len=2) :: c2
      character(len=*), parameter :: ROUTINE_NAME = "to_latin_1"

      ! 2014-04-11: added ligatures for "ae" and "AE".
!### Warning: ligatures for "oe" and "OE" are in ISO-8859-15 (= Latin-9) and
!             NOT in ISO-8859-1 (= Latin-1)
!             (the two encodings are NOT equivalent!)

   !------ end of declarations -- execution starts hereafter  ------

      if( len(string) < 2 ) then
         ! must return if length of 'string' is 0 or 1
         res = trim(string)
         return
      end if

      res = ""
      n = len_trim(string)
      ii = 0
      i = 1
      do
         c2 = string(i:i+1)
         ! =========== lowercase ===========
         if( c2 == "à" )      then ! a grave
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "â" ) then ! a circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "é" ) then ! e acute
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "è" ) then ! e grave
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "ê" ) then ! e circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "ë" ) then ! e trema
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "î" ) then ! i circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "ï" ) then ! i trema
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "ô" ) then ! o circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "ù" ) then ! u grave
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "û" ) then ! u circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "ü" ) then ! u trema
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "ç" ) then ! c cedilla
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "æ" ) then ! ae ligature
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
! not valid: oe ligature doesn't belong to the Latin-1 character set.
!            (actually Latin-9, or ISO-8859-15)
!!         else if( c2 == "œ" ) then ! oe ligature
!!            ii = ii + 1
!!            if( ii > max_len ) go to 99
!!            res(ii:ii) = ""
!!            i = i + 2
         ! =========== uppercase ===========
         else if( c2 == "À" ) then ! A grave
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Â" ) then ! A circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "É" ) then ! E acute
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "È" ) then ! E grave
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Ê" ) then ! E circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Ë" ) then ! E trema
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Î" ) then ! I circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Ï" ) then ! I trema
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Ô" ) then ! O circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Ù" ) then ! U grave
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Û" ) then ! U circumflex
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Ü" ) then ! U trema
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Ç" ) then ! C cedilla
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else if( c2 == "Æ" ) then ! AE ligature
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
! not valid: OE ligature doesn't belong to the Latin-1 character set.
!            (actually Latin-9, or ISO-8859-15)
!!         else if( c2 == "Œ" ) then ! OE ligature
!!            ii = ii + 1
!!            if( ii > max_len ) go to 99
!!            res(ii:ii) = ""
!!            i = i + 2
         ! misc
         else if( c2 == "°" ) then ! degree
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = ""
            i = i + 2
         else
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = string(i:i)
            i = i + 1
         end if

         if( i == n ) then
            ii = ii + 1
            if( ii > max_len ) go to 99
            res(ii:ii) = string(i:i)
            return
         else if( i > n ) then
            return
         end if

      end do

 99   continue
      call PrintMessage( trim(ROUTINE_NAME), "W",                       &
                         "truncated string in to_latin_1 : '" // trim(res) // "...'" )

   end function
