subroutine set_muesli_install_dir_fgl()

#if defined _INTEL_IFC
   use ifport, only: system, getpid
#endif

   use mod_mfaux, only: STDERR, find_unit

   integer :: status, unit, mypid
   character(len=16) :: str_mypid
   character(len=256) :: cmd, file, line
   logical :: exist, correct
   integer :: i, L

   !------ end of declarations -- execution starts hereafter  ------

   if( MFPLOT_DIR == "" ) then

      mypid = getpid()
      write( str_mypid, "(I0)" ) mypid

      cmd = "muesli-config --prefix > /tmp/muesli_install_dir_"//trim(str_mypid)//" 2> /dev/null"
#if defined _INTEL_IFC | defined _GNU_GFC
      status = system(trim(cmd))
#else
- '(MUESLI read_any:) compiler not defined!'
#endif
      if( status == 0 ) then

         inquire(file="/tmp/muesli_install_dir_"//trim(str_mypid),exist=exist)
         if( .not. exist ) then
            write(STDERR,*) "(MUESLI FGL:) ERROR:"
            write(STDERR,*) "   'muesli-config' succeeded but /tmp/muesli_install_dir file doesn't exist!"
            write(STDERR,*) ""
            write(STDERR,*) "   => Muesli cannot continue to proceed...!"
            stop
         end if
         call find_unit( unit )
         open(unit,file="/tmp/muesli_install_dir_"//trim(str_mypid))
         read(unit,"(A)") MFPLOT_DIR
         close(unit)
         status = system( "rm -f /tmp/muesli_install_dir_"//trim(str_mypid) )

         correct = .true.
         ! the directory given by 'muesli_config' must contain some important
         ! files...
         file = trim(MFPLOT_DIR) // "/rgb.txt"
         inquire(file=trim(file),exist=exist)
         correct = correct .and. exist
         file = trim(MFPLOT_DIR) // "/fontconfig/fonts.conf"
         inquire(file=trim(file),exist=exist)
         correct = correct .and. exist

         if( .not. correct ) then
            write(STDERR,*) "(MUESLI FGL:) ERROR:"
            write(STDERR,*) "  It appears that the directory given by 'muesli_config' exists but points to a"
            write(STDERR,*) "  bad directory. Indeed, the following directory:"
            write(STDERR,*) "    ", trim(MFPLOT_DIR)
            write(STDERR,*) "  must contain: 1) the file 'rgb.txt'"
            write(STDERR,*) "                2) a configuration file, named 'fontconfig/fonts.conf'"
            write(STDERR,*) ""
            write(STDERR,*) "   => corrupted installation?"
            write(STDERR,*) "      (for example, you could have removed the library folder, while keeping"
            write(STDERR,*) "       an old 'muesli-config' script...)"
            stop
         end if

      else

         ! The Muesli library is perhaps not yet installed: trying to get
         ! the environment variable MFPLOT_DIR
         ! (don't worry, 'grgenv' will prepend 'MFPLOT_' to the required name)
         call grgenv( "DIR", MFPLOT_DIR, L )

         if( L == 0 ) then
            write(STDERR,*) "(MUESLI FGL:) ERROR:"
            write(STDERR,*) "  It appears that the 'muesli-config' script is not available (forgot to"
            write(STDERR,*) "  update your PATH variable?) or that the library is not yet installed..."
            write(STDERR,*) ""
            write(STDERR,*) "  An alternative way to find the required resources is, temporarily, to set"
            write(STDERR,*) "  the MFPLOT_DIR environment variable to the Muesli installation path."
            write(STDERR,*) ""
            write(STDERR,*) "  If you want to just run the FGL test programs without installing the"
            write(STDERR,*) "  Muesli library, you could prepare the runtime environment by typing:"
            write(STDERR,*) "  'source ./prepa_env' in the FGL test directory."
            write(STDERR,*) ""
            stop
         end if

         correct = .true.
         ! the directory pointed by MFPLOT_DIR must contain some important
         ! files...
         file = trim(MFPLOT_DIR) // "/rgb.txt"
         inquire(file=trim(file),exist=exist)
         correct = correct .and. exist
         file = trim(MFPLOT_DIR) // "/fontconfig/fonts.conf"
         inquire(file=trim(file),exist=exist)
         correct = correct .and. exist

         if( .not. correct ) then
            write(STDERR,*) "(MUESLI FGL:) ERROR:"
            write(STDERR,*) "  It appears that the MFPLOT_DIR environment variable exists but points to a"
            write(STDERR,*) "  bad directory. Indeed, the following directory:"
            write(STDERR,*) "    ", trim(MFPLOT_DIR)
            write(STDERR,*) "  must contain: 1) the file 'rgb.txt'"
            write(STDERR,*) "                2) a configuration file, named 'fontconfig/fonts.conf'"
            write(STDERR,*) ""
            write(STDERR,*) "   => corrupted installation?"
            write(STDERR,*) "      (for example, you could have removed the library folder, while keeping"
            write(STDERR,*) "       an old 'muesli-config' script...)"
            stop
         end if

         ! check the path in 'fontconfig/fonts.conf'
         call find_unit( unit )
         file = trim(MFPLOT_DIR) // "/fontconfig/fonts.conf"
         open(unit,file=trim(file))
         do
            read(unit,"(A)",end=99) line
            line = adjustl(line)
            if( line(1:5) == "<dir>" ) then
               line = line(6:)
               i = index( line, "</dir>" )
               if( i == 0 ) then
                  write(STDERR,*) "(MUESLI FGL:) ERROR:"
                  write(STDERR,*) "  The configuration file 'fontconfig/fonts.conf' exists, but"
                  write(STDERR,*) "  seems to be corrupted: '</dir>' not found!"
                  write(STDERR,*) ""
                  stop
               else
                  if( line(1:i-1) /= trim(MFPLOT_DIR) // "/fontconfig/fonts" ) then
                     write(STDERR,*) "(MUESLI FGL:) ERROR:"
                     write(STDERR,*) "  The configuration file 'fontconfig/fonts.conf' exists, but"
                     write(STDERR,*) "  seems to be corrupted: bad path for fonts directory!"
                     write(STDERR,*) ""
                     stop
                  end if
               end if
               exit
            end if
         end do
         close(unit)
         return

 99      continue
         write(STDERR,*) "(MUESLI set_muesli_install_dir:) ERROR:"
         write(STDERR,*) "  The configuration file 'fontconfig/fonts.conf' exists, but"
         write(STDERR,*) "  seems to be corrupted: '<dir>' not found!"
         write(STDERR,*) ""
         stop

      end if

   end if

end subroutine set_muesli_install_dir_fgl
