subroutine set_mfplot_background_color( device_type, iback_col )

   character(len=3) :: device_type
   integer :: iback_col
   !------ API end ------

   ! change the default color background of all windows of MFPLOT
   !   only for device_type : "X11", "NULL"
   !   iback_col : 0=Black, 1=White
   !--------------------------------------------------------------------

   double precision :: rbuf(1)
   integer :: ibuf(1), lchr
   character :: chr

   character(len=80) :: dev
   integer :: grgtyp
   logical :: append

   ! check that we are on X11, and request the device type
   if( device_type == "X11" ) then
     if( grpars("/XWIN",dev,grgtyp,append) /= 1 ) then
        write(0,*) "(set_mfplot_background_color:) internal error"
        write(0,*) "                  cannot access to X11 device!"
        return
     end if
   else
     write(0,*) "(set_mfplot_background_color:) ",                      &
                "unimplemented device!"
     return
   end if

   ibuf(1) = iback_col
   call grexec( grgtyp, SELECT_BACK_FOREGROUND, rbuf, ibuf, chr, lchr )

end subroutine
