subroutine ps_font_char_width( ic, fontcode, width, h_min, h_max )

   integer,          intent(in)            :: ic
   character(len=1), intent(in)            :: fontcode
   double precision, intent(out)           :: width
   double precision, intent(out), optional :: h_min, h_max
   !------ API end ------

   ! find the character width of char(ic)
   !--------------------------------------------------------------------

   integer :: i_font, ic_min_1, ic_max_1, ic_min_2, ic_max_2
   !------ end of declarations -- execution starts hereafter  ------

   ! Read the AFM files (Adobe Font Metrics) of the eight fontes
   ! used for text (tables limited to 22:255 subrange).
   if( .not. MF_AFM_READ ) then
      ! Filling the tables of 'grpckg1.inc'.
      call gr_read_AFM_files()
      MF_AFM_READ = .true.
   end if
   ! Closing AFM files will be done in 'msExitFgl()'.

   if( fontcode == "n" ) then
      i_font = 1
   else if( fontcode == "N" ) then
      i_font = 2
   else if( fontcode == "i" ) then
      i_font = 3
   else if( fontcode == "I" ) then
      i_font = 4
   else if( fontcode == "r" ) then
      i_font = 5
   else if( fontcode == "R" ) then
      i_font = 6
   else if( fontcode == "s" ) then
      i_font = 8
   else ! greek
      i_font = 7
   end if

   ! valid ranges must match definitions in 'gr_read_AFM_files'
   if( i_font == 7 ) then ! greek symbols
      ic_min_1 = 32
      ic_max_1 = 126
      ic_min_2 = 160
      ic_max_2 = 254
   else
      ic_min_1 = 22
      ic_max_1 = 255
      ic_min_2 = 1
      ic_max_2 = -1
   end if

   ! the font_metrics(:,:) array is initialized in 'gr_read_AFM_files()'
   if( ic_min_1 <= ic .and. ic <= ic_max_1 ) then

      ! scaling used in AFM files
      width = font_metrics( i_font, ic )/1000.0d0

   else if( ic_min_2 <= ic .and. ic <= ic_max_2 ) then

      ! scaling used in AFM files
      width = font_metrics( i_font, ic )/1000.0d0

   else if( ic == -2 ) then ! thin space

      ! scaling used in AFM files
      width = font_metrics( i_font, 32 )/1000.0d0
      width = width/2.0d0

   else if( ic == -3 ) then ! very thin space

      ! scaling used in AFM files
      width = font_metrics( i_font, 32 )/1000.0d0
      width = width/4.0d0

   else

      print *, "(MFPLOT:) Internal error in 'ps_font_char_width'"
      call grwarn( "Character not handled!")
      print *, "          Character found: code = ", ic
      print *, "          incorrect character... changed to 'space' (code=32)"
      width = font_metrics( i_font, 32 )/1000.0d0
      pause "only for debugging purpose"
      return

   end if

   if( present(h_min) ) then
      h_min = font_heights( i_font, 1 )
   end if
   if( present(h_max) ) then
      h_max = font_heights( i_font, 2 )
   end if

end subroutine
